/*
 * Copyright 2010-2024 JetBrains s.r.o. and Kotlin Programming Language contributors.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.
 */

package org.jetbrains.kotlin.analysis.api.fir.test.cases.generated.cases.components.psiTypeProvider;

import com.intellij.testFramework.TestDataPath;
import org.jetbrains.kotlin.test.util.KtTestUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.api.fir.test.configurators.AnalysisApiFirTestConfiguratorFactory;
import org.jetbrains.kotlin.analysis.test.framework.test.configurators.AnalysisApiTestConfiguratorFactoryData;
import org.jetbrains.kotlin.analysis.test.framework.test.configurators.AnalysisApiTestConfigurator;
import org.jetbrains.kotlin.analysis.test.framework.test.configurators.TestModuleKind;
import org.jetbrains.kotlin.analysis.test.framework.test.configurators.FrontendKind;
import org.jetbrains.kotlin.analysis.test.framework.test.configurators.AnalysisSessionMode;
import org.jetbrains.kotlin.analysis.test.framework.test.configurators.AnalysisApiMode;
import org.jetbrains.kotlin.analysis.api.impl.base.test.cases.components.psiTypeProvider.AbstractAnalysisApiPsiTypeProviderTest;
import org.jetbrains.kotlin.test.TestMetadata;
import org.junit.jupiter.api.Test;

import java.io.File;
import java.util.regex.Pattern;

/** This class is generated by {@link org.jetbrains.kotlin.generators.tests.analysis.api.GenerateAnalysisApiTestsKt}. DO NOT MODIFY MANUALLY */
@SuppressWarnings("all")
@TestMetadata("analysis/analysis-api/testData/components/psiTypeProvider/psiType/forDeclaration")
@TestDataPath("$PROJECT_ROOT")
public class FirIdeNormalAnalysisSourceModuleAnalysisApiPsiTypeProviderTestGenerated extends AbstractAnalysisApiPsiTypeProviderTest {
  @NotNull
  @Override
  public AnalysisApiTestConfigurator getConfigurator() {
    return AnalysisApiFirTestConfiguratorFactory.INSTANCE.createConfigurator(
      new AnalysisApiTestConfiguratorFactoryData(
        FrontendKind.Fir,
        TestModuleKind.Source,
        AnalysisSessionMode.Normal,
        AnalysisApiMode.Ide
      )
    );
  }

  @Test
  @TestMetadata("actual_jvmInline_typealias.kt")
  public void testActual_jvmInline_typealias() {
    runTest("analysis/analysis-api/testData/components/psiTypeProvider/psiType/forDeclaration/actual_jvmInline_typealias.kt");
  }

  @Test
  @TestMetadata("actual_typealias.kt")
  public void testActual_typealias() {
    runTest("analysis/analysis-api/testData/components/psiTypeProvider/psiType/forDeclaration/actual_typealias.kt");
  }

  @Test
  public void testAllFilesPresentInForDeclaration() {
    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("analysis/analysis-api/testData/components/psiTypeProvider/psiType/forDeclaration"), Pattern.compile("^(.+)\\.kt$"), null, true);
  }

  @Test
  @TestMetadata("anonymousObject_exposedAsReturnValue.kt")
  public void testAnonymousObject_exposedAsReturnValue() {
    runTest("analysis/analysis-api/testData/components/psiTypeProvider/psiType/forDeclaration/anonymousObject_exposedAsReturnValue.kt");
  }

  @Test
  @TestMetadata("duplicatedClass_functionParameter.kt")
  public void testDuplicatedClass_functionParameter() {
    runTest("analysis/analysis-api/testData/components/psiTypeProvider/psiType/forDeclaration/duplicatedClass_functionParameter.kt");
  }

  @Test
  @TestMetadata("errorTypeInNestedTypeArgument.kt")
  public void testErrorTypeInNestedTypeArgument() {
    runTest("analysis/analysis-api/testData/components/psiTypeProvider/psiType/forDeclaration/errorTypeInNestedTypeArgument.kt");
  }

  @Test
  @TestMetadata("javaBoxed.kt")
  public void testJavaBoxed() {
    runTest("analysis/analysis-api/testData/components/psiTypeProvider/psiType/forDeclaration/javaBoxed.kt");
  }

  @Test
  @TestMetadata("javaBoxedArray.kt")
  public void testJavaBoxedArray() {
    runTest("analysis/analysis-api/testData/components/psiTypeProvider/psiType/forDeclaration/javaBoxedArray.kt");
  }

  @Test
  @TestMetadata("javaBoxedArrayWithTypeAnnotation.kt")
  public void testJavaBoxedArrayWithTypeAnnotation() {
    runTest("analysis/analysis-api/testData/components/psiTypeProvider/psiType/forDeclaration/javaBoxedArrayWithTypeAnnotation.kt");
  }

  @Test
  @TestMetadata("javaBoxedWithDeclarationAnnotation.kt")
  public void testJavaBoxedWithDeclarationAnnotation() {
    runTest("analysis/analysis-api/testData/components/psiTypeProvider/psiType/forDeclaration/javaBoxedWithDeclarationAnnotation.kt");
  }

  @Test
  @TestMetadata("javaBoxedWithTypeAnnotation.kt")
  public void testJavaBoxedWithTypeAnnotation() {
    runTest("analysis/analysis-api/testData/components/psiTypeProvider/psiType/forDeclaration/javaBoxedWithTypeAnnotation.kt");
  }

  @Test
  @TestMetadata("javaList.kt")
  public void testJavaList() {
    runTest("analysis/analysis-api/testData/components/psiTypeProvider/psiType/forDeclaration/javaList.kt");
  }

  @Test
  @TestMetadata("javaListWithExtendsWildcard.kt")
  public void testJavaListWithExtendsWildcard() {
    runTest("analysis/analysis-api/testData/components/psiTypeProvider/psiType/forDeclaration/javaListWithExtendsWildcard.kt");
  }

  @Test
  @TestMetadata("javaListWithSuperWildcard.kt")
  public void testJavaListWithSuperWildcard() {
    runTest("analysis/analysis-api/testData/components/psiTypeProvider/psiType/forDeclaration/javaListWithSuperWildcard.kt");
  }

  @Test
  @TestMetadata("javaNestedList.kt")
  public void testJavaNestedList() {
    runTest("analysis/analysis-api/testData/components/psiTypeProvider/psiType/forDeclaration/javaNestedList.kt");
  }

  @Test
  @TestMetadata("javaNestedListWithTypeAnnotation.kt")
  public void testJavaNestedListWithTypeAnnotation() {
    runTest("analysis/analysis-api/testData/components/psiTypeProvider/psiType/forDeclaration/javaNestedListWithTypeAnnotation.kt");
  }

  @Test
  @TestMetadata("javaNotNullList.kt")
  public void testJavaNotNullList() {
    runTest("analysis/analysis-api/testData/components/psiTypeProvider/psiType/forDeclaration/javaNotNullList.kt");
  }

  @Test
  @TestMetadata("javaNotNullString.kt")
  public void testJavaNotNullString() {
    runTest("analysis/analysis-api/testData/components/psiTypeProvider/psiType/forDeclaration/javaNotNullString.kt");
  }

  @Test
  @TestMetadata("javaPrimitive.kt")
  public void testJavaPrimitive() {
    runTest("analysis/analysis-api/testData/components/psiTypeProvider/psiType/forDeclaration/javaPrimitive.kt");
  }

  @Test
  @TestMetadata("javaPrimitiveArray.kt")
  public void testJavaPrimitiveArray() {
    runTest("analysis/analysis-api/testData/components/psiTypeProvider/psiType/forDeclaration/javaPrimitiveArray.kt");
  }

  @Test
  @TestMetadata("javaRawList.kt")
  public void testJavaRawList() {
    runTest("analysis/analysis-api/testData/components/psiTypeProvider/psiType/forDeclaration/javaRawList.kt");
  }

  @Test
  @TestMetadata("localClass_exposedAsMemberInAnonymousObject.kt")
  public void testLocalClass_exposedAsMemberInAnonymousObject() {
    runTest("analysis/analysis-api/testData/components/psiTypeProvider/psiType/forDeclaration/localClass_exposedAsMemberInAnonymousObject.kt");
  }

  @Test
  @TestMetadata("localClass_exposedAsReturnValue.kt")
  public void testLocalClass_exposedAsReturnValue() {
    runTest("analysis/analysis-api/testData/components/psiTypeProvider/psiType/forDeclaration/localClass_exposedAsReturnValue.kt");
  }

  @Test
  @TestMetadata("localClass_exposedAsReturnValue_privateFunction.kt")
  public void testLocalClass_exposedAsReturnValue_privateFunction() {
    runTest("analysis/analysis-api/testData/components/psiTypeProvider/psiType/forDeclaration/localClass_exposedAsReturnValue_privateFunction.kt");
  }

  @Test
  @TestMetadata("localClass_localFunctionInSameScope.kt")
  public void testLocalClass_localFunctionInSameScope() {
    runTest("analysis/analysis-api/testData/components/psiTypeProvider/psiType/forDeclaration/localClass_localFunctionInSameScope.kt");
  }

  @Test
  @TestMetadata("localClass_localPropertyInSameScope.kt")
  public void testLocalClass_localPropertyInSameScope() {
    runTest("analysis/analysis-api/testData/components/psiTypeProvider/psiType/forDeclaration/localClass_localPropertyInSameScope.kt");
  }

  @Test
  @TestMetadata("localClass_localPropertyInSampeScope_functionalType.kt")
  public void testLocalClass_localPropertyInSampeScope_functionalType() {
    runTest("analysis/analysis-api/testData/components/psiTypeProvider/psiType/forDeclaration/localClass_localPropertyInSampeScope_functionalType.kt");
  }

  @Test
  @TestMetadata("localClass_memberFunction.kt")
  public void testLocalClass_memberFunction() {
    runTest("analysis/analysis-api/testData/components/psiTypeProvider/psiType/forDeclaration/localClass_memberFunction.kt");
  }

  @Test
  @TestMetadata("nestedTypeAnnotation.kt")
  public void testNestedTypeAnnotation() {
    runTest("analysis/analysis-api/testData/components/psiTypeProvider/psiType/forDeclaration/nestedTypeAnnotation.kt");
  }

  @Test
  @TestMetadata("recursiveValueClass.kt")
  public void testRecursiveValueClass() {
    runTest("analysis/analysis-api/testData/components/psiTypeProvider/psiType/forDeclaration/recursiveValueClass.kt");
  }

  @Test
  @TestMetadata("recursiveValueClassAsImplicitType.kt")
  public void testRecursiveValueClassAsImplicitType() {
    runTest("analysis/analysis-api/testData/components/psiTypeProvider/psiType/forDeclaration/recursiveValueClassAsImplicitType.kt");
  }

  @Test
  @TestMetadata("suspendFunctionValueParameterNoStdlib.kt")
  public void testSuspendFunctionValueParameterNoStdlib() {
    runTest("analysis/analysis-api/testData/components/psiTypeProvider/psiType/forDeclaration/suspendFunctionValueParameterNoStdlib.kt");
  }

  @Test
  @TestMetadata("suspendFunctionValueParameterWithStdlib.kt")
  public void testSuspendFunctionValueParameterWithStdlib() {
    runTest("analysis/analysis-api/testData/components/psiTypeProvider/psiType/forDeclaration/suspendFunctionValueParameterWithStdlib.kt");
  }

  @Test
  @TestMetadata("typeAnnotation.kt")
  public void testTypeAnnotation() {
    runTest("analysis/analysis-api/testData/components/psiTypeProvider/psiType/forDeclaration/typeAnnotation.kt");
  }

  @Test
  @TestMetadata("valueClass.kt")
  public void testValueClass() {
    runTest("analysis/analysis-api/testData/components/psiTypeProvider/psiType/forDeclaration/valueClass.kt");
  }

  @Test
  @TestMetadata("wildcardSuppression_false.kt")
  public void testWildcardSuppression_false() {
    runTest("analysis/analysis-api/testData/components/psiTypeProvider/psiType/forDeclaration/wildcardSuppression_false.kt");
  }

  @Test
  @TestMetadata("wildcardSuppression_true.kt")
  public void testWildcardSuppression_true() {
    runTest("analysis/analysis-api/testData/components/psiTypeProvider/psiType/forDeclaration/wildcardSuppression_true.kt");
  }
}
