/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.v1.datetime;

import java.sql.Date;
import java.sql.Timestamp;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.datetime.ConvertersKt;
import kotlinx.datetime.Instant;
import kotlinx.datetime.LocalDate;
import kotlinx.datetime.TimeZone;
import kotlinx.datetime.TimeZoneKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.exposed.v1.core.ColumnType;
import org.jetbrains.exposed.v1.core.IDateColumnType;
import org.jetbrains.exposed.v1.core.statements.api.RowApi;
import org.jetbrains.exposed.v1.core.vendors.DatabaseDialect;
import org.jetbrains.exposed.v1.core.vendors.DatabaseDialectKt;
import org.jetbrains.exposed.v1.core.vendors.H2Dialect;
import org.jetbrains.exposed.v1.core.vendors.H2Kt;
import org.jetbrains.exposed.v1.core.vendors.OracleDialect;
import org.jetbrains.exposed.v1.core.vendors.PostgreSQLDialect;
import org.jetbrains.exposed.v1.core.vendors.SQLiteDialect;
import org.jetbrains.exposed.v1.datetime.KotlinDateColumnTypeKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\u0018\u0000 \u001c2\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003:\u0001\u001cB\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u0002H\u0016J\u0010\u0010\u000e\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u000fH\u0016J\u001d\u0010\u0010\u001a\n \u0011*\u0004\u0018\u00010\u000f0\u000f2\u0006\u0010\r\u001a\u00020\u0002H\u0016\u00a2\u0006\u0002\u0010\u0012J\u0010\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u0002H\u0016J\u001a\u0010\u0014\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\u00022\u0006\u0010\u001a\u001a\u00020\u001bH\u0002R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/exposed/v1/datetime/KotlinLocalDateColumnType;", "Lorg/jetbrains/exposed/v1/core/ColumnType;", "Lkotlinx/datetime/LocalDate;", "Lorg/jetbrains/exposed/v1/core/IDateColumnType;", "<init>", "()V", "hasTimePart", "", "getHasTimePart", "()Z", "sqlType", "", "nonNullValueToString", "value", "valueFromDB", "", "notNullValueToDB", "kotlin.jvm.PlatformType", "(Lkotlinx/datetime/LocalDate;)Ljava/lang/Object;", "nonNullValueAsDefaultString", "readObject", "rs", "Lorg/jetbrains/exposed/v1/core/statements/api/RowApi;", "index", "", "longToLocalDate", "instant", "", "Companion", "exposed-kotlin-datetime"})
public final class KotlinLocalDateColumnType
extends ColumnType<LocalDate>
implements IDateColumnType {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean hasTimePart;
    @NotNull
    private static final KotlinLocalDateColumnType INSTANCE = new KotlinLocalDateColumnType();

    public KotlinLocalDateColumnType() {
        super(false, 1, null);
    }

    public boolean getHasTimePart() {
        return this.hasTimePart;
    }

    @NotNull
    public String sqlType() {
        return DatabaseDialectKt.getCurrentDialect().getDataTypeProvider().dateType();
    }

    @NotNull
    public String nonNullValueToString(@NotNull LocalDate value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Instant instant = Instant.Companion.fromEpochMilliseconds(TimeZoneKt.atStartOfDayIn((LocalDate)value, (TimeZone)KotlinDateColumnTypeKt.access$getDEFAULT_TIME_ZONE()).toEpochMilliseconds());
        if (DatabaseDialectKt.getCurrentDialect() instanceof OracleDialect) {
            return KotlinDateColumnTypeKt.access$oracleDateLiteral(instant);
        }
        return '\'' + KotlinDateColumnTypeKt.access$getDEFAULT_DATE_STRING_FORMATTER().format(ConvertersKt.toJavaInstant((Instant)instant)) + '\'';
    }

    @NotNull
    public LocalDate valueFromDB(@NotNull Object value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Object object = value;
        return object instanceof LocalDate ? (LocalDate)value : (object instanceof Date ? this.longToLocalDate(((Date)value).getTime()) : (object instanceof Timestamp ? this.longToLocalDate(((Timestamp)value).getTime()) : (object instanceof Integer ? this.longToLocalDate(((Number)value).intValue()) : (object instanceof Long ? this.longToLocalDate(((Number)value).longValue()) : (object instanceof String ? LocalDate.Companion.parse$default((LocalDate.Companion)LocalDate.Companion, (CharSequence)((CharSequence)value), null, (int)2, null) : LocalDate.Companion.parse$default((LocalDate.Companion)LocalDate.Companion, (CharSequence)value.toString(), null, (int)2, null))))));
    }

    public Object notNullValueToDB(@NotNull LocalDate value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return DatabaseDialectKt.getCurrentDialect() instanceof SQLiteDialect ? KotlinDateColumnTypeKt.access$getDEFAULT_DATE_STRING_FORMATTER().format(ConvertersKt.toJavaLocalDate((LocalDate)value)) : new Date(KotlinDateColumnTypeKt.access$getMillis(value));
    }

    @NotNull
    public String nonNullValueAsDefaultString(@NotNull LocalDate value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return DatabaseDialectKt.getCurrentDialect() instanceof PostgreSQLDialect ? this.nonNullValueToString(value) + "::date" : super.nonNullValueAsDefaultString((Object)value);
    }

    @Nullable
    public Object readObject(@NotNull RowApi rs, int index) {
        Intrinsics.checkNotNullParameter((Object)rs, (String)"rs");
        DatabaseDialect dialect = DatabaseDialectKt.getCurrentDialect();
        return dialect instanceof OracleDialect || H2Kt.getH2Mode((DatabaseDialect)dialect) == H2Dialect.H2CompatibilityMode.Oracle ? rs.getObject(index, Timestamp.class) : super.readObject(rs, index);
    }

    private final LocalDate longToLocalDate(long instant) {
        return TimeZoneKt.toLocalDateTime((Instant)Instant.Companion.fromEpochMilliseconds(instant), (TimeZone)KotlinDateColumnTypeKt.access$getDEFAULT_TIME_ZONE()).getDate();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0004\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/exposed/v1/datetime/KotlinLocalDateColumnType$Companion;", "", "<init>", "()V", "INSTANCE", "Lorg/jetbrains/exposed/v1/datetime/KotlinLocalDateColumnType;", "getINSTANCE$exposed_kotlin_datetime", "()Lorg/jetbrains/exposed/v1/datetime/KotlinLocalDateColumnType;", "exposed-kotlin-datetime"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final KotlinLocalDateColumnType getINSTANCE$exposed_kotlin_datetime() {
            return INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

