/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.v1.datetime;

import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.datetime.ConvertersKt;
import kotlinx.datetime.Instant;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.exposed.v1.core.ColumnType;
import org.jetbrains.exposed.v1.core.IDateColumnType;
import org.jetbrains.exposed.v1.core.statements.api.RowApi;
import org.jetbrains.exposed.v1.core.transactions.CoreTransactionManager;
import org.jetbrains.exposed.v1.core.vendors.DatabaseDialect;
import org.jetbrains.exposed.v1.core.vendors.DatabaseDialectKt;
import org.jetbrains.exposed.v1.core.vendors.H2Dialect;
import org.jetbrains.exposed.v1.core.vendors.H2Kt;
import org.jetbrains.exposed.v1.core.vendors.MariaDBDialect;
import org.jetbrains.exposed.v1.core.vendors.MysqlDialect;
import org.jetbrains.exposed.v1.core.vendors.OracleDialect;
import org.jetbrains.exposed.v1.core.vendors.PostgreSQLDialect;
import org.jetbrains.exposed.v1.core.vendors.SQLiteDialect;
import org.jetbrains.exposed.v1.datetime.KotlinDateColumnTypeKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\u0018\u0000 \u00172\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003:\u0001\u0017B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u0002H\u0016J\u0010\u0010\u000e\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u000fH\u0016J\u001a\u0010\u0010\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\r\u001a\u00020\u0002H\u0016J\u0010\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u0002H\u0016R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/exposed/v1/datetime/KotlinInstantColumnType;", "Lorg/jetbrains/exposed/v1/core/ColumnType;", "Lkotlinx/datetime/Instant;", "Lorg/jetbrains/exposed/v1/core/IDateColumnType;", "<init>", "()V", "hasTimePart", "", "getHasTimePart", "()Z", "sqlType", "", "nonNullValueToString", "value", "valueFromDB", "", "readObject", "rs", "Lorg/jetbrains/exposed/v1/core/statements/api/RowApi;", "index", "", "notNullValueToDB", "nonNullValueAsDefaultString", "Companion", "exposed-kotlin-datetime"})
public final class KotlinInstantColumnType
extends ColumnType<kotlinx.datetime.Instant>
implements IDateColumnType {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean hasTimePart;
    @NotNull
    private static final KotlinInstantColumnType INSTANCE = new KotlinInstantColumnType();

    public KotlinInstantColumnType() {
        super(false, 1, null);
        this.hasTimePart = true;
    }

    public boolean getHasTimePart() {
        return this.hasTimePart;
    }

    @NotNull
    public String sqlType() {
        return DatabaseDialectKt.getCurrentDialect().getDataTypeProvider().timestampType();
    }

    @NotNull
    public String nonNullValueToString(@NotNull kotlinx.datetime.Instant value) {
        String string;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Instant instant = ConvertersKt.toJavaInstant((kotlinx.datetime.Instant)value);
        DatabaseDialect dialect = DatabaseDialectKt.getCurrentDialect();
        if (dialect instanceof MysqlDialect) {
            DateTimeFormatter formatter = ((MysqlDialect)dialect).isFractionDateTimeSupported() ? KotlinDateColumnTypeKt.access$getMYSQL_FRACTION_TIMESTAMP_STRING_FORMATTER() : KotlinDateColumnTypeKt.access$getMYSQL_TIMESTAMP_STRING_FORMATTER();
            string = '\'' + formatter.format(instant) + '\'';
        } else {
            string = dialect instanceof SQLiteDialect ? '\'' + KotlinDateColumnTypeKt.access$getSQLITE_AND_ORACLE_TIMESTAMP_STRING_FORMATTER().format(instant) + '\'' : (dialect instanceof OracleDialect ? KotlinDateColumnTypeKt.access$oracleTimestampLiteral(value) : '\'' + KotlinDateColumnTypeKt.access$getDEFAULT_TIMESTAMP_STRING_FORMATTER().format(instant) + '\'');
        }
        return string;
    }

    @NotNull
    public kotlinx.datetime.Instant valueFromDB(@NotNull Object value) {
        kotlinx.datetime.Instant instant;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Object object = value;
        if (object instanceof Timestamp) {
            Instant instant2 = ((Timestamp)value).toInstant();
            Intrinsics.checkNotNullExpressionValue((Object)instant2, (String)"toInstant(...)");
            instant = ConvertersKt.toKotlinInstant((Instant)instant2);
        } else if (object instanceof String) {
            instant = Instant.Companion.parse$default((Instant.Companion)kotlinx.datetime.Instant.Companion, (CharSequence)((CharSequence)value), null, (int)2, null);
        } else if (object instanceof LocalDateTime) {
            Instant instant3 = ((LocalDateTime)value).atZone(ZoneId.systemDefault()).toInstant();
            Intrinsics.checkNotNullExpressionValue((Object)instant3, (String)"toInstant(...)");
            instant = ConvertersKt.toKotlinInstant((Instant)instant3);
        } else {
            instant = this.valueFromDB(value.toString());
        }
        return instant;
    }

    @Nullable
    public Object readObject(@NotNull RowApi rs, int index) {
        Intrinsics.checkNotNullParameter((Object)rs, (String)"rs");
        return rs.getObject(index, Timestamp.class);
    }

    @NotNull
    public Object notNullValueToDB(@NotNull kotlinx.datetime.Instant value) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        DatabaseDialect dialect = DatabaseDialectKt.getCurrentDialect();
        if (dialect instanceof SQLiteDialect) {
            object = KotlinDateColumnTypeKt.access$getSQLITE_AND_ORACLE_TIMESTAMP_STRING_FORMATTER().format(ConvertersKt.toJavaInstant((kotlinx.datetime.Instant)value));
        } else if (dialect instanceof MysqlDialect && !(dialect instanceof MariaDBDialect) && !CoreTransactionManager.INSTANCE.currentTransaction().getDb().isVersionCovers(8, 0)) {
            DateTimeFormatter formatter = ((MysqlDialect)dialect).isFractionDateTimeSupported() ? KotlinDateColumnTypeKt.access$getMYSQL_FRACTION_TIMESTAMP_STRING_FORMATTER() : KotlinDateColumnTypeKt.access$getMYSQL_TIMESTAMP_STRING_FORMATTER();
            object = formatter.format(ConvertersKt.toJavaInstant((kotlinx.datetime.Instant)value));
        } else {
            object = Timestamp.from(ConvertersKt.toJavaInstant((kotlinx.datetime.Instant)value));
        }
        return object;
    }

    @NotNull
    public String nonNullValueAsDefaultString(@NotNull kotlinx.datetime.Instant value) {
        String string;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        DatabaseDialect dialect = DatabaseDialectKt.getCurrentDialect();
        if (dialect instanceof PostgreSQLDialect) {
            StringBuilder stringBuilder = new StringBuilder().append('\'');
            String string2 = KotlinDateColumnTypeKt.access$getSQLITE_AND_ORACLE_TIMESTAMP_STRING_FORMATTER().format(ConvertersKt.toJavaInstant((kotlinx.datetime.Instant)value));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
            char[] cArray = new char[]{'0'};
            String string3 = StringsKt.trimEnd((String)string2, (char[])cArray);
            cArray = new char[]{'.'};
            string = stringBuilder.append(StringsKt.trimEnd((String)string3, (char[])cArray)).append("'::timestamp without time zone").toString();
        } else if (H2Kt.getH2Mode((DatabaseDialect)dialect) == H2Dialect.H2CompatibilityMode.Oracle) {
            StringBuilder stringBuilder = new StringBuilder().append('\'');
            String string4 = KotlinDateColumnTypeKt.access$getSQLITE_AND_ORACLE_TIMESTAMP_STRING_FORMATTER().format(ConvertersKt.toJavaInstant((kotlinx.datetime.Instant)value));
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"format(...)");
            char[] cArray = new char[]{'0'};
            String string5 = StringsKt.trimEnd((String)string4, (char[])cArray);
            cArray = new char[]{'.'};
            string = stringBuilder.append(StringsKt.trimEnd((String)string5, (char[])cArray)).append('\'').toString();
        } else {
            string = super.nonNullValueAsDefaultString((Object)value);
        }
        return string;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0004\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/exposed/v1/datetime/KotlinInstantColumnType$Companion;", "", "<init>", "()V", "INSTANCE", "Lorg/jetbrains/exposed/v1/datetime/KotlinInstantColumnType;", "getINSTANCE$exposed_kotlin_datetime", "()Lorg/jetbrains/exposed/v1/datetime/KotlinInstantColumnType;", "exposed-kotlin-datetime"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final KotlinInstantColumnType getINSTANCE$exposed_kotlin_datetime() {
            return INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

