/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.serialization.metadata;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.serialization.metadata.KlibMetadataSerializerExtensionKt;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptorWithSource;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.library.metadata.KlibMetadataProtoBuf;
import org.jetbrains.kotlin.library.metadata.KlibMetadataSerializerProtocol;
import org.jetbrains.kotlin.metadata.ProtoBuf;
import org.jetbrains.kotlin.metadata.deserialization.BinaryVersion;
import org.jetbrains.kotlin.metadata.serialization.MutableVersionRequirementTable;
import org.jetbrains.kotlin.serialization.DescriptorSerializer;
import org.jetbrains.kotlin.serialization.KotlinSerializerExtensionBase;
import org.jetbrains.kotlin.serialization.StringTableImpl;
import org.jetbrains.kotlin.types.FlexibleType;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0002\u0010\u000bJ\u0017\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002\u00a2\u0006\u0002\u0010\u0014J(\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0012\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J \u0010\u001e\u001a\u00020\u00162\u0006\u0010\u0012\u001a\u00020\u001f2\u0006\u0010\u0018\u001a\u00020 2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0018\u0010!\u001a\u00020\u00162\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%H\u0016J \u0010&\u001a\u00020\u00162\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020%2\u0006\u0010*\u001a\u00020%H\u0016J*\u0010+\u001a\u00020\u00162\u0006\u0010\u0012\u001a\u00020,2\u0006\u0010\u0018\u001a\u00020-2\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J*\u0010.\u001a\u00020\u00162\u0006\u0010\u0012\u001a\u00020/2\u0006\u0010\u0018\u001a\u0002002\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\b\u00101\u001a\u00020\tH\u0016R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u00062"}, d2={"Lorg/jetbrains/kotlin/backend/common/serialization/metadata/KlibMetadataSerializerExtension;", "Lorg/jetbrains/kotlin/serialization/KotlinSerializerExtensionBase;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "metadataVersion", "Lorg/jetbrains/kotlin/metadata/deserialization/BinaryVersion;", "stringTable", "Lorg/jetbrains/kotlin/serialization/StringTableImpl;", "allowErrorTypes", "", "exportKDoc", "(Lorg/jetbrains/kotlin/config/LanguageVersionSettings;Lorg/jetbrains/kotlin/metadata/deserialization/BinaryVersion;Lorg/jetbrains/kotlin/serialization/StringTableImpl;ZZ)V", "getMetadataVersion", "()Lorg/jetbrains/kotlin/metadata/deserialization/BinaryVersion;", "getStringTable", "()Lorg/jetbrains/kotlin/serialization/StringTableImpl;", "descriptorFileId", "", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptorWithSource;", "(Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptorWithSource;)Ljava/lang/Integer;", "serializeClass", "", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "proto", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$Class$Builder;", "versionRequirementTable", "Lorg/jetbrains/kotlin/metadata/serialization/MutableVersionRequirementTable;", "childSerializer", "Lorg/jetbrains/kotlin/serialization/DescriptorSerializer;", "serializeConstructor", "Lorg/jetbrains/kotlin/descriptors/ConstructorDescriptor;", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$Constructor$Builder;", "serializeErrorType", "type", "Lorg/jetbrains/kotlin/types/KotlinType;", "builder", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$Type$Builder;", "serializeFlexibleType", "flexibleType", "Lorg/jetbrains/kotlin/types/FlexibleType;", "lowerProto", "upperProto", "serializeFunction", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$Function$Builder;", "serializeProperty", "Lorg/jetbrains/kotlin/descriptors/PropertyDescriptor;", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$Property$Builder;", "shouldUseTypeTable", "ir.serialization.common"})
public final class KlibMetadataSerializerExtension
extends KotlinSerializerExtensionBase {
    @NotNull
    private final LanguageVersionSettings languageVersionSettings;
    @NotNull
    private final BinaryVersion metadataVersion;
    @NotNull
    private final StringTableImpl stringTable;
    private final boolean allowErrorTypes;
    private final boolean exportKDoc;

    public KlibMetadataSerializerExtension(@NotNull LanguageVersionSettings languageVersionSettings, @NotNull BinaryVersion metadataVersion, @NotNull StringTableImpl stringTable2, boolean allowErrorTypes, boolean exportKDoc) {
        Intrinsics.checkNotNullParameter(languageVersionSettings, "languageVersionSettings");
        Intrinsics.checkNotNullParameter(metadataVersion, "metadataVersion");
        Intrinsics.checkNotNullParameter(stringTable2, "stringTable");
        super(KlibMetadataSerializerProtocol.INSTANCE);
        this.languageVersionSettings = languageVersionSettings;
        this.metadataVersion = metadataVersion;
        this.stringTable = stringTable2;
        this.allowErrorTypes = allowErrorTypes;
        this.exportKDoc = exportKDoc;
    }

    @Override
    @NotNull
    public BinaryVersion getMetadataVersion() {
        return this.metadataVersion;
    }

    @Override
    @NotNull
    public StringTableImpl getStringTable() {
        return this.stringTable;
    }

    @Override
    public boolean shouldUseTypeTable() {
        return true;
    }

    private final Integer descriptorFileId(DeclarationDescriptorWithSource descriptor2) {
        String string2 = descriptor2.getSource().getContainingFile().getName();
        if (string2 == null) {
            return null;
        }
        String fileName = string2;
        return this.getStringTable().getStringIndex(fileName);
    }

    @Override
    public void serializeFlexibleType(@NotNull FlexibleType flexibleType, @NotNull ProtoBuf.Type.Builder lowerProto, @NotNull ProtoBuf.Type.Builder upperProto) {
        Intrinsics.checkNotNullParameter(flexibleType, "flexibleType");
        Intrinsics.checkNotNullParameter(lowerProto, "lowerProto");
        Intrinsics.checkNotNullParameter(upperProto, "upperProto");
        lowerProto.setFlexibleTypeCapabilitiesId(this.getStringTable().getStringIndex("kotlin.DynamicType"));
    }

    @Override
    public void serializeErrorType(@NotNull KotlinType type2, @NotNull ProtoBuf.Type.Builder builder2) {
        Intrinsics.checkNotNullParameter(type2, "type");
        Intrinsics.checkNotNullParameter(builder2, "builder");
        if (!this.allowErrorTypes) {
            super.serializeErrorType(type2, builder2);
        }
    }

    @Override
    public void serializeClass(@NotNull ClassDescriptor descriptor2, @NotNull ProtoBuf.Class.Builder proto, @NotNull MutableVersionRequirementTable versionRequirementTable, @NotNull DescriptorSerializer childSerializer) {
        block3: {
            Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
            Intrinsics.checkNotNullParameter(proto, "proto");
            Intrinsics.checkNotNullParameter(versionRequirementTable, "versionRequirementTable");
            Intrinsics.checkNotNullParameter(childSerializer, "childSerializer");
            Integer n = this.descriptorFileId(descriptor2);
            if (n != null) {
                int it = ((Number)n).intValue();
                boolean bl = false;
                ProtoBuf.Class.Builder cfr_ignored_0 = (ProtoBuf.Class.Builder)proto.setExtension(KlibMetadataProtoBuf.classFile, it);
            }
            if (this.exportKDoc) {
                String string2 = KlibMetadataSerializerExtensionKt.findKDocString(descriptor2);
                if (string2 != null) {
                    String it = string2;
                    boolean bl = false;
                    ProtoBuf.Class.Builder cfr_ignored_1 = (ProtoBuf.Class.Builder)proto.setExtension(KlibMetadataProtoBuf.classKdoc, it);
                }
            }
            super.serializeClass(descriptor2, proto, versionRequirementTable, childSerializer);
            ProtoBuf.TypeTable typeTable = (ProtoBuf.TypeTable)childSerializer.getTypeTable().serialize();
            if (typeTable == null) break block3;
            ProtoBuf.TypeTable it = typeTable;
            boolean bl = false;
            proto.mergeTypeTable(it);
        }
    }

    @Override
    public void serializeConstructor(@NotNull ConstructorDescriptor descriptor2, @NotNull ProtoBuf.Constructor.Builder proto, @NotNull DescriptorSerializer childSerializer) {
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        Intrinsics.checkNotNullParameter(proto, "proto");
        Intrinsics.checkNotNullParameter(childSerializer, "childSerializer");
        if (this.exportKDoc) {
            String string2 = KlibMetadataSerializerExtensionKt.findKDocString(descriptor2);
            if (string2 != null) {
                String it = string2;
                boolean bl = false;
                ProtoBuf.Constructor.Builder cfr_ignored_0 = (ProtoBuf.Constructor.Builder)proto.setExtension(KlibMetadataProtoBuf.constructorKdoc, it);
            }
        }
        super.serializeConstructor(descriptor2, proto, childSerializer);
    }

    @Override
    public void serializeProperty(@NotNull PropertyDescriptor descriptor2, @NotNull ProtoBuf.Property.Builder proto, @Nullable MutableVersionRequirementTable versionRequirementTable, @NotNull DescriptorSerializer childSerializer) {
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        Intrinsics.checkNotNullParameter(proto, "proto");
        Intrinsics.checkNotNullParameter(childSerializer, "childSerializer");
        Integer n = this.descriptorFileId(descriptor2);
        if (n != null) {
            int it = ((Number)n).intValue();
            boolean bl = false;
            ProtoBuf.Property.Builder cfr_ignored_0 = (ProtoBuf.Property.Builder)proto.setExtension(KlibMetadataProtoBuf.propertyFile, it);
        }
        if (this.exportKDoc) {
            String string2 = KlibMetadataSerializerExtensionKt.findKDocString(descriptor2);
            if (string2 != null) {
                String it = string2;
                boolean bl = false;
                ProtoBuf.Property.Builder cfr_ignored_1 = (ProtoBuf.Property.Builder)proto.setExtension(KlibMetadataProtoBuf.propertyKdoc, it);
            }
        }
        super.serializeProperty(descriptor2, proto, versionRequirementTable, childSerializer);
    }

    @Override
    public void serializeFunction(@NotNull FunctionDescriptor descriptor2, @NotNull ProtoBuf.Function.Builder proto, @Nullable MutableVersionRequirementTable versionRequirementTable, @NotNull DescriptorSerializer childSerializer) {
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        Intrinsics.checkNotNullParameter(proto, "proto");
        Intrinsics.checkNotNullParameter(childSerializer, "childSerializer");
        Integer n = this.descriptorFileId(descriptor2);
        if (n != null) {
            int it = ((Number)n).intValue();
            boolean bl = false;
            ProtoBuf.Function.Builder cfr_ignored_0 = (ProtoBuf.Function.Builder)proto.setExtension(KlibMetadataProtoBuf.functionFile, it);
        }
        if (this.exportKDoc) {
            String string2 = KlibMetadataSerializerExtensionKt.findKDocString(descriptor2);
            if (string2 != null) {
                String it = string2;
                boolean bl = false;
                ProtoBuf.Function.Builder cfr_ignored_1 = (ProtoBuf.Function.Builder)proto.setExtension(KlibMetadataProtoBuf.functionKdoc, it);
            }
        }
        super.serializeFunction(descriptor2, proto, versionRequirementTable, childSerializer);
    }
}

