/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.asJava.builder;

import com.intellij.openapi.project.Project;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValueProvider;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analyzer.KotlinModificationTrackerService;
import org.jetbrains.kotlin.asJava.KotlinAsJavaSupport;
import org.jetbrains.kotlin.asJava.LightClassGenerationSupport;
import org.jetbrains.kotlin.asJava.builder.ClassFilterForFacade;
import org.jetbrains.kotlin.asJava.builder.LightClassBuilderKt;
import org.jetbrains.kotlin.asJava.builder.LightClassBuilderResult;
import org.jetbrains.kotlin.asJava.builder.LightClassConstructionContext;
import org.jetbrains.kotlin.asJava.builder.LightClassDataHolder;
import org.jetbrains.kotlin.codegen.MultifileClassCodegen;
import org.jetbrains.kotlin.codegen.PackageCodegen;
import org.jetbrains.kotlin.codegen.state.GenerationState;
import org.jetbrains.kotlin.fileClasses.JvmFileClassInfo;
import org.jetbrains.kotlin.fileClasses.JvmFileClassUtil;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002\u0015\u0016B\u0017\b\u0004\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\f\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\rH\u0016J\u0016\u0010\u000e\u001a\u00020\u00022\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0002J\u000e\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H&J\b\u0010\u0013\u001a\u00020\u0014H\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\u0003\u001a\u00020\u0004X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u0082\u0001\u0002\u0017\u0018\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/asJava/builder/LightClassDataProviderForFileFacade;", "Lcom/intellij/psi/util/CachedValueProvider;", "Lorg/jetbrains/kotlin/asJava/builder/LightClassDataHolder$ForFacade;", "project", "Lcom/intellij/openapi/project/Project;", "facadeFqName", "Lorg/jetbrains/kotlin/name/FqName;", "(Lcom/intellij/openapi/project/Project;Lorg/jetbrains/kotlin/name/FqName;)V", "getFacadeFqName", "()Lorg/jetbrains/kotlin/name/FqName;", "getProject", "()Lcom/intellij/openapi/project/Project;", "compute", "Lcom/intellij/psi/util/CachedValueProvider$Result;", "computeLightClassData", "files", "", "Lorg/jetbrains/kotlin/psi/KtFile;", "findFiles", "toString", "", "ByFile", "ByProjectSource", "Lorg/jetbrains/kotlin/asJava/builder/LightClassDataProviderForFileFacade$ByFile;", "Lorg/jetbrains/kotlin/asJava/builder/LightClassDataProviderForFileFacade$ByProjectSource;", "light-classes"})
public abstract class LightClassDataProviderForFileFacade
implements CachedValueProvider<LightClassDataHolder.ForFacade> {
    @NotNull
    private final Project project;
    @NotNull
    private final FqName facadeFqName;

    private LightClassDataProviderForFileFacade(Project project, FqName facadeFqName) {
        this.project = project;
        this.facadeFqName = facadeFqName;
    }

    @NotNull
    protected final Project getProject() {
        return this.project;
    }

    @NotNull
    protected final FqName getFacadeFqName() {
        return this.facadeFqName;
    }

    @NotNull
    public abstract Collection<KtFile> findFiles();

    private final LightClassDataHolder.ForFacade computeLightClassData(Collection<? extends KtFile> files2) {
        return LightClassGenerationSupport.Companion.getInstance(this.project).createDataHolderForFacade(files2, (Function1<? super LightClassConstructionContext, LightClassBuilderResult>)new Function1<LightClassConstructionContext, LightClassBuilderResult>(this, files2){
            final /* synthetic */ LightClassDataProviderForFileFacade this$0;
            final /* synthetic */ Collection<KtFile> $files;
            {
                this.this$0 = $receiver;
                this.$files = $files;
                super(1);
            }

            @NotNull
            public final LightClassBuilderResult invoke(@NotNull LightClassConstructionContext constructionContext) {
                Intrinsics.checkNotNullParameter(constructionContext, "constructionContext");
                FqName fqName2 = this.this$0.getFacadeFqName().parent();
                Intrinsics.checkNotNullExpressionValue(fqName2, "facadeFqName.parent()");
                return LightClassBuilderKt.buildLightClass(fqName2, this.$files, ClassFilterForFacade.INSTANCE, constructionContext, (Function2<? super GenerationState, ? super Collection<? extends KtFile>, Unit>)new Function2<GenerationState, Collection<? extends KtFile>, Unit>(this.this$0){
                    final /* synthetic */ LightClassDataProviderForFileFacade this$0;
                    {
                        this.this$0 = $receiver;
                        super(2);
                    }

                    public final void invoke(@NotNull GenerationState state, @NotNull Collection<? extends KtFile> files2) {
                        Intrinsics.checkNotNullParameter(state, "state");
                        Intrinsics.checkNotNullParameter(files2, "files");
                        KtFile representativeFile = (KtFile)CollectionsKt.first((Iterable)files2);
                        JvmFileClassInfo fileClassInfo = JvmFileClassUtil.getFileClassInfoNoResolve(representativeFile);
                        if (!fileClassInfo.getWithJvmMultifileClass()) {
                            PackageCodegen packageCodegen = state.getFactory().forPackage(representativeFile.getPackageFqName(), files2);
                            Intrinsics.checkNotNullExpressionValue(packageCodegen, "state.factory.forPackage\u2026ile.packageFqName, files)");
                            PackageCodegen codegen2 = packageCodegen;
                            codegen2.generate();
                            state.getFactory().done();
                            return;
                        }
                        MultifileClassCodegen multifileClassCodegen = state.getFactory().forMultifileClass(this.this$0.getFacadeFqName(), files2);
                        Intrinsics.checkNotNullExpressionValue(multifileClassCodegen, "state.factory.forMultifi\u2026lass(facadeFqName, files)");
                        MultifileClassCodegen codegen3 = multifileClassCodegen;
                        codegen3.generate();
                        state.getFactory().done();
                    }
                });
            }
        });
    }

    @Nullable
    public CachedValueProvider.Result<LightClassDataHolder.ForFacade> compute() {
        Collection<KtFile> files2 = this.findFiles();
        if (files2.isEmpty()) {
            return null;
        }
        Object[] objectArray = new Object[]{KotlinModificationTrackerService.Companion.getInstance(this.project).getOutOfBlockModificationTracker()};
        return CachedValueProvider.Result.create((Object)this.computeLightClassData(files2), (Object[])objectArray);
    }

    @NotNull
    public String toString() {
        return this.getClass().getName() + " for " + this.facadeFqName;
    }

    public /* synthetic */ LightClassDataProviderForFileFacade(Project project, FqName facadeFqName, DefaultConstructorMarker $constructor_marker) {
        this(project, facadeFqName);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u000e\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/asJava/builder/LightClassDataProviderForFileFacade$ByProjectSource;", "Lorg/jetbrains/kotlin/asJava/builder/LightClassDataProviderForFileFacade;", "project", "Lcom/intellij/openapi/project/Project;", "facadeFqName", "Lorg/jetbrains/kotlin/name/FqName;", "searchScope", "Lcom/intellij/psi/search/GlobalSearchScope;", "(Lcom/intellij/openapi/project/Project;Lorg/jetbrains/kotlin/name/FqName;Lcom/intellij/psi/search/GlobalSearchScope;)V", "findFiles", "", "Lorg/jetbrains/kotlin/psi/KtFile;", "light-classes"})
    public static final class ByProjectSource
    extends LightClassDataProviderForFileFacade {
        @NotNull
        private final GlobalSearchScope searchScope;

        public ByProjectSource(@NotNull Project project, @NotNull FqName facadeFqName, @NotNull GlobalSearchScope searchScope) {
            Intrinsics.checkNotNullParameter(project, "project");
            Intrinsics.checkNotNullParameter(facadeFqName, "facadeFqName");
            Intrinsics.checkNotNullParameter(searchScope, "searchScope");
            super(project, facadeFqName, null);
            this.searchScope = searchScope;
        }

        @Override
        @NotNull
        public Collection<KtFile> findFiles() {
            return KotlinAsJavaSupport.Companion.getInstance(this.getProject()).findFilesForFacade(this.getFacadeFqName(), this.searchScope);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u000e\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00070\nH\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/asJava/builder/LightClassDataProviderForFileFacade$ByFile;", "Lorg/jetbrains/kotlin/asJava/builder/LightClassDataProviderForFileFacade;", "project", "Lcom/intellij/openapi/project/Project;", "facadeFqName", "Lorg/jetbrains/kotlin/name/FqName;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "(Lcom/intellij/openapi/project/Project;Lorg/jetbrains/kotlin/name/FqName;Lorg/jetbrains/kotlin/psi/KtFile;)V", "findFiles", "", "light-classes"})
    public static final class ByFile
    extends LightClassDataProviderForFileFacade {
        @NotNull
        private final KtFile file;

        public ByFile(@NotNull Project project, @NotNull FqName facadeFqName, @NotNull KtFile file2) {
            Intrinsics.checkNotNullParameter(project, "project");
            Intrinsics.checkNotNullParameter(facadeFqName, "facadeFqName");
            Intrinsics.checkNotNullParameter(file2, "file");
            super(project, facadeFqName, null);
            this.file = file2;
        }

        @NotNull
        public List<KtFile> findFiles() {
            return CollectionsKt.listOf(this.file);
        }
    }
}

