/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.inference;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.resolve.calls.inference.CapturedType;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintContext;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystemBuilderImpl;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystemUtilsKt;
import org.jetbrains.kotlin.resolve.calls.inference.TypeBounds;
import org.jetbrains.kotlin.resolve.calls.inference.TypeBoundsImpl;
import org.jetbrains.kotlin.resolve.calls.inference.TypeBoundsKt;
import org.jetbrains.kotlin.resolve.calls.inference.TypeVariable;
import org.jetbrains.kotlin.resolve.calls.inference.constraintPosition.CompoundConstraintPosition;
import org.jetbrains.kotlin.resolve.calls.inference.constraintPosition.ConstraintPosition;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.TypeProjectionImpl;
import org.jetbrains.kotlin.types.TypeSubstitutor;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.types.typesApproximation.ApproximationBounds;
import org.jetbrains.kotlin.types.typesApproximation.CapturedTypeApproximationKt;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000\u0014\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u001a\u001c\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u001a\u001c\u0010\u0006\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0004H\u0002\u001a\u0012\u0010\t\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\n\u001a\u00020\u0004\u00a8\u0006\u000b"}, d2={"addConstraintFromBounds", "", "Lorg/jetbrains/kotlin/resolve/calls/inference/ConstraintSystemBuilderImpl;", "old", "Lorg/jetbrains/kotlin/resolve/calls/inference/TypeBounds$Bound;", "new", "generateNewBound", "bound", "substitution", "incorporateBound", "newBound", "frontend"})
public final class ConstraintIncorporationKt {
    public static final void incorporateBound(@NotNull ConstraintSystemBuilderImpl $this$incorporateBound, @NotNull TypeBounds.Bound newBound) {
        KotlinType constrainingType;
        List<TypeBounds.Bound> list2;
        List<Object> boundsUsedIn;
        int n;
        int oldBoundIndex;
        Intrinsics.checkNotNullParameter($this$incorporateBound, "<this>");
        Intrinsics.checkNotNullParameter(newBound, "newBound");
        TypeVariable typeVariable2 = newBound.getTypeVariable();
        TypeBoundsImpl typeBounds = $this$incorporateBound.getTypeBounds$frontend(typeVariable2);
        int n2 = 0;
        int n3 = ((ArrayList)typeBounds.getBounds()).size() + -1;
        if (n2 <= n3) {
            do {
                oldBoundIndex = n2++;
                Object e = ((ArrayList)typeBounds.getBounds()).get(oldBoundIndex);
                Intrinsics.checkNotNullExpressionValue(e, "typeBounds.bounds[oldBoundIndex]");
                ConstraintIncorporationKt.addConstraintFromBounds($this$incorporateBound, (TypeBounds.Bound)e, newBound);
            } while (n2 <= n3);
        }
        if ((n = 0) <= (oldBoundIndex = (boundsUsedIn = (list2 = $this$incorporateBound.getUsedInBounds$frontend().get(typeVariable2)) == null ? CollectionsKt.emptyList() : list2).size() + -1)) {
            do {
                int index2 = n++;
                TypeBounds.Bound boundUsedIn = (TypeBounds.Bound)boundsUsedIn.get(index2);
                ConstraintIncorporationKt.generateNewBound($this$incorporateBound, boundUsedIn, newBound);
            } while (n <= oldBoundIndex);
        }
        if ($this$incorporateBound.isMyTypeVariable$frontend(constrainingType = newBound.getConstrainingType())) {
            ConstraintContext context2 = new ConstraintContext(newBound.getPosition(), newBound.getDerivedFrom(), false, false, 12, null);
            TypeVariable typeVariable3 = $this$incorporateBound.getMyTypeVariable$frontend(constrainingType);
            Intrinsics.checkNotNull(typeVariable3);
            $this$incorporateBound.addBound$frontend(typeVariable3, typeVariable2.getType(), TypeBoundsKt.reverse(newBound.getKind()), context2);
            return;
        }
        Iterable $this$forEach$iv = $this$incorporateBound.getNestedTypeVariables$frontend(constrainingType);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            TypeVariable it = (TypeVariable)element$iv;
            boolean bl = false;
            int n4 = 0;
            Collection boundsForNestedVariable = $this$incorporateBound.getTypeBounds$frontend(it).getBounds();
            int n5 = ((ArrayList)boundsForNestedVariable).size() + -1;
            if (n4 > n5) continue;
            do {
                int index3 = n4++;
                Object e = ((ArrayList)boundsForNestedVariable).get(index3);
                Intrinsics.checkNotNullExpressionValue(e, "boundsForNestedVariable[index]");
                ConstraintIncorporationKt.generateNewBound($this$incorporateBound, newBound, (TypeBounds.Bound)e);
            } while (n4 <= n5);
        }
    }

    private static final void addConstraintFromBounds(ConstraintSystemBuilderImpl $this$addConstraintFromBounds, TypeBounds.Bound old, TypeBounds.Bound bound) {
        if (Intrinsics.areEqual(old, bound)) {
            return;
        }
        KotlinType oldType = old.getConstrainingType();
        KotlinType newType = bound.getConstrainingType();
        ConstraintPosition[] constraintPositionArray = new ConstraintPosition[]{old.getPosition(), bound.getPosition()};
        ConstraintContext context2 = new ConstraintContext(new CompoundConstraintPosition(constraintPositionArray), SetsKt.plus(old.getDerivedFrom(), (Iterable)bound.getDerivedFrom()), false, false, 12, null);
        if (old.getKind().ordinal() < bound.getKind().ordinal()) {
            $this$addConstraintFromBounds.addConstraint(ConstraintSystemBuilderImpl.ConstraintKind.SUB_TYPE, oldType, newType, context2);
        } else if (old.getKind().ordinal() > bound.getKind().ordinal()) {
            $this$addConstraintFromBounds.addConstraint(ConstraintSystemBuilderImpl.ConstraintKind.SUB_TYPE, newType, oldType, context2);
        } else if (old.getKind() == bound.getKind() && old.getKind() == TypeBounds.BoundKind.EXACT_BOUND) {
            $this$addConstraintFromBounds.addConstraint(ConstraintSystemBuilderImpl.ConstraintKind.EQUAL, oldType, newType, context2);
        }
    }

    private static final void generateNewBound(ConstraintSystemBuilderImpl $this$generateNewBound, TypeBounds.Bound bound, TypeBounds.Bound substitution) {
        ConstraintPosition[] constraintPositionArray;
        KotlinType kotlinType;
        if (bound == substitution) {
            return;
        }
        TypeBounds.BoundKind boundKind = substitution.getKind();
        int n = WhenMappings.$EnumSwitchMapping$0[boundKind.ordinal()];
        switch (n) {
            case 1: {
                kotlinType = substitution.getConstrainingType();
                break;
            }
            case 2: {
                kotlinType = new CapturedType(new TypeProjectionImpl(Variance.OUT_VARIANCE, substitution.getConstrainingType()), null, false, null, 14, null);
                break;
            }
            case 3: {
                kotlinType = new CapturedType(new TypeProjectionImpl(Variance.IN_VARIANCE, substitution.getConstrainingType()), null, false, null, 14, null);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        KotlinType substitutedType = kotlinType;
        TypeProjectionImpl newTypeProjection = new TypeProjectionImpl(substitutedType);
        TypeSubstitutor typeSubstitutor2 = TypeSubstitutor.create(MapsKt.mapOf(TuplesKt.to(substitution.getTypeVariable().getType().getConstructor(), newTypeProjection)));
        Intrinsics.checkNotNullExpressionValue(typeSubstitutor2, "create(mapOf(substitutio\u2026or to newTypeProjection))");
        TypeSubstitutor substitutor2 = typeSubstitutor2;
        ConstraintPosition[] constraintPositionArray2 = substitutor2.substitute(bound.getConstrainingType(), Variance.INVARIANT);
        if (constraintPositionArray2 == null) {
            return;
        }
        ConstraintPosition[] type2 = constraintPositionArray = constraintPositionArray2;
        constraintPositionArray2 = new ConstraintPosition[]{bound.getPosition(), substitution.getPosition()};
        CompoundConstraintPosition position = new CompoundConstraintPosition(constraintPositionArray2);
        if (substitution.getKind() == TypeBounds.BoundKind.EXACT_BOUND) {
            ConstraintIncorporationKt.generateNewBound$addNewBound($this$generateNewBound, bound, substitution, position, (KotlinType)type2, bound.getKind());
            return;
        }
        ApproximationBounds<KotlinType> approximationBounds = CapturedTypeApproximationKt.approximateCapturedTypes((KotlinType)type2);
        if (ConstraintIncorporationKt.generateNewBound$containsConstrainingTypeWithoutProjection(approximationBounds.getUpper(), substitution) && bound.getKind() != TypeBounds.BoundKind.LOWER_BOUND) {
            ConstraintIncorporationKt.generateNewBound$addNewBound($this$generateNewBound, bound, substitution, position, approximationBounds.getUpper(), TypeBounds.BoundKind.UPPER_BOUND);
        }
        if (ConstraintIncorporationKt.generateNewBound$containsConstrainingTypeWithoutProjection(approximationBounds.getLower(), substitution) && bound.getKind() != TypeBounds.BoundKind.UPPER_BOUND) {
            ConstraintIncorporationKt.generateNewBound$addNewBound($this$generateNewBound, bound, substitution, position, approximationBounds.getLower(), TypeBounds.BoundKind.LOWER_BOUND);
        }
    }

    private static final void generateNewBound$addNewBound(ConstraintSystemBuilderImpl $this_generateNewBound, TypeBounds.Bound $bound, TypeBounds.Bound $substitution, CompoundConstraintPosition position, KotlinType newConstrainingType, TypeBounds.BoundKind newBoundKind) {
        if ($this_generateNewBound.getNestedTypeVariables$frontend(newConstrainingType).contains($bound.getTypeVariable())) {
            return;
        }
        HashSet<TypeVariable> derivedFrom = new HashSet<TypeVariable>((Collection)SetsKt.plus($bound.getDerivedFrom(), (Iterable)$substitution.getDerivedFrom()));
        if (derivedFrom.contains($substitution.getTypeVariable())) {
            return;
        }
        derivedFrom.add($substitution.getTypeVariable());
        $this_generateNewBound.addBound$frontend($bound.getTypeVariable(), newConstrainingType, newBoundKind, new ConstraintContext(position, derivedFrom, false, false, 12, null));
    }

    private static final boolean generateNewBound$containsConstrainingTypeWithoutProjection(KotlinType $this$generateNewBound_u24containsConstrainingTypeWithoutProjection, TypeBounds.Bound $substitution) {
        boolean bl;
        block3: {
            Iterable $this$any$iv = ConstraintSystemUtilsKt.getNestedArguments($this$generateNewBound_u24containsConstrainingTypeWithoutProjection);
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    TypeProjection it = (TypeProjection)element$iv;
                    boolean bl2 = false;
                    if (!(Intrinsics.areEqual(it.getType().getConstructor(), $substitution.getConstrainingType().getConstructor()) && it.getProjectionKind() == Variance.INVARIANT)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[TypeBounds.BoundKind.values().length];
            nArray[TypeBounds.BoundKind.EXACT_BOUND.ordinal()] = 1;
            nArray[TypeBounds.BoundKind.UPPER_BOUND.ordinal()] = 2;
            nArray[TypeBounds.BoundKind.LOWER_BOUND.ordinal()] = 3;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

