/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.interpreter.state.reflection;

import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrValueDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.interpreter.stack.Variable;
import org.jetbrains.kotlin.ir.interpreter.state.State;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.types.IrSimpleType;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.AdditionalIrUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.util.RenderIrElementKt;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b \u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\tH\u0004J\u0010\u0010\u000f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\tH\u0004J\u0010\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0012H\u0004J\u001c\u0010\u0013\u001a\u00020\r2\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0015H\u0002J\u0014\u0010\u0017\u001a\u00020\u0018*\u00020\u00182\u0006\u0010\u0019\u001a\u00020\rH\u0004J\u0014\u0010\u001a\u001a\u00020\u0018*\u00020\u00182\u0006\u0010\u0019\u001a\u00020\rH\u0004J\f\u0010\u001b\u001a\u00020\r*\u00020\u0015H\u0004R\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/ir/interpreter/state/reflection/ReflectionState;", "Lorg/jetbrains/kotlin/ir/interpreter/state/State;", "()V", "fields", "", "Lorg/jetbrains/kotlin/ir/interpreter/stack/Variable;", "getFields", "()Ljava/util/List;", "getIrFunctionByIrCall", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "renderFunction", "", "irFunction", "renderLambda", "renderProperty", "property", "Lorg/jetbrains/kotlin/ir/declarations/IrProperty;", "renderReceivers", "dispatchReceiver", "Lorg/jetbrains/kotlin/ir/types/IrType;", "extensionReceiver", "getIrClassOfReflection", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "name", "getIrClassOfReflectionFromList", "renderType", "ir.interpreter"})
public abstract class ReflectionState
implements State {
    @NotNull
    private final List<Variable> fields;

    public ReflectionState() {
        boolean bl = false;
        this.fields = new ArrayList();
    }

    @Override
    @NotNull
    public List<Variable> getFields() {
        return this.fields;
    }

    @Override
    @Nullable
    public IrFunction getIrFunctionByIrCall(@NotNull IrCall expression2) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        return null;
    }

    @NotNull
    protected final IrClass getIrClassOfReflectionFromList(@NotNull IrClass $this$getIrClassOfReflectionFromList, @NotNull String name) {
        Intrinsics.checkNotNullParameter($this$getIrClassOfReflectionFromList, "<this>");
        Intrinsics.checkNotNullParameter(name, "name");
        Iterable $this$single$iv = $this$getIrClassOfReflectionFromList.getDeclarations();
        boolean $i$f$single = false;
        Object single$iv = null;
        boolean found$iv = false;
        for (Object element$iv : $this$single$iv) {
            IrDeclaration it = (IrDeclaration)element$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual(AdditionalIrUtilsKt.getNameForIrSerialization(it).asString(), name)) continue;
            if (found$iv) {
                throw (Throwable)new IllegalArgumentException("Collection contains more than one matching element.");
            }
            single$iv = element$iv;
            found$iv = true;
        }
        if (!found$iv) {
            throw (Throwable)new NoSuchElementException("Collection contains no element matching the predicate.");
        }
        IrProperty property2 = single$iv;
        IrSimpleFunction irSimpleFunction = property2.getGetter();
        Intrinsics.checkNotNull(irSimpleFunction);
        IrSimpleType list2 = (IrSimpleType)irSimpleFunction.getReturnType();
        IrType irType = IrTypesKt.getTypeOrNull(CollectionsKt.single(list2.getArguments()));
        Intrinsics.checkNotNull(irType);
        IrClassSymbol irClassSymbol = IrTypesKt.getClassOrNull(irType);
        Intrinsics.checkNotNull(irClassSymbol);
        return (IrClass)irClassSymbol.getOwner();
    }

    @NotNull
    protected final IrClass getIrClassOfReflection(@NotNull IrClass $this$getIrClassOfReflection, @NotNull String name) {
        Intrinsics.checkNotNullParameter($this$getIrClassOfReflection, "<this>");
        Intrinsics.checkNotNullParameter(name, "name");
        Iterable $this$single$iv = $this$getIrClassOfReflection.getDeclarations();
        boolean $i$f$single = false;
        Object single$iv = null;
        boolean found$iv = false;
        for (Object element$iv : $this$single$iv) {
            IrDeclaration it = (IrDeclaration)element$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual(AdditionalIrUtilsKt.getNameForIrSerialization(it).asString(), name)) continue;
            if (found$iv) {
                throw (Throwable)new IllegalArgumentException("Collection contains more than one matching element.");
            }
            single$iv = element$iv;
            found$iv = true;
        }
        if (!found$iv) {
            throw (Throwable)new NoSuchElementException("Collection contains no element matching the predicate.");
        }
        IrProperty property2 = single$iv;
        IrSimpleFunction irSimpleFunction = property2.getGetter();
        Intrinsics.checkNotNull(irSimpleFunction);
        IrSimpleType type2 = (IrSimpleType)irSimpleFunction.getReturnType();
        IrClassSymbol irClassSymbol = IrTypesKt.getClassOrNull(type2);
        Intrinsics.checkNotNull(irClassSymbol);
        return (IrClass)irClassSymbol.getOwner();
    }

    private final String renderReceivers(IrType dispatchReceiver, IrType extensionReceiver) {
        boolean addParentheses;
        boolean bl = false;
        boolean bl2 = false;
        StringBuilder stringBuilder2 = new StringBuilder();
        boolean bl3 = false;
        boolean bl4 = false;
        StringBuilder $this$renderReceivers_u24lambda_u2d2 = stringBuilder2;
        boolean bl5 = false;
        if (dispatchReceiver != null) {
            $this$renderReceivers_u24lambda_u2d2.append(this.renderType(dispatchReceiver));
            $this$renderReceivers_u24lambda_u2d2.append(".");
        }
        boolean bl6 = addParentheses = dispatchReceiver != null && extensionReceiver != null;
        if (addParentheses) {
            $this$renderReceivers_u24lambda_u2d2.append("(");
        }
        if (extensionReceiver != null) {
            $this$renderReceivers_u24lambda_u2d2.append(this.renderType(extensionReceiver));
            $this$renderReceivers_u24lambda_u2d2.append(".");
        }
        if (addParentheses) {
            $this$renderReceivers_u24lambda_u2d2.append(")");
        }
        String string2 = stringBuilder2.toString();
        Intrinsics.checkNotNullExpressionValue(string2, "StringBuilder().apply(builderAction).toString()");
        return string2;
    }

    @NotNull
    protected final String renderLambda(@NotNull IrFunction irFunction2) {
        IrType irType;
        Intrinsics.checkNotNullParameter(irFunction2, "irFunction");
        Object object = irFunction2.getDispatchReceiverParameter();
        IrType irType2 = irType = object == null ? null : ((IrValueDeclaration)object).getType();
        IrType irType3 = irType == null ? ((object = irFunction2.getExtensionReceiverParameter()) == null ? null : ((IrValueDeclaration)object).getType()) : irType;
        String receiver = irType3 == null ? null : this.renderType(irType3);
        String arguments2 = CollectionsKt.joinToString$default(irFunction2.getValueParameters(), null, "(", ")", 0, null, new Function1<IrValueParameter, CharSequence>(this){
            final /* synthetic */ ReflectionState this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final CharSequence invoke(@NotNull IrValueParameter it) {
                Intrinsics.checkNotNullParameter(it, "it");
                return this.this$0.renderType(it.getType());
            }
        }, 25, null);
        String returnType2 = this.renderType(irFunction2.getReturnType());
        object = arguments2 + " -> " + returnType2;
        boolean bl = false;
        boolean bl2 = false;
        Object it = object;
        boolean bl3 = false;
        return receiver != null ? receiver + '.' + (String)it : it;
    }

    @NotNull
    protected final String renderFunction(@NotNull IrFunction irFunction2) {
        Intrinsics.checkNotNullParameter(irFunction2, "irFunction");
        IrClass irClass2 = IrUtilsKt.getParentClassOrNull(irFunction2);
        IrSimpleType dispatchReceiver = irClass2 == null ? null : IrUtilsKt.getDefaultType(irClass2);
        IrValueParameter irValueParameter = irFunction2.getExtensionReceiverParameter();
        IrType extensionReceiver = irValueParameter == null ? null : irValueParameter.getType();
        String receivers = irFunction2 instanceof IrConstructor ? "" : this.renderReceivers(dispatchReceiver, extensionReceiver);
        String arguments2 = CollectionsKt.joinToString$default(irFunction2.getValueParameters(), null, "(", ")", 0, null, new Function1<IrValueParameter, CharSequence>(this){
            final /* synthetic */ ReflectionState this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final CharSequence invoke(@NotNull IrValueParameter it) {
                Intrinsics.checkNotNullParameter(it, "it");
                return this.this$0.renderType(it.getType());
            }
        }, 25, null);
        String returnType2 = this.renderType(irFunction2.getReturnType());
        return "fun " + receivers + irFunction2.getName() + arguments2 + ": " + returnType2;
    }

    @NotNull
    protected final String renderProperty(@NotNull IrProperty property2) {
        IrValueParameter irValueParameter;
        Intrinsics.checkNotNullParameter(property2, "property");
        String prefix = property2.isVar() ? "var" : "val";
        IrSimpleFunction irSimpleFunction = property2.getGetter();
        IrType irType = irSimpleFunction == null ? null : ((irValueParameter = irSimpleFunction.getDispatchReceiverParameter()) == null ? null : irValueParameter.getType());
        irSimpleFunction = property2.getGetter();
        String receivers = this.renderReceivers(irType, irSimpleFunction == null ? null : ((irValueParameter = irSimpleFunction.getExtensionReceiverParameter()) == null ? null : irValueParameter.getType()));
        IrSimpleFunction irSimpleFunction2 = property2.getGetter();
        Intrinsics.checkNotNull(irSimpleFunction2);
        String returnType2 = this.renderType(irSimpleFunction2.getReturnType());
        return prefix + ' ' + receivers + property2.getName() + ": " + returnType2;
    }

    @NotNull
    protected final String renderType(@NotNull IrType $this$renderType) {
        int index2;
        Intrinsics.checkNotNullParameter($this$renderType, "<this>");
        String renderedType2 = RenderIrElementKt.render($this$renderType);
        while ((index2 = StringsKt.indexOf$default((CharSequence)renderedType2, " of ", 0, false, 6, null)) != -1) {
            int n;
            int replaceUntilComma = StringsKt.indexOf$default((CharSequence)renderedType2, ',', index2, false, 4, null);
            int replaceUntilTriangle = StringsKt.indexOf$default((CharSequence)renderedType2, '>', index2, false, 4, null);
            if (replaceUntilComma == -1 && replaceUntilTriangle == -1) {
                n = renderedType2.length();
            } else if (replaceUntilComma == -1) {
                n = replaceUntilTriangle;
            } else if (replaceUntilTriangle == -1) {
                n = replaceUntilComma;
            } else {
                boolean bl = false;
                n = Math.min(replaceUntilComma, replaceUntilTriangle);
            }
            int replaceUntil = n;
            String string2 = renderedType2;
            CharSequence charSequence = "";
            boolean bl = false;
            String string3 = string2;
            if (string3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
            }
            renderedType2 = ((Object)StringsKt.replaceRange((CharSequence)string3, index2, replaceUntil, charSequence)).toString();
        }
        return renderedType2;
    }

    @Override
    @Nullable
    public State getField(@NotNull IrSymbol symbol2) {
        return State.DefaultImpls.getField(this, symbol2);
    }

    @Override
    public void setField(@NotNull Variable newVar) {
        State.DefaultImpls.setField(this, newVar);
    }
}

