/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers;

import com.intellij.lang.LighterASTNode;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.diff.FlyweightCapableTreeStructure;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.Visibility;
import org.jetbrains.kotlin.fir.ClassMembersKt;
import org.jetbrains.kotlin.fir.DefaultNamesKt;
import org.jetbrains.kotlin.fir.FirFakeSourceElementKind;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.FirSourceElement;
import org.jetbrains.kotlin.fir.FirSymbolOwner;
import org.jetbrains.kotlin.fir.SessionUtilsKt;
import org.jetbrains.kotlin.fir.analysis.FirSourceUtilsKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirTypeRefSource;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.fir.analysis.diagnostics.DiagnosticReporterKt;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirDiagnosticFactory2;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.analysis.diagnostics.LightTreePositioningStrategiesKt;
import org.jetbrains.kotlin.fir.declarations.FirAnnotationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousObject;
import org.jetbrains.kotlin.fir.declarations.FirCallableMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirClassLikeDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationOrigin;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirPropertyAccessor;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.declarations.FirTypeAlias;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameter;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameterRef;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.expressions.FirBlock;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirFunctionCall;
import org.jetbrains.kotlin.fir.expressions.FirQualifiedAccessExpression;
import org.jetbrains.kotlin.fir.expressions.impl.FirEmptyExpressionBlock;
import org.jetbrains.kotlin.fir.references.FirResolvedNamedReference;
import org.jetbrains.kotlin.fir.resolve.LookupTagUtilsKt;
import org.jetbrains.kotlin.fir.resolve.MainSessionComponentsKt;
import org.jetbrains.kotlin.fir.resolve.SessionHolder;
import org.jetbrains.kotlin.fir.resolve.TypeExpansionUtilsKt;
import org.jetbrains.kotlin.fir.resolve.inference.InferenceUtilsKt;
import org.jetbrains.kotlin.fir.resolve.transformers.FirSupertypesResolutionKt;
import org.jetbrains.kotlin.fir.scopes.FirKotlinScopeProviderKt;
import org.jetbrains.kotlin.fir.scopes.FirTypeScope;
import org.jetbrains.kotlin.fir.scopes.FirTypeScopeKt;
import org.jetbrains.kotlin.fir.scopes.ProcessorAction;
import org.jetbrains.kotlin.fir.symbols.AbstractFirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.ConeClassLikeLookupTag;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirIntersectionCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.types.CompilerConeAttributesKt;
import org.jetbrains.kotlin.fir.types.ConeClassErrorType;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeInferenceContext;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeNullability;
import org.jetbrains.kotlin.fir.types.ConeTypeProjection;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.ConeTypesKt;
import org.jetbrains.kotlin.fir.types.FirFunctionTypeRef;
import org.jetbrains.kotlin.fir.types.FirQualifierPart;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeProjection;
import org.jetbrains.kotlin.fir.types.FirTypeProjectionWithVariance;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.FirUserTypeRef;
import org.jetbrains.kotlin.fir.types.ProjectionKind;
import org.jetbrains.kotlin.lexer.KtModifierKeywordToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.StandardClassIds;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.types.AbstractTypeChecker;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.types.model.KotlinTypeMarker;
import org.jetbrains.kotlin.types.model.TypeCheckerProviderContext;
import org.jetbrains.kotlin.util.ImplementationStatus;
import org.jetbrains.kotlin.util.OperatorNameConventions;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000\u0082\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a \u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0000\u001a6\u0010\u001c\u001a\u00020\u00152\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010 \u001a\u00020!2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\"\u001a\u00020\u0003\u001a\u001a\u0010#\u001a\u0004\u0018\u00010$2\b\u0010%\u001a\u0004\u0018\u00010&2\u0006\u0010'\u001a\u00020(\u001a\u001e\u0010)\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020*2\u0006\u0010+\u001a\u00020\u001e2\u0006\u0010,\u001a\u00020\u001e\u001a \u0010-\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020*2\u0006\u0010+\u001a\u00020\u001e2\u0006\u0010,\u001a\u00020\u001eH\u0002\u001a \u0010.\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020*2\u0006\u0010/\u001a\u00020\u001e2\u0006\u00100\u001a\u000201H\u0002\u001a\u0012\u00102\u001a\u00020\u0003*\u00020\u001e2\u0006\u00103\u001a\u000204\u001a\u0010\u00105\u001a\b\u0012\u0002\b\u0003\u0018\u000106*\u00020\u0019\u001a\u0018\u00107\u001a\u0004\u0018\u00010&*\u0006\u0012\u0002\b\u0003062\u0006\u0010\u0018\u001a\u00020\u0019\u001a\u001c\u00108\u001a\b\u0012\u0002\b\u0003\u0018\u000109*\u0006\u0012\u0002\b\u0003092\u0006\u00103\u001a\u000204\u001a\u001c\u0010:\u001a\b\u0012\u0002\b\u0003\u0018\u000109*\u0006\u0012\u0002\b\u00030;2\u0006\u0010\u0018\u001a\u00020\u0019\u001a\u001e\u0010:\u001a\b\u0012\u0002\b\u0003\u0018\u000109*\u0006\u0012\u0002\b\u00030;2\u0006\u0010<\u001a\u00020=H\u0002\u001a \u0010>\u001a\u0004\u0018\u0001H?\"\n\b\u0000\u0010?\u0018\u0001*\u00020@*\u00020AH\u0086\b\u00a2\u0006\u0002\u0010B\u001a\"\u0010C\u001a\u00020D*\u0006\u0012\u0002\b\u00030E2\u0006\u0010<\u001a\u00020=2\n\u0010F\u001a\u0006\u0012\u0002\b\u000306\u001a\u000e\u0010G\u001a\u0004\u0018\u00010H*\u0004\u0018\u00010I\u001a\f\u0010J\u001a\u00020\u0003*\u00020KH\u0002\u001a\u0012\u0010L\u001a\u00020M*\u00020N2\u0006\u0010\u0018\u001a\u00020\u0019\u001a\u0012\u0010O\u001a\u00020\u0003*\u00020\u001e2\u0006\u00103\u001a\u000204\u001a\n\u0010P\u001a\u00020\u0003*\u00020N\u001a\u001c\u0010Q\u001a\u00020\u0003*\u00020R2\u0006\u0010\u0018\u001a\u00020S2\b\u0010T\u001a\u0004\u0018\u00010R\u001a\u0012\u0010U\u001a\u00020\u0003*\u00020\u001e2\u0006\u00103\u001a\u000204\u001a\"\u0010V\u001a\u00020\u0003*\u0006\u0012\u0002\b\u0003062\n\u0010W\u001a\u0006\u0012\u0002\b\u0003062\u0006\u00103\u001a\u000204\u001a\u001c\u0010V\u001a\u00020\u0003*\u00020R2\u0006\u0010\u0018\u001a\u00020S2\b\u0010T\u001a\u0004\u0018\u00010R\u001a\u001a\u0010X\u001a\u00020\u0003*\u0006\u0012\u0002\b\u00030E2\n\u0010F\u001a\u0006\u0012\u0002\b\u000306\u001a\u0010\u0010Y\u001a\u0004\u0018\u00010M*\u0006\u0012\u0002\b\u000306\u001a\u001c\u0010Z\u001a\b\u0012\u0002\b\u0003\u0018\u000106*\u0006\u0012\u0002\b\u0003062\u0006\u0010\u0018\u001a\u00020\u0019\u001a\u001c\u0010Z\u001a\b\u0012\u0002\b\u0003\u0018\u00010[*\u0006\u0012\u0002\b\u00030[2\u0006\u0010\u0018\u001a\u00020\u0019\u001a(\u0010\\\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030^0]*\u00020\u000b2\n\u0010_\u001a\u0006\u0012\u0002\b\u0003062\u0006\u0010\u0018\u001a\u00020\u0019\u001a\u0014\u0010`\u001a\u00020\u0003*\u00020a2\u0006\u0010<\u001a\u00020=H\u0002\u001a\u0018\u0010b\u001a\b\u0012\u0002\b\u0003\u0018\u000106*\u00020c2\u0006\u00103\u001a\u000204\u001a\u0014\u0010d\u001a\u0004\u0018\u00010e*\u00020c2\u0006\u00103\u001a\u000204\u001a\u0014\u0010d\u001a\u0004\u0018\u00010e*\u00020\u001e2\u0006\u00103\u001a\u000204\u001a\u0014\u0010d\u001a\u0004\u0018\u00010e*\u00020&2\u0006\u00103\u001a\u000204\u001a\f\u0010f\u001a\u0004\u0018\u00010H*\u00020g\u001a\u0016\u0010h\u001a\u00020i*\u0006\u0012\u0002\b\u0003062\u0006\u0010\u0018\u001a\u00020\u0019\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0015\u0010\u0002\u001a\u00020\u0003*\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\"\u0015\u0010\u0007\u001a\u00020\u0003*\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\t\"\u0018\u0010\n\u001a\u00020\u0003*\u00020\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\"\u0018\u0010\u000e\u001a\u00020\u0003*\u00020\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\r\"\u0018\u0010\u0010\u001a\u00020\u0003*\u00020\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\r\"\u0018\u0010\u0012\u001a\u00020\u0003*\u00020\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\r\u00a8\u0006j"}, d2={"INLINE_ONLY_ANNOTATION_CLASS_ID", "Lorg/jetbrains/kotlin/name/ClassId;", "hasValOrVar", "", "Lorg/jetbrains/kotlin/fir/declarations/FirValueParameter;", "getHasValOrVar", "(Lorg/jetbrains/kotlin/fir/declarations/FirValueParameter;)Z", "isIterator", "Lorg/jetbrains/kotlin/fir/expressions/FirFunctionCall;", "(Lorg/jetbrains/kotlin/fir/expressions/FirFunctionCall;)Z", "matchesDataClassSyntheticMemberSignatures", "Lorg/jetbrains/kotlin/fir/declarations/FirSimpleFunction;", "getMatchesDataClassSyntheticMemberSignatures", "(Lorg/jetbrains/kotlin/fir/declarations/FirSimpleFunction;)Z", "matchesEqualsSignature", "getMatchesEqualsSignature", "matchesHashCodeSignature", "getMatchesHashCodeSignature", "matchesToStringSignature", "getMatchesToStringSignature", "checkCondition", "", "condition", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/fir/analysis/diagnostics/DiagnosticReporter;", "checkTypeMismatch", "lValueOriginalType", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "rValue", "source", "Lorg/jetbrains/kotlin/fir/FirSourceElement;", "isInitializer", "extractArgumentTypeRefAndSource", "Lorg/jetbrains/kotlin/fir/analysis/checkers/FirTypeRefSource;", "typeRef", "Lorg/jetbrains/kotlin/fir/types/FirTypeRef;", "index", "", "isSubtypeForTypeMismatch", "Lorg/jetbrains/kotlin/fir/types/ConeInferenceContext;", "subtype", "supertype", "isSubtypeOfForFunctionalTypeReturningUnit", "lowerThanBound", "argument", "typeParameter", "Lorg/jetbrains/kotlin/fir/declarations/FirTypeParameter;", "canHaveSubtypes", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "findClosestClassOrObject", "Lorg/jetbrains/kotlin/fir/declarations/FirClass;", "findNonInterfaceSupertype", "followAllAlias", "Lorg/jetbrains/kotlin/fir/declarations/FirClassLikeDeclaration;", "getContainingClass", "Lorg/jetbrains/kotlin/fir/FirSymbolOwner;", "sessionHolder", "Lorg/jetbrains/kotlin/fir/resolve/SessionHolder;", "getDeclaration", "T", "", "Lorg/jetbrains/kotlin/fir/expressions/FirQualifiedAccessExpression;", "(Lorg/jetbrains/kotlin/fir/expressions/FirQualifiedAccessExpression;)Ljava/lang/Object;", "getImplementationStatus", "Lorg/jetbrains/kotlin/util/ImplementationStatus;", "Lorg/jetbrains/kotlin/fir/declarations/FirCallableMemberDeclaration;", "parentClass", "getVisibility", "Lorg/jetbrains/kotlin/descriptors/Visibility;", "Lorg/jetbrains/kotlin/psi/KtModifierList;", "hasBody", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "implicitModality", "Lorg/jetbrains/kotlin/descriptors/Modality;", "Lorg/jetbrains/kotlin/fir/declarations/FirMemberDeclaration;", "isInline", "isInlineOnly", "isSubtypeOf", "Lorg/jetbrains/kotlin/types/model/KotlinTypeMarker;", "Lorg/jetbrains/kotlin/types/model/TypeCheckerProviderContext;", "type", "isSubtypeOfThrowable", "isSupertypeOf", "other", "isVisibleInClass", "modality", "outerClass", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassLikeSymbol;", "overriddenFunctions", "", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirFunctionSymbol;", "containingClass", "subjectToManyNotImplemented", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirIntersectionCallableSymbol;", "toClass", "Lorg/jetbrains/kotlin/fir/types/ConeClassLikeType;", "toRegularClass", "Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;", "toVisibilityOrNull", "Lorg/jetbrains/kotlin/lexer/KtModifierKeywordToken;", "unsubstitutedScope", "Lorg/jetbrains/kotlin/fir/scopes/FirTypeScope;", "checkers"})
public final class FirHelpersKt {
    @NotNull
    private static final ClassId INLINE_ONLY_ANNOTATION_CLASS_ID;

    @NotNull
    public static final FirTypeScope unsubstitutedScope(@NotNull FirClass<?> $this$unsubstitutedScope, @NotNull CheckerContext context2) {
        Intrinsics.checkNotNullParameter($this$unsubstitutedScope, "<this>");
        Intrinsics.checkNotNullParameter(context2, "context");
        return FirKotlinScopeProviderKt.unsubstitutedScope($this$unsubstitutedScope, context2.getSessionHolder().getSession(), context2.getSessionHolder().getScopeSession(), false);
    }

    public static final boolean isSupertypeOf(@NotNull FirClass<?> $this$isSupertypeOf, @NotNull FirClass<?> other, @NotNull FirSession session2) {
        Intrinsics.checkNotNullParameter($this$isSupertypeOf, "<this>");
        Intrinsics.checkNotNullParameter(other, "other");
        Intrinsics.checkNotNullParameter(session2, "session");
        boolean bl = false;
        return FirHelpersKt.isSupertypeOf$isSupertypeOf($this$isSupertypeOf, session2, other, new LinkedHashSet());
    }

    @Nullable
    public static final FirClass<?> toClass(@NotNull ConeClassLikeType $this$toClass, @NotNull FirSession session2) {
        FirClassSymbol firClassSymbol;
        Intrinsics.checkNotNullParameter($this$toClass, "<this>");
        Intrinsics.checkNotNullParameter(session2, "session");
        FirClassLikeSymbol<?> $this$safeAs$iv = LookupTagUtilsKt.toSymbol($this$toClass.getLookupTag(), session2);
        boolean $i$f$safeAs = false;
        FirClassLikeSymbol<?> firClassLikeSymbol = $this$safeAs$iv;
        if (!(firClassLikeSymbol instanceof FirClassSymbol)) {
            firClassLikeSymbol = null;
        }
        return (firClassSymbol = (FirClassSymbol)firClassLikeSymbol) == null ? null : (FirClass)firClassSymbol.getFir();
    }

    @Nullable
    public static final FirRegularClass toRegularClass(@NotNull ConeClassLikeType $this$toRegularClass, @NotNull FirSession session2) {
        FirRegularClassSymbol firRegularClassSymbol;
        Intrinsics.checkNotNullParameter($this$toRegularClass, "<this>");
        Intrinsics.checkNotNullParameter(session2, "session");
        FirClassLikeSymbol<?> $this$safeAs$iv = LookupTagUtilsKt.toSymbol($this$toRegularClass.getLookupTag(), session2);
        boolean $i$f$safeAs = false;
        FirClassLikeSymbol<?> firClassLikeSymbol = $this$safeAs$iv;
        if (!(firClassLikeSymbol instanceof FirRegularClassSymbol)) {
            firClassLikeSymbol = null;
        }
        return (firRegularClassSymbol = (FirRegularClassSymbol)firClassLikeSymbol) == null ? null : (FirRegularClass)firRegularClassSymbol.getFir();
    }

    @Nullable
    public static final FirRegularClass toRegularClass(@NotNull ConeKotlinType $this$toRegularClass, @NotNull FirSession session2) {
        ConeClassLikeType coneClassLikeType;
        ConeClassLikeType coneClassLikeType2;
        Intrinsics.checkNotNullParameter($this$toRegularClass, "<this>");
        Intrinsics.checkNotNullParameter(session2, "session");
        ConeKotlinType $this$safeAs$iv = $this$toRegularClass;
        boolean $i$f$safeAs = false;
        ConeKotlinType coneKotlinType = $this$safeAs$iv;
        if (!(coneKotlinType instanceof ConeClassLikeType)) {
            coneKotlinType = null;
        }
        return (coneClassLikeType2 = (ConeClassLikeType)coneKotlinType) == null ? null : ((coneClassLikeType = TypeExpansionUtilsKt.fullyExpandedType$default(coneClassLikeType2, session2, null, 2, null)) == null ? null : FirHelpersKt.toRegularClass(coneClassLikeType, session2));
    }

    public static final boolean isInline(@NotNull ConeKotlinType $this$isInline, @NotNull FirSession session2) {
        boolean bl;
        Intrinsics.checkNotNullParameter($this$isInline, "<this>");
        Intrinsics.checkNotNullParameter(session2, "session");
        FirRegularClass firRegularClass = FirHelpersKt.toRegularClass($this$isInline, session2);
        if (firRegularClass == null) {
            bl = false;
        } else {
            FirMemberDeclaration $this$isInline$iv = firRegularClass;
            boolean $i$f$isInline = false;
            bl = $this$isInline$iv.getStatus().isInline();
        }
        return bl;
    }

    @Nullable
    public static final FirRegularClass toRegularClass(@NotNull FirTypeRef $this$toRegularClass, @NotNull FirSession session2) {
        Intrinsics.checkNotNullParameter($this$toRegularClass, "<this>");
        Intrinsics.checkNotNullParameter(session2, "session");
        return FirHelpersKt.toRegularClass(FirTypeUtilsKt.getConeType($this$toRegularClass), session2);
    }

    public static final /* synthetic */ <T> T getDeclaration(FirQualifiedAccessExpression $this$getDeclaration) {
        FirResolvedNamedReference firResolvedNamedReference;
        Intrinsics.checkNotNullParameter($this$getDeclaration, "<this>");
        boolean $i$f$getDeclaration = false;
        Object $this$safeAs$iv = $this$getDeclaration.getCalleeReference();
        boolean $i$f$safeAs = false;
        Object object = $this$safeAs$iv;
        if (!(object instanceof FirResolvedNamedReference)) {
            object = null;
        }
        Object $this$safeAs$iv2 = (firResolvedNamedReference = (FirResolvedNamedReference)object) == null ? null : (($this$safeAs$iv = firResolvedNamedReference.getResolvedSymbol()) == null ? null : ((AbstractFirBasedSymbol)$this$safeAs$iv).getFir());
        boolean $i$f$safeAs2 = false;
        Intrinsics.reifiedOperationMarker(2, "T");
        return (T)((Object)$this$safeAs$iv2);
    }

    @Nullable
    public static final FirClassLikeDeclaration<?> getContainingClass(@NotNull FirSymbolOwner<?> $this$getContainingClass, @NotNull CheckerContext context2) {
        FirClassLikeSymbol<?> firClassLikeSymbol;
        ConeClassLikeLookupTag coneClassLikeLookupTag;
        FirCallableMemberDeclaration firCallableMemberDeclaration;
        Intrinsics.checkNotNullParameter($this$getContainingClass, "<this>");
        Intrinsics.checkNotNullParameter(context2, "context");
        FirSymbolOwner<?> $this$safeAs$iv = $this$getContainingClass;
        boolean $i$f$safeAs = false;
        FirSymbolOwner<?> firSymbolOwner = $this$safeAs$iv;
        if (!(firSymbolOwner instanceof FirCallableMemberDeclaration)) {
            firSymbolOwner = null;
        }
        return (firCallableMemberDeclaration = (FirCallableMemberDeclaration)firSymbolOwner) == null ? null : ((coneClassLikeLookupTag = ClassMembersKt.containingClass(firCallableMemberDeclaration)) == null ? null : ((firClassLikeSymbol = LookupTagUtilsKt.toSymbol(coneClassLikeLookupTag, context2.getSession())) == null ? null : (FirClassLikeDeclaration)firClassLikeSymbol.getFir()));
    }

    @Nullable
    public static final FirClassLikeSymbol<?> outerClass(@NotNull FirClassLikeSymbol<?> $this$outerClass, @NotNull CheckerContext context2) {
        ClassId classId;
        Intrinsics.checkNotNullParameter($this$outerClass, "<this>");
        Intrinsics.checkNotNullParameter(context2, "context");
        if (!($this$outerClass instanceof FirClassSymbol)) {
            return null;
        }
        ClassId classId2 = $this$outerClass.getClassId().getOuterClassId();
        if (classId2 == null) {
            return null;
        }
        ClassId outerClassId = classId = classId2;
        return MainSessionComponentsKt.getSymbolProvider(context2.getSession()).getClassLikeSymbolByFqName(outerClassId);
    }

    @Nullable
    public static final FirClass<?> outerClass(@NotNull FirClass<?> $this$outerClass, @NotNull CheckerContext context2) {
        Intrinsics.checkNotNullParameter($this$outerClass, "<this>");
        Intrinsics.checkNotNullParameter(context2, "context");
        FirClassLikeSymbol<?> firClassLikeSymbol = FirHelpersKt.outerClass((FirClassLikeSymbol)$this$outerClass.getSymbol(), context2);
        FirClassLikeDeclaration firClassLikeDeclaration = firClassLikeSymbol == null ? null : (FirClassLikeDeclaration)firClassLikeSymbol.getFir();
        return firClassLikeDeclaration instanceof FirClass ? (FirClass)firClassLikeDeclaration : null;
    }

    @Nullable
    public static final FirClassLikeDeclaration<?> followAllAlias(@NotNull FirClassLikeDeclaration<?> $this$followAllAlias, @NotNull FirSession session2) {
        Intrinsics.checkNotNullParameter($this$followAllAlias, "<this>");
        Intrinsics.checkNotNullParameter(session2, "session");
        FirClassLikeDeclaration<?> it = $this$followAllAlias;
        while (it instanceof FirTypeAlias) {
            it = FirSupertypesResolutionKt.firClassLike(((FirTypeAlias)it).getExpandedTypeRef(), session2);
        }
        return it;
    }

    @Nullable
    public static final FirClass<?> findClosestClassOrObject(@NotNull CheckerContext $this$findClosestClassOrObject) {
        Intrinsics.checkNotNullParameter($this$findClosestClassOrObject, "<this>");
        for (FirDeclaration it : CollectionsKt.asReversed($this$findClosestClassOrObject.getContainingDeclarations())) {
            if (!(it instanceof FirRegularClass) && !(it instanceof FirAnonymousObject)) continue;
            return (FirClass)it;
        }
        return null;
    }

    @NotNull
    public static final List<FirFunctionSymbol<?>> overriddenFunctions(@NotNull FirSimpleFunction $this$overriddenFunctions, @NotNull FirClass<?> containingClass, @NotNull CheckerContext context2) {
        Intrinsics.checkNotNullParameter($this$overriddenFunctions, "<this>");
        Intrinsics.checkNotNullParameter(containingClass, "containingClass");
        Intrinsics.checkNotNullParameter(context2, "context");
        FirTypeScope firTypeScope = FirKotlinScopeProviderKt.unsubstitutedScope(containingClass, context2.getSessionHolder().getSession(), context2.getSessionHolder().getScopeSession(), true);
        boolean bl = false;
        List overriddenFunctions2 = new ArrayList();
        firTypeScope.processFunctionsByName(((FirSimpleFunction)$this$overriddenFunctions.getSymbol().getFir()).getName(), overriddenFunctions.1.INSTANCE);
        FirTypeScopeKt.processOverriddenFunctions(firTypeScope, $this$overriddenFunctions.getSymbol(), (Function1<? super FirNamedFunctionSymbol, ? extends ProcessorAction>)new Function1<FirNamedFunctionSymbol, ProcessorAction>(overriddenFunctions2){
            final /* synthetic */ List<FirFunctionSymbol<?>> $overriddenFunctions;
            {
                this.$overriddenFunctions = $overriddenFunctions;
                super(1);
            }

            @NotNull
            public final ProcessorAction invoke(@NotNull FirNamedFunctionSymbol it) {
                Intrinsics.checkNotNullParameter(it, "it");
                this.$overriddenFunctions.add(it);
                return ProcessorAction.NEXT;
            }
        });
        return overriddenFunctions2;
    }

    @Nullable
    public static final Visibility getVisibility(@Nullable KtModifierList $this$getVisibility) {
        KtModifierKeywordToken ktModifierKeywordToken;
        KtModifierList ktModifierList = $this$getVisibility;
        return ktModifierList == null ? null : ((ktModifierKeywordToken = KtPsiUtilKt.visibilityModifierType(ktModifierList)) == null ? null : FirHelpersKt.toVisibilityOrNull(ktModifierKeywordToken));
    }

    @Nullable
    public static final Visibility toVisibilityOrNull(@NotNull KtModifierKeywordToken $this$toVisibilityOrNull) {
        Intrinsics.checkNotNullParameter($this$toVisibilityOrNull, "<this>");
        KtModifierKeywordToken ktModifierKeywordToken = $this$toVisibilityOrNull;
        return Intrinsics.areEqual(ktModifierKeywordToken, KtTokens.PUBLIC_KEYWORD) ? (Visibility)Visibilities.Public.INSTANCE : (Intrinsics.areEqual(ktModifierKeywordToken, KtTokens.PRIVATE_KEYWORD) ? (Visibility)Visibilities.Private.INSTANCE : (Intrinsics.areEqual(ktModifierKeywordToken, KtTokens.PROTECTED_KEYWORD) ? (Visibility)Visibilities.Protected.INSTANCE : (Intrinsics.areEqual(ktModifierKeywordToken, KtTokens.INTERNAL_KEYWORD) ? (Visibility)Visibilities.Internal.INSTANCE : null)));
    }

    @Nullable
    public static final Modality modality(@NotNull FirClass<?> $this$modality) {
        Modality modality;
        Intrinsics.checkNotNullParameter($this$modality, "<this>");
        FirClass<?> firClass = $this$modality;
        if (firClass instanceof FirRegularClass) {
            FirRegularClass $this$modality$iv = (FirRegularClass)$this$modality;
            boolean $i$f$getModality = false;
            modality = $this$modality$iv.getStatus().getModality();
        } else {
            modality = Modality.FINAL;
        }
        return modality;
    }

    @NotNull
    public static final Modality implicitModality(@NotNull FirMemberDeclaration $this$implicitModality, @NotNull CheckerContext context2) {
        LighterASTNode lighterASTNode2;
        Intrinsics.checkNotNullParameter($this$implicitModality, "<this>");
        Intrinsics.checkNotNullParameter(context2, "context");
        if ($this$implicitModality instanceof FirRegularClass && (((FirRegularClass)$this$implicitModality).getClassKind() == ClassKind.CLASS || ((FirRegularClass)$this$implicitModality).getClassKind() == ClassKind.OBJECT)) {
            if (((FirRegularClass)$this$implicitModality).getClassKind() == ClassKind.INTERFACE) {
                return Modality.ABSTRACT;
            }
            return Modality.FINAL;
        }
        FirClass<?> firClass = FirHelpersKt.findClosestClassOrObject(context2);
        if (firClass == null) {
            return Modality.FINAL;
        }
        FirClass<?> klass = firClass;
        FirSourceElement firSourceElement = $this$implicitModality.getSource();
        if (firSourceElement == null) {
            return Modality.FINAL;
        }
        FirSourceElement source = firSourceElement;
        FlyweightCapableTreeStructure<LighterASTNode> tree = source.getTreeStructure();
        if (LightTreePositioningStrategiesKt.overrideModifier(tree, source.getLighterASTNode()) != null) {
            IElementType iElementType;
            FirSourceElement firSourceElement2 = klass.getSource();
            if (firSourceElement2 == null) {
                iElementType = null;
            } else {
                FirSourceElement firSourceElement3 = firSourceElement2;
                boolean bl = false;
                boolean bl2 = false;
                FirSourceElement it = firSourceElement3;
                boolean bl3 = false;
                LighterASTNode lighterASTNode3 = LightTreePositioningStrategiesKt.modalityModifier(tree, it.getLighterASTNode());
                iElementType = lighterASTNode3 == null ? null : lighterASTNode3.getTokenType();
            }
            IElementType klassModalityTokenType = iElementType;
            if (Intrinsics.areEqual(klassModalityTokenType, KtTokens.ABSTRACT_KEYWORD) || Intrinsics.areEqual(klassModalityTokenType, KtTokens.OPEN_KEYWORD) || Intrinsics.areEqual(klassModalityTokenType, KtTokens.SEALED_KEYWORD)) {
                return Modality.OPEN;
            }
        }
        if (klass instanceof FirRegularClass && klass.getClassKind() == ClassKind.INTERFACE && !Intrinsics.areEqual((lighterASTNode2 = LightTreePositioningStrategiesKt.visibilityModifier(tree, source.getLighterASTNode())) == null ? null : lighterASTNode2.getTokenType(), KtTokens.PRIVATE_KEYWORD)) {
            return FirHelpersKt.hasBody($this$implicitModality) ? Modality.OPEN : Modality.ABSTRACT;
        }
        return Modality.FINAL;
    }

    private static final boolean hasBody(FirDeclaration $this$hasBody) {
        FirPropertyAccessor firPropertyAccessor;
        FirBlock firBlock;
        FirDeclaration firDeclaration = $this$hasBody;
        boolean bl = firDeclaration instanceof FirSimpleFunction ? ((FirSimpleFunction)$this$hasBody).getBody() != null && !(((FirSimpleFunction)$this$hasBody).getBody() instanceof FirEmptyExpressionBlock) : (firDeclaration instanceof FirProperty ? !((firBlock = (firPropertyAccessor = ((FirProperty)$this$hasBody).getSetter()) == null ? null : firPropertyAccessor.getBody()) == null ? true : firBlock instanceof FirEmptyExpressionBlock) || !((firBlock = (firPropertyAccessor = ((FirProperty)$this$hasBody).getGetter()) == null ? null : firPropertyAccessor.getBody()) == null ? true : firBlock instanceof FirEmptyExpressionBlock) : false);
        return bl;
    }

    @Nullable
    public static final FirTypeRef findNonInterfaceSupertype(@NotNull FirClass<?> $this$findNonInterfaceSupertype, @NotNull CheckerContext context2) {
        Intrinsics.checkNotNullParameter($this$findNonInterfaceSupertype, "<this>");
        Intrinsics.checkNotNullParameter(context2, "context");
        for (FirTypeRef superTypeRef : $this$findNonInterfaceSupertype.getSuperTypeRefs()) {
            Object fir;
            Object object;
            ConeClassLikeLookupTag coneClassLikeLookupTag;
            FirClassLikeSymbol<?> $this$safeAs$iv = FirTypeUtilsKt.getConeType(superTypeRef);
            boolean $i$f$safeAs = false;
            Object object2 = $this$safeAs$iv;
            if (!(object2 instanceof ConeClassLikeType)) {
                object2 = null;
            }
            if ((coneClassLikeLookupTag = (object = (ConeClassLikeType)object2) == null ? null : ((ConeClassLikeType)object).getLookupTag()) == null) continue;
            ConeClassLikeLookupTag lookupTag = coneClassLikeLookupTag;
            $this$safeAs$iv = LookupTagUtilsKt.toSymbol(lookupTag, context2.getSession());
            $this$safeAs$iv = $this$safeAs$iv == null ? null : (FirClassLikeDeclaration)$this$safeAs$iv.getFir();
            $i$f$safeAs = false;
            FirClassLikeSymbol<?> firClassLikeSymbol = $this$safeAs$iv;
            if (!(firClassLikeSymbol instanceof FirClass)) {
                firClassLikeSymbol = null;
            }
            if ((object = (FirClass)((Object)firClassLikeSymbol)) == null || (fir = object).getClassKind() == ClassKind.INTERFACE) continue;
            return superTypeRef;
        }
        return null;
    }

    public static final boolean isIterator(@NotNull FirFunctionCall $this$isIterator) {
        Intrinsics.checkNotNullParameter($this$isIterator, "<this>");
        return Intrinsics.areEqual($this$isIterator.getCalleeReference().getName().asString(), "<iterator>");
    }

    public static final boolean isSubtypeOfThrowable(@NotNull ConeKotlinType $this$isSubtypeOfThrowable, @NotNull FirSession session2) {
        Intrinsics.checkNotNullParameter($this$isSubtypeOfThrowable, "<this>");
        Intrinsics.checkNotNullParameter(session2, "session");
        return FirHelpersKt.isSupertypeOf(session2.getBuiltinTypes().getThrowableType().getType(), SessionUtilsKt.getTypeContext(session2), TypeExpansionUtilsKt.fullyExpandedType($this$isSubtypeOfThrowable, session2));
    }

    public static final boolean getHasValOrVar(@NotNull FirValueParameter $this$hasValOrVar) {
        Intrinsics.checkNotNullParameter($this$hasValOrVar, "<this>");
        Object object = $this$hasValOrVar.getSource();
        if (object == null) {
            return false;
        }
        FirSourceElement source = object;
        object = KtParameter.VAL_VAR_TOKEN_SET;
        Intrinsics.checkNotNullExpressionValue(object, "VAL_VAR_TOKEN_SET");
        return FirSourceUtilsKt.getChild$default(source, (TokenSet)object, 0, 0, 6, null) != null;
    }

    public static final boolean isSupertypeOf(@NotNull KotlinTypeMarker $this$isSupertypeOf, @NotNull TypeCheckerProviderContext context2, @Nullable KotlinTypeMarker type2) {
        Intrinsics.checkNotNullParameter($this$isSupertypeOf, "<this>");
        Intrinsics.checkNotNullParameter(context2, "context");
        return type2 != null && AbstractTypeChecker.isSubtypeOf$default(AbstractTypeChecker.INSTANCE, context2, type2, $this$isSupertypeOf, false, 8, null);
    }

    public static final boolean isSubtypeOf(@NotNull KotlinTypeMarker $this$isSubtypeOf, @NotNull TypeCheckerProviderContext context2, @Nullable KotlinTypeMarker type2) {
        Intrinsics.checkNotNullParameter($this$isSubtypeOf, "<this>");
        Intrinsics.checkNotNullParameter(context2, "context");
        return type2 != null && AbstractTypeChecker.isSubtypeOf$default(AbstractTypeChecker.INSTANCE, context2, $this$isSubtypeOf, type2, false, 8, null);
    }

    /*
     * WARNING - void declaration
     */
    public static final boolean canHaveSubtypes(@NotNull ConeKotlinType $this$canHaveSubtypes, @NotNull FirSession session2) {
        FirRegularClass clazz;
        block20: {
            block19: {
                Intrinsics.checkNotNullParameter($this$canHaveSubtypes, "<this>");
                Intrinsics.checkNotNullParameter(session2, "session");
                if (ConeTypeUtilsKt.isMarkedNullable($this$canHaveSubtypes)) {
                    return true;
                }
                FirRegularClass firRegularClass = FirHelpersKt.toRegularClass($this$canHaveSubtypes, session2);
                if (firRegularClass == null) {
                    return true;
                }
                clazz = firRegularClass;
                FirClass $this$isEnumClass$iv = clazz;
                boolean $i$f$isEnumClass = false;
                if ($this$isEnumClass$iv.getClassKind() == ClassKind.ENUM_CLASS) break block19;
                FirMemberDeclaration $this$isExpect$iv = clazz;
                boolean $i$f$isExpect = false;
                if ($this$isExpect$iv.getStatus().isExpect()) break block19;
                FirRegularClass $this$modality$iv = clazz;
                boolean $i$f$getModality = false;
                if ($this$modality$iv.getStatus().getModality() == Modality.FINAL) break block20;
            }
            return true;
        }
        Iterable $this$forEachIndexed$iv = clazz.getTypeParameters();
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void typeParameterRef;
            int n = index$iv++;
            boolean bl = false;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            FirTypeParameterRef firTypeParameterRef = (FirTypeParameterRef)item$iv;
            int idx = n;
            boolean bl2 = false;
            FirTypeParameter typeParameter = (FirTypeParameter)typeParameterRef.getSymbol().getFir();
            ConeTypeProjection typeProjection = $this$canHaveSubtypes.getTypeArguments()[idx];
            if (ConeTypesKt.isStarProjection(typeProjection)) {
                return true;
            }
            Intrinsics.checkNotNull(ConeTypesKt.getType(typeProjection));
            Variance variance = typeParameter.getVariance();
            int n2 = WhenMappings.$EnumSwitchMapping$0[variance.ordinal()];
            block0 : switch (n2) {
                case 1: {
                    ConeKotlinType argument2;
                    ProjectionKind projectionKind = typeProjection.getKind();
                    int n3 = WhenMappings.$EnumSwitchMapping$1[projectionKind.ordinal()];
                    switch (n3) {
                        case 1: {
                            if (!FirHelpersKt.lowerThanBound(SessionUtilsKt.getTypeContext(session2), argument2, typeParameter) && !FirHelpersKt.canHaveSubtypes(argument2, session2)) break block0;
                            return true;
                        }
                        case 2: {
                            if (!FirHelpersKt.lowerThanBound(SessionUtilsKt.getTypeContext(session2), argument2, typeParameter)) break block0;
                            return true;
                        }
                        case 3: {
                            if (!FirHelpersKt.canHaveSubtypes(argument2, session2)) break block0;
                            return true;
                        }
                        case 4: {
                            return true;
                        }
                    }
                    break;
                }
                case 2: {
                    ConeKotlinType argument2;
                    if (!(typeProjection.getKind() != ProjectionKind.OUT ? FirHelpersKt.lowerThanBound(SessionUtilsKt.getTypeContext(session2), argument2, typeParameter) : FirHelpersKt.canHaveSubtypes(argument2, session2))) break;
                    return true;
                }
                case 3: {
                    ConeKotlinType argument2;
                    if (!(typeProjection.getKind() != ProjectionKind.IN ? FirHelpersKt.canHaveSubtypes(argument2, session2) : FirHelpersKt.lowerThanBound(SessionUtilsKt.getTypeContext(session2), argument2, typeParameter))) break;
                    return true;
                }
            }
        }
        return false;
    }

    private static final boolean lowerThanBound(ConeInferenceContext context2, ConeKotlinType argument2, FirTypeParameter typeParameter) {
        Iterable $this$forEach$iv = typeParameter.getBounds();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            FirTypeRef boundTypeRef = (FirTypeRef)element$iv;
            boolean bl = false;
            if (Intrinsics.areEqual(argument2, FirTypeUtilsKt.getConeType(boundTypeRef)) || !FirHelpersKt.isSubtypeOf(argument2, context2, FirTypeUtilsKt.getConeType(boundTypeRef))) continue;
            return true;
        }
        return false;
    }

    public static final boolean isInlineOnly(@NotNull FirMemberDeclaration $this$isInlineOnly) {
        Intrinsics.checkNotNullParameter($this$isInlineOnly, "<this>");
        FirMemberDeclaration $this$isInline$iv = $this$isInlineOnly;
        boolean $i$f$isInline = false;
        return $this$isInline$iv.getStatus().isInline() && FirAnnotationUtilsKt.hasAnnotation($this$isInlineOnly, INLINE_ONLY_ANNOTATION_CLASS_ID);
    }

    public static final boolean isSubtypeForTypeMismatch(@NotNull ConeInferenceContext context2, @NotNull ConeKotlinType subtype, @NotNull ConeKotlinType supertype2) {
        Intrinsics.checkNotNullParameter(context2, "context");
        Intrinsics.checkNotNullParameter(subtype, "subtype");
        Intrinsics.checkNotNullParameter(supertype2, "supertype");
        ConeKotlinType subtypeFullyExpanded = TypeExpansionUtilsKt.fullyExpandedType(subtype, context2.getSession());
        ConeKotlinType supertypeFullyExpanded = TypeExpansionUtilsKt.fullyExpandedType(supertype2, context2.getSession());
        return AbstractTypeChecker.isSubtypeOf$default(AbstractTypeChecker.INSTANCE, context2, (KotlinTypeMarker)subtypeFullyExpanded, (KotlinTypeMarker)supertypeFullyExpanded, false, 8, null) || FirHelpersKt.isSubtypeOfForFunctionalTypeReturningUnit(SessionUtilsKt.getTypeContext(context2.getSession()), subtypeFullyExpanded, supertypeFullyExpanded);
    }

    private static final boolean isSubtypeOfForFunctionalTypeReturningUnit(ConeInferenceContext context2, ConeKotlinType subtype, ConeKotlinType supertype2) {
        ConeClassLikeType coneClassLikeType;
        if (!InferenceUtilsKt.isBuiltinFunctionalType(supertype2, context2.getSession())) {
            return false;
        }
        ConeTypeProjection functionalTypeReturnType = ArraysKt.lastOrNull(supertype2.getTypeArguments());
        ConeClassLikeType coneClassLikeType2 = coneClassLikeType = functionalTypeReturnType instanceof ConeClassLikeType ? (ConeClassLikeType)functionalTypeReturnType : null;
        if (coneClassLikeType == null ? false : ConeTypeUtilsKt.isUnit(coneClassLikeType)) {
            List<ConeTypeProjection> superTypeArgs = ArraysKt.dropLast(supertype2.getTypeArguments(), 1);
            List<ConeTypeProjection> subTypeArgs = ArraysKt.dropLast(subtype.getTypeArguments(), 1);
            if (superTypeArgs.size() != subTypeArgs.size()) {
                return false;
            }
            int n = 0;
            int n2 = superTypeArgs.size() + -1;
            if (n <= n2) {
                do {
                    int i;
                    ConeKotlinType coneKotlinType;
                    if ((coneKotlinType = ConeTypesKt.getType(subTypeArgs.get(i = n++))) == null) {
                        return false;
                    }
                    ConeKotlinType subTypeArg = coneKotlinType;
                    ConeKotlinType coneKotlinType2 = ConeTypesKt.getType(superTypeArgs.get(i));
                    if (coneKotlinType2 == null) {
                        return false;
                    }
                    ConeKotlinType superTypeArg = coneKotlinType2;
                    if (AbstractTypeChecker.isSubtypeOf$default(AbstractTypeChecker.INSTANCE, SessionUtilsKt.getTypeContext(context2.getSession()), (KotlinTypeMarker)subTypeArg, (KotlinTypeMarker)superTypeArg, false, 8, null)) continue;
                    return false;
                } while (n <= n2);
            }
            return true;
        }
        return false;
    }

    public static final boolean isVisibleInClass(@NotNull FirCallableMemberDeclaration<?> $this$isVisibleInClass, @NotNull FirClass<?> parentClass) {
        boolean $i$f$getVisibility;
        FirMemberDeclaration $this$visibility$iv;
        block3: {
            block2: {
                Intrinsics.checkNotNullParameter($this$isVisibleInClass, "<this>");
                Intrinsics.checkNotNullParameter(parentClass, "parentClass");
                FqName fqName2 = parentClass.getSymbol().getClassId().getPackageFqName();
                Intrinsics.checkNotNullExpressionValue(fqName2, "parentClass.symbol.classId.packageFqName");
                FqName classPackage = fqName2;
                $this$visibility$iv = $this$isVisibleInClass;
                $i$f$getVisibility = false;
                if (Intrinsics.areEqual($this$visibility$iv.getStatus().getVisibility(), Visibilities.Private.INSTANCE)) break block2;
                $this$visibility$iv = $this$isVisibleInClass;
                $i$f$getVisibility = false;
                if ($this$visibility$iv.getStatus().getVisibility().visibleFromPackage(classPackage, $this$isVisibleInClass.getSymbol().getCallableId().getPackageName())) break block3;
            }
            return false;
        }
        $this$visibility$iv = $this$isVisibleInClass;
        $i$f$getVisibility = false;
        return !Intrinsics.areEqual($this$visibility$iv.getStatus().getVisibility(), Visibilities.Internal.INSTANCE) || Intrinsics.areEqual($this$isVisibleInClass.getModuleData(), parentClass.getModuleData()) && !$this$isVisibleInClass.getModuleData().getFriendDependencies().contains(parentClass.getModuleData());
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @NotNull
    public static final ImplementationStatus getImplementationStatus(@NotNull FirCallableMemberDeclaration<?> $this$getImplementationStatus, @NotNull SessionHolder sessionHolder, @NotNull FirClass<?> parentClass) {
        block22: {
            block23: {
                block21: {
                    block19: {
                        block18: {
                            block20: {
                                block17: {
                                    Intrinsics.checkNotNullParameter($this$getImplementationStatus, "<this>");
                                    Intrinsics.checkNotNullParameter(sessionHolder, "sessionHolder");
                                    Intrinsics.checkNotNullParameter(parentClass, "parentClass");
                                    containingClass = FirHelpersKt.getContainingClass((FirSymbolOwner)$this$getImplementationStatus, sessionHolder);
                                    symbol = $this$getImplementationStatus.getSymbol();
                                    if (!(symbol instanceof FirIntersectionCallableSymbol)) break block19;
                                    if (containingClass == parentClass && FirHelpersKt.subjectToManyNotImplemented((FirIntersectionCallableSymbol)symbol, sessionHolder)) {
                                        return ImplementationStatus.AMBIGUOUSLY_INHERITED;
                                    }
                                    $this$any$iv = ((FirIntersectionCallableSymbol)symbol).getIntersections();
                                    $i$f$any = false;
                                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                                        v0 = false;
                                    } else {
                                        for (E element$iv : $this$any$iv) {
                                            it = (FirCallableSymbol)element$iv;
                                            $i$a$-any-FirHelpersKt$getImplementationStatus$1 = false;
                                            $this$unwrapFakeOverrides$iv = (FirCallableMemberDeclaration)it.getFir();
                                            $i$f$unwrapFakeOverrides = false;
                                            current$iv = $this$unwrapFakeOverrides$iv;
                                            while (true) {
                                                $this$originalIfFakeOverride$iv$iv = current$iv;
                                                $i$f$originalIfFakeOverride = false;
                                                $this$originalForSubstitutionOverride$iv$iv$iv = $this$originalIfFakeOverride$iv$iv;
                                                $i$f$getOriginalForSubstitutionOverride = false;
                                                v1 = var18_22 = ClassMembersKt.isSubstitutionOverride($this$originalForSubstitutionOverride$iv$iv$iv) != false ? ClassMembersKt.getOriginalForSubstitutionOverrideAttr($this$originalForSubstitutionOverride$iv$iv$iv) : null;
                                                if (var18_22 == null) {
                                                    $this$baseForIntersectionOverride$iv$iv$iv = $this$originalIfFakeOverride$iv$iv;
                                                    $i$f$getBaseForIntersectionOverride = false;
                                                    v2 = ClassMembersKt.isIntersectionOverride($this$baseForIntersectionOverride$iv$iv$iv) ? ClassMembersKt.getOriginalForIntersectionOverrideAttr($this$baseForIntersectionOverride$iv$iv$iv) : null;
                                                } else {
                                                    v2 = var19_23 = var18_22;
                                                }
                                                if (var19_23 == null) break;
                                                current$iv = next$iv = var19_23;
                                            }
                                            fir = (FirCallableMemberDeclaration)current$iv;
                                            $this$isAbstract$iv = fir;
                                            $i$f$isAbstract = false;
                                            if (!($this$isAbstract$iv.getStatus().getModality() == Modality.ABSTRACT != false && (($this$isAbstract$iv = ($i$f$isAbstract = FirHelpersKt.getContainingClass((FirSymbolOwner)fir, sessionHolder)) instanceof FirRegularClass != false ? (FirRegularClass)$i$f$isAbstract : null) == null ? null : $this$isAbstract$iv.getClassKind()) == ClassKind.CLASS)) continue;
                                            v0 = true;
                                            break block17;
                                        }
                                        v0 = false;
                                    }
                                }
                                if (!v0) break block19;
                                $this$none$iv = ((FirIntersectionCallableSymbol)symbol).getIntersections();
                                $i$f$none = false;
                                if (!($this$none$iv instanceof Collection) || !((Collection)$this$none$iv).isEmpty()) break block20;
                                v3 = true;
                                break block18;
                            }
                            for (E element$iv : $this$none$iv) {
                                it = (FirCallableSymbol)element$iv;
                                $i$a$-none-FirHelpersKt$getImplementationStatus$2 = false;
                                fir = (FirCallableMemberDeclaration)it.getFir();
                                if (!Intrinsics.areEqual(fir.getOrigin(), FirDeclarationOrigin.Delegated.INSTANCE)) ** GOTO lbl-1000
                                $this$isAbstract$iv = fir;
                                $i$f$isAbstract = false;
                                if (!($this$isAbstract$iv.getStatus().getModality() == Modality.ABSTRACT)) {
                                    v4 = true;
                                } else lbl-1000:
                                // 2 sources

                                {
                                    v4 = false;
                                }
                                if (!v4) continue;
                                v3 = false;
                                break block18;
                            }
                            v3 = true;
                        }
                        if (v3) {
                            return ImplementationStatus.NOT_IMPLEMENTED;
                        }
                    }
                    if ($this$getImplementationStatus instanceof FirSimpleFunction) {
                        if (parentClass instanceof FirRegularClass) {
                            $this$isData$iv = (FirRegularClass)parentClass;
                            $i$f$isData = false;
                            if ($this$isData$iv.getStatus().isData() && FirHelpersKt.getMatchesDataClassSyntheticMemberSignatures((FirSimpleFunction)$this$getImplementationStatus)) {
                                return ImplementationStatus.INHERITED_OR_SYNTHESIZED;
                            }
                        }
                        $this$isSuspend$iv = $this$getImplementationStatus;
                        $i$f$isSuspend = false;
                        if ($this$isSuspend$iv.getStatus().isSuspend()) {
                            return ImplementationStatus.INHERITED_OR_SYNTHESIZED;
                        }
                    }
                    $this$isFinal$iv = $this$getImplementationStatus;
                    $i$f$isFinal = false;
                    var7_7 /* !! */  = $this$isFinal$iv.getStatus().getModality();
                    if (!(var7_7 /* !! */  == null ? true : (modality$iv = var7_7 /* !! */ ) == Modality.FINAL)) break block21;
                    v5 = ImplementationStatus.CANNOT_BE_IMPLEMENTED;
                    break block22;
                }
                if (containingClass != parentClass || !Intrinsics.areEqual($this$getImplementationStatus.getOrigin(), FirDeclarationOrigin.Source.INSTANCE)) break block23;
                v5 = ImplementationStatus.ALREADY_IMPLEMENTED;
                break block22;
            }
            if (!(containingClass instanceof FirRegularClass)) ** GOTO lbl-1000
            $this$isExpect$iv = (FirMemberDeclaration)containingClass;
            $i$f$isExpect = false;
            if ($this$isExpect$iv.getStatus().isExpect()) {
                v5 = ImplementationStatus.CANNOT_BE_IMPLEMENTED;
            } else lbl-1000:
            // 2 sources

            {
                $this$isAbstract$iv = $this$getImplementationStatus;
                $i$f$isAbstract = false;
                v5 = $this$isAbstract$iv.getStatus().getModality() == Modality.ABSTRACT != false ? ImplementationStatus.NOT_IMPLEMENTED : ImplementationStatus.INHERITED_OR_SYNTHESIZED;
            }
        }
        return v5;
    }

    private static final boolean subjectToManyNotImplemented(FirIntersectionCallableSymbol $this$subjectToManyNotImplemented, SessionHolder sessionHolder) {
        int nonAbstractCountInClass = 0;
        int nonAbstractCountInInterface = 0;
        int abstractCountInInterface = 0;
        for (FirCallableSymbol<?> intersectionSymbol : $this$subjectToManyNotImplemented.getIntersections()) {
            FirRegularClass containingClass;
            FirCallableMemberDeclaration intersection = (FirCallableMemberDeclaration)intersectionSymbol.getFir();
            FirClassLikeDeclaration<?> firClassLikeDeclaration = FirHelpersKt.getContainingClass((FirSymbolOwner)intersection, sessionHolder);
            FirRegularClass firRegularClass = containingClass = firClassLikeDeclaration instanceof FirRegularClass ? (FirRegularClass)firClassLikeDeclaration : null;
            boolean hasInterfaceContainer = (firRegularClass == null ? null : firRegularClass.getClassKind()) == ClassKind.INTERFACE;
            FirMemberDeclaration $this$modality$iv = intersection;
            boolean $i$f$getModality = false;
            if ($this$modality$iv.getStatus().getModality() != Modality.ABSTRACT) {
                if (hasInterfaceContainer) {
                    int n = nonAbstractCountInInterface;
                    nonAbstractCountInInterface = n + 1;
                } else {
                    int n = nonAbstractCountInClass;
                    nonAbstractCountInClass = n + 1;
                }
            } else if (hasInterfaceContainer) {
                int n = abstractCountInInterface;
                abstractCountInInterface = n + 1;
            }
            if (nonAbstractCountInClass + nonAbstractCountInInterface > 1) {
                return true;
            }
            if (nonAbstractCountInInterface <= 0 || abstractCountInInterface <= 0) continue;
            return true;
        }
        return false;
    }

    private static final boolean getMatchesDataClassSyntheticMemberSignatures(FirSimpleFunction $this$matchesDataClassSyntheticMemberSignatures) {
        return Intrinsics.areEqual($this$matchesDataClassSyntheticMemberSignatures.getName(), OperatorNameConventions.EQUALS) && FirHelpersKt.getMatchesEqualsSignature($this$matchesDataClassSyntheticMemberSignatures) || Intrinsics.areEqual($this$matchesDataClassSyntheticMemberSignatures.getName(), DefaultNamesKt.getHASHCODE_NAME()) && FirHelpersKt.getMatchesHashCodeSignature($this$matchesDataClassSyntheticMemberSignatures) || Intrinsics.areEqual($this$matchesDataClassSyntheticMemberSignatures.getName(), OperatorNameConventions.TO_STRING) && FirHelpersKt.getMatchesToStringSignature($this$matchesDataClassSyntheticMemberSignatures);
    }

    private static final FirClassLikeDeclaration<?> getContainingClass(FirSymbolOwner<?> $this$getContainingClass, SessionHolder sessionHolder) {
        FirClassLikeSymbol<?> firClassLikeSymbol;
        ConeClassLikeLookupTag coneClassLikeLookupTag;
        FirCallableMemberDeclaration firCallableMemberDeclaration;
        FirSymbolOwner<?> $this$safeAs$iv = $this$getContainingClass;
        boolean $i$f$safeAs = false;
        FirSymbolOwner<?> firSymbolOwner = $this$safeAs$iv;
        if (!(firSymbolOwner instanceof FirCallableMemberDeclaration)) {
            firSymbolOwner = null;
        }
        return (firCallableMemberDeclaration = (FirCallableMemberDeclaration)firSymbolOwner) == null ? null : ((coneClassLikeLookupTag = ClassMembersKt.containingClass(firCallableMemberDeclaration)) == null ? null : ((firClassLikeSymbol = LookupTagUtilsKt.toSymbol(coneClassLikeLookupTag, sessionHolder.getSession())) == null ? null : (FirClassLikeDeclaration)firClassLikeSymbol.getFir()));
    }

    private static final boolean getMatchesEqualsSignature(FirSimpleFunction $this$matchesEqualsSignature) {
        return $this$matchesEqualsSignature.getValueParameters().size() == 1 && ConeTypeUtilsKt.isNullableAny(FirTypeUtilsKt.getConeType($this$matchesEqualsSignature.getValueParameters().get(0).getReturnTypeRef()));
    }

    private static final boolean getMatchesHashCodeSignature(FirSimpleFunction $this$matchesHashCodeSignature) {
        return $this$matchesHashCodeSignature.getValueParameters().isEmpty();
    }

    private static final boolean getMatchesToStringSignature(FirSimpleFunction $this$matchesToStringSignature) {
        return $this$matchesToStringSignature.getValueParameters().isEmpty();
    }

    public static final void checkTypeMismatch(@NotNull ConeKotlinType lValueOriginalType, @NotNull FirExpression rValue, @NotNull CheckerContext context2, @NotNull FirSourceElement source, @NotNull DiagnosticReporter reporter, boolean isInitializer) {
        FirDiagnosticFactory2<ConeKotlinType, ConeKotlinType> diagnosticFactory;
        FirDiagnosticFactory2<ConeKotlinType, ConeKotlinType> firDiagnosticFactory2;
        Intrinsics.checkNotNullParameter(lValueOriginalType, "lValueOriginalType");
        Intrinsics.checkNotNullParameter(rValue, "rValue");
        Intrinsics.checkNotNullParameter(context2, "context");
        Intrinsics.checkNotNullParameter(source, "source");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        ConeKotlinType lValueType = lValueOriginalType;
        ConeKotlinType rValueType = FirTypeUtilsKt.getConeType(rValue.getTypeRef());
        ConeInferenceContext typeContext2 = SessionUtilsKt.getTypeContext(context2.getSession());
        if (isInitializer) {
            firDiagnosticFactory2 = FirErrors.INSTANCE.getINITIALIZER_TYPE_MISMATCH();
        } else if (source.getKind() instanceof FirFakeSourceElementKind.DesugaredIncrementOrDecrement) {
            if (!ConeTypeUtilsKt.isNullable(lValueType) && ConeTypeUtilsKt.isNullable(rValueType)) {
                ConeKotlinType tempType = rValueType;
                rValueType = lValueType;
                lValueType = tempType;
            }
            firDiagnosticFactory2 = FirErrors.INSTANCE.getRESULT_TYPE_MISMATCH();
        } else {
            firDiagnosticFactory2 = diagnosticFactory = FirErrors.INSTANCE.getASSIGNMENT_TYPE_MISMATCH();
        }
        if (!FirHelpersKt.isSubtypeForTypeMismatch(typeContext2, rValueType, lValueType)) {
            if (rValueType instanceof ConeClassLikeType && Intrinsics.areEqual(((ConeClassLikeType)rValueType).getLookupTag().getClassId(), StandardClassIds.INSTANCE.getInt()) && ConeTypeUtilsKt.isIntegerTypeOrNullableIntegerTypeOfAnySize(TypeExpansionUtilsKt.fullyExpandedType(lValueType, context2.getSession())) && rValueType.getNullability() == ConeNullability.NOT_NULL) {
                return;
            }
            if (CompilerConeAttributesKt.isExtensionFunctionType(lValueType) || CompilerConeAttributesKt.isExtensionFunctionType(rValueType)) {
                return;
            }
            if (FirTypeUtilsKt.isNullLiteral(rValue) && lValueType.getNullability() == ConeNullability.NOT_NULL) {
                DiagnosticReporterKt.reportOn$default(reporter, rValue.getSource(), FirErrors.INSTANCE.getNULL_FOR_NONNULL_TYPE(), context2, null, 8, null);
            } else {
                DiagnosticReporterKt.reportOn$default(reporter, source, diagnosticFactory, lValueType, rValueType, context2, null, 32, null);
            }
        }
    }

    public static final void checkCondition(@NotNull FirExpression condition, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter(condition, "condition");
        Intrinsics.checkNotNullParameter(context2, "context");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        ConeKotlinType coneType = ConeTypesKt.lowerBoundIfFlexible(FirTypeUtilsKt.getConeType(condition.getTypeRef()));
        if (!(coneType instanceof ConeClassErrorType) && !FirHelpersKt.isSubtypeOf(coneType, SessionUtilsKt.getTypeContext(context2.getSession()), context2.getSession().getBuiltinTypes().getBooleanType().getType())) {
            DiagnosticReporterKt.reportOn$default(reporter, condition.getSource(), FirErrors.INSTANCE.getCONDITION_TYPE_MISMATCH(), coneType, context2, null, 16, null);
        }
    }

    @Nullable
    public static final FirTypeRefSource extractArgumentTypeRefAndSource(@Nullable FirTypeRef typeRef, int index2) {
        if (typeRef instanceof FirResolvedTypeRef) {
            FirTypeRef delegatedTypeRef = ((FirResolvedTypeRef)typeRef).getDelegatedTypeRef();
            if (delegatedTypeRef instanceof FirUserTypeRef) {
                FirTypeProjection typeArgument;
                FirTypeProjection firTypeProjection;
                List<FirTypeProjection> list2;
                List<FirTypeProjection> currentTypeArguments = null;
                int currentIndex = index2;
                List<FirQualifierPart> qualifier = ((FirUserTypeRef)delegatedTypeRef).getQualifier();
                int n = qualifier.size() - 1;
                if (0 <= n) {
                    do {
                        int i;
                        List<FirTypeProjection> typeArguments2;
                        if (currentIndex < (typeArguments2 = qualifier.get(i = n--).getTypeArgumentList().getTypeArguments()).size()) {
                            currentTypeArguments = typeArguments2;
                            break;
                        }
                        currentIndex -= typeArguments2.size();
                    } while (0 <= n);
                }
                if ((list2 = currentTypeArguments) == null) {
                    firTypeProjection = null;
                } else {
                    List<FirTypeProjection> list3 = list2;
                    boolean bl = false;
                    firTypeProjection = typeArgument = (FirTypeProjection)CollectionsKt.getOrNull(list3, currentIndex);
                }
                if (typeArgument instanceof FirTypeProjectionWithVariance) {
                    return new FirTypeRefSource(((FirTypeProjectionWithVariance)typeArgument).getTypeRef(), ((FirTypeProjectionWithVariance)typeArgument).getSource());
                }
            } else if (delegatedTypeRef instanceof FirFunctionTypeRef) {
                List<FirValueParameter> valueParameters2 = ((FirFunctionTypeRef)delegatedTypeRef).getValueParameters();
                if (index2 < valueParameters2.size()) {
                    List<FirValueParameter> list4 = valueParameters2;
                    boolean bl = false;
                    FirTypeRef valueParamTypeRef = list4.get(index2).getReturnTypeRef();
                    return new FirTypeRefSource(valueParamTypeRef, valueParamTypeRef.getSource());
                }
                if (index2 == valueParameters2.size()) {
                    FirTypeRef returnTypeRef = ((FirFunctionTypeRef)delegatedTypeRef).getReturnTypeRef();
                    return new FirTypeRefSource(returnTypeRef, returnTypeRef.getSource());
                }
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private static final boolean isSupertypeOf$isSupertypeOf(FirClass<?> $this$isSupertypeOf_u24isSupertypeOf, FirSession $session, FirClass<?> other, Set<FirClass<?>> exclude) {
        for (FirTypeRef it : other.getSuperTypeRefs()) {
            FirClass candidate2;
            FirClass firClass;
            FirClass firClass2;
            FirClassLikeDeclaration<?> firClassLikeDeclaration = FirSupertypesResolutionKt.firClassLike(it, $session);
            if (firClassLikeDeclaration == null) {
                firClass2 = null;
            } else {
                FirClassLikeDeclaration<?> firClassLikeDeclaration2 = FirHelpersKt.followAllAlias(firClassLikeDeclaration, $session);
                if (firClassLikeDeclaration2 == null) {
                    firClass2 = null;
                } else {
                    void $this$safeAs$iv;
                    FirClassLikeDeclaration<?> firClassLikeDeclaration3 = firClassLikeDeclaration2;
                    boolean $i$f$safeAs = false;
                    Object v1 = $this$safeAs$iv;
                    if (!(v1 instanceof FirClass)) {
                        v1 = null;
                    }
                    firClass2 = v1;
                }
            }
            if ((firClass = firClass2) == null || exclude.contains(candidate2 = firClass)) continue;
            exclude.add(candidate2);
            if (Intrinsics.areEqual(candidate2, $this$isSupertypeOf_u24isSupertypeOf)) {
                return true;
            }
            if (!FirHelpersKt.isSupertypeOf$isSupertypeOf($this$isSupertypeOf_u24isSupertypeOf, $session, candidate2, exclude)) continue;
            return true;
        }
        return false;
    }

    static {
        ClassId classId = ClassId.topLevel(new FqName("kotlin.internal.InlineOnly"));
        Intrinsics.checkNotNullExpressionValue(classId, "topLevel(FqName(\"kotlin.internal.InlineOnly\"))");
        INLINE_ONLY_ANNOTATION_CLASS_ID = classId;
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[Variance.values().length];
            nArray[Variance.INVARIANT.ordinal()] = 1;
            nArray[Variance.IN_VARIANCE.ordinal()] = 2;
            nArray[Variance.OUT_VARIANCE.ordinal()] = 3;
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[ProjectionKind.values().length];
            nArray[ProjectionKind.INVARIANT.ordinal()] = 1;
            nArray[ProjectionKind.IN.ordinal()] = 2;
            nArray[ProjectionKind.OUT.ordinal()] = 3;
            nArray[ProjectionKind.STAR.ordinal()] = 4;
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

