/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.lower;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.phaser.NamedCompilerPhase;
import org.jetbrains.kotlin.backend.common.phaser.PhaseBuildersKt;
import org.jetbrains.kotlin.backend.jvm.JvmBackendContext;
import org.jetbrains.kotlin.backend.jvm.lower.PolymorphicSignatureLoweringKt;
import org.jetbrains.kotlin.backend.jvm.lower.VarargLoweringKt;
import org.jetbrains.kotlin.builtins.PrimitiveType;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.builtins.UnsignedType;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrPackageFragment;
import org.jetbrains.kotlin.ir.util.AdditionalIrUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.util.capitalizeDecapitalize.CapitalizeDecapitalizeKt;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000*\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\u001a\f\u0010\f\u001a\u00020\r*\u00020\u000eH\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u001a\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0005\"\u001d\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u000f"}, d2={"ARRAY_OF_NAME", "", "PRIMITIVE_ARRAY_OF_NAMES", "", "getPRIMITIVE_ARRAY_OF_NAMES", "()Ljava/util/Set;", "varargPhase", "Lorg/jetbrains/kotlin/backend/common/phaser/NamedCompilerPhase;", "Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "getVarargPhase", "()Lorg/jetbrains/kotlin/backend/common/phaser/NamedCompilerPhase;", "isArrayOf", "", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "backend.jvm"})
public final class VarargLoweringKt {
    @NotNull
    private static final NamedCompilerPhase<JvmBackendContext, IrFile> varargPhase;
    @NotNull
    private static final Set<String> PRIMITIVE_ARRAY_OF_NAMES;
    @NotNull
    public static final String ARRAY_OF_NAME = "arrayOf";

    @NotNull
    public static final NamedCompilerPhase<JvmBackendContext, IrFile> getVarargPhase() {
        return varargPhase;
    }

    @NotNull
    public static final Set<String> getPRIMITIVE_ARRAY_OF_NAMES() {
        return PRIMITIVE_ARRAY_OF_NAMES;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isArrayOf(@NotNull IrFunction $this$isArrayOf) {
        IrPackageFragment irPackageFragment;
        Intrinsics.checkNotNullParameter($this$isArrayOf, "<this>");
        IrDeclarationParent directParent = $this$isArrayOf.getParent();
        if (directParent instanceof IrClass) {
            IrPackageFragment irPackageFragment2 = IrUtilsKt.getPackageFragment(directParent);
            if (irPackageFragment2 == null) {
                return false;
            }
            irPackageFragment = irPackageFragment2;
        } else {
            if (!(directParent instanceof IrPackageFragment)) return false;
            irPackageFragment = (IrPackageFragment)directParent;
        }
        IrPackageFragment parent2 = irPackageFragment;
        if (!Intrinsics.areEqual(parent2.getFqName(), StandardNames.BUILT_INS_PACKAGE_FQ_NAME)) return false;
        String string2 = $this$isArrayOf.getName().asString();
        boolean bl = false;
        boolean bl2 = false;
        String it = string2;
        boolean bl3 = false;
        if (!VarargLoweringKt.getPRIMITIVE_ARRAY_OF_NAMES().contains(it)) {
            if (!Intrinsics.areEqual(it, ARRAY_OF_NAME)) return false;
        }
        boolean bl4 = true;
        if (!bl4) return false;
        if ($this$isArrayOf.getExtensionReceiverParameter() != null) return false;
        if ($this$isArrayOf.getDispatchReceiverParameter() != null) return false;
        if ($this$isArrayOf.getValueParameters().size() != 1) return false;
        if (!AdditionalIrUtilsKt.isVararg($this$isArrayOf.getValueParameters().get(0))) return false;
        return true;
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var3_3;
        Object object;
        Enum type2;
        boolean bl;
        Collection collection;
        Enum[] $this$mapTo$iv$iv;
        varargPhase = PhaseBuildersKt.makeIrFilePhase$default(varargPhase.1.INSTANCE, "VarargLowering", "Replace varargs with array arguments and lower arrayOf and emptyArray calls", SetsKt.setOf(PolymorphicSignatureLoweringKt.getPolymorphicSignaturePhase()), null, null, null, null, 240, null);
        Object $this$map$iv = PrimitiveType.values();
        boolean $i$f$map = false;
        PrimitiveType[] primitiveTypeArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(((PrimitiveType[])$this$map$iv).length);
        boolean $i$f$mapTo = false;
        for (Enum item$iv$iv : $this$mapTo$iv$iv) {
            void var9_13 = item$iv$iv;
            collection = destination$iv$iv;
            bl = false;
            object = type2.name();
            collection.add(object);
        }
        $this$map$iv = UnsignedType.values();
        collection = (List)destination$iv$iv;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(((Enum[])$this$map$iv).length);
        $i$f$mapTo = false;
        Enum[] enumArray = $this$mapTo$iv$iv;
        int n = enumArray.length;
        for (int string4 = 0; string4 < n; ++string4) {
            void type3;
            Enum item$iv$iv;
            type2 = item$iv$iv = enumArray[string4];
            object = destination$iv$iv;
            bl = false;
            String string2 = type3.getTypeName().asString();
            Intrinsics.checkNotNullExpressionValue(string2, "type.typeName.asString()");
            String string3 = string2;
            object.add(string3);
        }
        object = (List)destination$iv$iv;
        $this$map$iv = CollectionsKt.plus(collection, (Iterable)object);
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        $i$f$mapTo = false;
        for (Object e : $this$mapTo$iv$iv) {
            void name;
            String string4 = (String)e;
            collection = destination$iv$iv;
            boolean bl2 = false;
            object = Intrinsics.stringPlus(CapitalizeDecapitalizeKt.toLowerCaseAsciiOnly((String)name), "ArrayOf");
            collection.add(object);
        }
        PRIMITIVE_ARRAY_OF_NAMES = CollectionsKt.toSet((List)var3_3);
    }
}

