/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.types;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.descriptors.IrBuiltIns;
import org.jetbrains.kotlin.ir.symbols.IrClassifierSymbol;
import org.jetbrains.kotlin.ir.symbols.IrTypeParameterSymbol;
import org.jetbrains.kotlin.ir.types.IrDynamicType;
import org.jetbrains.kotlin.ir.types.IrErrorType;
import org.jetbrains.kotlin.ir.types.IrSimpleType;
import org.jetbrains.kotlin.ir.types.IrStarProjection;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypeArgument;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.types.IrTypeProjection;
import org.jetbrains.kotlin.ir.types.IrTypeSubstitutor;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.types.impl.IrSimpleTypeBuilder;
import org.jetbrains.kotlin.ir.types.impl.IrSimpleTypeImplKt;
import org.jetbrains.kotlin.ir.util.RenderIrElementKt;
import org.jetbrains.kotlin.types.model.TypeSubstitutorMarker;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B)\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u0004H\u0002J\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fJ\u0010\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u000fH\u0002J\u0010\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u0006H\u0002J\u000e\u0010\u0015\u001a\u0004\u0018\u00010\u0004*\u00020\u000fH\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00060\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/ir/types/IrTypeSubstitutor;", "Lorg/jetbrains/kotlin/types/model/TypeSubstitutorMarker;", "typeParameters", "", "Lorg/jetbrains/kotlin/ir/symbols/IrTypeParameterSymbol;", "typeArguments", "Lorg/jetbrains/kotlin/ir/types/IrTypeArgument;", "irBuiltIns", "Lorg/jetbrains/kotlin/ir/descriptors/IrBuiltIns;", "(Ljava/util/List;Ljava/util/List;Lorg/jetbrains/kotlin/ir/descriptors/IrBuiltIns;)V", "substitution", "", "getSubstitutionArgument", "typeParameter", "substitute", "Lorg/jetbrains/kotlin/ir/types/IrType;", "type", "substituteType", "irType", "substituteTypeArgument", "typeArgument", "typeParameterConstructor", "ir.tree"})
public final class IrTypeSubstitutor
implements TypeSubstitutorMarker {
    private final Map<IrTypeParameterSymbol, IrTypeArgument> substitution;
    private final IrBuiltIns irBuiltIns;

    private final IrTypeParameterSymbol typeParameterConstructor(IrType $this$typeParameterConstructor) {
        IrTypeParameterSymbol irTypeParameterSymbol;
        if ($this$typeParameterConstructor instanceof IrSimpleType) {
            IrClassifierSymbol irClassifierSymbol = ((IrSimpleType)$this$typeParameterConstructor).getClassifier();
            if (!(irClassifierSymbol instanceof IrTypeParameterSymbol)) {
                irClassifierSymbol = null;
            }
            irTypeParameterSymbol = (IrTypeParameterSymbol)irClassifierSymbol;
        } else {
            irTypeParameterSymbol = null;
        }
        return irTypeParameterSymbol;
    }

    private final IrTypeArgument getSubstitutionArgument(IrTypeParameterSymbol typeParameter) {
        IrTypeArgument irTypeArgument = this.substitution.get(typeParameter);
        if (irTypeArgument == null) {
            throw (Throwable)((Object)new AssertionError((Object)("Unsubstituted type parameter: " + RenderIrElementKt.render((IrElement)typeParameter.getOwner()))));
        }
        return irTypeArgument;
    }

    @NotNull
    public final IrType substitute(@NotNull IrType type2) {
        Object object;
        block9: {
            block8: {
                IrType irType;
                Intrinsics.checkNotNullParameter(type2, "type");
                if (this.substitution.isEmpty()) {
                    return type2;
                }
                object = this.typeParameterConstructor(type2);
                if (object == null) break block8;
                IrTypeParameterSymbol irTypeParameterSymbol = object;
                boolean bl = false;
                boolean bl2 = false;
                IrTypeParameterSymbol it = irTypeParameterSymbol;
                boolean bl3 = false;
                IrTypeArgument typeArgument = this.getSubstitutionArgument(it);
                if (typeArgument instanceof IrStarProjection) {
                    irType = this.irBuiltIns.getAnyNType();
                } else if (typeArgument instanceof IrTypeProjection) {
                    IrType irType2 = ((IrTypeProjection)typeArgument).getType();
                    boolean bl4 = false;
                    boolean bl5 = false;
                    IrType $this$run = irType2;
                    boolean bl6 = false;
                    irType = IrTypePredicatesKt.isMarkedNullable(type2) ? IrTypesKt.makeNullable($this$run) : $this$run;
                } else {
                    String string2 = "unknown type argument";
                    boolean bl7 = false;
                    throw (Throwable)new IllegalStateException(string2.toString());
                }
                object = irType;
                if (irType != null) break block9;
            }
            object = this.substituteType(type2);
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    private final IrType substituteType(IrType irType) {
        IrType irType2;
        IrType irType3 = irType;
        if (irType3 instanceof IrDynamicType) {
            irType2 = irType;
        } else if (irType3 instanceof IrErrorType) {
            irType2 = irType;
        } else {
            Collection<IrTypeArgument> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            boolean bl = irType instanceof IrSimpleType;
            boolean bl2 = false;
            boolean bl3 = false;
            bl3 = false;
            boolean bl4 = false;
            if (!bl) {
                boolean bl5 = false;
                String string2 = "Failed requirement.";
                throw (Throwable)new IllegalArgumentException(string2.toString());
            }
            IrSimpleTypeBuilder irSimpleTypeBuilder = IrSimpleTypeImplKt.toBuilder((IrSimpleType)irType);
            bl2 = false;
            bl3 = false;
            IrSimpleTypeBuilder $this$with = irSimpleTypeBuilder;
            boolean bl6 = false;
            Iterable iterable = ((IrSimpleType)irType).getArguments();
            IrSimpleTypeBuilder irSimpleTypeBuilder2 = $this$with;
            boolean $i$f$map = false;
            void var11_15 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                IrTypeArgument irTypeArgument = (IrTypeArgument)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl7 = false;
                IrTypeArgument irTypeArgument2 = this.substituteTypeArgument((IrTypeArgument)it);
                collection.add(irTypeArgument2);
            }
            collection = (List)destination$iv$iv;
            irSimpleTypeBuilder2.setArguments((List<? extends IrTypeArgument>)collection);
            irType2 = IrSimpleTypeImplKt.buildSimpleType($this$with);
        }
        return irType2;
    }

    private final IrTypeArgument substituteTypeArgument(IrTypeArgument typeArgument) {
        IrClassifierSymbol classifier2;
        if (typeArgument instanceof IrStarProjection) {
            return typeArgument;
        }
        boolean bl = typeArgument instanceof IrTypeProjection;
        boolean bl2 = false;
        boolean bl3 = false;
        bl3 = false;
        boolean bl4 = false;
        if (!bl) {
            boolean bl5 = false;
            String string2 = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string2.toString());
        }
        IrType type2 = ((IrTypeProjection)typeArgument).getType();
        if (type2 instanceof IrSimpleType && (classifier2 = ((IrSimpleType)type2).getClassifier()) instanceof IrTypeParameterSymbol) {
            IrTypeArgument newArgument = this.getSubstitutionArgument((IrTypeParameterSymbol)classifier2);
            return newArgument instanceof IrTypeProjection ? (IrTypeArgument)IrSimpleTypeImplKt.makeTypeProjection(((IrTypeProjection)newArgument).getType(), ((IrTypeProjection)typeArgument).getVariance()) : newArgument;
        }
        return IrSimpleTypeImplKt.makeTypeProjection(this.substituteType(((IrTypeProjection)typeArgument).getType()), ((IrTypeProjection)typeArgument).getVariance());
    }

    public IrTypeSubstitutor(@NotNull List<? extends IrTypeParameterSymbol> typeParameters2, @NotNull List<? extends IrTypeArgument> typeArguments2, @NotNull IrBuiltIns irBuiltIns) {
        Intrinsics.checkNotNullParameter(typeParameters2, "typeParameters");
        Intrinsics.checkNotNullParameter(typeArguments2, "typeArguments");
        Intrinsics.checkNotNullParameter(irBuiltIns, "irBuiltIns");
        this.irBuiltIns = irBuiltIns;
        boolean bl = typeParameters2.size() == typeArguments2.size();
        boolean bl2 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string2 = "Unexpected number of type arguments: " + typeArguments2.size() + '\n' + "Type parameters are:\n" + CollectionsKt.joinToString$default(typeParameters2, "\n", null, null, 0, null, 1.1.INSTANCE, 30, null) + "Type arguments are:\n" + CollectionsKt.joinToString$default(typeArguments2, "\n", null, null, 0, null, 1.2.INSTANCE, 30, null);
            throw (Throwable)((Object)new AssertionError((Object)string2));
        }
        this.substitution = MapsKt.toMap(CollectionsKt.zip((Iterable)typeParameters2, (Iterable)typeArguments2));
    }
}

