/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.symbols;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationWithName;
import org.jetbrains.kotlin.ir.declarations.IrPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrSymbolOwner;
import org.jetbrains.kotlin.ir.symbols.IrClassifierEqualityChecker;
import org.jetbrains.kotlin.ir.symbols.IrClassifierSymbol;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0016J\u0018\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0002J\u0018\u0010\u0011\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u00122\u0006\u0010\u0010\u001a\u00020\u0012H\u0002J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u000bH\u0016R\u001a\u0010\u0003\u001a\u0004\u0018\u00010\u0004*\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/ir/symbols/FqNameEqualityChecker;", "Lorg/jetbrains/kotlin/ir/symbols/IrClassifierEqualityChecker;", "()V", "fqName", "Lorg/jetbrains/kotlin/name/FqName;", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationWithName;", "getFqName", "(Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationWithName;)Lorg/jetbrains/kotlin/name/FqName;", "areEqual", "", "left", "Lorg/jetbrains/kotlin/ir/symbols/IrClassifierSymbol;", "right", "checkViaDeclarations", "c1", "Lorg/jetbrains/kotlin/ir/declarations/IrSymbolOwner;", "c2", "checkViaDescriptors", "Lorg/jetbrains/kotlin/descriptors/ClassifierDescriptor;", "getHashCode", "", "symbol", "ir.tree"})
public final class FqNameEqualityChecker
implements IrClassifierEqualityChecker {
    public static final FqNameEqualityChecker INSTANCE;

    @Override
    public boolean areEqual(@NotNull IrClassifierSymbol left, @NotNull IrClassifierSymbol right) {
        Intrinsics.checkNotNullParameter(left, "left");
        Intrinsics.checkNotNullParameter(right, "right");
        if (left == right) {
            return true;
        }
        if (!left.isBound() || !right.isBound()) {
            return this.checkViaDescriptors(left.getDescriptor(), right.getDescriptor());
        }
        return this.checkViaDeclarations(left.getOwner(), right.getOwner());
    }

    @Override
    public int getHashCode(@NotNull IrClassifierSymbol symbol2) {
        Intrinsics.checkNotNullParameter(symbol2, "symbol");
        if (symbol2.isBound()) {
            IrSymbolOwner owner = symbol2.getOwner();
            if (owner instanceof IrClass && !IrUtilsKt.isLocalClass((IrClass)owner)) {
                FqName fqName2 = this.getFqName((IrDeclarationWithName)((Object)owner));
                boolean bl = false;
                FqName fqName3 = fqName2;
                return fqName3 != null ? ((Object)fqName3).hashCode() : 0;
            }
            return owner.hashCode();
        }
        ClassifierDescriptor descriptor2 = symbol2.getDescriptor();
        if (descriptor2 instanceof ClassDescriptor && !DescriptorUtils.isLocal(descriptor2)) {
            return DescriptorUtilsKt.getFqNameSafe(descriptor2).hashCode();
        }
        return descriptor2.hashCode();
    }

    private final FqName getFqName(IrDeclarationWithName $this$fqName) {
        FqName parentFqName;
        FqName fqName2;
        IrDeclarationParent parent2 = $this$fqName.getParent();
        if (parent2 instanceof IrPackageFragment) {
            fqName2 = ((IrPackageFragment)parent2).getFqName();
        } else if (parent2 instanceof IrDeclarationWithName) {
            fqName2 = this.getFqName((IrDeclarationWithName)((Object)parent2));
        } else {
            return null;
        }
        FqName fqName3 = parentFqName = fqName2;
        return fqName3 != null ? fqName3.child($this$fqName.getName()) : null;
    }

    private final boolean checkViaDeclarations(IrSymbolOwner c1, IrSymbolOwner c2) {
        if (c1 instanceof IrClass && c2 instanceof IrClass) {
            if (IrUtilsKt.isLocalClass((IrClass)c1) || IrUtilsKt.isLocalClass((IrClass)c2)) {
                return c1 == c2;
            }
            return Intrinsics.areEqual(this.getFqName((IrDeclarationWithName)((Object)c1)), this.getFqName((IrDeclarationWithName)((Object)c2)));
        }
        return Intrinsics.areEqual(c1, c2);
    }

    private final boolean checkViaDescriptors(ClassifierDescriptor c1, ClassifierDescriptor c2) {
        return Intrinsics.areEqual(c1.getTypeConstructor(), c2.getTypeConstructor());
    }

    private FqNameEqualityChecker() {
    }

    static {
        FqNameEqualityChecker fqNameEqualityChecker;
        INSTANCE = fqNameEqualityChecker = new FqNameEqualityChecker();
    }
}

