/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.jvm.serialization;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.LoggingContext;
import org.jetbrains.kotlin.backend.common.overrides.FakeOverrideBuilder;
import org.jetbrains.kotlin.backend.common.overrides.FakeOverrideControl;
import org.jetbrains.kotlin.backend.common.serialization.CurrentModuleDeserializer;
import org.jetbrains.kotlin.backend.common.serialization.DescriptorByIdSignatureFinder;
import org.jetbrains.kotlin.backend.common.serialization.DeserializationStrategy;
import org.jetbrains.kotlin.backend.common.serialization.IrModuleDeserializer;
import org.jetbrains.kotlin.backend.common.serialization.KotlinIrLinker;
import org.jetbrains.kotlin.backend.common.serialization.encodings.BinarySymbolData;
import org.jetbrains.kotlin.backend.common.serialization.signature.IdSignatureSerializer;
import org.jetbrains.kotlin.descriptors.ClassConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DeserializedDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.TypeAliasDescriptor;
import org.jetbrains.kotlin.descriptors.konan.KlibModuleOrigin;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.backend.jvm.serialization.JvmIrLinker$MetadataJVMModuleDeserializer$WhenMappings;
import org.jetbrains.kotlin.ir.backend.jvm.serialization.JvmManglerDesc;
import org.jetbrains.kotlin.ir.backend.jvm.serialization.JvmManglerIr;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import org.jetbrains.kotlin.ir.declarations.IrSymbolOwner;
import org.jetbrains.kotlin.ir.declarations.impl.IrModuleFragmentImpl;
import org.jetbrains.kotlin.ir.descriptors.IrAbstractFunctionFactory;
import org.jetbrains.kotlin.ir.descriptors.IrBuiltIns;
import org.jetbrains.kotlin.ir.symbols.IrFieldSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.util.DeclarationStubGenerator;
import org.jetbrains.kotlin.ir.util.IdSignature;
import org.jetbrains.kotlin.ir.util.SymbolTable;
import org.jetbrains.kotlin.library.IrLibrary;
import org.jetbrains.kotlin.load.java.descriptors.JavaCallableMemberDescriptor;
import org.jetbrains.kotlin.load.java.descriptors.JavaClassDescriptor;
import org.jetbrains.kotlin.load.java.lazy.descriptors.LazyJavaPackageFragment;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u0003123BI\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\b\b\u0002\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\u0002\u0010\u0012J\u001e\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u001c0 H\u0014J\"\u0010!\u001a\u00020\u001c2\u0006\u0010\"\u001a\u00020\u00032\b\u0010#\u001a\u0004\u0018\u00010$2\u0006\u0010%\u001a\u00020&H\u0014J\u0010\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*H\u0002J\u0010\u0010+\u001a\u00020\u00112\u0006\u0010\"\u001a\u00020\u0003H\u0014J\u0010\u0010,\u001a\u00020\u00112\u0006\u0010)\u001a\u00020-H\u0014J\f\u0010.\u001a\u00020\u0011*\u00020/H\u0002J\f\u00100\u001a\u00020\u0011*\u00020/H\u0002R\u0014\u0010\u0013\u001a\u00020\u0014X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\n\u001a\u00020\u000bX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00064"}, d2={"Lorg/jetbrains/kotlin/ir/backend/jvm/serialization/JvmIrLinker;", "Lorg/jetbrains/kotlin/backend/common/serialization/KotlinIrLinker;", "currentModule", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "logger", "Lorg/jetbrains/kotlin/backend/common/LoggingContext;", "builtIns", "Lorg/jetbrains/kotlin/ir/descriptors/IrBuiltIns;", "symbolTable", "Lorg/jetbrains/kotlin/ir/util/SymbolTable;", "functionalInteraceFactory", "Lorg/jetbrains/kotlin/ir/descriptors/IrAbstractFunctionFactory;", "stubGenerator", "Lorg/jetbrains/kotlin/ir/util/DeclarationStubGenerator;", "manglerDesc", "Lorg/jetbrains/kotlin/ir/backend/jvm/serialization/JvmManglerDesc;", "deserializeFakeOverrides", "", "(Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;Lorg/jetbrains/kotlin/backend/common/LoggingContext;Lorg/jetbrains/kotlin/ir/descriptors/IrBuiltIns;Lorg/jetbrains/kotlin/ir/util/SymbolTable;Lorg/jetbrains/kotlin/ir/descriptors/IrAbstractFunctionFactory;Lorg/jetbrains/kotlin/ir/util/DeclarationStubGenerator;Lorg/jetbrains/kotlin/ir/backend/jvm/serialization/JvmManglerDesc;Z)V", "fakeOverrideBuilder", "Lorg/jetbrains/kotlin/backend/common/overrides/FakeOverrideBuilder;", "getFakeOverrideBuilder", "()Lorg/jetbrains/kotlin/backend/common/overrides/FakeOverrideBuilder;", "getFunctionalInteraceFactory", "()Lorg/jetbrains/kotlin/ir/descriptors/IrAbstractFunctionFactory;", "javaName", "Lorg/jetbrains/kotlin/name/Name;", "createCurrentModuleDeserializer", "Lorg/jetbrains/kotlin/backend/common/serialization/IrModuleDeserializer;", "moduleFragment", "Lorg/jetbrains/kotlin/ir/declarations/IrModuleFragment;", "dependencies", "", "createModuleDeserializer", "moduleDescriptor", "klib", "Lorg/jetbrains/kotlin/library/IrLibrary;", "strategy", "Lorg/jetbrains/kotlin/backend/common/serialization/DeserializationStrategy;", "declareJavaFieldStub", "Lorg/jetbrains/kotlin/ir/declarations/IrField;", "symbol", "Lorg/jetbrains/kotlin/ir/symbols/IrFieldSymbol;", "isBuiltInModule", "platformSpecificSymbol", "Lorg/jetbrains/kotlin/ir/symbols/IrSymbol;", "isCleanDescriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "isJavaDescriptor", "JvmCurrentModuleDeserializer", "JvmModuleDeserializer", "MetadataJVMModuleDeserializer", "ir.serialization.jvm"})
public final class JvmIrLinker
extends KotlinIrLinker {
    @NotNull
    private final FakeOverrideBuilder fakeOverrideBuilder;
    private final Name javaName;
    @NotNull
    private final IrAbstractFunctionFactory functionalInteraceFactory;
    private final DeclarationStubGenerator stubGenerator;
    private final JvmManglerDesc manglerDesc;

    @Override
    @NotNull
    public FakeOverrideBuilder getFakeOverrideBuilder() {
        return this.fakeOverrideBuilder;
    }

    @Override
    protected boolean isBuiltInModule(@NotNull ModuleDescriptor moduleDescriptor) {
        Intrinsics.checkNotNullParameter(moduleDescriptor, "moduleDescriptor");
        String string2 = moduleDescriptor.getName().asString();
        Intrinsics.checkNotNullExpressionValue(string2, "moduleDescriptor.name.asString()");
        return StringsKt.startsWith$default(string2, "<dependencies of ", false, 2, null);
    }

    @Override
    @NotNull
    protected IrModuleDeserializer createModuleDeserializer(@NotNull ModuleDescriptor moduleDescriptor, @Nullable IrLibrary klib, @NotNull DeserializationStrategy strategy) {
        Intrinsics.checkNotNullParameter(moduleDescriptor, "moduleDescriptor");
        Intrinsics.checkNotNullParameter((Object)strategy, "strategy");
        if (klib != null) {
            boolean bl = moduleDescriptor.getCapability(KlibModuleOrigin.Companion.getCAPABILITY()) != null;
            boolean bl2 = false;
            boolean bl3 = false;
            if (_Assertions.ENABLED && !bl) {
                boolean bl4 = false;
                String string2 = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)string2));
            }
            return new JvmModuleDeserializer(moduleDescriptor, klib, strategy);
        }
        return new MetadataJVMModuleDeserializer(moduleDescriptor, CollectionsKt.emptyList());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isJavaDescriptor(DeclarationDescriptor $this$isJavaDescriptor) {
        if ($this$isJavaDescriptor instanceof PackageFragmentDescriptor) {
            if ($this$isJavaDescriptor instanceof LazyJavaPackageFragment) return true;
            if (!((PackageFragmentDescriptor)$this$isJavaDescriptor).getFqName().startsWith(this.javaName)) return false;
            return true;
        }
        if ($this$isJavaDescriptor instanceof JavaClassDescriptor) return true;
        if ($this$isJavaDescriptor instanceof JavaCallableMemberDescriptor) return true;
        DeclarationDescriptor declarationDescriptor = $this$isJavaDescriptor.getContainingDeclaration();
        if (declarationDescriptor == null) return false;
        if (!this.isJavaDescriptor(declarationDescriptor)) return false;
        return true;
    }

    private final boolean isCleanDescriptor(DeclarationDescriptor $this$isCleanDescriptor) {
        if ($this$isCleanDescriptor instanceof PropertyAccessorDescriptor) {
            PropertyDescriptor propertyDescriptor = ((PropertyAccessorDescriptor)$this$isCleanDescriptor).getCorrespondingProperty();
            Intrinsics.checkNotNullExpressionValue(propertyDescriptor, "correspondingProperty");
            return this.isCleanDescriptor(propertyDescriptor);
        }
        return $this$isCleanDescriptor instanceof DeserializedDescriptor;
    }

    @Override
    protected boolean platformSpecificSymbol(@NotNull IrSymbol symbol2) {
        Intrinsics.checkNotNullParameter(symbol2, "symbol");
        return this.isJavaDescriptor(symbol2.getDescriptor());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final IrField declareJavaFieldStub(IrFieldSymbol symbol2) {
        IrField irField;
        DeclarationStubGenerator declarationStubGenerator = this.stubGenerator;
        boolean bl = false;
        boolean bl2 = false;
        DeclarationStubGenerator $this$with = declarationStubGenerator;
        boolean bl3 = false;
        boolean old = this.stubGenerator.getUnboundSymbolGeneration();
        try {
            this.stubGenerator.setUnboundSymbolGeneration(true);
            irField = $this$with.generateFieldStub((PropertyDescriptor)symbol2.getDescriptor());
        }
        finally {
            this.stubGenerator.setUnboundSymbolGeneration(old);
        }
        return irField;
    }

    @Override
    @NotNull
    protected IrModuleDeserializer createCurrentModuleDeserializer(@NotNull IrModuleFragment moduleFragment, @NotNull Collection<? extends IrModuleDeserializer> dependencies2) {
        Intrinsics.checkNotNullParameter(moduleFragment, "moduleFragment");
        Intrinsics.checkNotNullParameter(dependencies2, "dependencies");
        return new JvmCurrentModuleDeserializer(moduleFragment, dependencies2);
    }

    @Override
    @NotNull
    protected IrAbstractFunctionFactory getFunctionalInteraceFactory() {
        return this.functionalInteraceFactory;
    }

    public JvmIrLinker(@Nullable ModuleDescriptor currentModule, @NotNull LoggingContext logger, @NotNull IrBuiltIns builtIns, @NotNull SymbolTable symbolTable, @NotNull IrAbstractFunctionFactory functionalInteraceFactory, @NotNull DeclarationStubGenerator stubGenerator, @NotNull JvmManglerDesc manglerDesc, boolean deserializeFakeOverrides) {
        Intrinsics.checkNotNullParameter(logger, "logger");
        Intrinsics.checkNotNullParameter(builtIns, "builtIns");
        Intrinsics.checkNotNullParameter(symbolTable, "symbolTable");
        Intrinsics.checkNotNullParameter(functionalInteraceFactory, "functionalInteraceFactory");
        Intrinsics.checkNotNullParameter(stubGenerator, "stubGenerator");
        Intrinsics.checkNotNullParameter(manglerDesc, "manglerDesc");
        super(currentModule, logger, builtIns, symbolTable, CollectionsKt.emptyList(), deserializeFakeOverrides);
        this.functionalInteraceFactory = functionalInteraceFactory;
        this.stubGenerator = stubGenerator;
        this.manglerDesc = manglerDesc;
        this.fakeOverrideBuilder = new FakeOverrideBuilder(symbolTable, new IdSignatureSerializer(JvmManglerIr.INSTANCE), builtIns, null, 8, null);
        Name name = Name.identifier("java");
        Intrinsics.checkNotNullExpressionValue(name, "Name.identifier(\"java\")");
        this.javaName = name;
    }

    public /* synthetic */ JvmIrLinker(ModuleDescriptor moduleDescriptor, LoggingContext loggingContext, IrBuiltIns irBuiltIns, SymbolTable symbolTable, IrAbstractFunctionFactory irAbstractFunctionFactory, DeclarationStubGenerator declarationStubGenerator, JvmManglerDesc jvmManglerDesc, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x80) != 0) {
            bl = FakeOverrideControl.INSTANCE.getDeserializeFakeOverrides();
        }
        this(moduleDescriptor, loggingContext, irBuiltIns, symbolTable, irAbstractFunctionFactory, declarationStubGenerator, jvmManglerDesc, bl);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\t\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/ir/backend/jvm/serialization/JvmIrLinker$JvmModuleDeserializer;", "Lorg/jetbrains/kotlin/backend/common/serialization/KotlinIrLinker$BasicIrModuleDeserializer;", "Lorg/jetbrains/kotlin/backend/common/serialization/KotlinIrLinker;", "moduleDescriptor", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "klib", "Lorg/jetbrains/kotlin/library/IrLibrary;", "strategy", "Lorg/jetbrains/kotlin/backend/common/serialization/DeserializationStrategy;", "(Lorg/jetbrains/kotlin/ir/backend/jvm/serialization/JvmIrLinker;Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;Lorg/jetbrains/kotlin/library/IrLibrary;Lorg/jetbrains/kotlin/backend/common/serialization/DeserializationStrategy;)V", "ir.serialization.jvm"})
    private final class JvmModuleDeserializer
    extends KotlinIrLinker.BasicIrModuleDeserializer {
        public JvmModuleDeserializer(@NotNull ModuleDescriptor moduleDescriptor, @NotNull IrLibrary klib, DeserializationStrategy strategy) {
            Intrinsics.checkNotNullParameter(moduleDescriptor, "moduleDescriptor");
            Intrinsics.checkNotNullParameter(klib, "klib");
            Intrinsics.checkNotNullParameter((Object)strategy, "strategy");
            super(moduleDescriptor, klib, strategy);
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/ir/backend/jvm/serialization/JvmIrLinker$JvmCurrentModuleDeserializer;", "Lorg/jetbrains/kotlin/backend/common/serialization/CurrentModuleDeserializer;", "moduleFragment", "Lorg/jetbrains/kotlin/ir/declarations/IrModuleFragment;", "dependencies", "", "Lorg/jetbrains/kotlin/backend/common/serialization/IrModuleDeserializer;", "(Lorg/jetbrains/kotlin/ir/backend/jvm/serialization/JvmIrLinker;Lorg/jetbrains/kotlin/ir/declarations/IrModuleFragment;Ljava/util/Collection;)V", "declareIrSymbol", "", "symbol", "Lorg/jetbrains/kotlin/ir/symbols/IrSymbol;", "ir.serialization.jvm"})
    private final class JvmCurrentModuleDeserializer
    extends CurrentModuleDeserializer {
        @Override
        public void declareIrSymbol(@NotNull IrSymbol symbol2) {
            Intrinsics.checkNotNullParameter(symbol2, "symbol");
            DeclarationDescriptor descriptor2 = symbol2.getDescriptor();
            if (JvmIrLinker.this.isJavaDescriptor(descriptor2)) {
                if (symbol2 instanceof IrFieldSymbol) {
                    JvmIrLinker.this.declareJavaFieldStub((IrFieldSymbol)symbol2);
                } else {
                    JvmIrLinker.this.stubGenerator.generateMemberStub(descriptor2);
                }
                return;
            }
            if (JvmIrLinker.this.isCleanDescriptor(descriptor2)) {
                JvmIrLinker.this.stubGenerator.generateMemberStub(descriptor2);
                return;
            }
            super.declareIrSymbol(symbol2);
        }

        public JvmCurrentModuleDeserializer(@NotNull IrModuleFragment moduleFragment, Collection<? extends IrModuleDeserializer> dependencies2) {
            Intrinsics.checkNotNullParameter(moduleFragment, "moduleFragment");
            Intrinsics.checkNotNullParameter(dependencies2, "dependencies");
            super(moduleFragment, dependencies2);
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u0011\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0096\u0002J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0018\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00010\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/kotlin/ir/backend/jvm/serialization/JvmIrLinker$MetadataJVMModuleDeserializer;", "Lorg/jetbrains/kotlin/backend/common/serialization/IrModuleDeserializer;", "moduleDescriptor", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "dependencies", "", "(Lorg/jetbrains/kotlin/ir/backend/jvm/serialization/JvmIrLinker;Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;Ljava/util/List;)V", "descriptorFinder", "Lorg/jetbrains/kotlin/backend/common/serialization/DescriptorByIdSignatureFinder;", "moduleDependencies", "", "getModuleDependencies", "()Ljava/util/Collection;", "moduleFragment", "Lorg/jetbrains/kotlin/ir/declarations/IrModuleFragment;", "getModuleFragment", "()Lorg/jetbrains/kotlin/ir/declarations/IrModuleFragment;", "contains", "", "idSig", "Lorg/jetbrains/kotlin/ir/util/IdSignature;", "declareIrSymbol", "", "symbol", "Lorg/jetbrains/kotlin/ir/symbols/IrSymbol;", "deserializeIrSymbol", "symbolKind", "Lorg/jetbrains/kotlin/backend/common/serialization/encodings/BinarySymbolData$SymbolKind;", "resolveDescriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "ir.serialization.jvm"})
    private final class MetadataJVMModuleDeserializer
    extends IrModuleDeserializer {
        private final DescriptorByIdSignatureFinder descriptorFinder;
        @NotNull
        private final IrModuleFragment moduleFragment;
        @NotNull
        private final Collection<IrModuleDeserializer> moduleDependencies;

        @Override
        public boolean contains(@NotNull IdSignature idSig) {
            Intrinsics.checkNotNullParameter(idSig, "idSig");
            return true;
        }

        private final DeclarationDescriptor resolveDescriptor(IdSignature idSig) {
            DeclarationDescriptor declarationDescriptor = this.descriptorFinder.findDescriptorBySignature(idSig);
            if (declarationDescriptor == null) {
                String string2 = "No descriptor found for " + idSig;
                boolean bl = false;
                throw (Throwable)new IllegalStateException(string2.toString());
            }
            return declarationDescriptor;
        }

        @Override
        @NotNull
        public IrSymbol deserializeIrSymbol(@NotNull IdSignature idSig, @NotNull BinarySymbolData.SymbolKind symbolKind) {
            IrElement irElement;
            Intrinsics.checkNotNullParameter(idSig, "idSig");
            Intrinsics.checkNotNullParameter((Object)symbolKind, "symbolKind");
            DeclarationDescriptor descriptor2 = this.resolveDescriptor(idSig);
            DeclarationStubGenerator declarationStubGenerator = JvmIrLinker.this.stubGenerator;
            boolean bl = false;
            boolean bl2 = false;
            DeclarationStubGenerator $this$run = declarationStubGenerator;
            boolean bl3 = false;
            switch (JvmIrLinker$MetadataJVMModuleDeserializer$WhenMappings.$EnumSwitchMapping$0[symbolKind.ordinal()]) {
                case 1: {
                    DeclarationDescriptor declarationDescriptor = descriptor2;
                    if (declarationDescriptor == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.ClassDescriptor");
                    }
                    irElement = $this$run.generateClassStub((ClassDescriptor)declarationDescriptor);
                    break;
                }
                case 2: {
                    DeclarationDescriptor declarationDescriptor = descriptor2;
                    if (declarationDescriptor == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.PropertyDescriptor");
                    }
                    irElement = DeclarationStubGenerator.generatePropertyStub$default($this$run, (PropertyDescriptor)declarationDescriptor, null, 2, null);
                    break;
                }
                case 3: {
                    DeclarationDescriptor declarationDescriptor = descriptor2;
                    if (declarationDescriptor == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.FunctionDescriptor");
                    }
                    irElement = DeclarationStubGenerator.generateFunctionStub$default($this$run, (FunctionDescriptor)declarationDescriptor, false, 2, null);
                    break;
                }
                case 4: {
                    DeclarationDescriptor declarationDescriptor = descriptor2;
                    if (declarationDescriptor == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.ClassConstructorDescriptor");
                    }
                    irElement = $this$run.generateConstructorStub((ClassConstructorDescriptor)declarationDescriptor);
                    break;
                }
                case 5: {
                    DeclarationDescriptor declarationDescriptor = descriptor2;
                    if (declarationDescriptor == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.ClassDescriptor");
                    }
                    irElement = $this$run.generateEnumEntryStub((ClassDescriptor)declarationDescriptor);
                    break;
                }
                case 6: {
                    DeclarationDescriptor declarationDescriptor = descriptor2;
                    if (declarationDescriptor == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.TypeAliasDescriptor");
                    }
                    irElement = $this$run.generateTypeAliasStub((TypeAliasDescriptor)declarationDescriptor);
                    break;
                }
                default: {
                    String string2 = "Unexpected type " + (Object)((Object)symbolKind) + " for sig " + idSig;
                    boolean bl4 = false;
                    throw (Throwable)new IllegalStateException(string2.toString());
                }
            }
            IrElement declaration2 = irElement;
            return ((IrSymbolOwner)declaration2).getSymbol();
        }

        @Override
        public void declareIrSymbol(@NotNull IrSymbol symbol2) {
            Intrinsics.checkNotNullParameter(symbol2, "symbol");
            boolean bl = symbol2.isPublicApi() || JvmIrLinker.this.isJavaDescriptor(symbol2.getDescriptor());
            boolean bl2 = false;
            boolean bl3 = false;
            if (_Assertions.ENABLED && !bl) {
                boolean bl4 = false;
                String string2 = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)string2));
            }
            if (symbol2 instanceof IrFieldSymbol) {
                JvmIrLinker.this.declareJavaFieldStub((IrFieldSymbol)symbol2);
            } else {
                JvmIrLinker.this.stubGenerator.generateMemberStub(symbol2.getDescriptor());
            }
        }

        @Override
        @NotNull
        public IrModuleFragment getModuleFragment() {
            return this.moduleFragment;
        }

        @Override
        @NotNull
        public Collection<IrModuleDeserializer> getModuleDependencies() {
            return this.moduleDependencies;
        }

        public MetadataJVMModuleDeserializer(@NotNull ModuleDescriptor moduleDescriptor, List<? extends IrModuleDeserializer> dependencies2) {
            Intrinsics.checkNotNullParameter(moduleDescriptor, "moduleDescriptor");
            Intrinsics.checkNotNullParameter(dependencies2, "dependencies");
            super(moduleDescriptor);
            this.descriptorFinder = new DescriptorByIdSignatureFinder(moduleDescriptor, JvmIrLinker.this.manglerDesc, DescriptorByIdSignatureFinder.LookupMode.MODULE_ONLY);
            this.moduleFragment = new IrModuleFragmentImpl(moduleDescriptor, JvmIrLinker.this.getBuiltIns(), CollectionsKt.emptyList());
            this.moduleDependencies = dependencies2;
        }
    }
}

