/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.transformers;

import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.CopyUtilsKt;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.expressions.FirCall;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirFunctionCall;
import org.jetbrains.kotlin.fir.expressions.FirStatement;
import org.jetbrains.kotlin.fir.resolve.transformers.IntegerLiteralTypeApproximationTransformer;
import org.jetbrains.kotlin.fir.resolve.transformers.IntegerLiteralTypeApproximationTransformerKt;
import org.jetbrains.kotlin.fir.resolve.transformers.IntegerOperatorsTypeUpdater$WhenMappings;
import org.jetbrains.kotlin.fir.scopes.impl.FirIntegerOperator;
import org.jetbrains.kotlin.fir.symbols.StandardClassIds;
import org.jetbrains.kotlin.fir.types.ConeIntegerLiteralType;
import org.jetbrains.kotlin.fir.types.ConeIntegerLiteralTypeImpl;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.visitors.CompositeTransformResult;
import org.jetbrains.kotlin.fir.visitors.FirTransformer;
import org.jetbrains.kotlin.fir.visitors.FirTransformerUtilKt;
import org.jetbrains.kotlin.name.ClassId;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0001\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J/\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\n0\t\"\b\b\u0000\u0010\n*\u00020\u000b2\u0006\u0010\f\u001a\u0002H\n2\b\u0010\r\u001a\u0004\u0018\u00010\u0002H\u0016\u00a2\u0006\u0002\u0010\u000eJ \u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\t2\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\r\u001a\u0004\u0018\u00010\u0002H\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/transformers/IntegerOperatorsTypeUpdater;", "Lorg/jetbrains/kotlin/fir/visitors/FirTransformer;", "", "approximator", "Lorg/jetbrains/kotlin/fir/resolve/transformers/IntegerLiteralTypeApproximationTransformer;", "(Lorg/jetbrains/kotlin/fir/resolve/transformers/IntegerLiteralTypeApproximationTransformer;)V", "getApproximator", "()Lorg/jetbrains/kotlin/fir/resolve/transformers/IntegerLiteralTypeApproximationTransformer;", "transformElement", "Lorg/jetbrains/kotlin/fir/visitors/CompositeTransformResult;", "E", "Lorg/jetbrains/kotlin/fir/FirElement;", "element", "data", "(Lorg/jetbrains/kotlin/fir/FirElement;Ljava/lang/Void;)Lorg/jetbrains/kotlin/fir/visitors/CompositeTransformResult;", "transformFunctionCall", "Lorg/jetbrains/kotlin/fir/expressions/FirStatement;", "functionCall", "Lorg/jetbrains/kotlin/fir/expressions/FirFunctionCall;", "resolve"})
public final class IntegerOperatorsTypeUpdater
extends FirTransformer {
    @NotNull
    private final IntegerLiteralTypeApproximationTransformer approximator;

    @NotNull
    public <E extends FirElement> CompositeTransformResult<E> transformElement(@NotNull E element, @Nullable Void data2) {
        Intrinsics.checkNotNullParameter(element, "element");
        E $this$compose$iv = element;
        boolean $i$f$compose = false;
        return CompositeTransformResult.Companion.single($this$compose$iv);
    }

    @NotNull
    public CompositeTransformResult<FirStatement> transformFunctionCall(@NotNull FirFunctionCall functionCall, @Nullable Void data2) {
        long l;
        ConeIntegerLiteralType receiverType;
        block29: {
            ConeKotlinType argumentType;
            block30: {
                FirIntegerOperator.Kind kind;
                long receiverValue;
                block28: {
                    Intrinsics.checkNotNullParameter(functionCall, "functionCall");
                    FirCallableDeclaration<?> firCallableDeclaration = IntegerLiteralTypeApproximationTransformerKt.getOriginalFunction(functionCall);
                    if (firCallableDeclaration == null) {
                        FirElement $this$compose$iv = functionCall;
                        boolean $i$f$compose = false;
                        return CompositeTransformResult.Companion.single($this$compose$iv);
                    }
                    FirCallableDeclaration<?> function2 = firCallableDeclaration;
                    if (!(function2 instanceof FirIntegerOperator)) {
                        ConeKotlinType coneKotlinType;
                        FirTypeRef firTypeRef = function2.getReceiverTypeRef();
                        if (firTypeRef != null) {
                            FirTypeRef $this$coneTypeSafe$iv = firTypeRef;
                            boolean $i$f$coneTypeSafe = false;
                            boolean bl = false;
                            FirTypeRef firTypeRef2 = $this$coneTypeSafe$iv;
                            if (!(firTypeRef2 instanceof FirResolvedTypeRef)) {
                                firTypeRef2 = null;
                            }
                            FirResolvedTypeRef firResolvedTypeRef = (FirResolvedTypeRef)firTypeRef2;
                            coneKotlinType = firResolvedTypeRef != null ? firResolvedTypeRef.getType() : null;
                            if (!(coneKotlinType instanceof ConeKotlinType)) {
                                coneKotlinType = null;
                            }
                        } else {
                            coneKotlinType = null;
                        }
                        ConeKotlinType expectedType2 = coneKotlinType;
                        FirElement $this$compose$iv = functionCall.transformExplicitReceiver(this.approximator, expectedType2);
                        boolean $i$f$compose = false;
                        return CompositeTransformResult.Companion.single($this$compose$iv);
                    }
                    FirExpression firExpression2 = functionCall.getExplicitReceiver();
                    Intrinsics.checkNotNull(firExpression2);
                    FirTypeRef $this$coneTypeSafe$iv = firExpression2.getTypeRef();
                    boolean $i$f$coneTypeSafe = false;
                    boolean bl = false;
                    FirTypeRef firTypeRef = $this$coneTypeSafe$iv;
                    if (!(firTypeRef instanceof FirResolvedTypeRef)) {
                        firTypeRef = null;
                    }
                    FirResolvedTypeRef firResolvedTypeRef = (FirResolvedTypeRef)firTypeRef;
                    ConeKotlinType coneKotlinType = firResolvedTypeRef != null ? firResolvedTypeRef.getType() : null;
                    if (!(coneKotlinType instanceof ConeIntegerLiteralType)) {
                        coneKotlinType = null;
                    }
                    ConeIntegerLiteralType coneIntegerLiteralType = (ConeIntegerLiteralType)((ConeKotlinType)((ConeIntegerLiteralType)coneKotlinType));
                    if (coneIntegerLiteralType == null) {
                        FirElement $this$compose$iv = functionCall;
                        boolean $i$f$compose = false;
                        return CompositeTransformResult.Companion.single($this$compose$iv);
                    }
                    receiverType = coneIntegerLiteralType;
                    receiverValue = receiverType.getValue();
                    kind = ((FirIntegerOperator)function2).getKind();
                    if (!kind.getUnary()) break block28;
                    switch (IntegerOperatorsTypeUpdater$WhenMappings.$EnumSwitchMapping$0[kind.ordinal()]) {
                        case 1: {
                            l = receiverValue;
                            break block29;
                        }
                        case 2: {
                            l = -receiverValue;
                            break block29;
                        }
                        case 3: {
                            l = receiverValue ^ 0xFFFFFFFFFFFFFFFFL;
                            break block29;
                        }
                        default: {
                            throw (Throwable)new IllegalStateException();
                        }
                    }
                }
                FirCall $this$argument$iv = functionCall;
                boolean $i$f$getArgument = false;
                Object $this$coneTypeUnsafe$iv = CollectionsKt.first($this$argument$iv.getArgumentList().getArguments()).getTypeRef();
                boolean $i$f$coneTypeUnsafe = false;
                ConeKotlinType coneKotlinType = ((FirResolvedTypeRef)$this$coneTypeUnsafe$iv).getType();
                if (coneKotlinType == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.types.ConeKotlinType");
                }
                argumentType = coneKotlinType;
                $this$coneTypeUnsafe$iv = argumentType;
                if (!($this$coneTypeUnsafe$iv instanceof ConeIntegerLiteralType)) break block30;
                long argumentValue = ((ConeIntegerLiteralType)argumentType).getValue();
                boolean divisionByZero = argumentValue == 0L;
                switch (IntegerOperatorsTypeUpdater$WhenMappings.$EnumSwitchMapping$1[kind.ordinal()]) {
                    case 1: {
                        l = receiverValue + argumentValue;
                        break block29;
                    }
                    case 2: {
                        l = receiverValue - argumentValue;
                        break block29;
                    }
                    case 3: {
                        l = receiverValue * argumentValue;
                        break block29;
                    }
                    case 4: {
                        l = divisionByZero ? receiverValue : receiverValue / argumentValue;
                        break block29;
                    }
                    case 5: {
                        l = divisionByZero ? receiverValue : receiverValue % argumentValue;
                        break block29;
                    }
                    case 6: {
                        l = receiverValue << (int)argumentValue;
                        break block29;
                    }
                    case 7: {
                        l = receiverValue >> (int)argumentValue;
                        break block29;
                    }
                    case 8: {
                        l = receiverValue >>> (int)argumentValue;
                        break block29;
                    }
                    case 9: {
                        l = receiverValue ^ argumentValue;
                        break block29;
                    }
                    case 10: {
                        l = receiverValue & argumentValue;
                        break block29;
                    }
                    case 11: {
                        l = receiverValue | argumentValue;
                        break block29;
                    }
                    default: {
                        throw (Throwable)new IllegalStateException();
                    }
                }
            }
            ClassId classId = ConeTypeUtilsKt.getClassId(argumentType);
            ConeKotlinType expectedType3 = Intrinsics.areEqual(classId, StandardClassIds.INSTANCE.getLong()) ? argumentType : (ConeKotlinType)ConeIntegerLiteralTypeImpl.Companion.createType(StandardClassIds.INSTANCE.getInt());
            FirTransformerUtilKt.transformSingle((FirElement)functionCall, this.approximator, expectedType3);
            FirExpression $this$resultType$iv = functionCall;
            boolean $i$f$getResultType = false;
            functionCall.replaceTypeRef(CopyUtilsKt.resolvedTypeFromPrototype($this$resultType$iv.getTypeRef(), expectedType3));
            FirElement $this$compose$iv = functionCall;
            boolean $i$f$compose = false;
            return CompositeTransformResult.Companion.single($this$compose$iv);
        }
        long resultValue = l;
        FirExpression $this$resultType$iv = functionCall;
        boolean $i$f$getResultType = false;
        functionCall.replaceTypeRef(CopyUtilsKt.resolvedTypeFromPrototype($this$resultType$iv.getTypeRef(), new ConeIntegerLiteralTypeImpl(resultValue, receiverType.isUnsigned(), null, 4, null)));
        FirElement $this$compose$iv = IntegerLiteralTypeApproximationTransformerKt.access$toOperatorCall(functionCall);
        boolean $i$f$compose = false;
        return CompositeTransformResult.Companion.single($this$compose$iv);
    }

    @NotNull
    public final IntegerLiteralTypeApproximationTransformer getApproximator() {
        return this.approximator;
    }

    public IntegerOperatorsTypeUpdater(@NotNull IntegerLiteralTypeApproximationTransformer approximator2) {
        Intrinsics.checkNotNullParameter(approximator2, "approximator");
        this.approximator = approximator2;
    }
}

