/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.calls;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirRendererKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.SessionUtilsKt;
import org.jetbrains.kotlin.fir.UtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousFunction;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.declarations.FirTypeAlias;
import org.jetbrains.kotlin.fir.declarations.FirTypedDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.expressions.FirAnnotationCall;
import org.jetbrains.kotlin.fir.expressions.FirBlock;
import org.jetbrains.kotlin.fir.expressions.FirCallableReferenceAccess;
import org.jetbrains.kotlin.fir.expressions.FirCheckNotNullCall;
import org.jetbrains.kotlin.fir.expressions.FirConstExpression;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirFunctionCall;
import org.jetbrains.kotlin.fir.expressions.FirNamedArgumentExpression;
import org.jetbrains.kotlin.fir.expressions.FirQualifiedAccessExpression;
import org.jetbrains.kotlin.fir.expressions.FirResolvable;
import org.jetbrains.kotlin.fir.expressions.FirSpreadArgumentExpression;
import org.jetbrains.kotlin.fir.expressions.FirTryExpression;
import org.jetbrains.kotlin.fir.expressions.FirWhenExpression;
import org.jetbrains.kotlin.fir.expressions.FirWrappedArgumentExpression;
import org.jetbrains.kotlin.fir.references.FirResolvedNamedReference;
import org.jetbrains.kotlin.fir.resolve.ResolveUtilsKt;
import org.jetbrains.kotlin.fir.resolve.calls.Candidate;
import org.jetbrains.kotlin.fir.resolve.calls.CandidateApplicability;
import org.jetbrains.kotlin.fir.resolve.calls.CandidateFactoryKt;
import org.jetbrains.kotlin.fir.resolve.calls.CheckerSink;
import org.jetbrains.kotlin.fir.resolve.inference.InferenceUtilsKt;
import org.jetbrains.kotlin.fir.resolve.inference.PostponedArgumentsKt;
import org.jetbrains.kotlin.fir.scopes.impl.FirILTTypeRefPlaceHolder;
import org.jetbrains.kotlin.fir.scopes.impl.FirIntegerOperator;
import org.jetbrains.kotlin.fir.scopes.impl.FirIntegerOperatorCall;
import org.jetbrains.kotlin.fir.symbols.AbstractFirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirTypeAliasSymbol;
import org.jetbrains.kotlin.fir.types.ArrayUtilsKt;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeFlexibleType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeNullability;
import org.jetbrains.kotlin.fir.types.ConeTypeProjection;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.TypeRendererKt;
import org.jetbrains.kotlin.fir.types.TypeUtilsKt;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystemBuilder;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystemBuilderKt;
import org.jetbrains.kotlin.resolve.calls.inference.model.SimpleConstraintSystemConstraintPosition;
import org.jetbrains.kotlin.types.model.CaptureStatus;
import org.jetbrains.kotlin.types.model.SimpleTypeMarker;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u0000`\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u001aH\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000eH\u0002\u001a\u0016\u0010\u000f\u001a\u0004\u0018\u00010\u0005*\u00020\u00102\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\u001c\u0010\u0011\u001a\u00020\u0001*\u00020\u00102\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002\u001a\u001c\u0010\u0014\u001a\u00020\u0005*\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0000\u001a&\u0010\u0019\u001a\u0004\u0018\u00010\u0005*\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u0005H\u0002\u001a\u0012\u0010\u001b\u001a\u00020\n*\u00020\u001c2\u0006\u0010\u0015\u001a\u00020\u0016\u001a\u0012\u0010\u001d\u001a\u00020\n*\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0016\u001a\u0012\u0010\u001e\u001a\u00020\u0005*\u00020\u00102\u0006\u0010\u0004\u001a\u00020\u0005\u001a$\u0010\u001f\u001a\u00020\u0005*\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u0018H\u0002\u001a4\u0010 \u001a\u00020\u0001*\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\t\u001a\u00020\n2\u0006\u0010!\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000eH\u0000\u001aJ\u0010\"\u001a\u00020\u0001*\u00020\u00102\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010#\u001a\u00020\u001c2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010!\u001a\u00020\n\u001aL\u0010$\u001a\u00020\u0001*\u00020\u00102\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010%\u001a\u00020&2\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010#\u001a\u00020\u001c2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010!\u001a\u00020\nH\u0002\u001aB\u0010'\u001a\u00020\u0001*\u00020\u00102\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010!\u001a\u00020\n\u001aD\u0010(\u001a\u00020\u0001*\u00020\u00102\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0006\u001a\u0004\u0018\u00010\u00052\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010!\u001a\u00020\n\u001aB\u0010)\u001a\u00020\u0001*\u00020\u00102\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020*2\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010!\u001a\u00020\n\u001a\u0012\u0010+\u001a\u00020\u0005*\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u0016\u00a8\u0006,"}, d2={"checkApplicabilityForArgumentType", "", "csBuilder", "Lorg/jetbrains/kotlin/resolve/calls/inference/ConstraintSystemBuilder;", "argumentType", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "expectedType", "position", "Lorg/jetbrains/kotlin/resolve/calls/inference/model/SimpleConstraintSystemConstraintPosition;", "isReceiver", "", "isDispatch", "nullableExpectedType", "sink", "Lorg/jetbrains/kotlin/fir/resolve/calls/CheckerSink;", "captureTypeFromExpressionOrNull", "Lorg/jetbrains/kotlin/fir/resolve/calls/Candidate;", "checkApplicabilityForIntegerOperatorCall", "argument", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "getExpectedType", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "parameter", "Lorg/jetbrains/kotlin/fir/declarations/FirValueParameter;", "getExpectedTypeWithSAMConversion", "candidateExpectedType", "isExtensionFunctionType", "Lorg/jetbrains/kotlin/fir/types/FirTypeRef;", "isFunctional", "prepareCapturedType", "prepareExpectedType", "resolveArgument", "isSafeCall", "resolveArgumentExpression", "expectedTypeRef", "resolveBlockArgument", "block", "Lorg/jetbrains/kotlin/fir/expressions/FirBlock;", "resolvePlainArgumentType", "resolvePlainExpressionArgument", "resolveSubCallArgument", "Lorg/jetbrains/kotlin/fir/expressions/FirResolvable;", "varargElementType", "resolve"})
public final class ArgumentsKt {
    public static final void resolveArgumentExpression(@NotNull Candidate $this$resolveArgumentExpression, @NotNull ConstraintSystemBuilder csBuilder, @NotNull FirExpression argument, @NotNull ConeKotlinType expectedType2, @NotNull FirTypeRef expectedTypeRef, @NotNull CheckerSink sink, boolean isReceiver, boolean isDispatch, boolean isSafeCall) {
        Intrinsics.checkNotNullParameter($this$resolveArgumentExpression, "$this$resolveArgumentExpression");
        Intrinsics.checkNotNullParameter(csBuilder, "csBuilder");
        Intrinsics.checkNotNullParameter(argument, "argument");
        Intrinsics.checkNotNullParameter(expectedType2, "expectedType");
        Intrinsics.checkNotNullParameter(expectedTypeRef, "expectedTypeRef");
        Intrinsics.checkNotNullParameter(sink, "sink");
        FirExpression firExpression2 = argument;
        if (firExpression2 instanceof FirFunctionCall || firExpression2 instanceof FirWhenExpression || firExpression2 instanceof FirTryExpression || firExpression2 instanceof FirCheckNotNullCall) {
            ArgumentsKt.resolveSubCallArgument($this$resolveArgumentExpression, csBuilder, (FirResolvable)((Object)argument), expectedType2, sink, isReceiver, isDispatch, isSafeCall);
        } else if (firExpression2 instanceof FirCallableReferenceAccess) {
            if (((FirCallableReferenceAccess)argument).getCalleeReference() instanceof FirResolvedNamedReference) {
                ArgumentsKt.resolvePlainExpressionArgument($this$resolveArgumentExpression, csBuilder, argument, expectedType2, sink, isReceiver, isDispatch, isSafeCall);
            } else {
                PostponedArgumentsKt.preprocessCallableReference($this$resolveArgumentExpression, (FirCallableReferenceAccess)argument, expectedType2);
            }
        } else if (firExpression2 instanceof FirQualifiedAccessExpression) {
            ArgumentsKt.resolvePlainExpressionArgument($this$resolveArgumentExpression, csBuilder, argument, expectedType2, sink, isReceiver, isDispatch, isSafeCall);
        } else if (firExpression2 instanceof FirAnonymousFunction) {
            PostponedArgumentsKt.preprocessLambdaArgument$default($this$resolveArgumentExpression, csBuilder, (FirAnonymousFunction)argument, expectedType2, expectedTypeRef, false, null, 48, null);
        } else if (firExpression2 instanceof FirWrappedArgumentExpression) {
            ArgumentsKt.resolveArgumentExpression($this$resolveArgumentExpression, csBuilder, ((FirWrappedArgumentExpression)argument).getExpression(), expectedType2, expectedTypeRef, sink, isReceiver, isDispatch, isSafeCall);
        } else if (firExpression2 instanceof FirBlock) {
            ArgumentsKt.resolveBlockArgument($this$resolveArgumentExpression, csBuilder, (FirBlock)argument, expectedType2, expectedTypeRef, sink, isReceiver, isDispatch, isSafeCall);
        } else {
            ArgumentsKt.resolvePlainExpressionArgument($this$resolveArgumentExpression, csBuilder, argument, expectedType2, sink, isReceiver, isDispatch, isSafeCall);
        }
    }

    private static final void resolveBlockArgument(Candidate $this$resolveBlockArgument, ConstraintSystemBuilder csBuilder, FirBlock block, ConeKotlinType expectedType2, FirTypeRef expectedTypeRef, CheckerSink sink, boolean isReceiver, boolean isDispatch, boolean isSafeCall) {
        List<FirExpression> returnArguments = UtilsKt.returnExpressions(block);
        if (returnArguments.isEmpty()) {
            FirTypeRef $this$coneTypeUnsafe$iv = block.getTypeRef();
            boolean $i$f$coneTypeUnsafe = false;
            ConeKotlinType coneKotlinType = ((FirResolvedTypeRef)$this$coneTypeUnsafe$iv).getType();
            if (coneKotlinType == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.types.ConeKotlinType");
            }
            ArgumentsKt.checkApplicabilityForArgumentType(csBuilder, coneKotlinType, expectedType2.getType(), SimpleConstraintSystemConstraintPosition.INSTANCE, false, false, TypeUtilsKt.withNullability(expectedType2.getType(), ConeNullability.NULLABLE, SessionUtilsKt.getInferenceContext(sink.getComponents().getSession())), sink);
            return;
        }
        for (FirExpression argument : returnArguments) {
            ArgumentsKt.resolveArgumentExpression($this$resolveBlockArgument, csBuilder, argument, expectedType2, expectedTypeRef, sink, isReceiver, isDispatch, isSafeCall);
        }
    }

    public static final void resolveSubCallArgument(@NotNull Candidate $this$resolveSubCallArgument, @NotNull ConstraintSystemBuilder csBuilder, @NotNull FirResolvable argument, @NotNull ConeKotlinType expectedType2, @NotNull CheckerSink sink, boolean isReceiver, boolean isDispatch, boolean isSafeCall) {
        ConeKotlinType coneKotlinType;
        boolean $i$f$coneTypeUnsafe;
        FirTypeRef $this$coneTypeUnsafe$iv;
        Intrinsics.checkNotNullParameter($this$resolveSubCallArgument, "$this$resolveSubCallArgument");
        Intrinsics.checkNotNullParameter(csBuilder, "csBuilder");
        Intrinsics.checkNotNullParameter(argument, "argument");
        Intrinsics.checkNotNullParameter(expectedType2, "expectedType");
        Intrinsics.checkNotNullParameter(sink, "sink");
        Candidate candidate2 = CandidateFactoryKt.candidate(argument);
        if (candidate2 == null) {
            ArgumentsKt.resolvePlainExpressionArgument($this$resolveSubCallArgument, csBuilder, (FirExpression)((Object)argument), expectedType2, sink, isReceiver, isDispatch, isSafeCall);
            return;
        }
        Candidate candidate3 = candidate2;
        if (candidate3.getSymbol().getFir() instanceof FirIntegerOperator) {
            FirExpression $this$resultType$iv = (FirFunctionCall)argument;
            boolean $i$f$getResultType = false;
            $this$coneTypeUnsafe$iv = $this$resultType$iv.getTypeRef();
            $i$f$coneTypeUnsafe = false;
            coneKotlinType = ((FirResolvedTypeRef)$this$coneTypeUnsafe$iv).getType();
            if (coneKotlinType == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.types.ConeKotlinType");
            }
        } else {
            FirBasedSymbol $this$firUnsafe$iv = candidate3.getSymbol();
            boolean $i$f$firUnsafe = false;
            Object fir$iv = $this$firUnsafe$iv.getFir();
            boolean bl = fir$iv instanceof FirTypedDeclaration;
            boolean bl2 = false;
            boolean bl3 = false;
            if (!bl) {
                boolean bl4 = false;
                String string2 = "Not an expected fir element type = " + Reflection.getOrCreateKotlinClass(FirTypedDeclaration.class) + ", symbol = " + $this$firUnsafe$iv + ", fir = " + FirRendererKt.renderWithType$default((FirElement)fir$iv, null, 1, null);
                throw (Throwable)new IllegalArgumentException(string2.toString());
            }
            $this$coneTypeUnsafe$iv = sink.getComponents().getReturnTypeCalculator().tryCalculateReturnType((FirTypedDeclaration)((FirElement)fir$iv));
            $i$f$coneTypeUnsafe = false;
            coneKotlinType = ((FirResolvedTypeRef)$this$coneTypeUnsafe$iv).getType();
            if (coneKotlinType == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.types.ConeKotlinType");
            }
        }
        ConeKotlinType type2 = coneKotlinType;
        ConeKotlinType argumentType = candidate3.getSubstitutor().substituteOrSelf(type2);
        ArgumentsKt.resolvePlainArgumentType($this$resolveSubCallArgument, csBuilder, argumentType, expectedType2, sink, isReceiver, isDispatch, isSafeCall);
    }

    public static final void resolvePlainExpressionArgument(@NotNull Candidate $this$resolvePlainExpressionArgument, @NotNull ConstraintSystemBuilder csBuilder, @NotNull FirExpression argument, @Nullable ConeKotlinType expectedType2, @NotNull CheckerSink sink, boolean isReceiver, boolean isDispatch, boolean isSafeCall) {
        Intrinsics.checkNotNullParameter($this$resolvePlainExpressionArgument, "$this$resolvePlainExpressionArgument");
        Intrinsics.checkNotNullParameter(csBuilder, "csBuilder");
        Intrinsics.checkNotNullParameter(argument, "argument");
        Intrinsics.checkNotNullParameter(sink, "sink");
        if (expectedType2 == null) {
            return;
        }
        FirTypeRef $this$coneTypeSafe$iv = argument.getTypeRef();
        boolean $i$f$coneTypeSafe = false;
        boolean bl = false;
        FirTypeRef firTypeRef = $this$coneTypeSafe$iv;
        if (!(firTypeRef instanceof FirResolvedTypeRef)) {
            firTypeRef = null;
        }
        FirResolvedTypeRef firResolvedTypeRef = (FirResolvedTypeRef)firTypeRef;
        ConeKotlinType coneKotlinType = firResolvedTypeRef != null ? firResolvedTypeRef.getType() : null;
        if (!(coneKotlinType instanceof ConeKotlinType)) {
            coneKotlinType = null;
        }
        if (coneKotlinType == null) {
            return;
        }
        ConeKotlinType argumentType = coneKotlinType;
        ArgumentsKt.resolvePlainArgumentType($this$resolvePlainExpressionArgument, csBuilder, argumentType, expectedType2, sink, isReceiver, isDispatch, isSafeCall);
        ArgumentsKt.checkApplicabilityForIntegerOperatorCall($this$resolvePlainExpressionArgument, sink, argument);
    }

    private static final void checkApplicabilityForIntegerOperatorCall(Candidate $this$checkApplicabilityForIntegerOperatorCall, CheckerSink sink, FirExpression argument) {
        if (!($this$checkApplicabilityForIntegerOperatorCall.getSymbol().getFir() instanceof FirIntegerOperator)) {
            return;
        }
        if (!(argument instanceof FirConstExpression) && !(argument instanceof FirIntegerOperatorCall)) {
            sink.reportApplicability(CandidateApplicability.INAPPLICABLE);
        }
    }

    public static final void resolvePlainArgumentType(@NotNull Candidate $this$resolvePlainArgumentType, @NotNull ConstraintSystemBuilder csBuilder, @NotNull ConeKotlinType argumentType, @NotNull ConeKotlinType expectedType2, @NotNull CheckerSink sink, boolean isReceiver, boolean isDispatch, boolean isSafeCall) {
        Intrinsics.checkNotNullParameter($this$resolvePlainArgumentType, "$this$resolvePlainArgumentType");
        Intrinsics.checkNotNullParameter(csBuilder, "csBuilder");
        Intrinsics.checkNotNullParameter(argumentType, "argumentType");
        Intrinsics.checkNotNullParameter(expectedType2, "expectedType");
        Intrinsics.checkNotNullParameter(sink, "sink");
        SimpleConstraintSystemConstraintPosition position = SimpleConstraintSystemConstraintPosition.INSTANCE;
        FirSession session = sink.getComponents().getSession();
        ConeKotlinType capturedType = ArgumentsKt.prepareCapturedType($this$resolvePlainArgumentType, argumentType);
        ConeKotlinType nullableExpectedType = TypeUtilsKt.withNullability(expectedType2, ConeNullability.NULLABLE, SessionUtilsKt.getInferenceContext(session));
        if (isReceiver && isSafeCall) {
            if (!isDispatch && !ConstraintSystemBuilderKt.addSubtypeConstraintIfCompatible(csBuilder, capturedType, nullableExpectedType, position)) {
                sink.reportApplicability(CandidateApplicability.WRONG_RECEIVER);
            }
            return;
        }
        ArgumentsKt.checkApplicabilityForArgumentType(csBuilder, capturedType, expectedType2, position, isReceiver, isDispatch, nullableExpectedType, sink);
    }

    @NotNull
    public static final ConeKotlinType prepareCapturedType(@NotNull Candidate $this$prepareCapturedType, @NotNull ConeKotlinType argumentType) {
        Intrinsics.checkNotNullParameter($this$prepareCapturedType, "$this$prepareCapturedType");
        Intrinsics.checkNotNullParameter(argumentType, "argumentType");
        ConeKotlinType coneKotlinType = ArgumentsKt.captureTypeFromExpressionOrNull($this$prepareCapturedType, argumentType);
        if (coneKotlinType == null) {
            coneKotlinType = argumentType;
        }
        return coneKotlinType;
    }

    private static final ConeKotlinType captureTypeFromExpressionOrNull(Candidate $this$captureTypeFromExpressionOrNull, ConeKotlinType argumentType) {
        if (argumentType instanceof ConeFlexibleType) {
            return ArgumentsKt.captureTypeFromExpressionOrNull($this$captureTypeFromExpressionOrNull, ((ConeFlexibleType)argumentType).getLowerBound());
        }
        ConeTypeProjection[] coneTypeProjectionArray = argumentType.getTypeArguments();
        boolean bl = false;
        if (coneTypeProjectionArray.length == 0 || !(argumentType instanceof ConeClassLikeType)) {
            return null;
        }
        SimpleTypeMarker simpleTypeMarker = $this$captureTypeFromExpressionOrNull.getBodyResolveComponents().getInferenceComponents().getCtx().captureFromArguments((SimpleTypeMarker)((Object)argumentType), CaptureStatus.FROM_EXPRESSION);
        if (!(simpleTypeMarker instanceof ConeKotlinType)) {
            simpleTypeMarker = null;
        }
        return (ConeKotlinType)((Object)simpleTypeMarker);
    }

    private static final void checkApplicabilityForArgumentType(ConstraintSystemBuilder csBuilder, ConeKotlinType argumentType, ConeKotlinType expectedType2, SimpleConstraintSystemConstraintPosition position, boolean isReceiver, boolean isDispatch, ConeKotlinType nullableExpectedType, CheckerSink sink) {
        if (isReceiver && isDispatch) {
            if (!ConeTypeUtilsKt.isNullable(expectedType2) && ConeTypeUtilsKt.isMarkedNullable(argumentType)) {
                sink.reportApplicability(CandidateApplicability.WRONG_RECEIVER);
            }
            return;
        }
        if (!ConstraintSystemBuilderKt.addSubtypeConstraintIfCompatible(csBuilder, argumentType, expectedType2, position)) {
            if (!isReceiver) {
                csBuilder.addSubtypeConstraint(argumentType, expectedType2, position);
                return;
            }
            if (ConstraintSystemBuilderKt.addSubtypeConstraintIfCompatible(csBuilder, argumentType, nullableExpectedType, position)) {
                sink.reportApplicability(CandidateApplicability.WRONG_RECEIVER);
            } else {
                csBuilder.addSubtypeConstraint(argumentType, expectedType2, position);
                sink.reportApplicability(CandidateApplicability.WRONG_RECEIVER);
            }
        }
    }

    public static final void resolveArgument(@NotNull Candidate $this$resolveArgument, @NotNull FirExpression argument, @NotNull FirValueParameter parameter, boolean isReceiver, boolean isSafeCall, @NotNull CheckerSink sink) {
        Intrinsics.checkNotNullParameter($this$resolveArgument, "$this$resolveArgument");
        Intrinsics.checkNotNullParameter(argument, "argument");
        Intrinsics.checkNotNullParameter(parameter, "parameter");
        Intrinsics.checkNotNullParameter(sink, "sink");
        ConeKotlinType expectedType2 = ArgumentsKt.prepareExpectedType($this$resolveArgument, sink.getComponents().getSession(), argument, parameter);
        ArgumentsKt.resolveArgumentExpression($this$resolveArgument, $this$resolveArgument.getSystem().getBuilder(), argument, expectedType2, parameter.getReturnTypeRef(), sink, isReceiver, false, isSafeCall);
    }

    private static final ConeKotlinType prepareExpectedType(Candidate $this$prepareExpectedType, FirSession session, FirExpression argument, FirValueParameter parameter) {
        if (parameter.getReturnTypeRef() instanceof FirILTTypeRefPlaceHolder) {
            FirExpression $this$resultType$iv = argument;
            boolean $i$f$getResultType = false;
            FirTypeRef $this$coneTypeUnsafe$iv = $this$resultType$iv.getTypeRef();
            boolean $i$f$coneTypeUnsafe = false;
            ConeKotlinType coneKotlinType = ((FirResolvedTypeRef)$this$coneTypeUnsafe$iv).getType();
            if (coneKotlinType == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.types.ConeKotlinType");
            }
            return coneKotlinType;
        }
        ConeKotlinType basicExpectedType = ArgumentsKt.getExpectedType(argument, session, parameter);
        ConeKotlinType coneKotlinType = ArgumentsKt.getExpectedTypeWithSAMConversion($this$prepareExpectedType, session, argument, basicExpectedType);
        if (coneKotlinType == null) {
            coneKotlinType = basicExpectedType;
        }
        ConeKotlinType expectedType2 = coneKotlinType;
        return $this$prepareExpectedType.getSubstitutor().substituteOrSelf(expectedType2);
    }

    private static final ConeKotlinType getExpectedTypeWithSAMConversion(Candidate $this$getExpectedTypeWithSAMConversion, FirSession session, FirExpression argument, ConeKotlinType candidateExpectedType) {
        if (InferenceUtilsKt.isBuiltinFunctionalType(candidateExpectedType, session)) {
            return null;
        }
        Object obj = $this$getExpectedTypeWithSAMConversion.getSymbol().getFir();
        if (!(obj instanceof FirFunction)) {
            obj = null;
        }
        FirFunction firFunction = (FirFunction)obj;
        if (firFunction == null) {
            return null;
        }
        FirFunction firFunction2 = firFunction;
        if (!$this$getExpectedTypeWithSAMConversion.getSamResolver().shouldRunSamConversionForFunction(firFunction2)) {
            return null;
        }
        if (!ArgumentsKt.isFunctional(argument, session)) {
            return null;
        }
        ConeKotlinType coneKotlinType = $this$getExpectedTypeWithSAMConversion.getSamResolver().getFunctionTypeForPossibleSamType(candidateExpectedType);
        boolean bl = false;
        boolean bl2 = false;
        ConeKotlinType $this$apply = coneKotlinType;
        boolean bl3 = false;
        $this$getExpectedTypeWithSAMConversion.setUsesSAM(true);
        ConeKotlinType coneKotlinType2 = coneKotlinType;
        if (coneKotlinType2 == null) {
            return null;
        }
        return coneKotlinType2;
    }

    public static final boolean isFunctional(@NotNull FirExpression $this$isFunctional, @NotNull FirSession session) {
        boolean bl;
        FirExpression firExpression2;
        FirExpression firExpression3;
        Intrinsics.checkNotNullParameter($this$isFunctional, "$this$isFunctional");
        Intrinsics.checkNotNullParameter(session, "session");
        FirExpression firExpression4 = $this$isFunctional;
        if (!(firExpression4 instanceof FirWrappedArgumentExpression)) {
            firExpression4 = null;
        }
        if ((firExpression3 = (FirWrappedArgumentExpression)firExpression4) == null || (firExpression3 = firExpression3.getExpression()) == null) {
            firExpression3 = firExpression2 = $this$isFunctional;
        }
        if (firExpression2 instanceof FirAnonymousFunction || firExpression2 instanceof FirCallableReferenceAccess) {
            bl = true;
        } else {
            FirTypeRef $this$coneTypeSafe$iv = $this$isFunctional.getTypeRef();
            boolean $i$f$coneTypeSafe = false;
            boolean bl2 = false;
            FirTypeRef firTypeRef = $this$coneTypeSafe$iv;
            if (!(firTypeRef instanceof FirResolvedTypeRef)) {
                firTypeRef = null;
            }
            FirResolvedTypeRef firResolvedTypeRef = (FirResolvedTypeRef)firTypeRef;
            ConeKotlinType coneKotlinType = firResolvedTypeRef != null ? firResolvedTypeRef.getType() : null;
            if (!(coneKotlinType instanceof ConeKotlinType)) {
                coneKotlinType = null;
            }
            bl = coneKotlinType != null && InferenceUtilsKt.isBuiltinFunctionalType(coneKotlinType, session);
        }
        return bl;
    }

    @NotNull
    public static final ConeKotlinType getExpectedType(@NotNull FirExpression $this$getExpectedType, @NotNull FirSession session, @NotNull FirValueParameter parameter) {
        ConeKotlinType coneKotlinType;
        FirTypeRef $this$coneTypeUnsafe$iv;
        boolean shouldUnwrapVarargType;
        Intrinsics.checkNotNullParameter($this$getExpectedType, "$this$getExpectedType");
        Intrinsics.checkNotNullParameter(session, "session");
        Intrinsics.checkNotNullParameter(parameter, "parameter");
        FirExpression firExpression2 = $this$getExpectedType;
        boolean bl = firExpression2 instanceof FirSpreadArgumentExpression ? !((FirSpreadArgumentExpression)$this$getExpectedType).isSpread() : (shouldUnwrapVarargType = !(firExpression2 instanceof FirNamedArgumentExpression));
        if (parameter.isVararg() && shouldUnwrapVarargType) {
            $this$coneTypeUnsafe$iv = parameter.getReturnTypeRef();
            boolean $i$f$coneTypeUnsafe = false;
            ConeKotlinType coneKotlinType2 = ((FirResolvedTypeRef)$this$coneTypeUnsafe$iv).getType();
            if (coneKotlinType2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.types.ConeKotlinType");
            }
            coneKotlinType = ArgumentsKt.varargElementType(coneKotlinType2, session);
        } else {
            $this$coneTypeUnsafe$iv = parameter.getReturnTypeRef();
            boolean $i$f$coneTypeUnsafe = false;
            coneKotlinType = ((FirResolvedTypeRef)$this$coneTypeUnsafe$iv).getType();
            if (coneKotlinType == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.types.ConeKotlinType");
            }
        }
        return coneKotlinType;
    }

    @NotNull
    public static final ConeKotlinType varargElementType(@NotNull ConeKotlinType $this$varargElementType, @NotNull FirSession session) {
        Intrinsics.checkNotNullParameter($this$varargElementType, "$this$varargElementType");
        Intrinsics.checkNotNullParameter(session, "session");
        ConeKotlinType coneKotlinType = ArrayUtilsKt.arrayElementType($this$varargElementType, session);
        if (coneKotlinType == null) {
            String string2 = "Failed to extract! " + TypeRendererKt.render($this$varargElementType) + '!';
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string2.toString());
        }
        return coneKotlinType;
    }

    public static final boolean isExtensionFunctionType(@NotNull FirTypeRef $this$isExtensionFunctionType, @NotNull FirSession session) {
        boolean bl;
        block17: {
            Object object;
            block19: {
                block18: {
                    boolean bl2;
                    block16: {
                        Intrinsics.checkNotNullParameter($this$isExtensionFunctionType, "$this$isExtensionFunctionType");
                        Intrinsics.checkNotNullParameter(session, "session");
                        Iterable $this$any$iv = $this$isExtensionFunctionType.getAnnotations();
                        boolean $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl2 = false;
                        } else {
                            Iterator iterator2 = $this$any$iv.iterator();
                            while (iterator2.hasNext()) {
                                Object element$iv;
                                Object receiver = element$iv = iterator2.next();
                                boolean bl3 = false;
                                if (!FirTypeUtilsKt.isExtensionFunctionAnnotationCall((FirAnnotationCall)receiver)) continue;
                                bl2 = true;
                                break block16;
                            }
                            bl2 = false;
                        }
                    }
                    if (bl2) {
                        return true;
                    }
                    if (!($this$isExtensionFunctionType instanceof FirResolvedTypeRef)) {
                        return false;
                    }
                    ConeKotlinType coneKotlinType = ((FirResolvedTypeRef)$this$isExtensionFunctionType).getType();
                    if (!(coneKotlinType instanceof ConeClassLikeType)) {
                        coneKotlinType = null;
                    }
                    ConeClassLikeType coneClassLikeType = (ConeClassLikeType)coneKotlinType;
                    if (coneClassLikeType == null) {
                        return false;
                    }
                    ConeClassLikeType type2 = coneClassLikeType;
                    if (ResolveUtilsKt.fullyExpandedType$default(type2, session, null, 2, null) == type2) {
                        return false;
                    }
                    object = ResolveUtilsKt.toSymbol(type2.getLookupTag(), session);
                    if (object == null) break block18;
                    FirTypeAliasSymbol $this$safeAs$iv = object;
                    boolean $i$f$safeAs = false;
                    FirTypeAliasSymbol firTypeAliasSymbol = $this$safeAs$iv;
                    if (!(firTypeAliasSymbol instanceof FirTypeAliasSymbol)) {
                        firTypeAliasSymbol = null;
                    }
                    if ((object = (FirTypeAliasSymbol)firTypeAliasSymbol) != null && (object = (FirTypeAlias)((AbstractFirBasedSymbol)object).getFir()) != null) break block19;
                }
                return false;
            }
            Object typeAlias = object;
            Iterable $this$any$iv = ((FirTypeAlias)typeAlias).getExpandedTypeRef().getAnnotations();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                Iterator iterator3 = $this$any$iv.iterator();
                while (iterator3.hasNext()) {
                    Object element$iv;
                    Object receiver = element$iv = iterator3.next();
                    boolean bl4 = false;
                    if (!FirTypeUtilsKt.isExtensionFunctionAnnotationCall((FirAnnotationCall)receiver)) continue;
                    bl = true;
                    break block17;
                }
                bl = false;
            }
        }
        return bl;
    }
}

