/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.extensions;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.collections.immutable.PersistentList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.declarations.FirAnnotatedDeclaration;
import org.jetbrains.kotlin.fir.expressions.FirAnnotationCall;
import org.jetbrains.kotlin.fir.extensions.FirPredicateBasedProvider;
import org.jetbrains.kotlin.fir.extensions.FirRegisteredPluginAnnotations;
import org.jetbrains.kotlin.fir.extensions.FirRegisteredPluginAnnotationsKt;
import org.jetbrains.kotlin.fir.extensions.predicate.AnnotatedWith;
import org.jetbrains.kotlin.fir.extensions.predicate.AnnotatedWithMeta;
import org.jetbrains.kotlin.fir.extensions.predicate.DeclarationPredicate;
import org.jetbrains.kotlin.fir.extensions.predicate.DeclarationPredicateVisitor;
import org.jetbrains.kotlin.fir.extensions.predicate.MetaAnnotated;
import org.jetbrains.kotlin.fir.extensions.predicate.UnderAnnotatedWith;
import org.jetbrains.kotlin.fir.extensions.predicate.UnderMetaAnnotated;
import org.jetbrains.kotlin.fir.resolve.ResolveUtilsKt;
import org.jetbrains.kotlin.name.FqName;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001:\u0002\u0018\u0019B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\rH\u0016J\u001e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0012\u001a\u00020\r2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\r0\u0016H\u0016J\u001e\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0012\u001a\u00020\r2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\r0\u0016H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0007\u001a\u00060\bR\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/fir/extensions/FirPredicateBasedProviderImpl;", "Lorg/jetbrains/kotlin/fir/extensions/FirPredicateBasedProvider;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "(Lorg/jetbrains/kotlin/fir/FirSession;)V", "cache", "Lorg/jetbrains/kotlin/fir/extensions/FirPredicateBasedProviderImpl$Cache;", "matcher", "Lorg/jetbrains/kotlin/fir/extensions/FirPredicateBasedProviderImpl$Matcher;", "registeredPluginAnnotations", "Lorg/jetbrains/kotlin/fir/extensions/FirRegisteredPluginAnnotations;", "getSymbolsByPredicate", "", "Lorg/jetbrains/kotlin/fir/declarations/FirAnnotatedDeclaration;", "predicate", "Lorg/jetbrains/kotlin/fir/extensions/predicate/DeclarationPredicate;", "matches", "", "declaration", "registerAnnotatedDeclaration", "", "owners", "Lkotlinx/collections/immutable/PersistentList;", "registerOwnersDeclarations", "Cache", "Matcher", "resolve"})
final class FirPredicateBasedProviderImpl
extends FirPredicateBasedProvider {
    private final FirRegisteredPluginAnnotations registeredPluginAnnotations;
    private final Cache cache;
    private final Matcher matcher;
    private final FirSession session;

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<FirAnnotatedDeclaration> getSymbolsByPredicate(@NotNull DeclarationPredicate predicate) {
        void $this$filterTo$iv$iv;
        Object it;
        Iterable $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter(predicate, "predicate");
        Set<FqName> annotations2 = this.registeredPluginAnnotations.getAnnotationsForPredicate(predicate);
        if (annotations2.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        Iterable $this$flatMap$iv = annotations2;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            it = (FqName)element$iv$iv;
            boolean bl = false;
            Collection<FirAnnotatedDeclaration> collection = this.cache.getDeclarationByAnnotation().get((FqName)it);
            Intrinsics.checkNotNullExpressionValue(collection, "cache.declarationByAnnotation[it]");
            Collection<FirAnnotatedDeclaration> collection2 = this.cache.getDeclarationsUnderAnnotated().get((FqName)it);
            Intrinsics.checkNotNullExpressionValue(collection2, "cache.declarationsUnderAnnotated[it]");
            Iterable list$iv$iv = CollectionsKt.plus(collection, (Iterable)collection2);
            CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
        }
        Iterable $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$flatMapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (FirAnnotatedDeclaration)element$iv$iv;
            boolean bl = false;
            Object object = it;
            Intrinsics.checkNotNullExpressionValue(object, "it");
            if (!this.matches(predicate, (FirAnnotatedDeclaration)object)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void registerAnnotatedDeclaration(@NotNull FirAnnotatedDeclaration declaration2, @NotNull PersistentList<? extends FirAnnotatedDeclaration> owners) {
        void $this$filterTo$iv$iv;
        Iterable $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter(declaration2, "declaration");
        Intrinsics.checkNotNullParameter(owners, "owners");
        this.cache.getOwnersForDeclaration().put(declaration2, owners);
        this.registerOwnersDeclarations(declaration2, owners);
        if (declaration2.getAnnotations().isEmpty()) {
            return;
        }
        Iterable $this$mapNotNull$iv = declaration2.getAnnotations();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        Iterator $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            FqName fqName2;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            FirAnnotationCall it = (FirAnnotationCall)element$iv$iv;
            boolean bl2 = false;
            if (ResolveUtilsKt.fqName(it, this.session) == null) continue;
            boolean bl3 = false;
            boolean bl4 = false;
            FqName it$iv$iv = fqName2;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Iterable $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$mapNotNullTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            FqName it = (FqName)element$iv$iv;
            boolean bl = false;
            if (!this.registeredPluginAnnotations.getAnnotations().contains(it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List matchingAnnotations = (List)destination$iv$iv;
        if (matchingAnnotations.isEmpty()) {
            return;
        }
        Iterable $this$forEach$iv = matchingAnnotations;
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv) {
            FqName it = (FqName)element$iv;
            boolean bl = false;
            this.cache.getDeclarationByAnnotation().put(it, declaration2);
        }
        this.cache.getAnnotationsOfDeclaration().putAll((Object)declaration2, (Iterable)matchingAnnotations);
    }

    private final void registerOwnersDeclarations(FirAnnotatedDeclaration declaration2, PersistentList<? extends FirAnnotatedDeclaration> owners) {
        FirAnnotatedDeclaration firAnnotatedDeclaration = (FirAnnotatedDeclaration)CollectionsKt.lastOrNull((List)owners);
        if (firAnnotatedDeclaration == null) {
            return;
        }
        FirAnnotatedDeclaration lastOwner = firAnnotatedDeclaration;
        Set annotationsFromLastOwner = this.cache.getAnnotationsOfDeclaration().get((Object)lastOwner);
        Set annotationsFromPreviousOwners = this.cache.getParentAnnotationsOfDeclaration().get((Object)lastOwner);
        Set set = annotationsFromLastOwner;
        Intrinsics.checkNotNullExpressionValue(set, "annotationsFromLastOwner");
        Set set2 = annotationsFromPreviousOwners;
        Intrinsics.checkNotNullExpressionValue(set2, "annotationsFromPreviousOwners");
        Set allParentDeclarations = SetsKt.plus(set, set2);
        Iterable $this$forEach$iv = allParentDeclarations;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            FqName it = (FqName)element$iv;
            boolean bl = false;
            this.cache.getDeclarationsUnderAnnotated().put(it, declaration2);
        }
        this.cache.getParentAnnotationsOfDeclaration().putAll((Object)declaration2, allParentDeclarations);
    }

    @Override
    public boolean matches(@NotNull DeclarationPredicate predicate, @NotNull FirAnnotatedDeclaration declaration2) {
        Intrinsics.checkNotNullParameter(predicate, "predicate");
        Intrinsics.checkNotNullParameter(declaration2, "declaration");
        return (Boolean)predicate.accept$resolve(this.matcher, declaration2);
    }

    public FirPredicateBasedProviderImpl(@NotNull FirSession session) {
        Intrinsics.checkNotNullParameter(session, "session");
        this.session = session;
        this.registeredPluginAnnotations = FirRegisteredPluginAnnotationsKt.getRegisteredPluginAnnotations(this.session);
        this.cache = new Cache();
        this.matcher = new Matcher();
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0005\u00a2\u0006\u0002\u0010\u0004J\"\u0010\f\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u00032\u0010\u0010\u000e\u001a\f\u0012\b\u0012\u00060\u0007j\u0002`\b0\u0006H\u0002J\"\u0010\u000f\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u00032\u0010\u0010\u000e\u001a\f\u0012\b\u0012\u00060\u0007j\u0002`\b0\u0006H\u0002J\u001d\u0010\u0010\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0003H\u0016\u00a2\u0006\u0002\u0010\u0014J\u001d\u0010\u0015\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u00162\u0006\u0010\u0013\u001a\u00020\u0003H\u0016\u00a2\u0006\u0002\u0010\u0017J\u001d\u0010\u0018\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u00192\u0006\u0010\u0013\u001a\u00020\u0003H\u0016\u00a2\u0006\u0002\u0010\u001aJ\u001d\u0010\u001b\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u001c2\u0006\u0010\u0013\u001a\u00020\u0003H\u0016\u00a2\u0006\u0002\u0010\u001dJ\u001d\u0010\u001e\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u001f2\u0006\u0010\u0013\u001a\u00020\u0003H\u0016\u00a2\u0006\u0002\u0010 J\u001d\u0010!\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\"2\u0006\u0010\u0013\u001a\u00020\u0003H\u0016\u00a2\u0006\u0002\u0010#J\u001d\u0010$\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020%2\u0006\u0010\u0013\u001a\u00020\u0003H\u0016\u00a2\u0006\u0002\u0010&J\u001d\u0010'\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020(2\u0006\u0010\u0013\u001a\u00020\u0003H\u0016\u00a2\u0006\u0002\u0010)R\"\u0010\u0005\u001a\f\u0012\b\u0012\u00060\u0007j\u0002`\b0\u0006*\u00020\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006*"}, d2={"Lorg/jetbrains/kotlin/fir/extensions/FirPredicateBasedProviderImpl$Matcher;", "Lorg/jetbrains/kotlin/fir/extensions/predicate/DeclarationPredicateVisitor;", "", "Lorg/jetbrains/kotlin/fir/declarations/FirAnnotatedDeclaration;", "(Lorg/jetbrains/kotlin/fir/extensions/FirPredicateBasedProviderImpl;)V", "userDefinedAnnotations", "", "Lorg/jetbrains/kotlin/name/FqName;", "Lorg/jetbrains/kotlin/fir/extensions/AnnotationFqn;", "Lorg/jetbrains/kotlin/fir/extensions/predicate/MetaAnnotated;", "getUserDefinedAnnotations", "(Lorg/jetbrains/kotlin/fir/extensions/predicate/MetaAnnotated;)Ljava/util/Set;", "matchUnder", "declaration", "annotations", "matchWith", "visitAnd", "predicate", "Lorg/jetbrains/kotlin/fir/extensions/predicate/DeclarationPredicate$And;", "data", "(Lorg/jetbrains/kotlin/fir/extensions/predicate/DeclarationPredicate$And;Lorg/jetbrains/kotlin/fir/declarations/FirAnnotatedDeclaration;)Ljava/lang/Boolean;", "visitAnnotatedWith", "Lorg/jetbrains/kotlin/fir/extensions/predicate/AnnotatedWith;", "(Lorg/jetbrains/kotlin/fir/extensions/predicate/AnnotatedWith;Lorg/jetbrains/kotlin/fir/declarations/FirAnnotatedDeclaration;)Ljava/lang/Boolean;", "visitAnnotatedWithMeta", "Lorg/jetbrains/kotlin/fir/extensions/predicate/AnnotatedWithMeta;", "(Lorg/jetbrains/kotlin/fir/extensions/predicate/AnnotatedWithMeta;Lorg/jetbrains/kotlin/fir/declarations/FirAnnotatedDeclaration;)Ljava/lang/Boolean;", "visitAny", "Lorg/jetbrains/kotlin/fir/extensions/predicate/DeclarationPredicate$Any;", "(Lorg/jetbrains/kotlin/fir/extensions/predicate/DeclarationPredicate$Any;Lorg/jetbrains/kotlin/fir/declarations/FirAnnotatedDeclaration;)Ljava/lang/Boolean;", "visitOr", "Lorg/jetbrains/kotlin/fir/extensions/predicate/DeclarationPredicate$Or;", "(Lorg/jetbrains/kotlin/fir/extensions/predicate/DeclarationPredicate$Or;Lorg/jetbrains/kotlin/fir/declarations/FirAnnotatedDeclaration;)Ljava/lang/Boolean;", "visitPredicate", "Lorg/jetbrains/kotlin/fir/extensions/predicate/DeclarationPredicate;", "(Lorg/jetbrains/kotlin/fir/extensions/predicate/DeclarationPredicate;Lorg/jetbrains/kotlin/fir/declarations/FirAnnotatedDeclaration;)Ljava/lang/Boolean;", "visitUnderAnnotatedWith", "Lorg/jetbrains/kotlin/fir/extensions/predicate/UnderAnnotatedWith;", "(Lorg/jetbrains/kotlin/fir/extensions/predicate/UnderAnnotatedWith;Lorg/jetbrains/kotlin/fir/declarations/FirAnnotatedDeclaration;)Ljava/lang/Boolean;", "visitUnderMetaAnnotated", "Lorg/jetbrains/kotlin/fir/extensions/predicate/UnderMetaAnnotated;", "(Lorg/jetbrains/kotlin/fir/extensions/predicate/UnderMetaAnnotated;Lorg/jetbrains/kotlin/fir/declarations/FirAnnotatedDeclaration;)Ljava/lang/Boolean;", "resolve"})
    private final class Matcher
    extends DeclarationPredicateVisitor<Boolean, FirAnnotatedDeclaration> {
        @Override
        @NotNull
        public Boolean visitPredicate(@NotNull DeclarationPredicate predicate, @NotNull FirAnnotatedDeclaration data2) {
            Intrinsics.checkNotNullParameter(predicate, "predicate");
            Intrinsics.checkNotNullParameter(data2, "data");
            throw (Throwable)new IllegalStateException("Should not be there");
        }

        @Override
        @NotNull
        public Boolean visitAny(@NotNull DeclarationPredicate.Any predicate, @NotNull FirAnnotatedDeclaration data2) {
            Intrinsics.checkNotNullParameter(predicate, "predicate");
            Intrinsics.checkNotNullParameter(data2, "data");
            return true;
        }

        @Override
        @NotNull
        public Boolean visitAnd(@NotNull DeclarationPredicate.And predicate, @NotNull FirAnnotatedDeclaration data2) {
            Intrinsics.checkNotNullParameter(predicate, "predicate");
            Intrinsics.checkNotNullParameter(data2, "data");
            return (Boolean)predicate.getA().accept$resolve(this, data2) != false && (Boolean)predicate.getB().accept$resolve(this, data2) != false;
        }

        @Override
        @NotNull
        public Boolean visitOr(@NotNull DeclarationPredicate.Or predicate, @NotNull FirAnnotatedDeclaration data2) {
            Intrinsics.checkNotNullParameter(predicate, "predicate");
            Intrinsics.checkNotNullParameter(data2, "data");
            return (Boolean)predicate.getA().accept$resolve(this, data2) != false || (Boolean)predicate.getB().accept$resolve(this, data2) != false;
        }

        @Override
        @NotNull
        public Boolean visitAnnotatedWith(@NotNull AnnotatedWith predicate, @NotNull FirAnnotatedDeclaration data2) {
            Intrinsics.checkNotNullParameter(predicate, "predicate");
            Intrinsics.checkNotNullParameter(data2, "data");
            return this.matchWith(data2, predicate.getAnnotations());
        }

        @Override
        @NotNull
        public Boolean visitUnderAnnotatedWith(@NotNull UnderAnnotatedWith predicate, @NotNull FirAnnotatedDeclaration data2) {
            Intrinsics.checkNotNullParameter(predicate, "predicate");
            Intrinsics.checkNotNullParameter(data2, "data");
            return this.matchUnder(data2, predicate.getAnnotations());
        }

        @Override
        @NotNull
        public Boolean visitAnnotatedWithMeta(@NotNull AnnotatedWithMeta predicate, @NotNull FirAnnotatedDeclaration data2) {
            Intrinsics.checkNotNullParameter(predicate, "predicate");
            Intrinsics.checkNotNullParameter(data2, "data");
            return this.matchWith(data2, this.getUserDefinedAnnotations(predicate));
        }

        @Override
        @NotNull
        public Boolean visitUnderMetaAnnotated(@NotNull UnderMetaAnnotated predicate, @NotNull FirAnnotatedDeclaration data2) {
            Intrinsics.checkNotNullParameter(predicate, "predicate");
            Intrinsics.checkNotNullParameter(data2, "data");
            return this.matchUnder(data2, this.getUserDefinedAnnotations(predicate));
        }

        /*
         * WARNING - void declaration
         */
        private final Set<FqName> getUserDefinedAnnotations(MetaAnnotated $this$userDefinedAnnotations) {
            void var3_4;
            void $this$flatMapTo$iv;
            Iterable iterable = $this$userDefinedAnnotations.getMetaAnnotations();
            boolean bl = false;
            Collection destination$iv = new LinkedHashSet();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv : $this$flatMapTo$iv) {
                FqName it = (FqName)element$iv;
                boolean bl2 = false;
                Iterable list$iv = FirPredicateBasedProviderImpl.this.registeredPluginAnnotations.getAnnotationsWithMetaAnnotation(it);
                CollectionsKt.addAll(destination$iv, list$iv);
            }
            return (Set)var3_4;
        }

        private final boolean matchWith(FirAnnotatedDeclaration declaration2, Set<FqName> annotations2) {
            boolean bl;
            block3: {
                Set set = FirPredicateBasedProviderImpl.this.cache.getAnnotationsOfDeclaration().get((Object)declaration2);
                Intrinsics.checkNotNullExpressionValue(set, "cache.annotationsOfDeclaration[declaration]");
                Iterable $this$any$iv = set;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        FqName it = (FqName)element$iv;
                        boolean bl2 = false;
                        if (!annotations2.contains(it)) continue;
                        bl = true;
                        break block3;
                    }
                    bl = false;
                }
            }
            return bl;
        }

        private final boolean matchUnder(FirAnnotatedDeclaration declaration2, Set<FqName> annotations2) {
            boolean bl;
            block3: {
                Set set = FirPredicateBasedProviderImpl.this.cache.getParentAnnotationsOfDeclaration().get((Object)declaration2);
                Intrinsics.checkNotNullExpressionValue(set, "cache.parentAnnotationsOfDeclaration[declaration]");
                Iterable $this$any$iv = set;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        FqName it = (FqName)element$iv;
                        boolean bl2 = false;
                        if (!annotations2.contains(it)) continue;
                        bl = true;
                        break block3;
                    }
                    bl = false;
                }
            }
            return bl;
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R!\u0010\u0003\u001a\u0012\u0012\u0004\u0012\u00020\u0005\u0012\b\u0012\u00060\u0006j\u0002`\u00070\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR!\u0010\n\u001a\u0012\u0012\b\u0012\u00060\u0006j\u0002`\u0007\u0012\u0004\u0012\u00020\u00050\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR!\u0010\u000e\u001a\u0012\u0012\b\u0012\u00060\u0006j\u0002`\u0007\u0012\u0004\u0012\u00020\u00050\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\rR#\u0010\u0010\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00120\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R!\u0010\u0015\u001a\u0012\u0012\u0004\u0012\u00020\u0005\u0012\b\u0012\u00060\u0006j\u0002`\u00070\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\t\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/fir/extensions/FirPredicateBasedProviderImpl$Cache;", "", "()V", "annotationsOfDeclaration", "Lcom/google/common/collect/LinkedHashMultimap;", "Lorg/jetbrains/kotlin/fir/declarations/FirAnnotatedDeclaration;", "Lorg/jetbrains/kotlin/name/FqName;", "Lorg/jetbrains/kotlin/fir/extensions/AnnotationFqn;", "getAnnotationsOfDeclaration", "()Lcom/google/common/collect/LinkedHashMultimap;", "declarationByAnnotation", "Lcom/google/common/collect/Multimap;", "getDeclarationByAnnotation", "()Lcom/google/common/collect/Multimap;", "declarationsUnderAnnotated", "getDeclarationsUnderAnnotated", "ownersForDeclaration", "", "Lkotlinx/collections/immutable/PersistentList;", "getOwnersForDeclaration", "()Ljava/util/Map;", "parentAnnotationsOfDeclaration", "getParentAnnotationsOfDeclaration", "resolve"})
    private static final class Cache {
        @NotNull
        private final Multimap<FqName, FirAnnotatedDeclaration> declarationByAnnotation;
        @NotNull
        private final LinkedHashMultimap<FirAnnotatedDeclaration, FqName> annotationsOfDeclaration;
        @NotNull
        private final Multimap<FqName, FirAnnotatedDeclaration> declarationsUnderAnnotated;
        @NotNull
        private final LinkedHashMultimap<FirAnnotatedDeclaration, FqName> parentAnnotationsOfDeclaration;
        @NotNull
        private final Map<FirAnnotatedDeclaration, PersistentList<FirAnnotatedDeclaration>> ownersForDeclaration;

        @NotNull
        public final Multimap<FqName, FirAnnotatedDeclaration> getDeclarationByAnnotation() {
            return this.declarationByAnnotation;
        }

        @NotNull
        public final LinkedHashMultimap<FirAnnotatedDeclaration, FqName> getAnnotationsOfDeclaration() {
            return this.annotationsOfDeclaration;
        }

        @NotNull
        public final Multimap<FqName, FirAnnotatedDeclaration> getDeclarationsUnderAnnotated() {
            return this.declarationsUnderAnnotated;
        }

        @NotNull
        public final LinkedHashMultimap<FirAnnotatedDeclaration, FqName> getParentAnnotationsOfDeclaration() {
            return this.parentAnnotationsOfDeclaration;
        }

        @NotNull
        public final Map<FirAnnotatedDeclaration, PersistentList<FirAnnotatedDeclaration>> getOwnersForDeclaration() {
            return this.ownersForDeclaration;
        }

        public Cache() {
            ArrayListMultimap arrayListMultimap = ArrayListMultimap.create();
            Intrinsics.checkNotNullExpressionValue(arrayListMultimap, "ArrayListMultimap.create()");
            this.declarationByAnnotation = arrayListMultimap;
            LinkedHashMultimap linkedHashMultimap = LinkedHashMultimap.create();
            Intrinsics.checkNotNullExpressionValue(linkedHashMultimap, "LinkedHashMultimap.create()");
            this.annotationsOfDeclaration = linkedHashMultimap;
            ArrayListMultimap arrayListMultimap2 = ArrayListMultimap.create();
            Intrinsics.checkNotNullExpressionValue(arrayListMultimap2, "ArrayListMultimap.create()");
            this.declarationsUnderAnnotated = arrayListMultimap2;
            LinkedHashMultimap linkedHashMultimap2 = LinkedHashMultimap.create();
            Intrinsics.checkNotNullExpressionValue(linkedHashMultimap2, "LinkedHashMultimap.create()");
            this.parentAnnotationsOfDeclaration = linkedHashMultimap2;
            boolean bl = false;
            this.ownersForDeclaration = new LinkedHashMap();
        }
    }
}

