/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.metadata;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analyzer.AnalysisResult;
import org.jetbrains.kotlin.cli.common.messages.AnalyzerWithCompilerReport;
import org.jetbrains.kotlin.cli.jvm.compiler.KotlinCoreEnvironment;
import org.jetbrains.kotlin.cli.metadata.CommonAnalysisKt;
import org.jetbrains.kotlin.cli.metadata.MetadataSerializerExtension;
import org.jetbrains.kotlin.codegen.JvmCodegenUtil;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.TypeAliasDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.load.kotlin.PackagePartClassUtils;
import org.jetbrains.kotlin.metadata.ProtoBuf;
import org.jetbrains.kotlin.metadata.builtins.BuiltInsBinaryVersion;
import org.jetbrains.kotlin.metadata.jvm.JvmModuleProtoBuf;
import org.jetbrains.kotlin.metadata.jvm.deserialization.JvmMetadataVersion;
import org.jetbrains.kotlin.metadata.jvm.deserialization.ModuleMappingKt;
import org.jetbrains.kotlin.metadata.jvm.deserialization.PackageParts;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtTypeAlias;
import org.jetbrains.kotlin.psi.KtVisitorVoid;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.scopes.DescriptorKindFilter;
import org.jetbrains.kotlin.resolve.scopes.ResolutionScope;
import org.jetbrains.kotlin.serialization.DescriptorSerializer;
import org.jetbrains.kotlin.serialization.KotlinSerializerExtensionBase;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001:\u0001(B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0010\u001a\u00020\u0011H\u0014J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0018\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0013H\u0002J.\u0010\u001a\u001a\u00020\u001b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001d2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$H\u0014J\u000e\u0010%\u001a\u00020\u001b2\u0006\u0010&\u001a\u00020'R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u00020\bX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\u00020\bX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\n\"\u0004\b\u000f\u0010\f\u00a8\u0006)"}, d2={"Lorg/jetbrains/kotlin/cli/metadata/MetadataSerializer;", "", "metadataVersion", "Lorg/jetbrains/kotlin/metadata/builtins/BuiltInsBinaryVersion;", "dependOnOldBuiltIns", "", "(Lorg/jetbrains/kotlin/metadata/builtins/BuiltInsBinaryVersion;Z)V", "totalFiles", "", "getTotalFiles", "()I", "setTotalFiles", "(I)V", "totalSize", "getTotalSize", "setTotalSize", "createSerializerExtension", "Lorg/jetbrains/kotlin/serialization/KotlinSerializerExtensionBase;", "getClassFilePath", "", "classId", "Lorg/jetbrains/kotlin/name/ClassId;", "getPackageFilePath", "packageFqName", "Lorg/jetbrains/kotlin/name/FqName;", "fileName", "performSerialization", "", "files", "", "Lorg/jetbrains/kotlin/psi/KtFile;", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "module", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "destDir", "Ljava/io/File;", "serialize", "environment", "Lorg/jetbrains/kotlin/cli/jvm/compiler/KotlinCoreEnvironment;", "PackageSerializer", "cli"})
public class MetadataSerializer {
    private int totalSize;
    private int totalFiles;
    private final BuiltInsBinaryVersion metadataVersion;
    private final boolean dependOnOldBuiltIns;

    protected final int getTotalSize() {
        return this.totalSize;
    }

    protected final void setTotalSize(int n) {
        this.totalSize = n;
    }

    protected final int getTotalFiles() {
        return this.totalFiles;
    }

    protected final void setTotalFiles(int n) {
        this.totalFiles = n;
    }

    /*
     * WARNING - void declaration
     */
    public final void serialize(@NotNull KotlinCoreEnvironment environment) {
        void bindingContext;
        Intrinsics.checkParameterIsNotNull(environment, "environment");
        AnalyzerWithCompilerReport analyzer2 = CommonAnalysisKt.runCommonAnalysisForSerialization(environment, this.dependOnOldBuiltIns, null);
        if (analyzer2 == null || analyzer2.hasErrors()) {
            return;
        }
        AnalysisResult analysisResult2 = analyzer2.getAnalysisResult();
        BindingContext bindingContext2 = analysisResult2.component1();
        ModuleDescriptor moduleDescriptor = analysisResult2.component2();
        File file2 = CommonAnalysisKt.getDestDir(environment);
        boolean bl = false;
        boolean bl2 = false;
        bl2 = false;
        boolean bl3 = false;
        if (file2 == null) {
            boolean bl4 = false;
            String string2 = "Required value was null.";
            throw (Throwable)new IllegalStateException(string2.toString());
        }
        File destDir = file2;
        this.performSerialization((Collection<? extends KtFile>)environment.getSourceFiles(), (BindingContext)bindingContext, moduleDescriptor, destDir);
    }

    protected void performSerialization(@NotNull Collection<? extends KtFile> files2, @NotNull BindingContext bindingContext, @NotNull ModuleDescriptor module2, @NotNull File destDir) {
        Intrinsics.checkParameterIsNotNull(files2, "files");
        Intrinsics.checkParameterIsNotNull(bindingContext, "bindingContext");
        Intrinsics.checkParameterIsNotNull(module2, "module");
        Intrinsics.checkParameterIsNotNull(destDir, "destDir");
        boolean bl = false;
        HashMap packageTable = new HashMap();
        for (KtFile ktFile : files2) {
            Object object;
            FqName packageFqName = ktFile.getPackageFqName();
            boolean bl2 = false;
            ArrayList members2 = new ArrayList();
            for (KtDeclaration declaration2 : ktFile.getDeclarations()) {
                declaration2.accept(new KtVisitorVoid(this, members2, bindingContext, destDir, packageFqName){
                    final /* synthetic */ MetadataSerializer this$0;
                    final /* synthetic */ ArrayList $members;
                    final /* synthetic */ BindingContext $bindingContext;
                    final /* synthetic */ File $destDir;
                    final /* synthetic */ FqName $packageFqName;

                    public void visitNamedFunction(@NotNull KtNamedFunction function2) {
                        Intrinsics.checkParameterIsNotNull(function2, "function");
                        SimpleFunctionDescriptor simpleFunctionDescriptor = (SimpleFunctionDescriptor)this.$bindingContext.get(BindingContext.FUNCTION, function2);
                        if (simpleFunctionDescriptor == null) {
                            String string2 = "No descriptor found for function " + function2.getFqName();
                            boolean bl = false;
                            throw (Throwable)new IllegalStateException(string2.toString());
                        }
                        this.$members.add(simpleFunctionDescriptor);
                    }

                    public void visitProperty(@NotNull KtProperty property2) {
                        Intrinsics.checkParameterIsNotNull(property2, "property");
                        VariableDescriptor variableDescriptor = (VariableDescriptor)this.$bindingContext.get(BindingContext.VARIABLE, property2);
                        if (variableDescriptor == null) {
                            String string2 = "No descriptor found for property " + property2.getFqName();
                            boolean bl = false;
                            throw (Throwable)new IllegalStateException(string2.toString());
                        }
                        this.$members.add(variableDescriptor);
                    }

                    public void visitTypeAlias(@NotNull KtTypeAlias typeAlias) {
                        Intrinsics.checkParameterIsNotNull(typeAlias, "typeAlias");
                        TypeAliasDescriptor typeAliasDescriptor = (TypeAliasDescriptor)this.$bindingContext.get(BindingContext.TYPE_ALIAS, typeAlias);
                        if (typeAliasDescriptor == null) {
                            String string2 = "No descriptor found for type alias " + typeAlias.getFqName();
                            boolean bl = false;
                            throw (Throwable)new IllegalStateException(string2.toString());
                        }
                        this.$members.add(typeAliasDescriptor);
                    }

                    public void visitClassOrObject(@NotNull KtClassOrObject classOrObject) {
                        ClassDescriptor classDescriptor2;
                        Intrinsics.checkParameterIsNotNull(classOrObject, "classOrObject");
                        ClassDescriptor classDescriptor3 = (ClassDescriptor)this.$bindingContext.get(BindingContext.CLASS, classOrObject);
                        if (classDescriptor3 == null) {
                            String string2 = "No descriptor found for class " + classOrObject.getFqName();
                            boolean bl = false;
                            throw (Throwable)new IllegalStateException(string2.toString());
                        }
                        ClassDescriptor classDescriptor4 = classDescriptor2 = classDescriptor3;
                        Intrinsics.checkExpressionValueIsNotNull(classDescriptor4, "classDescriptor");
                        File destFile = new File(this.$destDir, MetadataSerializer.access$getClassFilePath(this.this$0, new ClassId(this.$packageFqName, classDescriptor4.getName())));
                        this.this$0.new PackageSerializer((Collection<? extends DeclarationDescriptor>)CollectionsKt.listOf(classDescriptor2), (Collection<? extends DeclarationDescriptor>)CollectionsKt.emptyList(), this.$packageFqName, destFile).run();
                    }
                    {
                        this.this$0 = this$0;
                        this.$members = $captured_local_variable$1;
                        this.$bindingContext = $captured_local_variable$2;
                        this.$destDir = $captured_local_variable$3;
                        this.$packageFqName = $captured_local_variable$4;
                    }
                });
            }
            Collection declaration2 = members2;
            boolean bl3 = false;
            if (!(!declaration2.isEmpty())) continue;
            String string2 = ktFile.getName();
            Intrinsics.checkExpressionValueIsNotNull(string2, "file.name");
            File destFile = new File(destDir, this.getPackageFilePath(packageFqName, string2));
            new PackageSerializer(CollectionsKt.emptyList(), members2, packageFqName, destFile).run();
            Map $this$getOrPut$iv = packageTable;
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(packageFqName);
            if (value$iv == null) {
                boolean bl4 = false;
                String string3 = packageFqName.asString();
                Intrinsics.checkExpressionValueIsNotNull(string3, "packageFqName.asString()");
                PackageParts answer$iv = new PackageParts(string3);
                $this$getOrPut$iv.put(packageFqName, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            ((PackageParts)object).addMetadataPart(FilesKt.getNameWithoutExtension(destFile));
        }
        File file2 = new File(destDir, JvmCodegenUtil.getMappingFileName(JvmCodegenUtil.getModuleName(module2)));
        JvmModuleProtoBuf.Module.Builder builder = JvmModuleProtoBuf.Module.newBuilder();
        boolean bl5 = false;
        boolean bl6 = false;
        JvmModuleProtoBuf.Module.Builder $receiver = builder;
        boolean bl7 = false;
        for (PackageParts table : packageTable.values()) {
            JvmModuleProtoBuf.Module.Builder builder2 = $receiver;
            Intrinsics.checkExpressionValueIsNotNull(builder2, "this");
            table.addTo(builder2);
        }
        JvmModuleProtoBuf.Module module3 = builder.build();
        Intrinsics.checkExpressionValueIsNotNull(module3, "JvmModuleProtoBuf.Module\u2026      }\n        }.build()");
        byte[] packageTableBytes = ModuleMappingKt.serializeToByteArray(module3, JvmMetadataVersion.INSTANCE, 0);
        file2.getParentFile().mkdirs();
        FilesKt.writeBytes(file2, packageTableBytes);
    }

    @NotNull
    protected KotlinSerializerExtensionBase createSerializerExtension() {
        return new MetadataSerializerExtension(this.metadataVersion);
    }

    private final String getPackageFilePath(FqName packageFqName, String fileName) {
        StringBuilder stringBuilder2 = new StringBuilder();
        String string2 = packageFqName.asString();
        Intrinsics.checkExpressionValueIsNotNull(string2, "packageFqName.asString()");
        return stringBuilder2.append(StringsKt.replace$default(string2, '.', '/', false, 4, null)).append("/").append(PackagePartClassUtils.getFilePartShortName(fileName)).append(".kotlin_metadata").toString();
    }

    private final String getClassFilePath(ClassId classId) {
        StringBuilder stringBuilder2 = new StringBuilder();
        String string2 = classId.asSingleFqName().asString();
        Intrinsics.checkExpressionValueIsNotNull(string2, "classId.asSingleFqName().asString()");
        return stringBuilder2.append(StringsKt.replace$default(string2, '.', '/', false, 4, null)).append(".kotlin_metadata").toString();
    }

    public MetadataSerializer(@NotNull BuiltInsBinaryVersion metadataVersion, boolean dependOnOldBuiltIns) {
        Intrinsics.checkParameterIsNotNull(metadataVersion, "metadataVersion");
        this.metadataVersion = metadataVersion;
        this.dependOnOldBuiltIns = dependOnOldBuiltIns;
    }

    public static final /* synthetic */ String access$getClassFilePath(MetadataSerializer $this, ClassId classId) {
        return $this.getClassFilePath(classId);
    }

    @Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u0084\u0004\u0018\u00002\u00020\u0001B1\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0006\u0010\u0010\u001a\u00020\u0011J\b\u0010\u0012\u001a\u00020\u0011H\u0002J\u001e\u0010\u0013\u001a\u00020\u00112\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u001e\u0010\u0016\u001a\u00020\u00112\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\u0017\u001a\u00020\u0015H\u0002J\b\u0010\u0018\u001a\u00020\u0011H\u0002J\u0010\u0010\u0019\u001a\u00020\u00112\u0006\u0010\u001a\u001a\u00020\u001bH\u0002R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\r\u001a\n \u000f*\u0004\u0018\u00010\u000e0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/cli/metadata/MetadataSerializer$PackageSerializer;", "", "classes", "", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "members", "packageFqName", "Lorg/jetbrains/kotlin/name/FqName;", "destFile", "Ljava/io/File;", "(Lorg/jetbrains/kotlin/cli/metadata/MetadataSerializer;Ljava/util/Collection;Ljava/util/Collection;Lorg/jetbrains/kotlin/name/FqName;Ljava/io/File;)V", "extension", "Lorg/jetbrains/kotlin/serialization/KotlinSerializerExtensionBase;", "proto", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$PackageFragment$Builder;", "kotlin.jvm.PlatformType", "run", "", "serializeBuiltInsFile", "serializeClasses", "parentSerializer", "Lorg/jetbrains/kotlin/serialization/DescriptorSerializer;", "serializeMembers", "serializer", "serializeStringTable", "write", "stream", "Ljava/io/ByteArrayOutputStream;", "cli"})
    protected final class PackageSerializer {
        private final ProtoBuf.PackageFragment.Builder proto;
        private final KotlinSerializerExtensionBase extension;
        private final Collection<DeclarationDescriptor> classes;
        private final Collection<DeclarationDescriptor> members;
        private final FqName packageFqName;
        private final File destFile;

        public final void run() {
            DescriptorSerializer serializer2 = DescriptorSerializer.Companion.createTopLevel(this.extension);
            this.serializeClasses(this.classes, serializer2);
            this.serializeMembers(this.members, serializer2);
            this.serializeStringTable();
            this.serializeBuiltInsFile();
        }

        private final void serializeClasses(Collection<? extends DeclarationDescriptor> classes2, DescriptorSerializer parentSerializer) {
            for (DeclarationDescriptor declarationDescriptor : DescriptorSerializer.Companion.sort(classes2)) {
                if (!(declarationDescriptor instanceof ClassDescriptor) || ((ClassDescriptor)declarationDescriptor).getKind() == ClassKind.ENUM_ENTRY) continue;
                DescriptorSerializer serializer2 = DescriptorSerializer.Companion.create((ClassDescriptor)declarationDescriptor, this.extension, parentSerializer);
                this.serializeClasses(ResolutionScope.DefaultImpls.getContributedDescriptors$default(((ClassDescriptor)declarationDescriptor).getUnsubstitutedInnerClassesScope(), DescriptorKindFilter.CLASSIFIERS, null, 2, null), serializer2);
                this.proto.addClass_(serializer2.classProto((ClassDescriptor)declarationDescriptor).build());
            }
        }

        private final void serializeMembers(Collection<? extends DeclarationDescriptor> members2, DescriptorSerializer serializer2) {
            ProtoBuf.PackageFragment.Builder builder = this.proto;
            Intrinsics.checkExpressionValueIsNotNull(builder, "proto");
            builder.setPackage(serializer2.packagePartProto(this.packageFqName, members2).build());
        }

        /*
         * WARNING - void declaration
         */
        private final void serializeStringTable() {
            void strings2;
            Pair<ProtoBuf.StringTable, ProtoBuf.QualifiedNameTable> pair = this.extension.getStringTable().buildProto();
            ProtoBuf.StringTable stringTable = pair.component1();
            ProtoBuf.QualifiedNameTable qualifiedNames = pair.component2();
            ProtoBuf.PackageFragment.Builder builder = this.proto;
            Intrinsics.checkExpressionValueIsNotNull(builder, "proto");
            builder.setStrings((ProtoBuf.StringTable)strings2);
            ProtoBuf.PackageFragment.Builder builder2 = this.proto;
            Intrinsics.checkExpressionValueIsNotNull(builder2, "proto");
            builder2.setQualifiedNames(qualifiedNames);
        }

        private final void serializeBuiltInsFile() {
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(stream);
            boolean bl = false;
            boolean bl2 = false;
            DataOutputStream $receiver = dataOutputStream;
            boolean bl3 = false;
            int[] version = this.extension.getMetadataVersion().toArray();
            $receiver.writeInt(version.length);
            int[] $this$forEach$iv = version;
            boolean $i$f$forEach = false;
            int[] nArray = $this$forEach$iv;
            int n = nArray.length;
            for (int i = 0; i < n; ++i) {
                int element$iv;
                int it = element$iv = nArray[i];
                boolean bl4 = false;
                $receiver.writeInt(it);
            }
            this.proto.build().writeTo(stream);
            this.write(stream);
        }

        private final void write(ByteArrayOutputStream stream) {
            MetadataSerializer metadataSerializer = MetadataSerializer.this;
            metadataSerializer.setTotalSize(metadataSerializer.getTotalSize() + stream.size());
            MetadataSerializer metadataSerializer2 = MetadataSerializer.this;
            int n = metadataSerializer2.getTotalFiles();
            metadataSerializer2.setTotalFiles(n + 1);
            n = !this.destFile.isDirectory() ? 1 : 0;
            boolean bl = false;
            if (_Assertions.ENABLED && n == 0) {
                boolean bl2 = false;
                String string2 = "Cannot write because output destination is a directory: " + this.destFile;
                throw (Throwable)((Object)new AssertionError((Object)string2));
            }
            this.destFile.getParentFile().mkdirs();
            byte[] byArray = stream.toByteArray();
            Intrinsics.checkExpressionValueIsNotNull(byArray, "stream.toByteArray()");
            FilesKt.writeBytes(this.destFile, byArray);
        }

        public PackageSerializer(@NotNull Collection<? extends DeclarationDescriptor> classes2, @NotNull Collection<? extends DeclarationDescriptor> members2, @NotNull FqName packageFqName, File destFile) {
            Intrinsics.checkParameterIsNotNull(classes2, "classes");
            Intrinsics.checkParameterIsNotNull(members2, "members");
            Intrinsics.checkParameterIsNotNull(packageFqName, "packageFqName");
            Intrinsics.checkParameterIsNotNull(destFile, "destFile");
            this.classes = classes2;
            this.members = members2;
            this.packageFqName = packageFqName;
            this.destFile = destFile;
            this.proto = ProtoBuf.PackageFragment.newBuilder();
            this.extension = MetadataSerializer.this.createSerializerExtension();
        }
    }
}

