/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.messages.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionNotApplicableException;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.EventDispatcher;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.lang.CompoundRuntimeException;
import com.intellij.util.messages.LazyListenerCreator;
import com.intellij.util.messages.ListenerDescriptor;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.Topic;
import com.intellij.util.messages.impl.Message;
import com.intellij.util.messages.impl.MessageBusConnectionImpl;
import com.intellij.util.messages.impl.MessageDeliveryListener;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MessageBusImpl
implements MessageBus {
    private static final Logger LOG = Logger.getInstance("#com.intellij.util.messages.impl.MessageBusImpl");
    private static final Comparator<MessageBusImpl> MESSAGE_BUS_COMPARATOR = (bus1, bus2) -> ArrayUtil.lexicographicCompare(bus1.myOrder, bus2.myOrder);
    private final ThreadLocal<Queue<DeliveryJob>> myMessageQueue;
    private final int[] myOrder;
    private final ConcurrentMap<Topic<?>, Object> myPublishers;
    private final ConcurrentMap<Topic<?>, List<MessageBusConnectionImpl>> mySubscribers;
    private final Map<Topic<?>, List<MessageBusConnectionImpl>> mySubscriberCache;
    private final List<MessageBusImpl> myChildBuses;
    @NotNull
    private volatile Map<String, List<ListenerDescriptor>> myTopicClassToListenerClass;
    private static final Object NA = new Object();
    private MessageBusImpl myParentBus;
    private final RootBus myRootBus;
    private final Object myOwner;
    private boolean myDisposed;
    private final Disposable myConnectionDisposable;
    private MessageDeliveryListener myMessageDeliveryListener;
    private final MessageBusConnectionImpl myLazyConnection;

    private MessageBusImpl(@NotNull Object owner) {
        if (owner == null) {
            MessageBusImpl.$$$reportNull$$$0(2);
        }
        this.myMessageQueue = MessageBusImpl.createThreadLocalQueue();
        this.myPublishers = ContainerUtil.newConcurrentMap();
        this.mySubscribers = ContainerUtil.newConcurrentMap();
        this.mySubscriberCache = ContainerUtil.newConcurrentMap();
        this.myChildBuses = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myTopicClassToListenerClass = Collections.emptyMap();
        this.myOwner = owner;
        this.myConnectionDisposable = Disposer.newDisposable(this.myOwner.toString());
        this.myOrder = ArrayUtil.EMPTY_INT_ARRAY;
        this.myRootBus = (RootBus)this;
        this.myLazyConnection = this.connect();
    }

    public String toString() {
        return super.toString() + "; owner=" + this.myOwner + (this.myDisposed ? "; disposed" : "");
    }

    private void onChildBusDisposed(@NotNull MessageBusImpl childBus) {
        if (childBus == null) {
            MessageBusImpl.$$$reportNull$$$0(5);
        }
        boolean removed2 = this.myChildBuses.remove(childBus);
        Map map2 = (Map)this.myRootBus.myWaitingBuses.get();
        if (map2 != null) {
            map2.remove(childBus);
        }
        this.myRootBus.clearSubscriberCache();
        LOG.assertTrue(removed2);
    }

    @Override
    @NotNull
    public MessageBusConnectionImpl connect() {
        MessageBusConnectionImpl messageBusConnectionImpl = this.connect(this.myConnectionDisposable);
        if (messageBusConnectionImpl == null) {
            MessageBusImpl.$$$reportNull$$$0(6);
        }
        return messageBusConnectionImpl;
    }

    @Override
    @NotNull
    public MessageBusConnectionImpl connect(@NotNull Disposable parentDisposable) {
        if (parentDisposable == null) {
            MessageBusImpl.$$$reportNull$$$0(7);
        }
        this.checkNotDisposed();
        MessageBusConnectionImpl connection = new MessageBusConnectionImpl(this);
        Disposer.register(parentDisposable, connection);
        MessageBusConnectionImpl messageBusConnectionImpl = connection;
        if (messageBusConnectionImpl == null) {
            MessageBusImpl.$$$reportNull$$$0(8);
        }
        return messageBusConnectionImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    @NotNull
    public <L> L syncPublisher(@NotNull Topic<L> topic) {
        if (topic == null) {
            MessageBusImpl.$$$reportNull$$$0(9);
        }
        this.checkNotDisposed();
        Object publisher = this.myPublishers.get(topic);
        if (publisher != null) {
            Object v = publisher;
            if (v != null) return (L)v;
            MessageBusImpl.$$$reportNull$$$0(10);
            return (L)v;
        }
        Class<L> listenerClass = topic.getListenerClass();
        if (!this.myTopicClassToListenerClass.isEmpty()) {
            Topic<L> topic2 = topic;
            // MONITORENTER : topic2
            L l = this.subscribeLazyListeners(topic, listenerClass);
            // MONITOREXIT : topic2
            if (l != null) return l;
            MessageBusImpl.$$$reportNull$$$0(12);
            return l;
        }
        Object newInstance = Proxy.newProxyInstance(listenerClass.getClassLoader(), new Class[]{listenerClass}, this.createTopicHandler(topic));
        Object prev = this.myPublishers.putIfAbsent(topic, newInstance);
        Object object = prev == null ? newInstance : prev;
        if (object != null) return (L)object;
        MessageBusImpl.$$$reportNull$$$0(11);
        return (L)object;
    }

    @NotNull
    private <L> L subscribeLazyListeners(@NotNull Topic<L> topic, @NotNull Class<L> listenerClass) {
        Object publisher;
        if (topic == null) {
            MessageBusImpl.$$$reportNull$$$0(13);
        }
        if (listenerClass == null) {
            MessageBusImpl.$$$reportNull$$$0(14);
        }
        if ((publisher = this.myPublishers.get(topic)) != null) {
            Object v = publisher;
            if (v == null) {
                MessageBusImpl.$$$reportNull$$$0(15);
            }
            return (L)v;
        }
        List<ListenerDescriptor> listenerDescriptors = this.myTopicClassToListenerClass.remove(listenerClass.getName());
        if (listenerDescriptors != null) {
            LazyListenerCreator listenerCreator = (LazyListenerCreator)this.myOwner;
            ArrayList<Object> listeners = new ArrayList<Object>(listenerDescriptors.size());
            for (ListenerDescriptor listenerDescriptor : listenerDescriptors) {
                try {
                    listeners.add(listenerCreator.createListener(listenerDescriptor));
                }
                catch (ExtensionNotApplicableException extensionNotApplicableException) {
                }
                catch (ProcessCanceledException e) {
                    throw e;
                }
                catch (Throwable e) {
                    LOG.error("Cannot create listener", e);
                }
            }
            if (!listeners.isEmpty()) {
                this.myLazyConnection.subscribe(topic, (List<Object>)listeners);
            }
        }
        publisher = Proxy.newProxyInstance(listenerClass.getClassLoader(), new Class[]{listenerClass}, this.createTopicHandler(topic));
        this.myPublishers.put(topic, publisher);
        Object object = publisher;
        if (object == null) {
            MessageBusImpl.$$$reportNull$$$0(16);
        }
        return (L)object;
    }

    @NotNull
    private <L> InvocationHandler createTopicHandler(@NotNull Topic<L> topic) {
        if (topic == null) {
            MessageBusImpl.$$$reportNull$$$0(17);
        }
        InvocationHandler invocationHandler = (proxy2, method, args2) -> {
            if (method.getDeclaringClass().getName().equals("java.lang.Object")) {
                return EventDispatcher.handleObjectMethod(proxy2, args2, method.getName());
            }
            this.sendMessage(new Message(topic, method, args2));
            return NA;
        };
        if (invocationHandler == null) {
            MessageBusImpl.$$$reportNull$$$0(18);
        }
        return invocationHandler;
    }

    @Override
    public void dispose() {
        this.checkNotDisposed();
        this.myDisposed = true;
        for (MessageBusImpl childBus : this.myChildBuses) {
            Disposer.dispose(childBus);
        }
        Disposer.dispose(this.myConnectionDisposable);
        Queue<DeliveryJob> jobs = this.myMessageQueue.get();
        if (!jobs.isEmpty()) {
            LOG.error("Not delivered events in the queue: " + jobs);
        }
        this.myMessageQueue.remove();
        if (this.myParentBus != null) {
            this.myParentBus.onChildBusDisposed(this);
            this.myParentBus = null;
        } else {
            this.myRootBus.myWaitingBuses.remove();
        }
    }

    private void checkNotDisposed() {
        if (this.myDisposed) {
            LOG.error("Already disposed: " + this);
        }
    }

    private void calcSubscribers(@NotNull Topic<?> topic, @NotNull List<? super MessageBusConnectionImpl> result2) {
        Topic.BroadcastDirection direction;
        List topicSubscribers;
        if (topic == null) {
            MessageBusImpl.$$$reportNull$$$0(21);
        }
        if (result2 == null) {
            MessageBusImpl.$$$reportNull$$$0(22);
        }
        if ((topicSubscribers = (List)this.mySubscribers.get(topic)) != null) {
            result2.addAll(topicSubscribers);
        }
        if ((direction = topic.getBroadcastDirection()) == Topic.BroadcastDirection.TO_CHILDREN) {
            for (MessageBusImpl childBus : this.myChildBuses) {
                childBus.calcSubscribers(topic, result2);
            }
        }
        if (direction == Topic.BroadcastDirection.TO_PARENT && this.myParentBus != null) {
            this.myParentBus.calcSubscribers(topic, result2);
        }
    }

    private void postMessage(@NotNull Message message2) {
        if (message2 == null) {
            MessageBusImpl.$$$reportNull$$$0(23);
        }
        this.checkNotDisposed();
        List<MessageBusConnectionImpl> topicSubscribers = this.getTopicSubscribers(message2.getTopic());
        if (!topicSubscribers.isEmpty()) {
            for (MessageBusConnectionImpl subscriber : topicSubscribers) {
                subscriber.getBus().myMessageQueue.get().offer(new DeliveryJob(subscriber, message2));
                subscriber.getBus().notifyPendingJobChange(1);
                subscriber.scheduleMessageDelivery(message2);
            }
        }
    }

    @NotNull
    private List<MessageBusConnectionImpl> getTopicSubscribers(@NotNull Topic<?> topic) {
        List<MessageBusConnectionImpl> topicSubscribers;
        if (topic == null) {
            MessageBusImpl.$$$reportNull$$$0(24);
        }
        if ((topicSubscribers = this.mySubscriberCache.get(topic)) == null) {
            topicSubscribers = new ArrayList<MessageBusConnectionImpl>();
            this.calcSubscribers(topic, topicSubscribers);
            this.mySubscriberCache.put(topic, topicSubscribers);
            this.myRootBus.myClearedSubscribersCache = false;
        }
        List<MessageBusConnectionImpl> list2 = topicSubscribers;
        if (list2 == null) {
            MessageBusImpl.$$$reportNull$$$0(25);
        }
        return list2;
    }

    private void notifyPendingJobChange(int delta) {
        Integer countObject;
        int count;
        int newCount;
        ThreadLocal ref = this.myRootBus.myWaitingBuses;
        TreeMap<MessageBusImpl, Integer> map2 = (TreeMap<MessageBusImpl, Integer>)ref.get();
        if (map2 == null) {
            map2 = new TreeMap<MessageBusImpl, Integer>(MESSAGE_BUS_COMPARATOR);
            ref.set(map2);
        }
        if ((newCount = (count = (countObject = (Integer)map2.get(this)) == null ? 0 : countObject) + delta) > 0) {
            this.checkNotDisposed();
            map2.put(this, newCount);
        } else if (newCount == 0) {
            map2.remove(this);
        } else {
            LOG.error("Negative job count: " + this);
        }
    }

    private void sendMessage(@NotNull Message message2) {
        if (message2 == null) {
            MessageBusImpl.$$$reportNull$$$0(26);
        }
        this.pumpMessages();
        this.postMessage(message2);
        this.pumpMessages();
    }

    private void pumpMessages() {
        this.checkNotDisposed();
        Map map2 = (Map)this.myRootBus.myWaitingBuses.get();
        if (map2 != null && !map2.isEmpty()) {
            ArrayList<MessageBusImpl> liveBuses = new ArrayList<MessageBusImpl>(map2.size());
            for (MessageBusImpl bus : map2.keySet()) {
                if (!MessageBusImpl.ensureAlive(map2, bus)) continue;
                liveBuses.add(bus);
            }
            if (!liveBuses.isEmpty()) {
                MessageBusImpl.pumpWaitingBuses(liveBuses);
            }
        }
    }

    private static void pumpWaitingBuses(@NotNull List<? extends MessageBusImpl> buses) {
        if (buses == null) {
            MessageBusImpl.$$$reportNull$$$0(27);
        }
        List<Throwable> exceptions = null;
        for (MessageBusImpl messageBusImpl : buses) {
            if (messageBusImpl.myDisposed) continue;
            exceptions = MessageBusImpl.appendExceptions(exceptions, messageBusImpl.doPumpMessages());
        }
        MessageBusImpl.rethrowExceptions(exceptions);
    }

    private static List<Throwable> appendExceptions(@Nullable List<Throwable> exceptions, @NotNull List<? extends Throwable> busExceptions) {
        if (busExceptions == null) {
            MessageBusImpl.$$$reportNull$$$0(28);
        }
        if (!busExceptions.isEmpty()) {
            if (exceptions == null) {
                exceptions = new ArrayList<Throwable>(busExceptions.size());
            }
            exceptions.addAll(busExceptions);
        }
        return exceptions;
    }

    private static void rethrowExceptions(@Nullable List<? extends Throwable> exceptions) {
        if (exceptions == null) {
            return;
        }
        ProcessCanceledException pce = ContainerUtil.findInstance(exceptions, ProcessCanceledException.class);
        if (pce != null) {
            throw pce;
        }
        CompoundRuntimeException.throwIfNotEmpty(exceptions);
    }

    private static boolean ensureAlive(@NotNull Map<MessageBusImpl, Integer> map2, @NotNull MessageBusImpl bus) {
        if (map2 == null) {
            MessageBusImpl.$$$reportNull$$$0(29);
        }
        if (bus == null) {
            MessageBusImpl.$$$reportNull$$$0(30);
        }
        if (bus.myDisposed) {
            map2.remove(bus);
            LOG.error("Accessing disposed message bus " + bus);
            return false;
        }
        return true;
    }

    @NotNull
    private List<Throwable> doPumpMessages() {
        DeliveryJob job;
        Queue<DeliveryJob> queue = this.myMessageQueue.get();
        List<Throwable> exceptions = Collections.emptyList();
        while ((job = queue.poll()) != null) {
            this.notifyPendingJobChange(-1);
            try {
                job.connection.deliverMessage(job.message);
            }
            catch (Throwable e) {
                if (exceptions == Collections.emptyList()) {
                    exceptions = new ArrayList<Throwable>();
                }
                exceptions.add(e);
            }
        }
        List<Throwable> list2 = exceptions;
        if (list2 == null) {
            MessageBusImpl.$$$reportNull$$$0(31);
        }
        return list2;
    }

    void notifyOnSubscription(@NotNull MessageBusConnectionImpl connection, @NotNull Topic<?> topic) {
        if (connection == null) {
            MessageBusImpl.$$$reportNull$$$0(32);
        }
        if (topic == null) {
            MessageBusImpl.$$$reportNull$$$0(33);
        }
        this.checkNotDisposed();
        List topicSubscribers = (List)this.mySubscribers.get(topic);
        if (topicSubscribers == null) {
            topicSubscribers = ContainerUtil.createLockFreeCopyOnWriteList();
            topicSubscribers = ConcurrencyUtil.cacheOrGet(this.mySubscribers, topic, topicSubscribers);
        }
        topicSubscribers.add(connection);
        this.myRootBus.clearSubscriberCache();
    }

    void clearSubscriberCache() {
        this.mySubscriberCache.clear();
        for (MessageBusImpl bus : this.myChildBuses) {
            bus.clearSubscriberCache();
        }
    }

    void notifyConnectionTerminated(@NotNull MessageBusConnectionImpl connection) {
        if (connection == null) {
            MessageBusImpl.$$$reportNull$$$0(34);
        }
        for (List topicSubscribers : this.mySubscribers.values()) {
            topicSubscribers.remove(connection);
        }
        if (this.myDisposed) {
            return;
        }
        this.myRootBus.clearSubscriberCache();
        Iterator i = this.myMessageQueue.get().iterator();
        while (i.hasNext()) {
            DeliveryJob job = (DeliveryJob)i.next();
            if (job.connection != connection) continue;
            i.remove();
            this.notifyPendingJobChange(-1);
        }
    }

    void deliverSingleMessage() {
        this.checkNotDisposed();
        DeliveryJob job = this.myMessageQueue.get().poll();
        if (job == null) {
            return;
        }
        this.notifyPendingJobChange(-1);
        job.connection.deliverMessage(job.message);
    }

    @NotNull
    static <T> ThreadLocal<Queue<T>> createThreadLocalQueue() {
        ThreadLocal<Queue<T>> threadLocal = ThreadLocal.withInitial(ArrayDeque::new);
        if (threadLocal == null) {
            MessageBusImpl.$$$reportNull$$$0(35);
        }
        return threadLocal;
    }

    void invokeListener(@NotNull Message message2, Object handler2) throws IllegalAccessException, InvocationTargetException {
        if (message2 == null) {
            MessageBusImpl.$$$reportNull$$$0(36);
        }
        Method method = message2.getListenerMethod();
        MessageDeliveryListener listener = this.myMessageDeliveryListener;
        if (listener == null) {
            method.invoke(handler2, message2.getArgs());
            return;
        }
        long startTime = System.nanoTime();
        method.invoke(handler2, message2.getArgs());
        listener.messageDelivered(message2.getTopic(), method.getName(), handler2, System.nanoTime() - startTime);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 15: 
            case 16: 
            case 18: 
            case 20: 
            case 25: 
            case 31: 
            case 35: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 15: 
            case 16: 
            case 18: 
            case 20: 
            case 25: 
            case 31: 
            case 35: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentBus";
                break;
            }
            case 3: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 15: 
            case 16: 
            case 18: 
            case 20: 
            case 25: 
            case 31: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/messages/impl/MessageBusImpl";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childBus";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 9: 
            case 13: 
            case 17: 
            case 19: 
            case 21: 
            case 24: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "topic";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listenerClass";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 23: 
            case 26: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buses";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "busExceptions";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bus";
                break;
            }
            case 32: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/messages/impl/MessageBusImpl";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "nextOrder";
                break;
            }
            case 6: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "connect";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "syncPublisher";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "subscribeLazyListeners";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "createTopicHandler";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getOwner";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getTopicSubscribers";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "doPumpMessages";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "createThreadLocalQueue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setLazyListeners";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 15: 
            case 16: 
            case 18: 
            case 20: 
            case 25: 
            case 31: 
            case 35: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "onChildBusDisposed";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "connect";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "syncPublisher";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "subscribeLazyListeners";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "createTopicHandler";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "hasUndeliveredEvents";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "calcSubscribers";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "postMessage";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getTopicSubscribers";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "sendMessage";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "pumpWaitingBuses";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "appendExceptions";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "ensureAlive";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "notifyOnSubscription";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "notifyConnectionTerminated";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "invokeListener";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 15: 
            case 16: 
            case 18: 
            case 20: 
            case 25: 
            case 31: 
            case 35: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    static final class RootBus
    extends MessageBusImpl {
        private final ThreadLocal<SortedMap<MessageBusImpl, Integer>> myWaitingBuses;
        private volatile boolean myClearedSubscribersCache;

        @Override
        void clearSubscriberCache() {
            if (this.myClearedSubscribersCache) {
                return;
            }
            super.clearSubscriberCache();
            this.myClearedSubscribersCache = true;
        }

        RootBus(@NotNull Object owner) {
            if (owner == null) {
                RootBus.$$$reportNull$$$0(0);
            }
            super(owner);
            this.myWaitingBuses = new ThreadLocal();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/util/messages/impl/MessageBusImpl$RootBus", "<init>"));
        }
    }

    private static final class DeliveryJob {
        public final MessageBusConnectionImpl connection;
        public final Message message;

        DeliveryJob(@NotNull MessageBusConnectionImpl connection, @NotNull Message message2) {
            if (connection == null) {
                DeliveryJob.$$$reportNull$$$0(0);
            }
            if (message2 == null) {
                DeliveryJob.$$$reportNull$$$0(1);
            }
            this.connection = connection;
            this.message = message2;
        }

        @NonNls
        public String toString() {
            return "{ DJob connection:" + this.connection + "; message: " + this.message + " }";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "connection";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "message";
                    break;
                }
            }
            objectArray[1] = "com/intellij/util/messages/impl/MessageBusImpl$DeliveryJob";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

