/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.LinkedMultiMap;
import com.intellij.util.containers.SmartHashSet;
import gnu.trove.THashMap;
import gnu.trove.TObjectHashingStrategy;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Debug;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Debug.Renderer(text="\"size = \" + size()", hasChildren="!isEmpty()", childrenArray="entrySet().toArray()")
public class MultiMap<K, V>
implements Serializable {
    public static final MultiMap<?, ?> EMPTY = new EmptyMap();
    private static final long serialVersionUID = -2632269270151455493L;
    protected final Map<K, Collection<V>> myMap;

    public MultiMap() {
        this.myMap = this.createMap();
    }

    public MultiMap(@NotNull MultiMap<? extends K, ? extends V> toCopy) {
        if (toCopy == null) {
            MultiMap.$$$reportNull$$$0(0);
        }
        this();
        this.putAllValues(toCopy);
    }

    @NotNull
    public MultiMap<K, V> copy() {
        return new MultiMap<K, V>(this);
    }

    @NotNull
    protected Map<K, Collection<V>> createMap() {
        return new HashMap();
    }

    @NotNull
    protected Collection<V> createCollection() {
        return new SmartList();
    }

    @NotNull
    protected Collection<V> createEmptyCollection() {
        List list2 = Collections.emptyList();
        if (list2 == null) {
            MultiMap.$$$reportNull$$$0(1);
        }
        return list2;
    }

    public void putAllValues(@NotNull MultiMap<? extends K, ? extends V> from) {
        if (from == null) {
            MultiMap.$$$reportNull$$$0(2);
        }
        for (Map.Entry<K, Collection<V>> entry : from.entrySet()) {
            this.putValues(entry.getKey(), entry.getValue());
        }
    }

    public void putValues(K key, @NotNull Collection<? extends V> values2) {
        Collection<V> list2;
        if (values2 == null) {
            MultiMap.$$$reportNull$$$0(4);
        }
        if ((list2 = this.myMap.get(key)) == null) {
            list2 = this.createCollection();
            this.myMap.put(key, list2);
        }
        list2.addAll(values2);
    }

    public void putValue(@Nullable K key, V value2) {
        Collection<V> list2 = this.myMap.get(key);
        if (list2 == null) {
            list2 = this.createCollection();
            this.myMap.put(key, list2);
        }
        list2.add(value2);
    }

    @NotNull
    public Set<Map.Entry<K, Collection<V>>> entrySet() {
        Set<Map.Entry<K, Collection<V>>> set = this.myMap.entrySet();
        if (set == null) {
            MultiMap.$$$reportNull$$$0(5);
        }
        return set;
    }

    public boolean isEmpty() {
        if (this.myMap.isEmpty()) {
            return true;
        }
        for (Collection<V> valueList : this.myMap.values()) {
            if (valueList.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public boolean containsKey(K key) {
        return this.myMap.containsKey(key);
    }

    @NotNull
    public Collection<V> get(K key) {
        Collection<V> collection = this.myMap.get(key);
        Collection<V> collection2 = collection == null ? this.createEmptyCollection() : collection;
        if (collection2 == null) {
            MultiMap.$$$reportNull$$$0(6);
        }
        return collection2;
    }

    @NotNull
    public Set<K> keySet() {
        Set<K> set = this.myMap.keySet();
        if (set == null) {
            MultiMap.$$$reportNull$$$0(8);
        }
        return set;
    }

    public boolean remove(K key, V value2) {
        Collection<V> values2 = this.myMap.get(key);
        if (values2 != null) {
            boolean removed2 = values2.remove(value2);
            if (values2.isEmpty()) {
                this.myMap.remove(key);
            }
            return removed2;
        }
        return false;
    }

    @NotNull
    public static <K, V> MultiMap<K, V> create() {
        return new MultiMap<K, V>();
    }

    @NotNull
    public static <K, V> MultiMap<K, V> createLinked() {
        return new LinkedMultiMap();
    }

    @NotNull
    public static <K, V> MultiMap<K, V> createLinkedSet() {
        return new LinkedMultiMap<K, V>(){

            @Override
            @NotNull
            protected Collection<V> createCollection() {
                return new LinkedHashSet();
            }

            @Override
            @NotNull
            protected Collection<V> createEmptyCollection() {
                Set set = Collections.emptySet();
                if (set == null) {
                    3.$$$reportNull$$$0(0);
                }
                return set;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/MultiMap$3", "createEmptyCollection"));
            }
        };
    }

    @NotNull
    public static <K, V> MultiMap<K, V> createSet() {
        return MultiMap.createSet(ContainerUtil.canonicalStrategy());
    }

    @NotNull
    public static <K, V> MultiMap<K, V> createSet(final @NotNull TObjectHashingStrategy<K> strategy) {
        if (strategy == null) {
            MultiMap.$$$reportNull$$$0(12);
        }
        return new MultiMap<K, V>(){

            @Override
            @NotNull
            protected Collection<V> createCollection() {
                return new SmartHashSet();
            }

            @Override
            @NotNull
            protected Collection<V> createEmptyCollection() {
                Set set = Collections.emptySet();
                if (set == null) {
                    8.$$$reportNull$$$0(0);
                }
                return set;
            }

            @Override
            @NotNull
            protected Map<K, Collection<V>> createMap() {
                return new THashMap(strategy);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/MultiMap$8", "createEmptyCollection"));
            }
        };
    }

    public boolean equals(Object o) {
        return this == o || o instanceof MultiMap && this.myMap.equals(((MultiMap)o).myMap);
    }

    public int hashCode() {
        return this.myMap.hashCode();
    }

    public String toString() {
        return new HashMap<K, Collection<V>>(this.myMap).toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toCopy";
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/containers/MultiMap";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "values";
                break;
            }
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "strategy";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/containers/MultiMap";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createEmptyCollection";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "entrySet";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "get";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getModifiable";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "keySet";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "values";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "emptyInstance";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "putAllValues";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "putValues";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createSet";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private static class EmptyMap
    extends MultiMap<Object, Object> {
        private EmptyMap() {
        }

        @Override
        @NotNull
        protected Map<Object, Collection<Object>> createMap() {
            Map<Object, Collection<Object>> map2 = Collections.emptyMap();
            if (map2 == null) {
                EmptyMap.$$$reportNull$$$0(0);
            }
            return map2;
        }

        @Override
        public void putValues(Object key, @NotNull Collection values2) {
            if (values2 == null) {
                EmptyMap.$$$reportNull$$$0(1);
            }
            throw new UnsupportedOperationException();
        }

        @Override
        public void putValue(@Nullable Object key, Object value2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean remove(Object key, Object value2) {
            throw new UnsupportedOperationException();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string2;
            switch (n) {
                default: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/util/containers/MultiMap$EmptyMap";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "values";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createMap";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/util/containers/MultiMap$EmptyMap";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "putValues";
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

