/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.util.ArrayFactory;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ConcurrentIntKeyWeakValueHashMap;
import com.intellij.util.containers.ConcurrentIntObjectHashMap;
import com.intellij.util.containers.ConcurrentIntObjectMap;
import com.intellij.util.containers.ConcurrentList;
import com.intellij.util.containers.ConcurrentLongObjectHashMap;
import com.intellij.util.containers.ConcurrentLongObjectMap;
import com.intellij.util.containers.ConcurrentSoftHashMap;
import com.intellij.util.containers.ConcurrentSoftKeySoftValueHashMap;
import com.intellij.util.containers.ConcurrentSoftValueHashMap;
import com.intellij.util.containers.ConcurrentWeakHashMap;
import com.intellij.util.containers.ConcurrentWeakKeySoftValueHashMap;
import com.intellij.util.containers.ConcurrentWeakKeyWeakValueHashMap;
import com.intellij.util.containers.ConcurrentWeakValueHashMap;
import com.intellij.util.containers.ContainerUtilRt;
import com.intellij.util.containers.EmptyIterable;
import com.intellij.util.containers.FilteringIterator;
import com.intellij.util.containers.ImmutableList;
import com.intellij.util.containers.LockFreeCopyOnWriteArrayList;
import com.intellij.util.containers.SequenceIterator;
import com.intellij.util.containers.SoftHashMap;
import com.intellij.util.containers.WeakHashMap;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import gnu.trove.TIntIterator;
import gnu.trove.TObjectHashingStrategy;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Consumer;
import java.util.function.IntFunction;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ContainerUtil
extends ContainerUtilRt {
    @Deprecated
    @NotNull
    @Contract(pure=true)
    public static <K, V> HashMap<K, V> newHashMap() {
        return new HashMap();
    }

    @Deprecated
    @NotNull
    @Contract(pure=true)
    public static <K, V> THashMap<K, V> newTroveMap() {
        return new THashMap();
    }

    @NotNull
    @Contract(pure=true)
    public static <T> TObjectHashingStrategy<T> canonicalStrategy() {
        TObjectHashingStrategy tObjectHashingStrategy = TObjectHashingStrategy.CANONICAL;
        if (tObjectHashingStrategy == null) {
            ContainerUtil.$$$reportNull$$$0(16);
        }
        return tObjectHashingStrategy;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> TObjectHashingStrategy<T> identityStrategy() {
        TObjectHashingStrategy tObjectHashingStrategy = TObjectHashingStrategy.IDENTITY;
        if (tObjectHashingStrategy == null) {
            ContainerUtil.$$$reportNull$$$0(17);
        }
        return tObjectHashingStrategy;
    }

    @NotNull
    @Contract(pure=true)
    public static <K, V> IdentityHashMap<K, V> newIdentityHashMap() {
        return new IdentityHashMap();
    }

    @Deprecated
    @NotNull
    @Contract(pure=true)
    public static <T> ArrayList<T> newArrayList() {
        return new ArrayList();
    }

    @SafeVarargs
    @NotNull
    @Contract(pure=true)
    public static <E> ArrayList<E> newArrayList(E ... array) {
        if (array == null) {
            ContainerUtil.$$$reportNull$$$0(20);
        }
        return new ArrayList<E>(Arrays.asList(array));
    }

    @NotNull
    @Contract(pure=true)
    public static <E> ArrayList<E> newArrayList(@NotNull Iterable<? extends E> iterable) {
        if (iterable == null) {
            ContainerUtil.$$$reportNull$$$0(22);
        }
        ArrayList<? extends E> arrayList = ContainerUtilRt.newArrayList(iterable);
        if (arrayList == null) {
            ContainerUtil.$$$reportNull$$$0(23);
        }
        return arrayList;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> List<T> newArrayList(final @NotNull T[] elements, final int start, final int end) {
        if (elements == null) {
            ContainerUtil.$$$reportNull$$$0(24);
        }
        if (start < 0 || start > end || end > elements.length) {
            throw new IllegalArgumentException("start:" + start + " end:" + end + " length:" + elements.length);
        }
        return new AbstractList<T>(){
            private final int size;
            {
                this.size = end - start;
            }

            @Override
            public T get(int index2) {
                if (index2 < 0 || index2 >= this.size) {
                    throw new IndexOutOfBoundsException("index:" + index2 + " size:" + this.size);
                }
                return elements[start + index2];
            }

            @Override
            public int size() {
                return this.size;
            }
        };
    }

    @Deprecated
    @NotNull
    public static <T> List<T> newSmartList() {
        return new SmartList();
    }

    @SafeVarargs
    @NotNull
    @Contract(pure=true)
    public static <T> HashSet<T> newHashSet(T ... elements) {
        if (elements == null) {
            ContainerUtil.$$$reportNull$$$0(39);
        }
        return new HashSet<T>(Arrays.asList(elements));
    }

    @NotNull
    @Contract(pure=true)
    public static <T> LinkedHashSet<T> newLinkedHashSet(@NotNull Iterable<? extends T> elements) {
        if (elements == null) {
            ContainerUtil.$$$reportNull$$$0(46);
        }
        LinkedHashSet linkedHashSet = ContainerUtil.copy(new LinkedHashSet(), elements);
        if (linkedHashSet == null) {
            ContainerUtil.$$$reportNull$$$0(47);
        }
        return linkedHashSet;
    }

    @SafeVarargs
    @NotNull
    @Contract(pure=true)
    public static <T> THashSet<T> newTroveSet(T ... elements) {
        if (elements == null) {
            ContainerUtil.$$$reportNull$$$0(51);
        }
        return new THashSet<T>(Arrays.asList(elements));
    }

    @SafeVarargs
    @NotNull
    @Contract(pure=true)
    public static <T> THashSet<T> newTroveSet(@NotNull TObjectHashingStrategy<T> strategy, T ... elements) {
        if (strategy == null) {
            ContainerUtil.$$$reportNull$$$0(52);
        }
        if (elements == null) {
            ContainerUtil.$$$reportNull$$$0(53);
        }
        return new THashSet<T>(Arrays.asList(elements), strategy);
    }

    @NotNull
    @Contract(pure=true)
    public static <K> THashSet<K> newIdentityTroveSet() {
        return new THashSet(ContainerUtil.identityStrategy());
    }

    @NotNull
    @Contract(pure=true)
    public static <K> THashSet<K> newIdentityTroveSet(int initialCapacity) {
        return new THashSet(initialCapacity, ContainerUtil.identityStrategy());
    }

    @NotNull
    @Contract(pure=true)
    public static <K> THashSet<K> newIdentityTroveSet(@NotNull Collection<? extends K> collection) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(57);
        }
        return new THashSet<K>(collection, ContainerUtil.identityStrategy());
    }

    @NotNull
    @Contract(pure=true)
    public static <K, V> THashMap<K, V> newIdentityTroveMap() {
        return new THashMap(ContainerUtil.identityStrategy());
    }

    @NotNull
    @Contract(pure=true)
    public static <T> Set<T> newConcurrentSet() {
        Set set = Collections.newSetFromMap(ContainerUtil.newConcurrentMap());
        if (set == null) {
            ContainerUtil.$$$reportNull$$$0(58);
        }
        return set;
    }

    @NotNull
    @Contract(pure=true)
    public static <K, V> ConcurrentMap<K, V> newConcurrentMap() {
        return new ConcurrentHashMap();
    }

    @Contract(pure=true)
    public static <K, V> ConcurrentMap<K, V> newConcurrentMap(int initialCapacity) {
        return new ConcurrentHashMap(initialCapacity);
    }

    @Contract(pure=true)
    public static <K, V> ConcurrentMap<K, V> newConcurrentMap(int initialCapacity, float loadFactor, int concurrencyLevel) {
        return new ConcurrentHashMap(initialCapacity, loadFactor, concurrencyLevel);
    }

    @NotNull
    @Contract(pure=true)
    public static <E> List<E> reverse(final @NotNull List<? extends E> elements) {
        if (elements == null) {
            ContainerUtil.$$$reportNull$$$0(59);
        }
        if (elements.isEmpty()) {
            return ContainerUtil.emptyList();
        }
        return new AbstractList<E>(){

            @Override
            public E get(int index2) {
                return elements.get(elements.size() - 1 - index2);
            }

            @Override
            public int size() {
                return elements.size();
            }
        };
    }

    @NotNull
    @Contract(pure=true)
    public static <T> Set<T> union(@NotNull Collection<? extends T> set, @NotNull Collection<? extends T> set2) {
        if (set == null) {
            ContainerUtil.$$$reportNull$$$0(65);
        }
        if (set2 == null) {
            ContainerUtil.$$$reportNull$$$0(66);
        }
        THashSet<T> result2 = new THashSet<T>(set.size() + set2.size());
        result2.addAll(set);
        result2.addAll(set2);
        THashSet<T> tHashSet = result2;
        if (tHashSet == null) {
            ContainerUtil.$$$reportNull$$$0(67);
        }
        return tHashSet;
    }

    @SafeVarargs
    @NotNull
    @Contract(pure=true)
    public static <E> Set<E> immutableSet(E ... elements) {
        if (elements == null) {
            ContainerUtil.$$$reportNull$$$0(68);
        }
        switch (elements.length) {
            case 0: {
                Set set = Collections.emptySet();
                if (set == null) {
                    ContainerUtil.$$$reportNull$$$0(69);
                }
                return set;
            }
            case 1: {
                Set<E> set = Collections.singleton(elements[0]);
                if (set == null) {
                    ContainerUtil.$$$reportNull$$$0(70);
                }
                return set;
            }
        }
        Set<E> set = Collections.unmodifiableSet(ContainerUtil.newTroveSet(elements));
        if (set == null) {
            ContainerUtil.$$$reportNull$$$0(71);
        }
        return set;
    }

    @SafeVarargs
    @NotNull
    @Contract(pure=true)
    public static <E> ImmutableList<E> immutableList(E ... array) {
        if (array == null) {
            ContainerUtil.$$$reportNull$$$0(72);
        }
        return new ImmutableListBackedByArray(array);
    }

    @NotNull
    @Contract(pure=true)
    public static <E> ImmutableList<E> immutableSingletonList(E element) {
        ImmutableList<E> immutableList = ImmutableList.singleton(element);
        if (immutableList == null) {
            ContainerUtil.$$$reportNull$$$0(73);
        }
        return immutableList;
    }

    @NotNull
    @Contract(pure=true)
    public static <U> Iterator<U> mapIterator(final @NotNull TIntIterator iterator2, final @NotNull IntFunction<? extends U> mapper) {
        if (iterator2 == null) {
            ContainerUtil.$$$reportNull$$$0(79);
        }
        if (mapper == null) {
            ContainerUtil.$$$reportNull$$$0(80);
        }
        return new Iterator<U>(){

            @Override
            public boolean hasNext() {
                return iterator2.hasNext();
            }

            @Override
            public U next() {
                return mapper.apply(iterator2.next());
            }

            @Override
            public void remove() {
                iterator2.remove();
            }
        };
    }

    public static <T> void addAll(@NotNull Collection<? super T> collection, @NotNull Iterator<? extends T> iterator2) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(101);
        }
        if (iterator2 == null) {
            ContainerUtil.$$$reportNull$$$0(102);
        }
        while (iterator2.hasNext()) {
            T o = iterator2.next();
            collection.add(o);
        }
    }

    public static <T> void addAllNotNull(@NotNull Collection<? super T> collection, @NotNull Iterable<? extends T> elements) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(103);
        }
        if (elements == null) {
            ContainerUtil.$$$reportNull$$$0(104);
        }
        ContainerUtil.addAllNotNull(collection, elements.iterator());
    }

    public static <T> void addAllNotNull(@NotNull Collection<? super T> collection, @NotNull Iterator<? extends T> elements) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(105);
        }
        if (elements == null) {
            ContainerUtil.$$$reportNull$$$0(106);
        }
        while (elements.hasNext()) {
            T o = elements.next();
            if (o == null) continue;
            collection.add(o);
        }
    }

    @NotNull
    @Contract(pure=true)
    public static <T> Iterable<T> emptyIterable() {
        EmptyIterable emptyIterable = EmptyIterable.getInstance();
        if (emptyIterable == null) {
            ContainerUtil.$$$reportNull$$$0(122);
        }
        return emptyIterable;
    }

    @Contract(pure=true)
    public static <T> T find(@NotNull T[] array, @NotNull Condition<? super T> condition) {
        if (array == null) {
            ContainerUtil.$$$reportNull$$$0(123);
        }
        if (condition == null) {
            ContainerUtil.$$$reportNull$$$0(124);
        }
        for (T element : array) {
            if (!condition.value(element)) continue;
            return element;
        }
        return null;
    }

    public static <T> boolean process(@NotNull Iterable<? extends T> iterable, @NotNull Processor<? super T> processor2) {
        if (iterable == null) {
            ContainerUtil.$$$reportNull$$$0(125);
        }
        if (processor2 == null) {
            ContainerUtil.$$$reportNull$$$0(126);
        }
        for (T t : iterable) {
            if (processor2.process(t)) continue;
            return false;
        }
        return true;
    }

    public static <T> boolean process(@NotNull List<? extends T> list2, @NotNull Processor<? super T> processor2) {
        if (list2 == null) {
            ContainerUtil.$$$reportNull$$$0(127);
        }
        if (processor2 == null) {
            ContainerUtil.$$$reportNull$$$0(128);
        }
        int size = list2.size();
        for (int i = 0; i < size; ++i) {
            T t = list2.get(i);
            if (processor2.process(t)) continue;
            return false;
        }
        return true;
    }

    public static <T> boolean process(@NotNull T[] iterable, @NotNull Processor<? super T> processor2) {
        if (iterable == null) {
            ContainerUtil.$$$reportNull$$$0(129);
        }
        if (processor2 == null) {
            ContainerUtil.$$$reportNull$$$0(130);
        }
        for (T t : iterable) {
            if (processor2.process(t)) continue;
            return false;
        }
        return true;
    }

    @Contract(pure=true)
    public static <T> T find(@NotNull Iterable<? extends T> iterable, @NotNull Condition<? super T> condition) {
        if (iterable == null) {
            ContainerUtil.$$$reportNull$$$0(133);
        }
        if (condition == null) {
            ContainerUtil.$$$reportNull$$$0(134);
        }
        return ContainerUtil.find(iterable.iterator(), condition);
    }

    public static <T> T find(@NotNull Iterator<? extends T> iterator2, @NotNull Condition<? super T> condition) {
        if (iterator2 == null) {
            ContainerUtil.$$$reportNull$$$0(139);
        }
        if (condition == null) {
            ContainerUtil.$$$reportNull$$$0(140);
        }
        while (iterator2.hasNext()) {
            T value2 = iterator2.next();
            if (!condition.value(value2)) continue;
            return value2;
        }
        return null;
    }

    @NotNull
    @Contract(pure=true)
    public static <T, V> V[] map2Array(@NotNull T[] array, @NotNull Class<V> aClass2, @NotNull Function<? super T, ? extends V> mapper) {
        if (array == null) {
            ContainerUtil.$$$reportNull$$$0(159);
        }
        if (aClass2 == null) {
            ContainerUtil.$$$reportNull$$$0(160);
        }
        if (mapper == null) {
            ContainerUtil.$$$reportNull$$$0(161);
        }
        V[] result2 = ArrayUtil.newArray(aClass2, array.length);
        for (int i = 0; i < array.length; ++i) {
            result2[i] = mapper.fun(array[i]);
        }
        if (result2 == null) {
            ContainerUtil.$$$reportNull$$$0(162);
        }
        return result2;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> List<T> filter(@NotNull T[] collection, @NotNull Condition<? super T> condition) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(171);
        }
        if (condition == null) {
            ContainerUtil.$$$reportNull$$$0(172);
        }
        return ContainerUtil.findAll(collection, condition);
    }

    @NotNull
    @Contract(pure=true)
    public static <T> List<T> findAll(@NotNull T[] collection, @NotNull Condition<? super T> condition) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(176);
        }
        if (condition == null) {
            ContainerUtil.$$$reportNull$$$0(177);
        }
        SmartList<T> result2 = new SmartList<T>();
        for (T t : collection) {
            if (!condition.value(t)) continue;
            result2.add(t);
        }
        SmartList<T> smartList = result2;
        if (smartList == null) {
            ContainerUtil.$$$reportNull$$$0(178);
        }
        return smartList;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> List<T> filter(@NotNull Collection<? extends T> collection, @NotNull Condition<? super T> condition) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(181);
        }
        if (condition == null) {
            ContainerUtil.$$$reportNull$$$0(182);
        }
        return ContainerUtil.findAll(collection, condition);
    }

    @NotNull
    @Contract(pure=true)
    public static <T> List<T> findAll(@NotNull Collection<? extends T> collection, @NotNull Condition<? super T> condition) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(186);
        }
        if (condition == null) {
            ContainerUtil.$$$reportNull$$$0(187);
        }
        if (collection.isEmpty()) {
            return ContainerUtil.emptyList();
        }
        SmartList<T> result2 = new SmartList<T>();
        for (T t : collection) {
            if (!condition.value(t)) continue;
            result2.add(t);
        }
        SmartList<T> smartList = result2;
        if (smartList == null) {
            ContainerUtil.$$$reportNull$$$0(188);
        }
        return smartList;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> List<T> skipNulls(@NotNull Collection<? extends T> collection) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(189);
        }
        return ContainerUtil.findAll(collection, Conditions.notNull());
    }

    @NotNull
    @Contract(pure=true)
    public static <T> Iterable<T> iterate(@NotNull T[] arrays, @NotNull Condition<? super T> condition) {
        if (arrays == null) {
            ContainerUtil.$$$reportNull$$$0(213);
        }
        if (condition == null) {
            ContainerUtil.$$$reportNull$$$0(214);
        }
        return ContainerUtil.iterate(Arrays.asList(arrays), condition);
    }

    @NotNull
    @Contract(pure=true)
    public static <T> Iterable<T> iterate(final @NotNull Collection<? extends T> collection, final @NotNull Condition<? super T> condition) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(215);
        }
        if (condition == null) {
            ContainerUtil.$$$reportNull$$$0(216);
        }
        if (collection.isEmpty()) {
            return ContainerUtil.emptyIterable();
        }
        Iterable iterable = () -> new Iterator<T>(){
            private final Iterator impl;
            private Object next;
            {
                this.impl = collection.iterator();
                this.next = this.findNext();
            }

            @Override
            public boolean hasNext() {
                return this.next != null;
            }

            @Override
            public T next() {
                Object result2 = this.next;
                this.next = this.findNext();
                return result2;
            }

            @Nullable
            private T findNext() {
                while (this.impl.hasNext()) {
                    Object each = this.impl.next();
                    if (!condition.value(each)) continue;
                    return each;
                }
                return null;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
        if (iterable == null) {
            ContainerUtil.$$$reportNull$$$0(217);
        }
        return iterable;
    }

    public static <E> void swapElements(@NotNull List<E> list2, int index1, int index2) {
        if (list2 == null) {
            ContainerUtil.$$$reportNull$$$0(223);
        }
        E e1 = list2.get(index1);
        E e2 = list2.get(index2);
        list2.set(index1, e2);
        list2.set(index2, e1);
    }

    @SafeVarargs
    @NotNull
    public static <T, C extends Collection<? super T>> C addAll(@NotNull C collection, T ... elements) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(228);
        }
        if (elements == null) {
            ContainerUtil.$$$reportNull$$$0(229);
        }
        for (T element : elements) {
            collection.add(element);
        }
        C c = collection;
        if (c == null) {
            ContainerUtil.$$$reportNull$$$0(230);
        }
        return c;
    }

    @SafeVarargs
    @NotNull
    public static <T, C extends Collection<T>> C addAllNotNull(@NotNull C collection, T ... elements) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(231);
        }
        if (elements == null) {
            ContainerUtil.$$$reportNull$$$0(232);
        }
        for (T element : elements) {
            if (element == null) continue;
            collection.add(element);
        }
        C c = collection;
        if (c == null) {
            ContainerUtil.$$$reportNull$$$0(233);
        }
        return c;
    }

    @Contract(pure=true)
    public static <T, U extends T> U findInstance(@NotNull Iterable<? extends T> iterable, @NotNull Class<? extends U> aClass2) {
        if (iterable == null) {
            ContainerUtil.$$$reportNull$$$0(238);
        }
        if (aClass2 == null) {
            ContainerUtil.$$$reportNull$$$0(239);
        }
        return ContainerUtil.findInstance(iterable.iterator(), aClass2);
    }

    public static <T, U extends T> U findInstance(@NotNull Iterator<? extends T> iterator2, @NotNull Class<? extends U> aClass2) {
        if (iterator2 == null) {
            ContainerUtil.$$$reportNull$$$0(240);
        }
        if (aClass2 == null) {
            ContainerUtil.$$$reportNull$$$0(241);
        }
        return (U)ContainerUtil.find(iterator2, FilteringIterator.instanceOf(aClass2));
    }

    @Contract(pure=true)
    public static <T, U extends T> U findInstance(@NotNull T[] array, @NotNull Class<? extends U> aClass2) {
        if (array == null) {
            ContainerUtil.$$$reportNull$$$0(242);
        }
        if (aClass2 == null) {
            ContainerUtil.$$$reportNull$$$0(243);
        }
        return ContainerUtil.findInstance(Arrays.asList(array), aClass2);
    }

    @NotNull
    @Contract(pure=true)
    public static <T, V> List<T> concat(@NotNull V[] array, @NotNull Function<? super V, ? extends Collection<? extends T>> fun) {
        if (array == null) {
            ContainerUtil.$$$reportNull$$$0(244);
        }
        if (fun == null) {
            ContainerUtil.$$$reportNull$$$0(245);
        }
        return ContainerUtil.concat(Arrays.asList(array), fun);
    }

    @NotNull
    @Contract(pure=true)
    public static <T> List<T> concat(final @NotNull List<? extends T> list1, final @NotNull List<? extends T> list2) {
        if (list1 == null) {
            ContainerUtil.$$$reportNull$$$0(252);
        }
        if (list2 == null) {
            ContainerUtil.$$$reportNull$$$0(253);
        }
        if (list1.isEmpty() && list2.isEmpty()) {
            List list3 = Collections.emptyList();
            if (list3 == null) {
                ContainerUtil.$$$reportNull$$$0(254);
            }
            return list3;
        }
        if (list1.isEmpty()) {
            List<T> list4 = list2;
            if (list4 == null) {
                ContainerUtil.$$$reportNull$$$0(255);
            }
            return list4;
        }
        if (list2.isEmpty()) {
            List<T> list5 = list1;
            if (list5 == null) {
                ContainerUtil.$$$reportNull$$$0(256);
            }
            return list5;
        }
        final int size1 = list1.size();
        final int size = size1 + list2.size();
        return new AbstractList<T>(){

            @Override
            public T get(int index2) {
                if (index2 < size1) {
                    return list1.get(index2);
                }
                return list2.get(index2 - size1);
            }

            @Override
            public int size() {
                return size;
            }
        };
    }

    @NotNull
    @Contract(pure=true)
    public static <T> Iterable<T> concat(final @NotNull Iterable<? extends T> it1, final @NotNull Iterable<? extends T> it2) {
        if (it1 == null) {
            ContainerUtil.$$$reportNull$$$0(257);
        }
        if (it2 == null) {
            ContainerUtil.$$$reportNull$$$0(258);
        }
        return new Iterable<T>(){

            @Override
            public void forEach(Consumer<? super T> action) {
                it1.forEach(action);
                it2.forEach(action);
            }

            @Override
            @NotNull
            public Iterator<T> iterator() {
                return new Iterator<T>(){
                    Iterator<? extends T> it;
                    boolean firstFinished;
                    {
                        this.it = it1.iterator();
                        this.advance();
                    }

                    @Override
                    public boolean hasNext() {
                        return !this.firstFinished || this.it.hasNext();
                    }

                    @Override
                    public T next() {
                        Object value2 = this.it.next();
                        this.advance();
                        return value2;
                    }

                    private void advance() {
                        if (!this.firstFinished && !this.it.hasNext()) {
                            this.it = it2.iterator();
                            this.firstFinished = true;
                        }
                    }
                };
            }
        };
    }

    @SafeVarargs
    @NotNull
    @Contract(pure=true)
    public static <T> Iterator<T> concatIterators(Iterator<? extends T> ... iterators) {
        if (iterators == null) {
            ContainerUtil.$$$reportNull$$$0(262);
        }
        return new SequenceIterator<T>(iterators);
    }

    @NotNull
    @Contract(pure=true)
    public static <T, V> List<V> concat(@NotNull Iterable<? extends T> list2, @NotNull Function<? super T, ? extends Collection<? extends V>> listGenerator) {
        if (list2 == null) {
            ContainerUtil.$$$reportNull$$$0(268);
        }
        if (listGenerator == null) {
            ContainerUtil.$$$reportNull$$$0(269);
        }
        ArrayList<T> result2 = new ArrayList<T>();
        for (T v : list2) {
            result2.addAll(listGenerator.fun(v));
        }
        List<T> list3 = result2.isEmpty() ? ContainerUtil.emptyList() : result2;
        if (list3 == null) {
            ContainerUtil.$$$reportNull$$$0(270);
        }
        return list3;
    }

    @Contract(pure=true)
    public static <T> boolean intersects(@NotNull Collection<? extends T> collection1, @NotNull Collection<? extends T> collection2) {
        if (collection1 == null) {
            ContainerUtil.$$$reportNull$$$0(271);
        }
        if (collection2 == null) {
            ContainerUtil.$$$reportNull$$$0(272);
        }
        if (collection1.size() <= collection2.size()) {
            for (T t : collection1) {
                if (!collection2.contains(t)) continue;
                return true;
            }
        } else {
            for (T t : collection2) {
                if (!collection1.contains(t)) continue;
                return true;
            }
        }
        return false;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> Collection<T> intersection(@NotNull Collection<? extends T> collection1, @NotNull Collection<? extends T> collection2) {
        if (collection1 == null) {
            ContainerUtil.$$$reportNull$$$0(273);
        }
        if (collection2 == null) {
            ContainerUtil.$$$reportNull$$$0(274);
        }
        ArrayList<T> result2 = new ArrayList<T>();
        for (T t : collection1) {
            if (!collection2.contains(t)) continue;
            result2.add(t);
        }
        List<T> list2 = result2.isEmpty() ? ContainerUtil.emptyList() : result2;
        if (list2 == null) {
            ContainerUtil.$$$reportNull$$$0(275);
        }
        return list2;
    }

    @Contract(pure=true)
    public static <T> T getFirstItem(@Nullable Collection<? extends T> items) {
        return ContainerUtil.getFirstItem(items, null);
    }

    @Contract(pure=true)
    public static <T> T getFirstItem(@Nullable List<? extends T> items) {
        return items == null || items.isEmpty() ? null : (T)items.get(0);
    }

    @Contract(pure=true)
    public static <T> T getFirstItem(@Nullable Collection<? extends T> items, @Nullable T defaultResult) {
        return items == null || items.isEmpty() ? defaultResult : items.iterator().next();
    }

    @NotNull
    @Contract(pure=true)
    public static <T> List<T> getFirstItems(@NotNull List<T> items, int maxItems) {
        if (items == null) {
            ContainerUtil.$$$reportNull$$$0(279);
        }
        if (maxItems < 0) {
            throw new IllegalArgumentException("Expected non-negative maxItems; got: " + maxItems);
        }
        List<T> list2 = maxItems >= items.size() ? items : items.subList(0, maxItems);
        if (list2 == null) {
            ContainerUtil.$$$reportNull$$$0(280);
        }
        return list2;
    }

    @NotNull
    @Contract(pure=true)
    public static <T, U> Iterator<U> mapIterator(final @NotNull Iterator<? extends T> iterator2, final @NotNull Function<? super T, ? extends U> mapper) {
        if (iterator2 == null) {
            ContainerUtil.$$$reportNull$$$0(282);
        }
        if (mapper == null) {
            ContainerUtil.$$$reportNull$$$0(283);
        }
        return new Iterator<U>(){

            @Override
            public boolean hasNext() {
                return iterator2.hasNext();
            }

            @Override
            public U next() {
                return mapper.fun(iterator2.next());
            }

            @Override
            public void remove() {
                iterator2.remove();
            }
        };
    }

    @NotNull
    @Contract(pure=true)
    public static <T> Iterator<T> filterIterator(final @NotNull Iterator<? extends T> iterator2, final @NotNull Condition<? super T> filter2) {
        if (iterator2 == null) {
            ContainerUtil.$$$reportNull$$$0(284);
        }
        if (filter2 == null) {
            ContainerUtil.$$$reportNull$$$0(285);
        }
        return new Iterator<T>(){
            T next;
            boolean hasNext;
            {
                this.findNext();
            }

            @Override
            public boolean hasNext() {
                return this.hasNext;
            }

            private void findNext() {
                this.hasNext = false;
                while (iterator2.hasNext()) {
                    Object t = iterator2.next();
                    if (!filter2.value(t)) continue;
                    this.next = t;
                    this.hasNext = true;
                    break;
                }
            }

            @Override
            public T next() {
                if (!this.hasNext) {
                    throw new NoSuchElementException();
                }
                Object result2 = this.next;
                this.findNext();
                return result2;
            }

            @Override
            public void remove() {
                iterator2.remove();
            }
        };
    }

    @NotNull
    @Contract(pure=true)
    public static <T> T[] toArray(@NotNull Collection<T> c, @NotNull ArrayFactory<? extends T> factory2) {
        if (c == null) {
            ContainerUtil.$$$reportNull$$$0(289);
        }
        if (factory2 == null) {
            ContainerUtil.$$$reportNull$$$0(290);
        }
        T[] a = factory2.create(c.size());
        T[] TArray = c.toArray(a);
        if (TArray == null) {
            ContainerUtil.$$$reportNull$$$0(291);
        }
        return TArray;
    }

    public static <T> void sort(@NotNull List<T> list2, @NotNull Comparator<? super T> comparator) {
        int size;
        if (list2 == null) {
            ContainerUtil.$$$reportNull$$$0(301);
        }
        if (comparator == null) {
            ContainerUtil.$$$reportNull$$$0(302);
        }
        if ((size = list2.size()) < 2) {
            return;
        }
        if (size == 2) {
            T t1;
            T t0 = list2.get(0);
            if (comparator.compare(t0, t1 = list2.get(1)) > 0) {
                list2.set(0, t1);
                list2.set(1, t0);
            }
        } else if (size < 10) {
            for (int i = 0; i < size; ++i) {
                for (int j = 0; j < i; ++j) {
                    T tj;
                    T ti = list2.get(i);
                    if (comparator.compare(ti, tj = list2.get(j)) >= 0) continue;
                    list2.set(i, tj);
                    list2.set(j, ti);
                }
            }
        } else {
            list2.sort(comparator);
        }
    }

    @NotNull
    @Contract(pure=true)
    public static <T, V> List<V> map(@NotNull Iterable<? extends T> iterable, @NotNull Function<? super T, ? extends V> mapping2) {
        if (iterable == null) {
            ContainerUtil.$$$reportNull$$$0(312);
        }
        if (mapping2 == null) {
            ContainerUtil.$$$reportNull$$$0(313);
        }
        ArrayList<T> result2 = new ArrayList<T>();
        for (T t : iterable) {
            result2.add(mapping2.fun(t));
        }
        List<T> list2 = result2.isEmpty() ? ContainerUtil.emptyList() : result2;
        if (list2 == null) {
            ContainerUtil.$$$reportNull$$$0(314);
        }
        return list2;
    }

    @NotNull
    @Contract(pure=true)
    public static <T, V> List<V> map(@NotNull Collection<? extends T> collection, @NotNull Function<? super T, ? extends V> mapping2) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(315);
        }
        if (mapping2 == null) {
            ContainerUtil.$$$reportNull$$$0(316);
        }
        if (collection.isEmpty()) {
            return ContainerUtil.emptyList();
        }
        ArrayList<V> list2 = new ArrayList<V>(collection.size());
        for (T t : collection) {
            list2.add(mapping2.fun(t));
        }
        ArrayList<V> arrayList = list2;
        if (arrayList == null) {
            ContainerUtil.$$$reportNull$$$0(317);
        }
        return arrayList;
    }

    @NotNull
    @Contract(pure=true)
    public static <T, V> List<V> mapNotNull(@NotNull T[] array, @NotNull Function<? super T, ? extends V> mapping2) {
        if (array == null) {
            ContainerUtil.$$$reportNull$$$0(318);
        }
        if (mapping2 == null) {
            ContainerUtil.$$$reportNull$$$0(319);
        }
        return ContainerUtil.mapNotNull(Arrays.asList(array), mapping2);
    }

    @NotNull
    @Contract(pure=true)
    public static <T, V> List<V> mapNotNull(@NotNull Collection<? extends T> collection, @NotNull Function<? super T, ? extends V> mapping2) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(328);
        }
        if (mapping2 == null) {
            ContainerUtil.$$$reportNull$$$0(329);
        }
        if (collection.isEmpty()) {
            return ContainerUtil.emptyList();
        }
        ArrayList<T> result2 = new ArrayList<T>(collection.size());
        for (T t : collection) {
            V o = mapping2.fun(t);
            if (o == null) continue;
            result2.add(o);
        }
        List<T> list2 = result2.isEmpty() ? ContainerUtil.emptyList() : result2;
        if (list2 == null) {
            ContainerUtil.$$$reportNull$$$0(330);
        }
        return list2;
    }

    @NotNull
    @Contract(pure=true)
    public static <T, V> List<V> map(@NotNull T[] array, @NotNull Function<? super T, ? extends V> mapping2) {
        if (array == null) {
            ContainerUtil.$$$reportNull$$$0(333);
        }
        if (mapping2 == null) {
            ContainerUtil.$$$reportNull$$$0(334);
        }
        ArrayList<T> result2 = new ArrayList<T>(array.length);
        for (T t : array) {
            result2.add(mapping2.fun(t));
        }
        List<T> list2 = result2.isEmpty() ? ContainerUtil.emptyList() : result2;
        if (list2 == null) {
            ContainerUtil.$$$reportNull$$$0(335);
        }
        return list2;
    }

    @SafeVarargs
    @NotNull
    @Contract(pure=true)
    public static <T> Set<T> set(T ... items) {
        if (items == null) {
            ContainerUtil.$$$reportNull$$$0(341);
        }
        return new HashSet<T>(Arrays.asList(items));
    }

    @NotNull
    @Contract(pure=true)
    public static <T> List<T> createMaybeSingletonList(@Nullable T element) {
        List<T> list2 = element == null ? ContainerUtil.emptyList() : Collections.singletonList(element);
        if (list2 == null) {
            ContainerUtil.$$$reportNull$$$0(348);
        }
        return list2;
    }

    @Contract(pure=true)
    public static <T> boolean and(@NotNull T[] iterable, @NotNull Condition<? super T> condition) {
        if (iterable == null) {
            ContainerUtil.$$$reportNull$$$0(358);
        }
        if (condition == null) {
            ContainerUtil.$$$reportNull$$$0(359);
        }
        return ContainerUtil.and(Arrays.asList(iterable), condition);
    }

    @Contract(pure=true)
    public static <T> boolean and(@NotNull Iterable<? extends T> iterable, @NotNull Condition<? super T> condition) {
        if (iterable == null) {
            ContainerUtil.$$$reportNull$$$0(360);
        }
        if (condition == null) {
            ContainerUtil.$$$reportNull$$$0(361);
        }
        for (T t : iterable) {
            if (condition.value(t)) continue;
            return false;
        }
        return true;
    }

    @Contract(pure=true)
    public static <T> boolean exists(@NotNull T[] array, @NotNull Condition<? super T> condition) {
        if (array == null) {
            ContainerUtil.$$$reportNull$$$0(362);
        }
        if (condition == null) {
            ContainerUtil.$$$reportNull$$$0(363);
        }
        for (T t : array) {
            if (!condition.value(t)) continue;
            return true;
        }
        return false;
    }

    @Contract(pure=true)
    public static <T> boolean exists(@NotNull Iterable<? extends T> iterable, @NotNull Condition<? super T> condition) {
        if (iterable == null) {
            ContainerUtil.$$$reportNull$$$0(364);
        }
        if (condition == null) {
            ContainerUtil.$$$reportNull$$$0(365);
        }
        return ContainerUtil.or(iterable, condition);
    }

    @Contract(pure=true)
    public static <T> boolean or(@NotNull Iterable<? extends T> iterable, @NotNull Condition<? super T> condition) {
        if (iterable == null) {
            ContainerUtil.$$$reportNull$$$0(368);
        }
        if (condition == null) {
            ContainerUtil.$$$reportNull$$$0(369);
        }
        for (T t : iterable) {
            if (!condition.value(t)) continue;
            return true;
        }
        return false;
    }

    public static <T> void quickSort(@NotNull List<? extends T> list2, @NotNull Comparator<? super T> comparator) {
        if (list2 == null) {
            ContainerUtil.$$$reportNull$$$0(378);
        }
        if (comparator == null) {
            ContainerUtil.$$$reportNull$$$0(379);
        }
        ContainerUtil.quickSort(list2, comparator, 0, list2.size());
    }

    private static <T> void quickSort(@NotNull List<? extends T> x, @NotNull Comparator<? super T> comparator, int off, int len) {
        int c;
        int a;
        if (x == null) {
            ContainerUtil.$$$reportNull$$$0(380);
        }
        if (comparator == null) {
            ContainerUtil.$$$reportNull$$$0(381);
        }
        if (len < 7) {
            for (int i = off; i < len + off; ++i) {
                for (int j = i; j > off && comparator.compare(x.get(j), x.get(j - 1)) < 0; --j) {
                    ContainerUtil.swapElements(x, j, j - 1);
                }
            }
            return;
        }
        int m = off + (len >> 1);
        if (len > 7) {
            int l = off;
            int n = off + len - 1;
            if (len > 40) {
                int s = len / 8;
                l = ContainerUtil.med3(x, comparator, l, l + s, l + 2 * s);
                m = ContainerUtil.med3(x, comparator, m - s, m, m + s);
                n = ContainerUtil.med3(x, comparator, n - 2 * s, n - s, n);
            }
            m = ContainerUtil.med3(x, comparator, l, m, n);
        }
        T v = x.get(m);
        int b = a = off;
        int d = c = off + len - 1;
        while (true) {
            if (b <= c && comparator.compare(x.get(b), v) <= 0) {
                if (comparator.compare(x.get(b), v) == 0) {
                    ContainerUtil.swapElements(x, a++, b);
                }
                ++b;
                continue;
            }
            while (c >= b && comparator.compare(v, x.get(c)) <= 0) {
                if (comparator.compare(x.get(c), v) == 0) {
                    ContainerUtil.swapElements(x, c, d--);
                }
                --c;
            }
            if (b > c) break;
            ContainerUtil.swapElements(x, b++, c--);
        }
        int s = Math.min(a - off, b - a);
        ContainerUtil.vecswap(x, off, b - s, s);
        int n = off + len;
        s = Math.min(d - c, n - d - 1);
        ContainerUtil.vecswap(x, b, n - s, s);
        s = b - a;
        if (s > 1) {
            ContainerUtil.quickSort(x, comparator, off, s);
        }
        if ((s = d - c) > 1) {
            ContainerUtil.quickSort(x, comparator, n - s, s);
        }
    }

    private static <T> int med3(@NotNull List<? extends T> x, Comparator<? super T> comparator, int a, int b, int c) {
        if (x == null) {
            ContainerUtil.$$$reportNull$$$0(382);
        }
        return comparator.compare(x.get(a), x.get(b)) < 0 ? (comparator.compare(x.get(b), x.get(c)) < 0 ? b : (comparator.compare(x.get(a), x.get(c)) < 0 ? c : a)) : (comparator.compare(x.get(c), x.get(b)) < 0 ? b : (comparator.compare(x.get(c), x.get(a)) < 0 ? c : a));
    }

    private static <T> void vecswap(List<T> x, int a, int b, int n) {
        int i = 0;
        while (i < n) {
            ContainerUtil.swapElements(x, a, b);
            ++i;
            ++a;
            ++b;
        }
    }

    @NotNull
    @Contract(pure=true)
    public static <E> List<E> flatten(@NotNull Iterable<? extends Collection<? extends E>> collections) {
        if (collections == null) {
            ContainerUtil.$$$reportNull$$$0(389);
        }
        int totalSize = 0;
        for (Collection<E> list2 : collections) {
            totalSize += list2.size();
        }
        ArrayList result2 = new ArrayList(totalSize);
        for (Collection<E> collection : collections) {
            result2.addAll(collection);
        }
        List list2 = result2.isEmpty() ? ContainerUtil.emptyList() : result2;
        if (list2 == null) {
            ContainerUtil.$$$reportNull$$$0(390);
        }
        return list2;
    }

    @Contract(pure=true)
    public static <T> int indexOfIdentity(@NotNull List<? extends T> list2, T element) {
        if (list2 == null) {
            ContainerUtil.$$$reportNull$$$0(398);
        }
        int listSize = list2.size();
        for (int i = 0; i < listSize; ++i) {
            if (list2.get(i) != element) continue;
            return i;
        }
        return -1;
    }

    @Contract(pure=true)
    public static <T> int indexOf(@NotNull List<? extends T> list2, @NotNull Condition<? super T> condition) {
        if (list2 == null) {
            ContainerUtil.$$$reportNull$$$0(401);
        }
        if (condition == null) {
            ContainerUtil.$$$reportNull$$$0(402);
        }
        int listSize = list2.size();
        for (int i = 0; i < listSize; ++i) {
            T t = list2.get(i);
            if (!condition.value(t)) continue;
            return i;
        }
        return -1;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> List<T> emptyList() {
        List list2 = ContainerUtilRt.emptyList();
        if (list2 == null) {
            ContainerUtil.$$$reportNull$$$0(411);
        }
        return list2;
    }

    @NotNull
    @Contract(value=" -> new", pure=true)
    public static <T> List<T> createLockFreeCopyOnWriteList() {
        return ContainerUtil.createConcurrentList();
    }

    @NotNull
    @Contract(value=" -> new", pure=true)
    public static <V> ConcurrentIntObjectMap<V> createConcurrentIntObjectMap() {
        return new ConcurrentIntObjectHashMap();
    }

    @NotNull
    @Contract(value=" -> new", pure=true)
    public static <V> ConcurrentLongObjectMap<V> createConcurrentLongObjectMap() {
        return new ConcurrentLongObjectHashMap();
    }

    @NotNull
    @Contract(value=" -> new", pure=true)
    public static <K, V> ConcurrentMap<K, V> createConcurrentWeakValueMap() {
        return new ConcurrentWeakValueHashMap();
    }

    @NotNull
    @Contract(value=" -> new", pure=true)
    public static <V> ConcurrentIntObjectMap<V> createConcurrentIntObjectWeakValueMap() {
        return new ConcurrentIntKeyWeakValueHashMap();
    }

    @NotNull
    @Contract(value="_,_,_,_ -> new", pure=true)
    public static <K, V> ConcurrentMap<K, V> createConcurrentWeakKeySoftValueMap(int initialCapacity, float loadFactor, int concurrencyLevel, @NotNull TObjectHashingStrategy<? super K> hashingStrategy) {
        if (hashingStrategy == null) {
            ContainerUtil.$$$reportNull$$$0(413);
        }
        return new ConcurrentWeakKeySoftValueHashMap(initialCapacity, loadFactor, concurrencyLevel, hashingStrategy);
    }

    @NotNull
    @Contract(value=" -> new", pure=true)
    public static <K, V> ConcurrentMap<K, V> createConcurrentSoftKeySoftValueMap() {
        return ContainerUtil.createConcurrentSoftKeySoftValueMap(100, 0.75f, Runtime.getRuntime().availableProcessors(), ContainerUtil.canonicalStrategy());
    }

    @NotNull
    @Contract(value="_,_,_,_ -> new", pure=true)
    public static <K, V> ConcurrentMap<K, V> createConcurrentSoftKeySoftValueMap(int initialCapacity, float loadFactor, int concurrencyLevel, @NotNull TObjectHashingStrategy<? super K> hashingStrategy) {
        if (hashingStrategy == null) {
            ContainerUtil.$$$reportNull$$$0(414);
        }
        return new ConcurrentSoftKeySoftValueHashMap(initialCapacity, loadFactor, concurrencyLevel, hashingStrategy);
    }

    @NotNull
    @Contract(value=" -> new", pure=true)
    public static <K, V> ConcurrentMap<K, V> createConcurrentWeakKeySoftValueMap() {
        return ContainerUtil.createConcurrentWeakKeySoftValueMap(100, 0.75f, Runtime.getRuntime().availableProcessors(), ContainerUtil.canonicalStrategy());
    }

    @NotNull
    @Contract(value=" -> new", pure=true)
    public static <K, V> ConcurrentMap<K, V> createConcurrentWeakKeyWeakValueMap() {
        return ContainerUtil.createConcurrentWeakKeyWeakValueMap(ContainerUtil.canonicalStrategy());
    }

    @NotNull
    @Contract(value="_ -> new", pure=true)
    public static <K, V> ConcurrentMap<K, V> createConcurrentWeakKeyWeakValueMap(@NotNull TObjectHashingStrategy<? super K> strategy) {
        if (strategy == null) {
            ContainerUtil.$$$reportNull$$$0(415);
        }
        return new ConcurrentWeakKeyWeakValueHashMap(100, 0.75f, Runtime.getRuntime().availableProcessors(), strategy);
    }

    @NotNull
    @Contract(value=" -> new", pure=true)
    public static <K, V> ConcurrentMap<K, V> createConcurrentSoftValueMap() {
        return new ConcurrentSoftValueHashMap();
    }

    @NotNull
    @Contract(value=" -> new", pure=true)
    public static <K, V> ConcurrentMap<K, V> createConcurrentSoftMap() {
        return new ConcurrentSoftHashMap();
    }

    @NotNull
    @Contract(value=" -> new", pure=true)
    public static <K, V> ConcurrentMap<K, V> createConcurrentWeakMap() {
        return new ConcurrentWeakHashMap(0.75f);
    }

    @NotNull
    @Contract(value=" -> new", pure=true)
    public static <T> ConcurrentList<T> createConcurrentList() {
        return new LockFreeCopyOnWriteArrayList();
    }

    public static <T> void addIfNotNull(@NotNull Collection<? super T> result2, @Nullable T element) {
        if (result2 == null) {
            ContainerUtil.$$$reportNull$$$0(421);
        }
        if (element != null) {
            result2.add(element);
        }
    }

    @NotNull
    @Contract(pure=true)
    public static <T, V> Set<V> map2Set(@NotNull Collection<? extends T> collection, @NotNull Function<? super T, ? extends V> mapper) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(431);
        }
        if (mapper == null) {
            ContainerUtil.$$$reportNull$$$0(432);
        }
        if (collection.isEmpty()) {
            Set set = Collections.emptySet();
            if (set == null) {
                ContainerUtil.$$$reportNull$$$0(433);
            }
            return set;
        }
        HashSet<V> set = new HashSet<V>(collection.size());
        for (T t : collection) {
            set.add(mapper.fun(t));
        }
        HashSet<V> hashSet = set;
        if (hashSet == null) {
            ContainerUtil.$$$reportNull$$$0(434);
        }
        return hashSet;
    }

    @NotNull
    public static <T> T[] copyAndClear(@NotNull Collection<? extends T> collection, @NotNull ArrayFactory<? extends T> factory2, boolean clear) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(449);
        }
        if (factory2 == null) {
            ContainerUtil.$$$reportNull$$$0(450);
        }
        int size = collection.size();
        T[] a = factory2.create(size);
        if (size > 0) {
            a = collection.toArray(a);
            if (clear) {
                collection.clear();
            }
        }
        if (a == null) {
            ContainerUtil.$$$reportNull$$$0(451);
        }
        return a;
    }

    @NotNull
    public static <T> List<T> copyList(@NotNull List<? extends T> list2) {
        if (list2 == null) {
            ContainerUtil.$$$reportNull$$$0(452);
        }
        if (list2 == Collections.emptyList()) {
            List list3 = Collections.emptyList();
            if (list3 == null) {
                ContainerUtil.$$$reportNull$$$0(453);
            }
            return list3;
        }
        if (list2.size() == 1) {
            return new SmartList<T>(list2.get(0));
        }
        if (list2.isEmpty()) {
            return new SmartList();
        }
        return new ArrayList<T>(list2);
    }

    @Contract(value="null -> true", pure=true)
    public static <T> boolean isEmpty(@Nullable Collection<? extends T> collection) {
        return collection == null || collection.isEmpty();
    }

    @NotNull
    @Contract(pure=true)
    public static <T> List<T> notNullize(@Nullable List<T> list2) {
        List<T> list3 = list2 == null ? ContainerUtil.emptyList() : list2;
        if (list3 == null) {
            ContainerUtil.$$$reportNull$$$0(458);
        }
        return list3;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> Set<T> notNullize(@Nullable Set<T> set) {
        Set set2 = set == null ? Collections.emptySet() : set;
        if (set2 == null) {
            ContainerUtil.$$$reportNull$$$0(459);
        }
        return set2;
    }

    @Contract(value=" -> new", pure=true)
    @NotNull
    public static <K, V> Map<K, V> createSoftMap() {
        return new SoftHashMap(4);
    }

    @Contract(value=" -> new", pure=true)
    @NotNull
    public static <K, V> Map<K, V> createWeakMap() {
        return ContainerUtil.createWeakMap(4);
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public static <K, V> Map<K, V> createWeakMap(int initialCapacity) {
        return ContainerUtil.createWeakMap(initialCapacity, 0.8f, ContainerUtil.canonicalStrategy());
    }

    @Contract(value="_, _, _ -> new", pure=true)
    @NotNull
    public static <K, V> Map<K, V> createWeakMap(int initialCapacity, float loadFactor, @NotNull TObjectHashingStrategy<? super K> strategy) {
        if (strategy == null) {
            ContainerUtil.$$$reportNull$$$0(471);
        }
        return new WeakHashMap(initialCapacity, loadFactor, strategy);
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public static <T> List<T> freeze(@NotNull List<? extends T> list2) {
        if (list2 == null) {
            ContainerUtil.$$$reportNull$$$0(472);
        }
        if (list2.isEmpty()) {
            List list3 = Collections.emptyList();
            if (list3 == null) {
                ContainerUtil.$$$reportNull$$$0(473);
            }
            return list3;
        }
        if (list2.size() == 1) {
            return ContainerUtil.immutableSingletonList(list2.get(0));
        }
        return ContainerUtil.immutableList(list2.toArray());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 5: 
            case 8: 
            case 13: 
            case 16: 
            case 17: 
            case 19: 
            case 23: 
            case 26: 
            case 27: 
            case 29: 
            case 31: 
            case 33: 
            case 34: 
            case 36: 
            case 37: 
            case 41: 
            case 44: 
            case 45: 
            case 47: 
            case 58: 
            case 62: 
            case 67: 
            case 69: 
            case 70: 
            case 71: 
            case 73: 
            case 77: 
            case 83: 
            case 86: 
            case 94: 
            case 96: 
            case 108: 
            case 111: 
            case 114: 
            case 120: 
            case 121: 
            case 122: 
            case 147: 
            case 152: 
            case 154: 
            case 162: 
            case 166: 
            case 170: 
            case 175: 
            case 178: 
            case 185: 
            case 188: 
            case 194: 
            case 197: 
            case 200: 
            case 201: 
            case 204: 
            case 209: 
            case 211: 
            case 217: 
            case 219: 
            case 222: 
            case 230: 
            case 233: 
            case 247: 
            case 254: 
            case 255: 
            case 256: 
            case 260: 
            case 261: 
            case 265: 
            case 270: 
            case 275: 
            case 278: 
            case 280: 
            case 288: 
            case 291: 
            case 295: 
            case 299: 
            case 308: 
            case 314: 
            case 317: 
            case 323: 
            case 324: 
            case 327: 
            case 330: 
            case 332: 
            case 335: 
            case 339: 
            case 340: 
            case 348: 
            case 349: 
            case 352: 
            case 357: 
            case 373: 
            case 375: 
            case 377: 
            case 384: 
            case 388: 
            case 390: 
            case 392: 
            case 396: 
            case 410: 
            case 411: 
            case 426: 
            case 428: 
            case 433: 
            case 434: 
            case 437: 
            case 438: 
            case 441: 
            case 442: 
            case 445: 
            case 448: 
            case 451: 
            case 453: 
            case 456: 
            case 457: 
            case 458: 
            case 459: 
            case 460: 
            case 469: 
            case 473: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 5: 
            case 8: 
            case 13: 
            case 16: 
            case 17: 
            case 19: 
            case 23: 
            case 26: 
            case 27: 
            case 29: 
            case 31: 
            case 33: 
            case 34: 
            case 36: 
            case 37: 
            case 41: 
            case 44: 
            case 45: 
            case 47: 
            case 58: 
            case 62: 
            case 67: 
            case 69: 
            case 70: 
            case 71: 
            case 73: 
            case 77: 
            case 83: 
            case 86: 
            case 94: 
            case 96: 
            case 108: 
            case 111: 
            case 114: 
            case 120: 
            case 121: 
            case 122: 
            case 147: 
            case 152: 
            case 154: 
            case 162: 
            case 166: 
            case 170: 
            case 175: 
            case 178: 
            case 185: 
            case 188: 
            case 194: 
            case 197: 
            case 200: 
            case 201: 
            case 204: 
            case 209: 
            case 211: 
            case 217: 
            case 219: 
            case 222: 
            case 230: 
            case 233: 
            case 247: 
            case 254: 
            case 255: 
            case 256: 
            case 260: 
            case 261: 
            case 265: 
            case 270: 
            case 275: 
            case 278: 
            case 280: 
            case 288: 
            case 291: 
            case 295: 
            case 299: 
            case 308: 
            case 314: 
            case 317: 
            case 323: 
            case 324: 
            case 327: 
            case 330: 
            case 332: 
            case 335: 
            case 339: 
            case 340: 
            case 348: 
            case 349: 
            case 352: 
            case 357: 
            case 373: 
            case 375: 
            case 377: 
            case 384: 
            case 388: 
            case 390: 
            case 392: 
            case 396: 
            case 410: 
            case 411: 
            case 426: 
            case 428: 
            case 433: 
            case 434: 
            case 437: 
            case 438: 
            case 441: 
            case 442: 
            case 445: 
            case 448: 
            case 451: 
            case 453: 
            case 456: 
            case 457: 
            case 458: 
            case 459: 
            case 460: 
            case 469: 
            case 473: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 1: 
            case 5: 
            case 8: 
            case 13: 
            case 16: 
            case 17: 
            case 19: 
            case 23: 
            case 26: 
            case 27: 
            case 29: 
            case 31: 
            case 33: 
            case 34: 
            case 36: 
            case 37: 
            case 41: 
            case 44: 
            case 45: 
            case 47: 
            case 58: 
            case 62: 
            case 67: 
            case 69: 
            case 70: 
            case 71: 
            case 73: 
            case 77: 
            case 83: 
            case 86: 
            case 94: 
            case 96: 
            case 108: 
            case 111: 
            case 114: 
            case 120: 
            case 121: 
            case 122: 
            case 147: 
            case 152: 
            case 154: 
            case 162: 
            case 166: 
            case 170: 
            case 175: 
            case 178: 
            case 185: 
            case 188: 
            case 194: 
            case 197: 
            case 200: 
            case 201: 
            case 204: 
            case 209: 
            case 211: 
            case 217: 
            case 219: 
            case 222: 
            case 230: 
            case 233: 
            case 247: 
            case 254: 
            case 255: 
            case 256: 
            case 260: 
            case 261: 
            case 265: 
            case 270: 
            case 275: 
            case 278: 
            case 280: 
            case 288: 
            case 291: 
            case 295: 
            case 299: 
            case 308: 
            case 314: 
            case 317: 
            case 323: 
            case 324: 
            case 327: 
            case 330: 
            case 332: 
            case 335: 
            case 339: 
            case 340: 
            case 348: 
            case 349: 
            case 352: 
            case 357: 
            case 373: 
            case 375: 
            case 377: 
            case 384: 
            case 388: 
            case 390: 
            case 392: 
            case 396: 
            case 410: 
            case 411: 
            case 426: 
            case 428: 
            case 433: 
            case 434: 
            case 437: 
            case 438: 
            case 441: 
            case 442: 
            case 445: 
            case 448: 
            case 451: 
            case 453: 
            case 456: 
            case 457: 
            case 458: 
            case 459: 
            case 460: 
            case 469: 
            case 473: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/containers/ContainerUtil";
                break;
            }
            case 2: 
            case 9: 
            case 10: 
            case 60: 
            case 115: 
            case 183: 
            case 409: 
            case 427: 
            case 468: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 3: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "first";
                break;
            }
            case 4: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entries";
                break;
            }
            case 6: 
            case 109: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keys";
                break;
            }
            case 7: 
            case 112: 
            case 116: 
            case 249: 
            case 251: {
                objectArray2 = objectArray3;
                objectArray3[0] = "values";
                break;
            }
            case 14: 
            case 50: 
            case 52: 
            case 54: 
            case 383: 
            case 415: 
            case 470: 
            case 471: {
                objectArray2 = objectArray3;
                objectArray3[0] = "strategy";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyType";
                break;
            }
            case 20: 
            case 72: 
            case 123: 
            case 155: 
            case 157: 
            case 159: 
            case 210: 
            case 242: 
            case 244: 
            case 318: 
            case 320: 
            case 333: 
            case 362: 
            case 422: 
            case 444: {
                objectArray2 = objectArray3;
                objectArray3[0] = "array";
                break;
            }
            case 21: 
            case 22: 
            case 40: 
            case 125: 
            case 129: 
            case 133: 
            case 135: 
            case 238: 
            case 312: 
            case 325: 
            case 358: 
            case 360: 
            case 364: 
            case 366: 
            case 368: 
            case 370: 
            case 454: {
                objectArray2 = objectArray3;
                objectArray3[0] = "iterable";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalList";
                break;
            }
            case 28: 
            case 30: 
            case 32: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "original";
                break;
            }
            case 42: 
            case 57: 
            case 75: 
            case 97: 
            case 99: 
            case 101: 
            case 103: 
            case 105: 
            case 143: 
            case 145: 
            case 148: 
            case 150: 
            case 153: 
            case 163: 
            case 167: 
            case 171: 
            case 173: 
            case 176: 
            case 179: 
            case 181: 
            case 186: 
            case 189: 
            case 190: 
            case 192: 
            case 195: 
            case 198: 
            case 202: 
            case 205: 
            case 207: 
            case 215: 
            case 226: 
            case 228: 
            case 231: 
            case 234: 
            case 236: 
            case 315: 
            case 328: 
            case 419: 
            case 424: 
            case 429: 
            case 431: 
            case 435: 
            case 439: 
            case 443: 
            case 449: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collection";
                break;
            }
            case 43: 
            case 79: 
            case 102: 
            case 107: 
            case 118: 
            case 131: 
            case 137: 
            case 139: 
            case 224: 
            case 240: 
            case 282: 
            case 284: {
                objectArray2 = objectArray3;
                objectArray3[0] = "iterator";
                break;
            }
            case 61: 
            case 82: 
            case 85: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map2";
                break;
            }
            case 63: 
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "set";
                break;
            }
            case 64: 
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "set2";
                break;
            }
            case 74: 
            case 95: 
            case 127: 
            case 141: 
            case 218: 
            case 223: 
            case 246: 
            case 248: 
            case 250: 
            case 268: 
            case 300: 
            case 301: 
            case 304: 
            case 306: 
            case 309: 
            case 378: 
            case 386: 
            case 397: 
            case 398: 
            case 401: 
            case 403: 
            case 405: 
            case 407: 
            case 452: 
            case 461: 
            case 472: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 76: {
                objectArray2 = objectArray3;
                objectArray3[0] = "grouper";
                break;
            }
            case 80: 
            case 144: 
            case 146: 
            case 149: 
            case 151: 
            case 156: 
            case 158: 
            case 161: 
            case 165: 
            case 169: 
            case 283: 
            case 423: 
            case 425: 
            case 430: 
            case 432: 
            case 436: 
            case 440: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mapper";
                break;
            }
            case 81: 
            case 84: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map1";
                break;
            }
            case 87: 
            case 91: 
            case 252: 
            case 399: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list1";
                break;
            }
            case 88: 
            case 92: 
            case 253: 
            case 400: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list2";
                break;
            }
            case 89: 
            case 93: 
            case 302: 
            case 305: 
            case 307: 
            case 311: 
            case 379: 
            case 381: 
            case 387: 
            case 467: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comparator";
                break;
            }
            case 90: 
            case 126: 
            case 128: 
            case 130: 
            case 132: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 100: {
                objectArray2 = objectArray3;
                objectArray3[0] = "appendix";
                break;
            }
            case 110: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueConvertor";
                break;
            }
            case 113: 
            case 117: 
            case 119: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyConvertor";
                break;
            }
            case 124: 
            case 134: 
            case 140: 
            case 142: 
            case 172: 
            case 174: 
            case 177: 
            case 182: 
            case 187: 
            case 206: 
            case 214: 
            case 216: 
            case 237: 
            case 359: 
            case 361: 
            case 363: 
            case 365: 
            case 367: 
            case 369: 
            case 371: 
            case 402: 
            case 404: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condition";
                break;
            }
            case 136: 
            case 138: {
                objectArray2 = objectArray3;
                objectArray3[0] = "equalTo";
                break;
            }
            case 160: 
            case 164: 
            case 180: 
            case 239: 
            case 241: 
            case 243: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 168: 
            case 394: {
                objectArray2 = objectArray3;
                objectArray3[0] = "to";
                break;
            }
            case 184: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyFilter";
                break;
            }
            case 191: 
            case 193: 
            case 196: 
            case 199: 
            case 203: 
            case 225: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instanceOf";
                break;
            }
            case 208: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyValues";
                break;
            }
            case 212: 
            case 227: 
            case 455: {
                objectArray2 = objectArray3;
                objectArray3[0] = "enumeration";
                break;
            }
            case 213: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arrays";
                break;
            }
            case 220: {
                objectArray2 = objectArray3;
                objectArray3[0] = "iterable1";
                break;
            }
            case 221: {
                objectArray2 = objectArray3;
                objectArray3[0] = "iterable2";
                break;
            }
            case 245: 
            case 395: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fun";
                break;
            }
            case 257: {
                objectArray2 = objectArray3;
                objectArray3[0] = "it1";
                break;
            }
            case 258: {
                objectArray2 = objectArray3;
                objectArray3[0] = "it2";
                break;
            }
            case 259: 
            case 264: {
                objectArray2 = objectArray3;
                objectArray3[0] = "iterables";
                break;
            }
            case 262: 
            case 263: {
                objectArray2 = objectArray3;
                objectArray3[0] = "iterators";
                break;
            }
            case 266: 
            case 267: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lists";
                break;
            }
            case 269: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listGenerator";
                break;
            }
            case 271: 
            case 273: 
            case 276: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collection1";
                break;
            }
            case 272: 
            case 274: 
            case 277: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collection2";
                break;
            }
            case 279: 
            case 281: 
            case 341: 
            case 374: 
            case 376: {
                objectArray2 = objectArray3;
                objectArray3[0] = "items";
                break;
            }
            case 285: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 286: 
            case 393: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
            case 287: {
                objectArray2 = objectArray3;
                objectArray3[0] = "what";
                break;
            }
            case 289: 
            case 412: 
            case 446: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c";
                break;
            }
            case 290: 
            case 294: 
            case 298: 
            case 354: 
            case 450: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 292: 
            case 296: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c1";
                break;
            }
            case 293: 
            case 297: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c2";
                break;
            }
            case 303: 
            case 310: {
                objectArray2 = objectArray3;
                objectArray3[0] = "a";
                break;
            }
            case 313: 
            case 316: 
            case 319: 
            case 321: 
            case 326: 
            case 329: 
            case 334: 
            case 337: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mapping";
                break;
            }
            case 322: 
            case 338: {
                objectArray2 = objectArray3;
                objectArray3[0] = "emptyArray";
                break;
            }
            case 336: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arr";
                break;
            }
            case 342: 
            case 343: 
            case 344: 
            case 345: 
            case 346: 
            case 350: 
            case 353: 
            case 355: 
            case 420: 
            case 421: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 347: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 351: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultValue";
                break;
            }
            case 356: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defValue";
                break;
            }
            case 372: {
                objectArray2 = objectArray3;
                objectArray3[0] = "next";
                break;
            }
            case 380: 
            case 382: {
                objectArray2 = objectArray3;
                objectArray3[0] = "x";
                break;
            }
            case 385: 
            case 389: 
            case 391: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collections";
                break;
            }
            case 406: 
            case 408: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 413: 
            case 414: 
            case 416: 
            case 417: 
            case 418: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hashingStrategy";
                break;
            }
            case 447: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sample";
                break;
            }
            case 462: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 463: 
            case 465: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o1";
                break;
            }
            case 464: 
            case 466: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o2";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/containers/ContainerUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "ar";
                break;
            }
            case 5: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "newHashMap";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "newLinkedHashMap";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "canonicalStrategy";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "identityStrategy";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "newLinkedList";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "newArrayList";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "newUnmodifiableList";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "unmodifiableOrEmptyCollection";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "unmodifiableOrEmptyList";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "unmodifiableOrEmptySet";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "unmodifiableOrEmptyMap";
                break;
            }
            case 41: 
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "newHashSet";
                break;
            }
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "newHashOrEmptySet";
                break;
            }
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "newLinkedHashSet";
                break;
            }
            case 58: {
                objectArray = objectArray2;
                objectArray2[1] = "newConcurrentSet";
                break;
            }
            case 62: 
            case 67: {
                objectArray = objectArray2;
                objectArray2[1] = "union";
                break;
            }
            case 69: 
            case 70: 
            case 71: {
                objectArray = objectArray2;
                objectArray2[1] = "immutableSet";
                break;
            }
            case 73: {
                objectArray = objectArray2;
                objectArray2[1] = "immutableSingletonList";
                break;
            }
            case 77: {
                objectArray = objectArray2;
                objectArray2[1] = "groupBy";
                break;
            }
            case 83: 
            case 275: 
            case 278: {
                objectArray = objectArray2;
                objectArray2[1] = "intersection";
                break;
            }
            case 86: {
                objectArray = objectArray2;
                objectArray2[1] = "diff";
                break;
            }
            case 94: {
                objectArray = objectArray2;
                objectArray2[1] = "mergeSortedLists";
                break;
            }
            case 96: {
                objectArray = objectArray2;
                objectArray2[1] = "subList";
                break;
            }
            case 108: {
                objectArray = objectArray2;
                objectArray2[1] = "collect";
                break;
            }
            case 111: {
                objectArray = objectArray2;
                objectArray2[1] = "newMapFromKeys";
                break;
            }
            case 114: {
                objectArray = objectArray2;
                objectArray2[1] = "newMapFromValues";
                break;
            }
            case 120: {
                objectArray = objectArray2;
                objectArray2[1] = "classify";
                break;
            }
            case 121: {
                objectArray = objectArray2;
                objectArray2[1] = "emptyIterator";
                break;
            }
            case 122: {
                objectArray = objectArray2;
                objectArray2[1] = "emptyIterable";
                break;
            }
            case 147: 
            case 154: {
                objectArray = objectArray2;
                objectArray2[1] = "map2Map";
                break;
            }
            case 152: {
                objectArray = objectArray2;
                objectArray2[1] = "map2MapNotNull";
                break;
            }
            case 162: 
            case 166: 
            case 170: {
                objectArray = objectArray2;
                objectArray2[1] = "map2Array";
                break;
            }
            case 175: 
            case 185: {
                objectArray = objectArray2;
                objectArray2[1] = "filter";
                break;
            }
            case 178: 
            case 188: 
            case 204: {
                objectArray = objectArray2;
                objectArray2[1] = "findAll";
                break;
            }
            case 194: 
            case 197: 
            case 200: 
            case 201: {
                objectArray = objectArray2;
                objectArray2[1] = "findAllAsArray";
                break;
            }
            case 209: {
                objectArray = objectArray2;
                objectArray2[1] = "stringMap";
                break;
            }
            case 211: 
            case 217: {
                objectArray = objectArray2;
                objectArray2[1] = "iterate";
                break;
            }
            case 219: {
                objectArray = objectArray2;
                objectArray2[1] = "iterateBackward";
                break;
            }
            case 222: {
                objectArray = objectArray2;
                objectArray2[1] = "zip";
                break;
            }
            case 230: {
                objectArray = objectArray2;
                objectArray2[1] = "addAll";
                break;
            }
            case 233: {
                objectArray = objectArray2;
                objectArray2[1] = "addAllNotNull";
                break;
            }
            case 247: 
            case 254: 
            case 255: 
            case 256: 
            case 260: 
            case 261: 
            case 265: 
            case 270: {
                objectArray = objectArray2;
                objectArray2[1] = "concat";
                break;
            }
            case 280: {
                objectArray = objectArray2;
                objectArray2[1] = "getFirstItems";
                break;
            }
            case 288: {
                objectArray = objectArray2;
                objectArray2[1] = "subtract";
                break;
            }
            case 291: 
            case 295: 
            case 445: 
            case 448: {
                objectArray = objectArray2;
                objectArray2[1] = "toArray";
                break;
            }
            case 299: {
                objectArray = objectArray2;
                objectArray2[1] = "mergeCollectionsToArray";
                break;
            }
            case 308: {
                objectArray = objectArray2;
                objectArray2[1] = "sorted";
                break;
            }
            case 314: 
            case 317: 
            case 335: 
            case 339: 
            case 340: {
                objectArray = objectArray2;
                objectArray2[1] = "map";
                break;
            }
            case 323: 
            case 324: 
            case 327: 
            case 330: {
                objectArray = objectArray2;
                objectArray2[1] = "mapNotNull";
                break;
            }
            case 332: {
                objectArray = objectArray2;
                objectArray2[1] = "packNullables";
                break;
            }
            case 348: {
                objectArray = objectArray2;
                objectArray2[1] = "createMaybeSingletonList";
                break;
            }
            case 349: {
                objectArray = objectArray2;
                objectArray2[1] = "createMaybeSingletonSet";
                break;
            }
            case 352: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreate";
                break;
            }
            case 357: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrElse";
                break;
            }
            case 373: {
                objectArray = objectArray2;
                objectArray2[1] = "unfold";
                break;
            }
            case 375: {
                objectArray = objectArray2;
                objectArray2[1] = "dropTail";
                break;
            }
            case 377: {
                objectArray = objectArray2;
                objectArray2[1] = "list";
                break;
            }
            case 384: {
                objectArray = objectArray2;
                objectArray2[1] = "singleton";
                break;
            }
            case 388: {
                objectArray = objectArray2;
                objectArray2[1] = "removeDuplicatesFromSorted";
                break;
            }
            case 390: {
                objectArray = objectArray2;
                objectArray2[1] = "flatten";
                break;
            }
            case 392: {
                objectArray = objectArray2;
                objectArray2[1] = "flattenIterables";
                break;
            }
            case 396: {
                objectArray = objectArray2;
                objectArray2[1] = "convert";
                break;
            }
            case 410: {
                objectArray = objectArray2;
                objectArray2[1] = "reverseMap";
                break;
            }
            case 411: {
                objectArray = objectArray2;
                objectArray2[1] = "emptyList";
                break;
            }
            case 426: 
            case 428: {
                objectArray = objectArray2;
                objectArray2[1] = "map2List";
                break;
            }
            case 433: 
            case 434: {
                objectArray = objectArray2;
                objectArray2[1] = "map2Set";
                break;
            }
            case 437: 
            case 438: {
                objectArray = objectArray2;
                objectArray2[1] = "map2LinkedSet";
                break;
            }
            case 441: 
            case 442: {
                objectArray = objectArray2;
                objectArray2[1] = "map2SetNotNull";
                break;
            }
            case 451: {
                objectArray = objectArray2;
                objectArray2[1] = "copyAndClear";
                break;
            }
            case 453: {
                objectArray = objectArray2;
                objectArray2[1] = "copyList";
                break;
            }
            case 456: 
            case 457: {
                objectArray = objectArray2;
                objectArray2[1] = "toList";
                break;
            }
            case 458: 
            case 459: 
            case 460: {
                objectArray = objectArray2;
                objectArray2[1] = "notNullize";
                break;
            }
            case 469: {
                objectArray = objectArray2;
                objectArray2[1] = "toString";
                break;
            }
            case 473: {
                objectArray = objectArray2;
                objectArray2[1] = "freeze";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "ar";
                break;
            }
            case 1: 
            case 5: 
            case 8: 
            case 13: 
            case 16: 
            case 17: 
            case 19: 
            case 23: 
            case 26: 
            case 27: 
            case 29: 
            case 31: 
            case 33: 
            case 34: 
            case 36: 
            case 37: 
            case 41: 
            case 44: 
            case 45: 
            case 47: 
            case 58: 
            case 62: 
            case 67: 
            case 69: 
            case 70: 
            case 71: 
            case 73: 
            case 77: 
            case 83: 
            case 86: 
            case 94: 
            case 96: 
            case 108: 
            case 111: 
            case 114: 
            case 120: 
            case 121: 
            case 122: 
            case 147: 
            case 152: 
            case 154: 
            case 162: 
            case 166: 
            case 170: 
            case 175: 
            case 178: 
            case 185: 
            case 188: 
            case 194: 
            case 197: 
            case 200: 
            case 201: 
            case 204: 
            case 209: 
            case 211: 
            case 217: 
            case 219: 
            case 222: 
            case 230: 
            case 233: 
            case 247: 
            case 254: 
            case 255: 
            case 256: 
            case 260: 
            case 261: 
            case 265: 
            case 270: 
            case 275: 
            case 278: 
            case 280: 
            case 288: 
            case 291: 
            case 295: 
            case 299: 
            case 308: 
            case 314: 
            case 317: 
            case 323: 
            case 324: 
            case 327: 
            case 330: 
            case 332: 
            case 335: 
            case 339: 
            case 340: 
            case 348: 
            case 349: 
            case 352: 
            case 357: 
            case 373: 
            case 375: 
            case 377: 
            case 384: 
            case 388: 
            case 390: 
            case 392: 
            case 396: 
            case 410: 
            case 411: 
            case 426: 
            case 428: 
            case 433: 
            case 434: 
            case 437: 
            case 438: 
            case 441: 
            case 442: 
            case 445: 
            case 448: 
            case 451: 
            case 453: 
            case 456: 
            case 457: 
            case 458: 
            case 459: 
            case 460: 
            case 469: 
            case 473: {
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "newHashMap";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "newTreeMap";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "newLinkedHashMap";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "newTroveMap";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "newEnumMap";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "newLinkedList";
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "newArrayList";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "newUnmodifiableList";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "unmodifiableOrEmptyCollection";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "unmodifiableOrEmptyList";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "unmodifiableOrEmptySet";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "unmodifiableOrEmptyMap";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "newSmartList";
                break;
            }
            case 39: 
            case 40: 
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "newHashSet";
                break;
            }
            case 46: 
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "newLinkedHashSet";
                break;
            }
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "newTroveSet";
                break;
            }
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "newIdentityTroveSet";
                break;
            }
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "reverse";
                break;
            }
            case 60: 
            case 61: 
            case 63: 
            case 64: 
            case 65: 
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "union";
                break;
            }
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "immutableSet";
                break;
            }
            case 72: 
            case 74: {
                objectArray = objectArray;
                objectArray[2] = "immutableList";
                break;
            }
            case 75: 
            case 76: {
                objectArray = objectArray;
                objectArray[2] = "groupBy";
                break;
            }
            case 78: 
            case 355: 
            case 356: {
                objectArray = objectArray;
                objectArray[2] = "getOrElse";
                break;
            }
            case 79: 
            case 80: 
            case 282: 
            case 283: {
                objectArray = objectArray;
                objectArray[2] = "mapIterator";
                break;
            }
            case 81: 
            case 82: 
            case 273: 
            case 274: 
            case 276: 
            case 277: {
                objectArray = objectArray;
                objectArray[2] = "intersection";
                break;
            }
            case 84: 
            case 85: {
                objectArray = objectArray;
                objectArray[2] = "diff";
                break;
            }
            case 87: 
            case 88: 
            case 89: 
            case 90: {
                objectArray = objectArray;
                objectArray[2] = "processSortedListsInOrder";
                break;
            }
            case 91: 
            case 92: 
            case 93: {
                objectArray = objectArray;
                objectArray[2] = "mergeSortedLists";
                break;
            }
            case 95: {
                objectArray = objectArray;
                objectArray[2] = "subList";
                break;
            }
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 226: 
            case 227: 
            case 228: 
            case 229: {
                objectArray = objectArray;
                objectArray[2] = "addAll";
                break;
            }
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 231: 
            case 232: {
                objectArray = objectArray;
                objectArray[2] = "addAllNotNull";
                break;
            }
            case 107: 
            case 224: 
            case 225: {
                objectArray = objectArray;
                objectArray[2] = "collect";
                break;
            }
            case 109: 
            case 110: {
                objectArray = objectArray;
                objectArray[2] = "newMapFromKeys";
                break;
            }
            case 112: 
            case 113: {
                objectArray = objectArray;
                objectArray[2] = "newMapFromValues";
                break;
            }
            case 115: 
            case 116: 
            case 117: {
                objectArray = objectArray;
                objectArray[2] = "fillMapWithValues";
                break;
            }
            case 118: 
            case 119: {
                objectArray = objectArray;
                objectArray[2] = "classify";
                break;
            }
            case 123: 
            case 124: 
            case 133: 
            case 134: 
            case 135: 
            case 136: 
            case 137: 
            case 138: 
            case 139: 
            case 140: {
                objectArray = objectArray;
                objectArray[2] = "find";
                break;
            }
            case 125: 
            case 126: 
            case 127: 
            case 128: 
            case 129: 
            case 130: 
            case 131: 
            case 132: {
                objectArray = objectArray;
                objectArray[2] = "process";
                break;
            }
            case 141: 
            case 142: {
                objectArray = objectArray;
                objectArray[2] = "findLast";
                break;
            }
            case 143: 
            case 144: 
            case 145: 
            case 146: 
            case 153: {
                objectArray = objectArray;
                objectArray[2] = "map2Map";
                break;
            }
            case 148: 
            case 149: 
            case 150: 
            case 151: {
                objectArray = objectArray;
                objectArray[2] = "map2MapNotNull";
                break;
            }
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 159: 
            case 160: 
            case 161: 
            case 163: 
            case 164: 
            case 165: 
            case 167: 
            case 168: 
            case 169: {
                objectArray = objectArray;
                objectArray[2] = "map2Array";
                break;
            }
            case 171: 
            case 172: 
            case 173: 
            case 174: 
            case 181: 
            case 182: 
            case 183: 
            case 184: {
                objectArray = objectArray;
                objectArray[2] = "filter";
                break;
            }
            case 176: 
            case 177: 
            case 186: 
            case 187: 
            case 190: 
            case 191: 
            case 202: 
            case 203: {
                objectArray = objectArray;
                objectArray[2] = "findAll";
                break;
            }
            case 179: 
            case 180: {
                objectArray = objectArray;
                objectArray[2] = "filterIsInstance";
                break;
            }
            case 189: {
                objectArray = objectArray;
                objectArray[2] = "skipNulls";
                break;
            }
            case 192: 
            case 193: 
            case 195: 
            case 196: 
            case 198: 
            case 199: {
                objectArray = objectArray;
                objectArray[2] = "findAllAsArray";
                break;
            }
            case 205: 
            case 206: {
                objectArray = objectArray;
                objectArray[2] = "all";
                break;
            }
            case 207: {
                objectArray = objectArray;
                objectArray[2] = "removeDuplicates";
                break;
            }
            case 208: {
                objectArray = objectArray;
                objectArray[2] = "stringMap";
                break;
            }
            case 210: 
            case 212: 
            case 213: 
            case 214: 
            case 215: 
            case 216: {
                objectArray = objectArray;
                objectArray[2] = "iterate";
                break;
            }
            case 218: {
                objectArray = objectArray;
                objectArray[2] = "iterateBackward";
                break;
            }
            case 220: 
            case 221: {
                objectArray = objectArray;
                objectArray[2] = "zip";
                break;
            }
            case 223: {
                objectArray = objectArray;
                objectArray[2] = "swapElements";
                break;
            }
            case 234: 
            case 235: {
                objectArray = objectArray;
                objectArray[2] = "removeAll";
                break;
            }
            case 236: 
            case 237: {
                objectArray = objectArray;
                objectArray[2] = "retainAll";
                break;
            }
            case 238: 
            case 239: 
            case 240: 
            case 241: 
            case 242: 
            case 243: {
                objectArray = objectArray;
                objectArray[2] = "findInstance";
                break;
            }
            case 244: 
            case 245: 
            case 246: 
            case 252: 
            case 253: 
            case 257: 
            case 258: 
            case 259: 
            case 264: 
            case 266: 
            case 267: 
            case 268: 
            case 269: {
                objectArray = objectArray;
                objectArray[2] = "concat";
                break;
            }
            case 248: 
            case 249: {
                objectArray = objectArray;
                objectArray[2] = "append";
                break;
            }
            case 250: 
            case 251: {
                objectArray = objectArray;
                objectArray[2] = "prepend";
                break;
            }
            case 262: 
            case 263: {
                objectArray = objectArray;
                objectArray[2] = "concatIterators";
                break;
            }
            case 271: 
            case 272: {
                objectArray = objectArray;
                objectArray[2] = "intersects";
                break;
            }
            case 279: {
                objectArray = objectArray;
                objectArray[2] = "getFirstItems";
                break;
            }
            case 281: {
                objectArray = objectArray;
                objectArray[2] = "iterateAndGetLastItem";
                break;
            }
            case 284: 
            case 285: {
                objectArray = objectArray;
                objectArray[2] = "filterIterator";
                break;
            }
            case 286: 
            case 287: {
                objectArray = objectArray;
                objectArray[2] = "subtract";
                break;
            }
            case 289: 
            case 290: 
            case 292: 
            case 293: 
            case 294: 
            case 443: 
            case 444: 
            case 446: 
            case 447: {
                objectArray = objectArray;
                objectArray[2] = "toArray";
                break;
            }
            case 296: 
            case 297: 
            case 298: {
                objectArray = objectArray;
                objectArray[2] = "mergeCollectionsToArray";
                break;
            }
            case 300: 
            case 301: 
            case 302: 
            case 303: 
            case 310: 
            case 311: {
                objectArray = objectArray;
                objectArray[2] = "sort";
                break;
            }
            case 304: 
            case 305: 
            case 306: 
            case 307: 
            case 309: {
                objectArray = objectArray;
                objectArray[2] = "sorted";
                break;
            }
            case 312: 
            case 313: 
            case 315: 
            case 316: 
            case 333: 
            case 334: 
            case 336: 
            case 337: 
            case 338: {
                objectArray = objectArray;
                objectArray[2] = "map";
                break;
            }
            case 318: 
            case 319: 
            case 320: 
            case 321: 
            case 322: 
            case 325: 
            case 326: 
            case 328: 
            case 329: {
                objectArray = objectArray;
                objectArray[2] = "mapNotNull";
                break;
            }
            case 331: {
                objectArray = objectArray;
                objectArray[2] = "packNullables";
                break;
            }
            case 341: {
                objectArray = objectArray;
                objectArray[2] = "set";
                break;
            }
            case 342: {
                objectArray = objectArray;
                objectArray[2] = "putIfAbsent";
                break;
            }
            case 343: 
            case 344: 
            case 345: {
                objectArray = objectArray;
                objectArray[2] = "putIfNotNull";
                break;
            }
            case 346: 
            case 347: {
                objectArray = objectArray;
                objectArray[2] = "add";
                break;
            }
            case 350: 
            case 351: 
            case 353: 
            case 354: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreate";
                break;
            }
            case 358: 
            case 359: 
            case 360: 
            case 361: {
                objectArray = objectArray;
                objectArray[2] = "and";
                break;
            }
            case 362: 
            case 363: 
            case 364: 
            case 365: {
                objectArray = objectArray;
                objectArray[2] = "exists";
                break;
            }
            case 366: 
            case 367: 
            case 368: 
            case 369: {
                objectArray = objectArray;
                objectArray[2] = "or";
                break;
            }
            case 370: 
            case 371: {
                objectArray = objectArray;
                objectArray[2] = "count";
                break;
            }
            case 372: {
                objectArray = objectArray;
                objectArray[2] = "unfold";
                break;
            }
            case 374: {
                objectArray = objectArray;
                objectArray[2] = "dropTail";
                break;
            }
            case 376: {
                objectArray = objectArray;
                objectArray[2] = "list";
                break;
            }
            case 378: 
            case 379: 
            case 380: 
            case 381: {
                objectArray = objectArray;
                objectArray[2] = "quickSort";
                break;
            }
            case 382: {
                objectArray = objectArray;
                objectArray[2] = "med3";
                break;
            }
            case 383: {
                objectArray = objectArray;
                objectArray[2] = "singleton";
                break;
            }
            case 385: 
            case 389: {
                objectArray = objectArray;
                objectArray[2] = "flatten";
                break;
            }
            case 386: 
            case 387: {
                objectArray = objectArray;
                objectArray[2] = "removeDuplicatesFromSorted";
                break;
            }
            case 391: {
                objectArray = objectArray;
                objectArray[2] = "flattenIterables";
                break;
            }
            case 393: 
            case 394: 
            case 395: {
                objectArray = objectArray;
                objectArray[2] = "convert";
                break;
            }
            case 397: {
                objectArray = objectArray;
                objectArray[2] = "containsIdentity";
                break;
            }
            case 398: {
                objectArray = objectArray;
                objectArray[2] = "indexOfIdentity";
                break;
            }
            case 399: 
            case 400: {
                objectArray = objectArray;
                objectArray[2] = "equalsIdentity";
                break;
            }
            case 401: 
            case 402: {
                objectArray = objectArray;
                objectArray[2] = "indexOf";
                break;
            }
            case 403: 
            case 404: {
                objectArray = objectArray;
                objectArray[2] = "lastIndexOf";
                break;
            }
            case 405: 
            case 406: {
                objectArray = objectArray;
                objectArray[2] = "findLastInstance";
                break;
            }
            case 407: 
            case 408: {
                objectArray = objectArray;
                objectArray[2] = "lastIndexOfInstance";
                break;
            }
            case 409: {
                objectArray = objectArray;
                objectArray[2] = "reverseMap";
                break;
            }
            case 412: {
                objectArray = objectArray;
                objectArray[2] = "createLockFreeCopyOnWriteList";
                break;
            }
            case 413: {
                objectArray = objectArray;
                objectArray[2] = "createConcurrentWeakKeySoftValueMap";
                break;
            }
            case 414: {
                objectArray = objectArray;
                objectArray[2] = "createConcurrentSoftKeySoftValueMap";
                break;
            }
            case 415: {
                objectArray = objectArray;
                objectArray[2] = "createConcurrentWeakKeyWeakValueMap";
                break;
            }
            case 416: {
                objectArray = objectArray;
                objectArray[2] = "createConcurrentSoftMap";
                break;
            }
            case 417: 
            case 418: {
                objectArray = objectArray;
                objectArray[2] = "createConcurrentWeakMap";
                break;
            }
            case 419: {
                objectArray = objectArray;
                objectArray[2] = "createConcurrentList";
                break;
            }
            case 420: 
            case 421: {
                objectArray = objectArray;
                objectArray[2] = "addIfNotNull";
                break;
            }
            case 422: 
            case 423: 
            case 424: 
            case 425: 
            case 427: {
                objectArray = objectArray;
                objectArray[2] = "map2List";
                break;
            }
            case 429: 
            case 430: 
            case 431: 
            case 432: {
                objectArray = objectArray;
                objectArray[2] = "map2Set";
                break;
            }
            case 435: 
            case 436: {
                objectArray = objectArray;
                objectArray[2] = "map2LinkedSet";
                break;
            }
            case 439: 
            case 440: {
                objectArray = objectArray;
                objectArray[2] = "map2SetNotNull";
                break;
            }
            case 449: 
            case 450: {
                objectArray = objectArray;
                objectArray[2] = "copyAndClear";
                break;
            }
            case 452: {
                objectArray = objectArray;
                objectArray[2] = "copyList";
                break;
            }
            case 454: {
                objectArray = objectArray;
                objectArray[2] = "toCollection";
                break;
            }
            case 455: {
                objectArray = objectArray;
                objectArray[2] = "toList";
                break;
            }
            case 461: 
            case 462: {
                objectArray = objectArray;
                objectArray[2] = "startsWith";
                break;
            }
            case 463: 
            case 464: 
            case 465: 
            case 466: 
            case 467: {
                objectArray = objectArray;
                objectArray[2] = "compareLexicographically";
                break;
            }
            case 468: {
                objectArray = objectArray;
                objectArray[2] = "toString";
                break;
            }
            case 470: {
                objectArray = objectArray;
                objectArray[2] = "createSoftMap";
                break;
            }
            case 471: {
                objectArray = objectArray;
                objectArray[2] = "createWeakMap";
                break;
            }
            case 472: {
                objectArray = objectArray;
                objectArray[2] = "freeze";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 1: 
            case 5: 
            case 8: 
            case 13: 
            case 16: 
            case 17: 
            case 19: 
            case 23: 
            case 26: 
            case 27: 
            case 29: 
            case 31: 
            case 33: 
            case 34: 
            case 36: 
            case 37: 
            case 41: 
            case 44: 
            case 45: 
            case 47: 
            case 58: 
            case 62: 
            case 67: 
            case 69: 
            case 70: 
            case 71: 
            case 73: 
            case 77: 
            case 83: 
            case 86: 
            case 94: 
            case 96: 
            case 108: 
            case 111: 
            case 114: 
            case 120: 
            case 121: 
            case 122: 
            case 147: 
            case 152: 
            case 154: 
            case 162: 
            case 166: 
            case 170: 
            case 175: 
            case 178: 
            case 185: 
            case 188: 
            case 194: 
            case 197: 
            case 200: 
            case 201: 
            case 204: 
            case 209: 
            case 211: 
            case 217: 
            case 219: 
            case 222: 
            case 230: 
            case 233: 
            case 247: 
            case 254: 
            case 255: 
            case 256: 
            case 260: 
            case 261: 
            case 265: 
            case 270: 
            case 275: 
            case 278: 
            case 280: 
            case 288: 
            case 291: 
            case 295: 
            case 299: 
            case 308: 
            case 314: 
            case 317: 
            case 323: 
            case 324: 
            case 327: 
            case 330: 
            case 332: 
            case 335: 
            case 339: 
            case 340: 
            case 348: 
            case 349: 
            case 352: 
            case 357: 
            case 373: 
            case 375: 
            case 377: 
            case 384: 
            case 388: 
            case 390: 
            case 392: 
            case 396: 
            case 410: 
            case 411: 
            case 426: 
            case 428: 
            case 433: 
            case 434: 
            case 437: 
            case 438: 
            case 441: 
            case 442: 
            case 445: 
            case 448: 
            case 451: 
            case 453: 
            case 456: 
            case 457: 
            case 458: 
            case 459: 
            case 460: 
            case 469: 
            case 473: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ImmutableListBackedByArray<E>
    extends ImmutableList<E> {
        private final E[] myStore;

        private ImmutableListBackedByArray(@NotNull E[] array) {
            if (array == null) {
                ImmutableListBackedByArray.$$$reportNull$$$0(0);
            }
            this.myStore = array;
        }

        @Override
        public E get(int index2) {
            return this.myStore[index2];
        }

        @Override
        public int size() {
            return this.myStore.length;
        }

        @Override
        @NotNull
        public <T> T[] toArray(@NotNull T[] a) {
            int size;
            if (a == null) {
                ImmutableListBackedByArray.$$$reportNull$$$0(1);
            }
            T[] result2 = a.length >= (size = this.size()) ? a : ArrayUtil.newArray(ArrayUtil.getComponentType(a), size);
            System.arraycopy(this.myStore, 0, result2, 0, size);
            if (result2.length > size) {
                result2[size] = null;
            }
            if (result2 == null) {
                ImmutableListBackedByArray.$$$reportNull$$$0(2);
            }
            return result2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string2;
            switch (n) {
                default: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "array";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "a";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/util/containers/ContainerUtil$ImmutableListBackedByArray";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/util/containers/ContainerUtil$ImmutableListBackedByArray";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "toArray";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "toArray";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

