/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.text.input;

import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.text.AnnotatedString;
import androidx.compose.ui.text.TextRange;
import androidx.compose.ui.text.TextRangeKt;
import androidx.compose.ui.text.input.EditingBufferKt;
import androidx.compose.ui.text.input.PartialGapBuffer;
import androidx.compose.ui.text.internal.InlineClassHelperKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0010\f\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\f\b\u0007\u0018\u0000 =2\u00020\u0001:\u0001=B\u0017\b\u0010\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0007\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\bJ\r\u0010$\u001a\u00020%H\u0000\u00a2\u0006\u0002\b&J\r\u0010'\u001a\u00020%H\u0000\u00a2\u0006\u0002\b(J\u001d\u0010)\u001a\u00020%2\u0006\u0010*\u001a\u00020\r2\u0006\u0010+\u001a\u00020\rH\u0000\u00a2\u0006\u0002\b,J\u0016\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u00020\rH\u0080\u0002\u00a2\u0006\u0002\b0J\r\u00101\u001a\u000202H\u0000\u00a2\u0006\u0002\b3J%\u00104\u001a\u00020%2\u0006\u0010*\u001a\u00020\r2\u0006\u0010+\u001a\u00020\r2\u0006\u0010\u0002\u001a\u00020\u0007H\u0000\u00a2\u0006\u0002\b5J%\u00104\u001a\u00020%2\u0006\u0010*\u001a\u00020\r2\u0006\u0010+\u001a\u00020\r2\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u00a2\u0006\u0002\b5J\u001d\u00106\u001a\u00020%2\u0006\u0010*\u001a\u00020\r2\u0006\u0010+\u001a\u00020\rH\u0000\u00a2\u0006\u0002\b7J\u001d\u00108\u001a\u00020%2\u0006\u0010*\u001a\u00020\r2\u0006\u0010+\u001a\u00020\rH\u0000\u00a2\u0006\u0002\b9J\r\u0010:\u001a\u00020\u0007H\u0000\u00a2\u0006\u0002\b;J\b\u0010<\u001a\u00020\u0003H\u0016R\u001c\u0010\t\u001a\u0004\u0018\u00010\u00058@X\u0080\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u001e\u0010\u000e\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\r@BX\u0080\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001e\u0010\u0011\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\r@BX\u0080\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0010R$\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\r8@@@X\u0080\u000e\u00a2\u0006\f\u001a\u0004\b\u0014\u0010\u0010\"\u0004\b\u0015\u0010\u0016R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0019\u001a\u00020\r8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u0010R\u001a\u0010\u0004\u001a\u00020\u00058@X\u0080\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR$\u0010\u001e\u001a\u00020\r2\u0006\u0010\u001d\u001a\u00020\r@BX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010\u0010\"\u0004\b \u0010\u0016R$\u0010!\u001a\u00020\r2\u0006\u0010\u001d\u001a\u00020\r@BX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010\u0010\"\u0004\b#\u0010\u0016\u0082\u0002\u000b\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006>"}, d2={"Landroidx/compose/ui/text/input/EditingBuffer;", "", "text", "", "selection", "Landroidx/compose/ui/text/TextRange;", "(Ljava/lang/String;JLkotlin/jvm/internal/DefaultConstructorMarker;)V", "Landroidx/compose/ui/text/AnnotatedString;", "(Landroidx/compose/ui/text/AnnotatedString;JLkotlin/jvm/internal/DefaultConstructorMarker;)V", "composition", "getComposition-MzsxiRA$ui_text", "()Landroidx/compose/ui/text/TextRange;", "<set-?>", "", "compositionEnd", "getCompositionEnd$ui_text", "()I", "compositionStart", "getCompositionStart$ui_text", "cursor", "getCursor$ui_text", "setCursor$ui_text", "(I)V", "gapBuffer", "Landroidx/compose/ui/text/input/PartialGapBuffer;", "length", "getLength$ui_text", "getSelection-d9O1mEE$ui_text", "()J", "value", "selectionEnd", "getSelectionEnd$ui_text", "setSelectionEnd", "selectionStart", "getSelectionStart$ui_text", "setSelectionStart", "cancelComposition", "", "cancelComposition$ui_text", "commitComposition", "commitComposition$ui_text", "delete", "start", "end", "delete$ui_text", "get", "", "index", "get$ui_text", "hasComposition", "", "hasComposition$ui_text", "replace", "replace$ui_text", "setComposition", "setComposition$ui_text", "setSelection", "setSelection$ui_text", "toAnnotatedString", "toAnnotatedString$ui_text", "toString", "Companion", "ui-text"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nEditingBuffer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EditingBuffer.kt\nandroidx/compose/ui/text/input/EditingBuffer\n+ 2 InlineClassHelper.kt\nandroidx/compose/ui/text/internal/InlineClassHelperKt\n*L\n1#1,382:1\n114#2,8:383\n114#2,8:391\n*S KotlinDebug\n*F\n+ 1 EditingBuffer.kt\nandroidx/compose/ui/text/input/EditingBuffer\n*L\n50#1:383,8\n59#1:391,8\n*E\n"})
public final class EditingBuffer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PartialGapBuffer gapBuffer;
    private int selectionStart;
    private int selectionEnd;
    private int compositionStart;
    private int compositionEnd;
    public static final int $stable = 8;
    public static final int NOWHERE = -1;

    private EditingBuffer(AnnotatedString text, long selection) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        this.gapBuffer = new PartialGapBuffer(text.getText());
        this.selectionStart = TextRange.getMin-impl(selection);
        this.selectionEnd = TextRange.getMax-impl(selection);
        this.compositionStart = -1;
        this.compositionEnd = -1;
        int start = TextRange.getMin-impl(selection);
        int end = TextRange.getMax-impl(selection);
        if (start < 0 || start > text.length()) {
            throw new IndexOutOfBoundsException("start (" + start + ") offset is outside of text region " + text.length());
        }
        if (end < 0 || end > text.length()) {
            throw new IndexOutOfBoundsException("end (" + end + ") offset is outside of text region " + text.length());
        }
        if (start > end) {
            throw new IllegalArgumentException("Do not set reversed range: " + start + " > " + end);
        }
    }

    public final int getSelectionStart$ui_text() {
        return this.selectionStart;
    }

    private final void setSelectionStart(int value) {
        boolean value$iv = value >= 0;
        boolean $i$f$requirePrecondition = false;
        if (!value$iv) {
            boolean bl = false;
            InlineClassHelperKt.throwIllegalArgumentException("Cannot set selectionStart to a negative value: " + value);
        }
        this.selectionStart = value;
    }

    public final int getSelectionEnd$ui_text() {
        return this.selectionEnd;
    }

    private final void setSelectionEnd(int value) {
        boolean value$iv = value >= 0;
        boolean $i$f$requirePrecondition = false;
        if (!value$iv) {
            boolean bl = false;
            InlineClassHelperKt.throwIllegalArgumentException("Cannot set selectionEnd to a negative value: " + value);
        }
        this.selectionEnd = value;
    }

    public final int getCompositionStart$ui_text() {
        return this.compositionStart;
    }

    public final int getCompositionEnd$ui_text() {
        return this.compositionEnd;
    }

    public final boolean hasComposition$ui_text() {
        return this.compositionStart != -1;
    }

    @Nullable
    public final TextRange getComposition-MzsxiRA$ui_text() {
        return this.hasComposition$ui_text() ? TextRange.box-impl(TextRangeKt.TextRange(this.compositionStart, this.compositionEnd)) : null;
    }

    public final long getSelection-d9O1mEE$ui_text() {
        return TextRangeKt.TextRange(this.selectionStart, this.selectionEnd);
    }

    public final int getCursor$ui_text() {
        return this.selectionStart == this.selectionEnd ? this.selectionEnd : -1;
    }

    public final void setCursor$ui_text(int cursor) {
        this.setSelection$ui_text(cursor, cursor);
    }

    public final char get$ui_text(int index2) {
        return this.gapBuffer.get(index2);
    }

    public final int getLength$ui_text() {
        return this.gapBuffer.getLength();
    }

    private EditingBuffer(String text, long selection) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        this(new AnnotatedString(text, null, 2, null), selection, null);
    }

    public final void replace$ui_text(int start, int end, @NotNull AnnotatedString text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        this.replace$ui_text(start, end, text.getText());
    }

    public final void replace$ui_text(int start, int end, @NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        if (start < 0 || start > this.gapBuffer.getLength()) {
            throw new IndexOutOfBoundsException("start (" + start + ") offset is outside of text region " + this.gapBuffer.getLength());
        }
        if (end < 0 || end > this.gapBuffer.getLength()) {
            throw new IndexOutOfBoundsException("end (" + end + ") offset is outside of text region " + this.gapBuffer.getLength());
        }
        if (start > end) {
            throw new IllegalArgumentException("Do not set reversed range: " + start + " > " + end);
        }
        this.gapBuffer.replace(start, end, text);
        this.setSelectionStart(start + text.length());
        this.setSelectionEnd(start + text.length());
        this.compositionStart = -1;
        this.compositionEnd = -1;
    }

    public final void delete$ui_text(int start, int end) {
        long deleteRange = TextRangeKt.TextRange(start, end);
        this.gapBuffer.replace(start, end, "");
        long newSelection = EditingBufferKt.updateRangeAfterDelete-pWDy79M(TextRangeKt.TextRange(this.selectionStart, this.selectionEnd), deleteRange);
        this.setSelectionStart(TextRange.getMin-impl(newSelection));
        this.setSelectionEnd(TextRange.getMax-impl(newSelection));
        if (this.hasComposition$ui_text()) {
            long compositionRange = TextRangeKt.TextRange(this.compositionStart, this.compositionEnd);
            long newComposition = EditingBufferKt.updateRangeAfterDelete-pWDy79M(compositionRange, deleteRange);
            if (TextRange.getCollapsed-impl(newComposition)) {
                this.commitComposition$ui_text();
            } else {
                this.compositionStart = TextRange.getMin-impl(newComposition);
                this.compositionEnd = TextRange.getMax-impl(newComposition);
            }
        }
    }

    public final void setSelection$ui_text(int start, int end) {
        if (start < 0 || start > this.gapBuffer.getLength()) {
            throw new IndexOutOfBoundsException("start (" + start + ") offset is outside of text region " + this.gapBuffer.getLength());
        }
        if (end < 0 || end > this.gapBuffer.getLength()) {
            throw new IndexOutOfBoundsException("end (" + end + ") offset is outside of text region " + this.gapBuffer.getLength());
        }
        if (start > end) {
            throw new IllegalArgumentException("Do not set reversed range: " + start + " > " + end);
        }
        this.setSelectionStart(start);
        this.setSelectionEnd(end);
    }

    public final void setComposition$ui_text(int start, int end) {
        if (start < 0 || start > this.gapBuffer.getLength()) {
            throw new IndexOutOfBoundsException("start (" + start + ") offset is outside of text region " + this.gapBuffer.getLength());
        }
        if (end < 0 || end > this.gapBuffer.getLength()) {
            throw new IndexOutOfBoundsException("end (" + end + ") offset is outside of text region " + this.gapBuffer.getLength());
        }
        if (start >= end) {
            throw new IllegalArgumentException("Do not set reversed or empty range: " + start + " > " + end);
        }
        this.compositionStart = start;
        this.compositionEnd = end;
    }

    public final void cancelComposition$ui_text() {
        this.replace$ui_text(this.compositionStart, this.compositionEnd, "");
        this.compositionStart = -1;
        this.compositionEnd = -1;
    }

    public final void commitComposition$ui_text() {
        this.compositionStart = -1;
        this.compositionEnd = -1;
    }

    @NotNull
    public String toString() {
        return this.gapBuffer.toString();
    }

    @NotNull
    public final AnnotatedString toAnnotatedString$ui_text() {
        return new AnnotatedString(this.toString(), null, 2, null);
    }

    public /* synthetic */ EditingBuffer(AnnotatedString text, long selection, DefaultConstructorMarker $constructor_marker) {
        this(text, selection);
    }

    public /* synthetic */ EditingBuffer(String text, long selection, DefaultConstructorMarker $constructor_marker) {
        this(text, selection);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Landroidx/compose/ui/text/input/EditingBuffer$Companion;", "", "()V", "NOWHERE", "", "ui-text"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

