/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.text.input;

import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.text.AnnotatedString;
import androidx.compose.ui.text.AnnotatedStringKt;
import androidx.compose.ui.text.TextRange;
import androidx.compose.ui.text.TextRangeKt;
import androidx.compose.ui.text.input.BackspaceCommand;
import androidx.compose.ui.text.input.CommitTextCommand;
import androidx.compose.ui.text.input.DeleteAllCommand;
import androidx.compose.ui.text.input.DeleteSurroundingTextCommand;
import androidx.compose.ui.text.input.DeleteSurroundingTextInCodePointsCommand;
import androidx.compose.ui.text.input.EditCommand;
import androidx.compose.ui.text.input.EditingBuffer;
import androidx.compose.ui.text.input.FinishComposingTextCommand;
import androidx.compose.ui.text.input.MoveCursorCommand;
import androidx.compose.ui.text.input.SetComposingRegionCommand;
import androidx.compose.ui.text.input.SetComposingTextCommand;
import androidx.compose.ui.text.input.SetSelectionCommand;
import androidx.compose.ui.text.input.TextFieldValue;
import androidx.compose.ui.text.input.TextInputSession;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\f\u001a\u00020\b2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eJ \u0010\u0010\u001a\u00020\u00112\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\b\u0010\u0012\u001a\u0004\u0018\u00010\u000fH\u0002J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\b2\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017J\u0006\u0010\u0018\u001a\u00020\bJ\f\u0010\u0019\u001a\u00020\u0011*\u00020\u000fH\u0002R\u001e\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0004@BX\u0080\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001e\u0010\t\u001a\u00020\b2\u0006\u0010\u0003\u001a\u00020\b@BX\u0080\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u001a"}, d2={"Landroidx/compose/ui/text/input/EditProcessor;", "", "()V", "<set-?>", "Landroidx/compose/ui/text/input/EditingBuffer;", "mBuffer", "getMBuffer$ui_text", "()Landroidx/compose/ui/text/input/EditingBuffer;", "Landroidx/compose/ui/text/input/TextFieldValue;", "mBufferState", "getMBufferState$ui_text", "()Landroidx/compose/ui/text/input/TextFieldValue;", "apply", "editCommands", "", "Landroidx/compose/ui/text/input/EditCommand;", "generateBatchErrorMessage", "", "failedCommand", "reset", "", "value", "textInputSession", "Landroidx/compose/ui/text/input/TextInputSession;", "toTextFieldValue", "toStringForLog", "ui-text"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nEditProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EditProcessor.kt\nandroidx/compose/ui/text/input/EditProcessor\n+ 2 ListUtils.kt\nandroidx/compose/ui/util/ListUtilsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,182:1\n33#2,6:183\n1#3:189\n*S KotlinDebug\n*F\n+ 1 EditProcessor.kt\nandroidx/compose/ui/text/input/EditProcessor\n*L\n115#1:183,6\n*E\n"})
public final class EditProcessor {
    @NotNull
    private TextFieldValue mBufferState = new TextFieldValue(AnnotatedStringKt.emptyAnnotatedString(), TextRange.Companion.getZero-d9O1mEE(), null, null);
    @NotNull
    private EditingBuffer mBuffer = new EditingBuffer(this.mBufferState.getAnnotatedString(), this.mBufferState.getSelection-d9O1mEE(), null);
    public static final int $stable = 8;

    @NotNull
    public final TextFieldValue getMBufferState$ui_text() {
        return this.mBufferState;
    }

    @NotNull
    public final EditingBuffer getMBuffer$ui_text() {
        return this.mBuffer;
    }

    public final void reset(@NotNull TextFieldValue value, @Nullable TextInputSession textInputSession) {
        block8: {
            TextFieldValue textFieldValue;
            boolean compositionChanged;
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            boolean textChanged = false;
            boolean selectionChanged = false;
            boolean bl = compositionChanged = !Intrinsics.areEqual((Object)value.getComposition-MzsxiRA(), (Object)this.mBuffer.getComposition-MzsxiRA$ui_text());
            if (!Intrinsics.areEqual((Object)this.mBufferState.getAnnotatedString(), (Object)value.getAnnotatedString())) {
                this.mBuffer = new EditingBuffer(value.getAnnotatedString(), value.getSelection-d9O1mEE(), null);
                textChanged = true;
            } else if (!TextRange.equals-impl0(this.mBufferState.getSelection-d9O1mEE(), value.getSelection-d9O1mEE())) {
                this.mBuffer.setSelection$ui_text(TextRange.getMin-impl(value.getSelection-d9O1mEE()), TextRange.getMax-impl(value.getSelection-d9O1mEE()));
                selectionChanged = true;
            }
            if (value.getComposition-MzsxiRA() == null) {
                this.mBuffer.commitComposition$ui_text();
            } else if (!TextRange.getCollapsed-impl(value.getComposition-MzsxiRA().unbox-impl())) {
                this.mBuffer.setComposition$ui_text(TextRange.getMin-impl(value.getComposition-MzsxiRA().unbox-impl()), TextRange.getMax-impl(value.getComposition-MzsxiRA().unbox-impl()));
            }
            if (textChanged || !selectionChanged && compositionChanged) {
                this.mBuffer.commitComposition$ui_text();
                textFieldValue = TextFieldValue.copy-3r_uNRQ$default(value, null, 0L, null, 3, null);
            } else {
                textFieldValue = value;
            }
            TextFieldValue newValue = textFieldValue;
            TextFieldValue oldValue = this.mBufferState;
            this.mBufferState = newValue;
            TextInputSession textInputSession2 = textInputSession;
            if (textInputSession2 == null) break block8;
            textInputSession2.updateState(oldValue, newValue);
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final TextFieldValue apply(@NotNull List<? extends EditCommand> editCommands) {
        TextFieldValue newState;
        void $this$apply_u24lambda_u242;
        Intrinsics.checkNotNullParameter(editCommands, (String)"editCommands");
        EditCommand lastCommand = null;
        try {
            List<? extends EditCommand> $this$fastForEach$iv = editCommands;
            boolean $i$f$fastForEach = false;
            int n = $this$fastForEach$iv.size();
            for (int index$iv = 0; index$iv < n; ++index$iv) {
                EditCommand item$iv;
                EditCommand it = item$iv = $this$fastForEach$iv.get(index$iv);
                boolean bl = false;
                lastCommand = it;
                it.applyTo(this.mBuffer);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(this.generateBatchErrorMessage(editCommands, lastCommand), e);
        }
        long index$iv = this.mBuffer.getSelection-d9O1mEE$ui_text();
        AnnotatedString annotatedString = this.mBuffer.toAnnotatedString$ui_text();
        boolean bl = false;
        TextRange textRange = TextRange.box-impl((long)$this$apply_u24lambda_u242);
        long it = textRange.unbox-impl();
        boolean bl2 = false;
        TextRange textRange2 = !TextRange.getReversed-impl(this.mBufferState.getSelection-d9O1mEE()) ? textRange : null;
        long l = textRange2 != null ? textRange2.unbox-impl() : TextRangeKt.TextRange(TextRange.getMax-impl((long)$this$apply_u24lambda_u242), TextRange.getMin-impl((long)$this$apply_u24lambda_u242));
        DefaultConstructorMarker defaultConstructorMarker = null;
        TextRange textRange3 = this.mBuffer.getComposition-MzsxiRA$ui_text();
        long l2 = l;
        AnnotatedString annotatedString2 = annotatedString;
        this.mBufferState = newState = new TextFieldValue(annotatedString2, l2, textRange3, defaultConstructorMarker);
        return newState;
    }

    @NotNull
    public final TextFieldValue toTextFieldValue() {
        return this.mBufferState;
    }

    private final String generateBatchErrorMessage(List<? extends EditCommand> editCommands, EditCommand failedCommand) {
        StringBuilder stringBuilder;
        StringBuilder $this$generateBatchErrorMessage_u24lambda_u243 = stringBuilder = new StringBuilder();
        boolean bl = false;
        StringBuilder stringBuilder2 = $this$generateBatchErrorMessage_u24lambda_u243.append("Error while applying EditCommand batch to buffer (length=" + this.mBuffer.getLength$ui_text() + ", composition=" + this.mBuffer.getComposition-MzsxiRA$ui_text() + ", selection=" + TextRange.toString-impl(this.mBuffer.getSelection-d9O1mEE$ui_text()) + "):");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2.append('\n'), (String)"append(...)");
        CollectionsKt.joinTo$default((Iterable)editCommands, (Appendable)$this$generateBatchErrorMessage_u24lambda_u243, (CharSequence)"\n", null, null, (int)0, null, (Function1)((Function1)new Function1<EditCommand, CharSequence>(failedCommand, this){
            final /* synthetic */ EditCommand $failedCommand;
            final /* synthetic */ EditProcessor this$0;
            {
                this.$failedCommand = $failedCommand;
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final CharSequence invoke(@NotNull EditCommand it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                String prefix = this.$failedCommand == it ? " > " : "   ";
                return prefix + EditProcessor.access$toStringForLog(this.this$0, it);
            }
        }), (int)60, null);
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private final String toStringForLog(EditCommand $this$toStringForLog) {
        Object object;
        EditCommand editCommand = $this$toStringForLog;
        if (editCommand instanceof CommitTextCommand) {
            object = "CommitTextCommand(text.length=" + ((CommitTextCommand)$this$toStringForLog).getText().length() + ", newCursorPosition=" + ((CommitTextCommand)$this$toStringForLog).getNewCursorPosition() + ")";
        } else if (editCommand instanceof SetComposingTextCommand) {
            object = "SetComposingTextCommand(text.length=" + ((SetComposingTextCommand)$this$toStringForLog).getText().length() + ", newCursorPosition=" + ((SetComposingTextCommand)$this$toStringForLog).getNewCursorPosition() + ")";
        } else if (editCommand instanceof SetComposingRegionCommand) {
            object = $this$toStringForLog.toString();
        } else if (editCommand instanceof DeleteSurroundingTextCommand) {
            object = $this$toStringForLog.toString();
        } else if (editCommand instanceof DeleteSurroundingTextInCodePointsCommand) {
            object = $this$toStringForLog.toString();
        } else if (editCommand instanceof SetSelectionCommand) {
            object = $this$toStringForLog.toString();
        } else if (editCommand instanceof FinishComposingTextCommand) {
            object = $this$toStringForLog.toString();
        } else if (editCommand instanceof BackspaceCommand) {
            object = $this$toStringForLog.toString();
        } else if (editCommand instanceof MoveCursorCommand) {
            object = $this$toStringForLog.toString();
        } else if (editCommand instanceof DeleteAllCommand) {
            object = $this$toStringForLog.toString();
        } else {
            String string = Reflection.getOrCreateKotlinClass($this$toStringForLog.getClass()).getSimpleName();
            if (string == null) {
                string = "{anonymous EditCommand}";
            }
            object = "Unknown EditCommand: " + string;
        }
        return object;
    }

    public static final /* synthetic */ String access$toStringForLog(EditProcessor $this, EditCommand $receiver) {
        return $this.toStringForLog($receiver);
    }
}

