/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.text;

import androidx.compose.ui.geometry.Offset;
import androidx.compose.ui.geometry.Rect;
import androidx.compose.ui.geometry.SizeKt;
import androidx.compose.ui.graphics.Brush;
import androidx.compose.ui.graphics.Canvas;
import androidx.compose.ui.graphics.Rects_skikoKt;
import androidx.compose.ui.graphics.Shadow;
import androidx.compose.ui.graphics.SkiaBackedCanvas_skikoKt;
import androidx.compose.ui.graphics.SkiaBackedPath_skikoKt;
import androidx.compose.ui.graphics.drawscope.DrawStyle;
import androidx.compose.ui.text.CharHelpers_jvmKt;
import androidx.compose.ui.text.CharHelpers_skikoKt;
import androidx.compose.ui.text.ExperimentalTextApi;
import androidx.compose.ui.text.Paragraph;
import androidx.compose.ui.text.ParagraphIntrinsics;
import androidx.compose.ui.text.SkiaParagraph_skikoKt;
import androidx.compose.ui.text.TextRangeKt;
import androidx.compose.ui.text.platform.ParagraphLayouter;
import androidx.compose.ui.text.platform.SkiaParagraphIntrinsics;
import androidx.compose.ui.text.style.ResolvedTextDirection;
import androidx.compose.ui.text.style.TextDecoration;
import androidx.compose.ui.unit.Constraints;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.skia.FontMetrics;
import org.jetbrains.skia.Path;
import org.jetbrains.skia.paragraph.Direction;
import org.jetbrains.skia.paragraph.LineMetrics;
import org.jetbrains.skia.paragraph.RectHeightMode;
import org.jetbrains.skia.paragraph.RectWidthMode;
import org.jetbrains.skia.paragraph.StrutStyle;
import org.jetbrains.skia.paragraph.TextBox;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u00be\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0015\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001B(\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\nJ\u0011\u00109\u001a\u00020:2\u0006\u0010;\u001a\u00020\u0005H\u0082\bJ\u0010\u0010<\u001a\u00020=2\u0006\u0010;\u001a\u00020\u0005H\u0016J\u0010\u0010>\u001a\u0002012\u0006\u0010;\u001a\u00020\u0005H\u0016J\u001c\u0010?\u001a\u0004\u0018\u00010@2\u0006\u0010;\u001a\u00020\u00052\b\b\u0002\u0010A\u001a\u00020\u0005H\u0002J\u0012\u0010B\u001a\u0004\u0018\u00010@2\u0006\u0010;\u001a\u00020\u0005H\u0002J\u0010\u0010C\u001a\u0002012\u0006\u0010;\u001a\u00020\u0005H\u0016J\u0018\u0010D\u001a\u00020\u00152\u0006\u0010;\u001a\u00020\u00052\u0006\u0010E\u001a\u00020\u0007H\u0016J\u0010\u0010F\u001a\u00020\u00152\u0006\u0010G\u001a\u00020\u0005H\u0016J\u0018\u0010H\u001a\u00020\u00052\u0006\u0010G\u001a\u00020\u00052\u0006\u0010I\u001a\u00020\u0007H\u0016J\u0010\u0010J\u001a\u00020\u00052\u0006\u0010;\u001a\u00020\u0005H\u0016J\u0010\u0010K\u001a\u00020\u00052\u0006\u0010L\u001a\u00020\u0015H\u0016J\u0010\u0010M\u001a\u00020\u00152\u0006\u0010G\u001a\u00020\u0005H\u0016J\u0010\u0010N\u001a\u00020\u00152\u0006\u0010G\u001a\u00020\u0005H\u0016J\u0012\u0010O\u001a\u0004\u0018\u00010#2\u0006\u0010L\u001a\u00020\u0015H\u0002J\u0010\u0010P\u001a\u00020\u00152\u0006\u0010G\u001a\u00020\u0005H\u0016J\u0010\u0010Q\u001a\u00020\u00052\u0006\u0010G\u001a\u00020\u0005H\u0016J\u0010\u0010R\u001a\u00020\u00152\u0006\u0010G\u001a\u00020\u0005H\u0016J\u0010\u0010S\u001a\u00020\u00152\u0006\u0010G\u001a\u00020\u0005H\u0016J\u001d\u0010T\u001a\u00020\u00052\u0006\u0010U\u001a\u00020VH\u0016\u00f8\u0001\u0001\u00f8\u0001\u0000\u00a2\u0006\u0004\bW\u0010XJ\u0010\u0010Y\u001a\u00020=2\u0006\u0010;\u001a\u00020\u0005H\u0016J\u0018\u0010Z\u001a\u00020[2\u0006\u0010\\\u001a\u00020\u00052\u0006\u0010A\u001a\u00020\u0005H\u0016J \u0010]\u001a\u00020^2\u0006\u0010;\u001a\u00020\u0005H\u0016\u00f8\u0001\u0002\u00f8\u0001\u0001\u00f8\u0001\u0000\u00a2\u0006\u0004\b_\u0010`J\u0010\u0010a\u001a\u00020\u00072\u0006\u0010G\u001a\u00020\u0005H\u0016J\u0012\u0010b\u001a\u0004\u0018\u00010#2\u0006\u0010;\u001a\u00020\u0005H\u0002JS\u0010c\u001a\u00020:2\u0006\u0010d\u001a\u00020e2\u0006\u0010f\u001a\u00020g2\u0006\u0010h\u001a\u00020\u00152\b\u0010i\u001a\u0004\u0018\u00010j2\b\u0010k\u001a\u0004\u0018\u00010l2\b\u0010m\u001a\u0004\u0018\u00010n2\u0006\u0010o\u001a\u00020pH\u0017\u00f8\u0001\u0001\u00f8\u0001\u0000\u00a2\u0006\u0004\bq\u0010rJ9\u0010c\u001a\u00020:2\u0006\u0010d\u001a\u00020e2\u0006\u0010s\u001a\u00020t2\b\u0010i\u001a\u0004\u0018\u00010j2\b\u0010k\u001a\u0004\u0018\u00010lH\u0016\u00f8\u0001\u0001\u00f8\u0001\u0000\u00a2\u0006\u0004\bu\u0010vJK\u0010c\u001a\u00020:2\u0006\u0010d\u001a\u00020e2\u0006\u0010s\u001a\u00020t2\b\u0010i\u001a\u0004\u0018\u00010j2\b\u0010k\u001a\u0004\u0018\u00010l2\b\u0010m\u001a\u0004\u0018\u00010n2\u0006\u0010o\u001a\u00020pH\u0017\u00f8\u0001\u0001\u00f8\u0001\u0000\u00a2\u0006\u0004\bw\u0010xR\u001c\u0010\b\u001a\u00020\t\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\n\n\u0002\u0010\r\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\u000e\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0010R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\u00020\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0018\u001a\u00020\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0017R\u0014\u0010\u001a\u001a\u00020\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u0017R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001e\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 R\u001a\u0010!\u001a\b\u0012\u0004\u0012\u00020#0\"8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010%R\u0014\u0010&\u001a\u00020\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b'\u0010\u0017R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010 R\u0014\u0010)\u001a\u00020\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b*\u0010\u0017R\u000e\u0010+\u001a\u00020,X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010-\u001a\u00020.X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010/\u001a\n\u0012\u0006\u0012\u0004\u0018\u000101008VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b2\u00103R\u0014\u00104\u001a\u00020\u00138BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b5\u00106R\u0014\u00107\u001a\u00020\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b8\u0010\u0017\u0082\u0002\u000f\n\u0002\b\u0019\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006y"}, d2={"Landroidx/compose/ui/text/SkiaParagraph;", "Landroidx/compose/ui/text/Paragraph;", "intrinsics", "Landroidx/compose/ui/text/ParagraphIntrinsics;", "maxLines", "", "ellipsis", "", "constraints", "Landroidx/compose/ui/unit/Constraints;", "(Landroidx/compose/ui/text/ParagraphIntrinsics;IZJLkotlin/jvm/internal/DefaultConstructorMarker;)V", "getConstraints-msEJaDk", "()J", "J", "didExceedMaxLines", "getDidExceedMaxLines", "()Z", "getEllipsis", "ellipsisChar", "", "firstBaseline", "", "getFirstBaseline", "()F", "height", "getHeight", "lastBaseline", "getLastBaseline", "layouter", "Landroidx/compose/ui/text/platform/ParagraphLayouter;", "lineCount", "getLineCount", "()I", "lineMetrics", "", "Lorg/jetbrains/skia/paragraph/LineMetrics;", "getLineMetrics", "()[Lorg/jetbrains/skia/paragraph/LineMetrics;", "maxIntrinsicWidth", "getMaxIntrinsicWidth", "getMaxLines", "minIntrinsicWidth", "getMinIntrinsicWidth", "paragraph", "Lorg/jetbrains/skia/paragraph/Paragraph;", "paragraphIntrinsics", "Landroidx/compose/ui/text/platform/SkiaParagraphIntrinsics;", "placeholderRects", "", "Landroidx/compose/ui/geometry/Rect;", "getPlaceholderRects", "()Ljava/util/List;", "text", "getText", "()Ljava/lang/String;", "width", "getWidth", "checkOffsetIsValid", "", "offset", "getBidiRunDirection", "Landroidx/compose/ui/text/style/ResolvedTextDirection;", "getBoundingBox", "getBoxBackwardByOffset", "Lorg/jetbrains/skia/paragraph/TextBox;", "end", "getBoxForwardByOffset", "getCursorRect", "getHorizontalPosition", "usePrimaryDirection", "getLineBottom", "lineIndex", "getLineEnd", "visibleEnd", "getLineForOffset", "getLineForVerticalPosition", "vertical", "getLineHeight", "getLineLeft", "getLineMetricsForVerticalPosition", "getLineRight", "getLineStart", "getLineTop", "getLineWidth", "getOffsetForPosition", "position", "Landroidx/compose/ui/geometry/Offset;", "getOffsetForPosition-k-4lQ0M", "(J)I", "getParagraphDirection", "getPathForRange", "Landroidx/compose/ui/graphics/Path;", "start", "getWordBoundary", "Landroidx/compose/ui/text/TextRange;", "getWordBoundary--jx7JFs", "(I)J", "isLineEllipsized", "lineMetricsForOffset", "paint", "canvas", "Landroidx/compose/ui/graphics/Canvas;", "brush", "Landroidx/compose/ui/graphics/Brush;", "alpha", "shadow", "Landroidx/compose/ui/graphics/Shadow;", "textDecoration", "Landroidx/compose/ui/text/style/TextDecoration;", "drawStyle", "Landroidx/compose/ui/graphics/drawscope/DrawStyle;", "blendMode", "Landroidx/compose/ui/graphics/BlendMode;", "paint-hn5TExg", "(Landroidx/compose/ui/graphics/Canvas;Landroidx/compose/ui/graphics/Brush;FLandroidx/compose/ui/graphics/Shadow;Landroidx/compose/ui/text/style/TextDecoration;Landroidx/compose/ui/graphics/drawscope/DrawStyle;I)V", "color", "Landroidx/compose/ui/graphics/Color;", "paint-RPmYEkk", "(Landroidx/compose/ui/graphics/Canvas;JLandroidx/compose/ui/graphics/Shadow;Landroidx/compose/ui/text/style/TextDecoration;)V", "paint-LG529CI", "(Landroidx/compose/ui/graphics/Canvas;JLandroidx/compose/ui/graphics/Shadow;Landroidx/compose/ui/text/style/TextDecoration;Landroidx/compose/ui/graphics/drawscope/DrawStyle;I)V", "ui-text"})
@SourceDebugExtension(value={"SMAP\nSkiaParagraph.skiko.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SkiaParagraph.skiko.kt\nandroidx/compose/ui/text/SkiaParagraph\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,527:1\n520#1,4:533\n520#1,4:539\n520#1,4:543\n520#1,4:547\n1#2:528\n11335#3:529\n11670#3,3:530\n1282#3,2:537\n*S KotlinDebug\n*F\n+ 1 SkiaParagraph.skiko.kt\nandroidx/compose/ui/text/SkiaParagraph\n*L\n169#1:533,4\n270#1:539,4\n286#1:543,4\n421#1:547,4\n100#1:529\n100#1:530,3\n221#1:537,2\n*E\n"})
public final class SkiaParagraph
implements Paragraph {
    private final int maxLines;
    private final boolean ellipsis;
    private final long constraints;
    @NotNull
    private final String ellipsisChar;
    @NotNull
    private final SkiaParagraphIntrinsics paragraphIntrinsics;
    @NotNull
    private final ParagraphLayouter layouter;
    @NotNull
    private org.jetbrains.skia.paragraph.Paragraph paragraph;

    /*
     * WARNING - void declaration
     */
    private SkiaParagraph(ParagraphIntrinsics intrinsics, int maxLines, boolean ellipsis, long constraints) {
        void $this$layouter_u24lambda_u240;
        ParagraphLayouter paragraphLayouter;
        Intrinsics.checkNotNullParameter((Object)intrinsics, (String)"intrinsics");
        this.maxLines = maxLines;
        this.ellipsis = ellipsis;
        this.constraints = constraints;
        this.ellipsisChar = this.ellipsis ? "\u2026" : "";
        this.paragraphIntrinsics = (SkiaParagraphIntrinsics)intrinsics;
        ParagraphLayouter paragraphLayouter2 = paragraphLayouter = this.paragraphIntrinsics.layouter();
        SkiaParagraph skiaParagraph = this;
        boolean bl = false;
        $this$layouter_u24lambda_u240.setParagraphStyle(this.maxLines, this.ellipsisChar);
        skiaParagraph.layouter = paragraphLayouter;
        this.paragraph = this.layouter.layoutParagraph(this.getWidth());
        this.paragraph.layout(this.getWidth());
    }

    public final int getMaxLines() {
        return this.maxLines;
    }

    public final boolean getEllipsis() {
        return this.ellipsis;
    }

    public final long getConstraints-msEJaDk() {
        return this.constraints;
    }

    private final String getText() {
        return this.paragraphIntrinsics.getText();
    }

    @Override
    public float getWidth() {
        return Constraints.getMaxWidth-impl((long)this.constraints);
    }

    @Override
    public float getHeight() {
        return this.paragraph.getHeight();
    }

    @Override
    public float getMinIntrinsicWidth() {
        return this.paragraphIntrinsics.getMinIntrinsicWidth();
    }

    @Override
    public float getMaxIntrinsicWidth() {
        return this.paragraphIntrinsics.getMaxIntrinsicWidth();
    }

    @Override
    public float getFirstBaseline() {
        float f;
        LineMetrics lineMetrics = (LineMetrics)ArraysKt.firstOrNull((Object[])this.getLineMetrics());
        if (lineMetrics != null) {
            LineMetrics $this$_get_firstBaseline__u24lambda_u241 = lineMetrics;
            boolean bl = false;
            f = (float)$this$_get_firstBaseline__u24lambda_u241.getBaseline();
        } else {
            f = 0.0f;
        }
        return f;
    }

    @Override
    public float getLastBaseline() {
        float f;
        LineMetrics lineMetrics = (LineMetrics)ArraysKt.lastOrNull((Object[])this.getLineMetrics());
        if (lineMetrics != null) {
            LineMetrics $this$_get_lastBaseline__u24lambda_u242 = lineMetrics;
            boolean bl = false;
            f = (float)$this$_get_lastBaseline__u24lambda_u242.getBaseline();
        } else {
            f = 0.0f;
        }
        return f;
    }

    @Override
    public boolean getDidExceedMaxLines() {
        return this.paragraph.didExceedMaxLines();
    }

    @Override
    public int getLineCount() {
        return Intrinsics.areEqual((Object)this.getText(), (Object)"") || this.paragraph.getLineNumber() < 1 ? 1 : this.paragraph.getLineNumber();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<Rect> getPlaceholderRects() {
        void $this$mapTo$iv$iv;
        TextBox[] $this$map$iv = this.paragraph.getRectsForPlaceholders();
        boolean $i$f$map = false;
        TextBox[] textBoxArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        int n = ((void)$this$mapTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void it;
            void item$iv$iv;
            void var9_9 = item$iv$iv = $this$mapTo$iv$iv[i];
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(Rects_skikoKt.toComposeRect((org.jetbrains.skia.Rect)it.getRect()));
        }
        return (List)destination$iv$iv;
    }

    @Override
    @NotNull
    public androidx.compose.ui.graphics.Path getPathForRange(int start2, int end) {
        TextBox[] boxes = this.paragraph.getRectsForRange(start2, end, RectHeightMode.MAX, RectWidthMode.TIGHT);
        androidx.compose.ui.graphics.Path path = SkiaBackedPath_skikoKt.Path();
        for (TextBox b : boxes) {
            Path.addRect$default((Path)SkiaBackedPath_skikoKt.asSkiaPath((androidx.compose.ui.graphics.Path)path), (org.jetbrains.skia.Rect)b.getRect(), null, (int)0, (int)6, null);
        }
        return path;
    }

    @Override
    @NotNull
    public Rect getCursorRect(int offset) {
        double d;
        double d2;
        float horizontal = this.getHorizontalPosition(offset, true);
        LineMetrics lineMetrics = this.lineMetricsForOffset(offset);
        Intrinsics.checkNotNull((Object)lineMetrics);
        LineMetrics line = lineMetrics;
        boolean isNewEmptyLine = offset - 1 == line.getStartIndex() && offset == this.getText().length();
        FontMetrics metrics = this.layouter.getDefaultFont().getMetrics();
        double it = line.getAscent();
        boolean bl = false;
        if (isNewEmptyLine) {
            double ascent = -((double)metrics.getAscent());
            d2 = RangesKt.coerceAtMost((double)it, (double)ascent);
        } else {
            d2 = it;
        }
        double asc = d2;
        double it2 = line.getDescent();
        boolean bl2 = false;
        if (isNewEmptyLine) {
            double descent = metrics.getDescent();
            d = RangesKt.coerceAtMost((double)it2, (double)descent);
        } else {
            d = it2;
        }
        double desc = d;
        return new Rect(horizontal, (float)(line.getBaseline() - asc), horizontal, (float)(line.getBaseline() + desc));
    }

    @Override
    public float getLineLeft(int lineIndex) {
        LineMetrics lineMetrics = (LineMetrics)ArraysKt.getOrNull((Object[])this.getLineMetrics(), (int)lineIndex);
        return lineMetrics != null ? (float)lineMetrics.getLeft() : 0.0f;
    }

    @Override
    public float getLineRight(int lineIndex) {
        LineMetrics lineMetrics = (LineMetrics)ArraysKt.getOrNull((Object[])this.getLineMetrics(), (int)lineIndex);
        return lineMetrics != null ? (float)lineMetrics.getRight() : 0.0f;
    }

    @Override
    public float getLineTop(int lineIndex) {
        float f;
        LineMetrics lineMetrics = (LineMetrics)ArraysKt.getOrNull((Object[])this.getLineMetrics(), (int)lineIndex);
        if (lineMetrics != null) {
            LineMetrics line = lineMetrics;
            boolean bl = false;
            f = (float)Math.floor((float)(line.getBaseline() - line.getAscent()));
        } else {
            f = 0.0f;
        }
        return f;
    }

    @Override
    public float getLineBottom(int lineIndex) {
        float f;
        LineMetrics lineMetrics = (LineMetrics)ArraysKt.getOrNull((Object[])this.getLineMetrics(), (int)lineIndex);
        if (lineMetrics != null) {
            LineMetrics line = lineMetrics;
            boolean bl = false;
            f = (float)Math.floor((float)(line.getBaseline() + line.getDescent()));
        } else {
            f = 0.0f;
        }
        return f;
    }

    private final LineMetrics lineMetricsForOffset(int offset) {
        SkiaParagraph this_$iv = this;
        boolean $i$f$checkOffsetIsValid = false;
        if (!(0 <= offset ? offset <= this_$iv.getText().length() : false)) {
            boolean bl = false;
            String string = "Invalid offset: " + offset + ". Valid range is [0, " + this_$iv.getText().length() + ']';
            throw new IllegalArgumentException(string.toString());
        }
        Object[] metrics = this.getLineMetrics();
        int n = metrics.length;
        for (int i = 0; i < n; ++i) {
            LineMetrics line = metrics[i];
            if (offset >= line.getEndIncludingNewline()) continue;
            return line;
        }
        if (metrics.length == 0) {
            return null;
        }
        return (LineMetrics)ArraysKt.last((Object[])metrics);
    }

    @Override
    public float getLineHeight(int lineIndex) {
        LineMetrics lineMetrics = (LineMetrics)ArraysKt.getOrNull((Object[])this.getLineMetrics(), (int)lineIndex);
        return lineMetrics != null ? (float)lineMetrics.getHeight() : 0.0f;
    }

    @Override
    public float getLineWidth(int lineIndex) {
        LineMetrics lineMetrics = (LineMetrics)ArraysKt.getOrNull((Object[])this.getLineMetrics(), (int)lineIndex);
        return lineMetrics != null ? (float)lineMetrics.getWidth() : 0.0f;
    }

    @Override
    public int getLineStart(int lineIndex) {
        LineMetrics lineMetrics = (LineMetrics)ArraysKt.getOrNull((Object[])this.getLineMetrics(), (int)lineIndex);
        return lineMetrics != null ? lineMetrics.getStartIndex() : 0;
    }

    @Override
    public int getLineEnd(int lineIndex, boolean visibleEnd) {
        LineMetrics lineMetrics = (LineMetrics)ArraysKt.getOrNull((Object[])this.getLineMetrics(), (int)lineIndex);
        if (lineMetrics == null) {
            return 0;
        }
        LineMetrics metrics = lineMetrics;
        return visibleEnd ? (lineIndex > 0 && metrics.getStartIndex() < this.getLineMetrics()[lineIndex - 1].getEndIndex() ? metrics.getEndIndex() : (metrics.getStartIndex() < this.getText().length() && this.getText().charAt(metrics.getStartIndex()) == '\n' ? metrics.getStartIndex() : metrics.getEndExcludingWhitespaces())) : metrics.getEndIndex();
    }

    @Override
    public boolean isLineEllipsized(int lineIndex) {
        return false;
    }

    @Override
    public int getLineForOffset(int offset) {
        LineMetrics lineMetrics = this.lineMetricsForOffset(offset);
        return lineMetrics != null ? lineMetrics.getLineNumber() : 0;
    }

    @Override
    public int getLineForVerticalPosition(float vertical) {
        LineMetrics lineMetrics = this.getLineMetricsForVerticalPosition(vertical);
        return lineMetrics != null ? lineMetrics.getLineNumber() : 0;
    }

    private final LineMetrics getLineMetricsForVerticalPosition(float vertical) {
        LineMetrics lineMetrics;
        block1: {
            LineMetrics[] $this$firstOrNull$iv = this.getLineMetrics();
            boolean $i$f$firstOrNull = false;
            int n = $this$firstOrNull$iv.length;
            for (int i = 0; i < n; ++i) {
                LineMetrics element$iv;
                LineMetrics it = element$iv = $this$firstOrNull$iv[i];
                boolean bl = false;
                if (!((double)vertical < it.getBaseline() + it.getDescent())) continue;
                lineMetrics = element$iv;
                break block1;
            }
            lineMetrics = null;
        }
        return lineMetrics;
    }

    @Override
    public float getHorizontalPosition(int offset, boolean usePrimaryDirection) {
        float f;
        TextBox prevBox = SkiaParagraph.getBoxBackwardByOffset$default(this, offset, 0, 2, null);
        TextBox nextBox = this.getBoxForwardByOffset(offset);
        boolean isRtl = this.paragraphIntrinsics.getTextDirection() == ResolvedTextDirection.Rtl;
        boolean isLtr = !isRtl;
        if (prevBox == null && nextBox == null) {
            f = isRtl ? this.getWidth() : 0.0f;
        } else if (prevBox == null) {
            TextBox textBox = nextBox;
            Intrinsics.checkNotNull((Object)textBox);
            f = androidx.compose.ui.text.platform.SkiaParagraph_skikoKt.cursorHorizontalPosition(textBox, true);
        } else {
            f = nextBox == null ? androidx.compose.ui.text.platform.SkiaParagraph_skikoKt.cursorHorizontalPosition$default(prevBox, false, 1, null) : (nextBox.getDirection() == prevBox.getDirection() ? androidx.compose.ui.text.platform.SkiaParagraph_skikoKt.cursorHorizontalPosition(nextBox, true) : (isLtr && prevBox.getDirection() == Direction.LTR ? androidx.compose.ui.text.platform.SkiaParagraph_skikoKt.cursorHorizontalPosition(nextBox, true) : (isRtl && prevBox.getDirection() == Direction.RTL ? androidx.compose.ui.text.platform.SkiaParagraph_skikoKt.cursorHorizontalPosition(nextBox, true) : (usePrimaryDirection ? androidx.compose.ui.text.platform.SkiaParagraph_skikoKt.cursorHorizontalPosition$default(prevBox, false, 1, null) : androidx.compose.ui.text.platform.SkiaParagraph_skikoKt.cursorHorizontalPosition(nextBox, true)))));
        }
        return f;
    }

    private final LineMetrics[] getLineMetrics() {
        LineMetrics[] lineMetricsArray;
        if (Intrinsics.areEqual((Object)this.getText(), (Object)"")) {
            FontMetrics metrics = this.layouter.getDefaultFont().getMetrics();
            double ascent = -((double)metrics.getAscent());
            double descent = metrics.getDescent();
            double baseline = this.paragraph.getAlphabeticBaseline();
            StrutStyle $this$_get_lineMetrics__u24lambda_u249 = this.layouter.getParagraphStyle().getStrutStyle();
            boolean bl = false;
            double height = $this$_get_lineMetrics__u24lambda_u249.isEnabled() && !$this$_get_lineMetrics__u24lambda_u249.isHeightForced() && $this$_get_lineMetrics__u24lambda_u249.isHeightOverridden() && $this$_get_lineMetrics__u24lambda_u249.getFontSize() > 0.0f ? (double)($this$_get_lineMetrics__u24lambda_u249.getHeight() * $this$_get_lineMetrics__u24lambda_u249.getFontSize()) : ascent + descent;
            LineMetrics[] lineMetricsArray2 = new LineMetrics[]{new LineMetrics(0, 0, 0, 0, true, ascent, descent, ascent, height, 0.0, 0.0, baseline, 0)};
            lineMetricsArray = lineMetricsArray2;
        } else {
            lineMetricsArray = this.paragraph.getLineMetrics();
        }
        return lineMetricsArray;
    }

    private final TextBox getBoxForwardByOffset(int offset) {
        SkiaParagraph this_$iv = this;
        boolean $i$f$checkOffsetIsValid = false;
        if (!(0 <= offset ? offset <= this_$iv.getText().length() : false)) {
            boolean bl = false;
            String string = "Invalid offset: " + offset + ". Valid range is [0, " + this_$iv.getText().length() + ']';
            throw new IllegalArgumentException(string.toString());
        }
        for (int to = offset + 1; to <= this.getText().length(); ++to) {
            TextBox box = (TextBox)ArraysKt.firstOrNull((Object[])this.paragraph.getRectsForRange(offset, to, RectHeightMode.STRUT, RectWidthMode.TIGHT));
            if (box == null) continue;
            return box;
        }
        return null;
    }

    private final TextBox getBoxBackwardByOffset(int offset, int end) {
        boolean isRtl;
        SkiaParagraph this_$iv = this;
        boolean $i$f$checkOffsetIsValid = false;
        if (!(0 <= offset ? offset <= this_$iv.getText().length() : false)) {
            boolean $i$a$-require-SkiaParagraph$checkOffsetIsValid$1$iv22 = false;
            String $i$a$-require-SkiaParagraph$checkOffsetIsValid$1$iv22 = "Invalid offset: " + offset + ". Valid range is [0, " + this_$iv.getText().length() + ']';
            throw new IllegalArgumentException($i$a$-require-SkiaParagraph$checkOffsetIsValid$1$iv22.toString());
        }
        boolean bl = isRtl = this.paragraphIntrinsics.getTextDirection() == ResolvedTextDirection.Rtl;
        for (int from = offset - 1; from >= 0; --from) {
            TextBox box = (TextBox)ArraysKt.firstOrNull((Object[])this.paragraph.getRectsForRange(from, end, RectHeightMode.STRUT, RectWidthMode.TIGHT));
            if (box == null) {
                continue;
            }
            if (this.getText().charAt(from) == '\n') {
                TextBox textBox;
                if (!isRtl) {
                    float bottom = box.getRect().getBottom() + box.getRect().getBottom() - box.getRect().getTop();
                    org.jetbrains.skia.Rect rect = new org.jetbrains.skia.Rect(0.0f, box.getRect().getBottom(), 0.0f, bottom);
                    return new TextBox(rect, box.getDirection());
                }
                if (from == StringsKt.getLastIndex((CharSequence)this.getText())) {
                    float bottom = box.getRect().getBottom() + box.getRect().getBottom() - box.getRect().getTop();
                    org.jetbrains.skia.Rect rect = new org.jetbrains.skia.Rect(this.getWidth(), box.getRect().getBottom(), this.getWidth(), bottom);
                    textBox = new TextBox(rect, box.getDirection());
                } else {
                    TextBox nextBox = (TextBox)ArraysKt.first((Object[])this.paragraph.getRectsForRange(offset, offset + 1, RectHeightMode.STRUT, RectWidthMode.TIGHT));
                    org.jetbrains.skia.Rect rect = new org.jetbrains.skia.Rect(nextBox.getRect().getLeft(), nextBox.getRect().getTop(), nextBox.getRect().getLeft(), nextBox.getRect().getBottom());
                    textBox = new TextBox(rect, nextBox.getDirection());
                }
                return textBox;
            }
            return box;
        }
        return null;
    }

    static /* synthetic */ TextBox getBoxBackwardByOffset$default(SkiaParagraph skiaParagraph, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n2 = n;
        }
        return skiaParagraph.getBoxBackwardByOffset(n, n2);
    }

    @Override
    @NotNull
    public ResolvedTextDirection getParagraphDirection(int offset) {
        return this.paragraphIntrinsics.getTextDirection();
    }

    @Override
    @NotNull
    public ResolvedTextDirection getBidiRunDirection(int offset) {
        ResolvedTextDirection resolvedTextDirection;
        TextBox textBox = this.getBoxForwardByOffset(offset);
        Object object = textBox != null ? textBox.getDirection() : null;
        switch (object == null ? -1 : WhenMappings.$EnumSwitchMapping$0[object.ordinal()]) {
            case 1: {
                resolvedTextDirection = ResolvedTextDirection.Rtl;
                break;
            }
            case 2: {
                resolvedTextDirection = ResolvedTextDirection.Ltr;
                break;
            }
            case -1: {
                resolvedTextDirection = ResolvedTextDirection.Ltr;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return resolvedTextDirection;
    }

    @Override
    public int getOffsetForPosition-k-4lQ0M(long position) {
        float rightX;
        boolean isNotEmptyLine;
        int glyphPosition = this.paragraph.getGlyphPositionAtCoordinate(Offset.getX-impl((long)position), Offset.getY-impl((long)position)).getPosition();
        LineMetrics lineMetrics = this.getLineMetricsForVerticalPosition(Offset.getY-impl((long)position));
        if (lineMetrics == null) {
            return glyphPosition;
        }
        LineMetrics expectedLine = lineMetrics;
        boolean bl = isNotEmptyLine = expectedLine.getStartIndex() < expectedLine.getEndIndex();
        if ((double)Offset.getX-impl((long)position) > expectedLine.getLeft() && (double)Offset.getX-impl((long)position) < expectedLine.getRight()) {
            return glyphPosition;
        }
        Object rects = isNotEmptyLine ? this.paragraph.getRectsForRange(expectedLine.getStartIndex(), expectedLine.isHardBreak() ? expectedLine.getEndIndex() : expectedLine.getEndIndex() - 1, RectHeightMode.STRUT, RectWidthMode.TIGHT) : null;
        TextBox textBox = rects;
        float leftX = textBox != null && (textBox = (TextBox[])ArraysKt.firstOrNull(textBox)) != null && (textBox = textBox.getRect()) != null ? textBox.getLeft() : (float)expectedLine.getLeft();
        TextBox textBox2 = rects;
        float f = rightX = textBox2 != null && (textBox2 = (TextBox)ArraysKt.lastOrNull((Object[])textBox2)) != null && (textBox2 = textBox2.getRect()) != null ? textBox2.getRight() : (float)expectedLine.getRight();
        if (leftX == rightX) {
            return glyphPosition;
        }
        int correctedGlyphPosition = glyphPosition;
        if (Offset.getX-impl((long)position) <= leftX) {
            correctedGlyphPosition = this.paragraph.getGlyphPositionAtCoordinate(leftX + 1.0f, Offset.getY-impl((long)position)).getPosition();
        } else if (Offset.getX-impl((long)position) >= rightX) {
            boolean isNeutralChar;
            correctedGlyphPosition = this.paragraph.getGlyphPositionAtCoordinate(rightX - 1.0f, Offset.getY-impl((long)position)).getPosition();
            boolean bl2 = isNeutralChar = (0 <= correctedGlyphPosition ? correctedGlyphPosition < this.getText().length() : false) ? CharHelpers_jvmKt.isNeutralDirection(CharHelpers_skikoKt.codePointAt(this.getText(), correctedGlyphPosition)) : false;
            if (!isNeutralChar) {
                TextBox textBox3 = SkiaParagraph.getBoxBackwardByOffset$default(this, correctedGlyphPosition, 0, 2, null);
                if ((textBox3 != null ? textBox3.getDirection() : null) == Direction.RTL) {
                    --correctedGlyphPosition;
                }
            }
        }
        return correctedGlyphPosition;
    }

    @Override
    @NotNull
    public Rect getBoundingBox(int offset) {
        TextBox textBox = this.getBoxForwardByOffset(offset);
        if (textBox == null) {
            TextBox textBox2 = this.getBoxBackwardByOffset(offset, this.getText().length());
            textBox = textBox2;
            Intrinsics.checkNotNull((Object)textBox2);
        }
        TextBox box = textBox;
        return Rects_skikoKt.toComposeRect((org.jetbrains.skia.Rect)box.getRect());
    }

    @Override
    public long getWordBoundary--jx7JFs(int offset) {
        SkiaParagraph this_$iv = this;
        boolean $i$f$checkOffsetIsValid = false;
        if (!(0 <= offset ? offset <= this_$iv.getText().length() : false)) {
            boolean bl = false;
            String string = "Invalid offset: " + offset + ". Valid range is [0, " + this_$iv.getText().length() + ']';
            throw new IllegalArgumentException(string.toString());
        }
        if (offset < this.getText().length() && CharsKt.isWhitespace((char)this.getText().charAt(offset)) || offset == this.getText().length()) {
            return offset > 0 && !CharsKt.isWhitespace((char)this.getText().charAt(offset - 1)) ? SkiaParagraph_skikoKt.access$toTextRange(this.paragraph.getWordBoundary(offset - 1)) : TextRangeKt.TextRange(offset, offset);
        }
        return SkiaParagraph_skikoKt.access$toTextRange(this.paragraph.getWordBoundary(offset));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void paint-RPmYEkk(@NotNull Canvas canvas, long color, @Nullable Shadow shadow, @Nullable TextDecoration textDecoration) {
        void $this$paint_RPmYEkk_u24lambda_u2410;
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        ParagraphLayouter paragraphLayouter = this.layouter;
        SkiaParagraph skiaParagraph = this;
        boolean bl = false;
        $this$paint_RPmYEkk_u24lambda_u2410.setTextStyle-ek8zF_U(color, shadow, textDecoration);
        skiaParagraph.paragraph = $this$paint_RPmYEkk_u24lambda_u2410.layoutParagraph(this.getWidth());
        this.paragraph.paint(SkiaBackedCanvas_skikoKt.getNativeCanvas((Canvas)canvas), 0.0f, 0.0f);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @ExperimentalTextApi
    public void paint-LG529CI(@NotNull Canvas canvas, long color, @Nullable Shadow shadow, @Nullable TextDecoration textDecoration, @Nullable DrawStyle drawStyle, int blendMode) {
        void $this$paint_LG529CI_u24lambda_u2411;
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        ParagraphLayouter paragraphLayouter = this.layouter;
        SkiaParagraph skiaParagraph = this;
        boolean bl = false;
        $this$paint_LG529CI_u24lambda_u2411.setTextStyle-ek8zF_U(color, shadow, textDecoration);
        $this$paint_LG529CI_u24lambda_u2411.setDrawStyle(drawStyle);
        $this$paint_LG529CI_u24lambda_u2411.setBlendMode-s9anfk8(blendMode);
        skiaParagraph.paragraph = $this$paint_LG529CI_u24lambda_u2411.layoutParagraph(this.getWidth());
        this.paragraph.paint(SkiaBackedCanvas_skikoKt.getNativeCanvas((Canvas)canvas), 0.0f, 0.0f);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @ExperimentalTextApi
    public void paint-hn5TExg(@NotNull Canvas canvas, @NotNull Brush brush, float alpha, @Nullable Shadow shadow, @Nullable TextDecoration textDecoration, @Nullable DrawStyle drawStyle, int blendMode) {
        void $this$paint_hn5TExg_u24lambda_u2412;
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        Intrinsics.checkNotNullParameter((Object)brush, (String)"brush");
        ParagraphLayouter paragraphLayouter = this.layouter;
        SkiaParagraph skiaParagraph = this;
        boolean bl = false;
        $this$paint_hn5TExg_u24lambda_u2412.setTextStyle-eZhPAX0(brush, SizeKt.Size((float)this.getWidth(), (float)this.getHeight()), alpha, shadow, textDecoration);
        $this$paint_hn5TExg_u24lambda_u2412.setDrawStyle(drawStyle);
        $this$paint_hn5TExg_u24lambda_u2412.setBlendMode-s9anfk8(blendMode);
        skiaParagraph.paragraph = $this$paint_hn5TExg_u24lambda_u2412.layoutParagraph(this.getWidth());
        this.paragraph.paint(SkiaBackedCanvas_skikoKt.getNativeCanvas((Canvas)canvas), 0.0f, 0.0f);
    }

    private final void checkOffsetIsValid(int offset) {
        boolean $i$f$checkOffsetIsValid = false;
        if (!(0 <= offset ? offset <= this.getText().length() : false)) {
            boolean bl = false;
            String string = "Invalid offset: " + offset + ". Valid range is [0, " + this.getText().length() + ']';
            throw new IllegalArgumentException(string.toString());
        }
    }

    public /* synthetic */ SkiaParagraph(ParagraphIntrinsics intrinsics, int maxLines, boolean ellipsis, long constraints, DefaultConstructorMarker $constructor_marker) {
        this(intrinsics, maxLines, ellipsis, constraints);
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Direction.values().length];
            try {
                nArray[Direction.RTL.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.LTR.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

