/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.text.platform;

import androidx.compose.ui.geometry.Offset;
import androidx.compose.ui.geometry.Rect;
import androidx.compose.ui.graphics.Canvas;
import androidx.compose.ui.graphics.Rects_skikoKt;
import androidx.compose.ui.graphics.Shadow;
import androidx.compose.ui.graphics.SkiaBackedCanvas_skikoKt;
import androidx.compose.ui.graphics.SkiaBackedPath_skikoKt;
import androidx.compose.ui.text.Paragraph;
import androidx.compose.ui.text.ParagraphIntrinsics;
import androidx.compose.ui.text.TextRangeKt;
import androidx.compose.ui.text.platform.ParagraphLayouter;
import androidx.compose.ui.text.platform.SkiaParagraphIntrinsics;
import androidx.compose.ui.text.platform.SkiaParagraph_skikoKt;
import androidx.compose.ui.text.style.ResolvedTextDirection;
import androidx.compose.ui.text.style.TextDecoration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.skia.IRange;
import org.jetbrains.skia.Path;
import org.jetbrains.skia.paragraph.Direction;
import org.jetbrains.skia.paragraph.LineMetrics;
import org.jetbrains.skia.paragraph.RectHeightMode;
import org.jetbrains.skia.paragraph.RectWidthMode;
import org.jetbrains.skia.paragraph.TextBox;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u00a0\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0014\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0010\u00104\u001a\u0002052\u0006\u00106\u001a\u00020\u0005H\u0016J\u0010\u00107\u001a\u00020-2\u0006\u00106\u001a\u00020\u0005H\u0016J\u001c\u00108\u001a\u0004\u0018\u0001092\u0006\u00106\u001a\u00020\u00052\b\b\u0002\u0010:\u001a\u00020\u0005H\u0002J\u0012\u0010;\u001a\u0004\u0018\u0001092\u0006\u00106\u001a\u00020\u0005H\u0002J\u0010\u0010<\u001a\u00020-2\u0006\u00106\u001a\u00020\u0005H\u0016J\u0018\u0010=\u001a\u00020\t2\u0006\u00106\u001a\u00020\u00052\u0006\u0010>\u001a\u00020\u0007H\u0016J\u0010\u0010?\u001a\u00020\t2\u0006\u0010@\u001a\u00020\u0005H\u0016J\u0018\u0010A\u001a\u00020\u00052\u0006\u0010@\u001a\u00020\u00052\u0006\u0010B\u001a\u00020\u0007H\u0016J\u0010\u0010C\u001a\u00020\u00052\u0006\u00106\u001a\u00020\u0005H\u0016J\u0010\u0010D\u001a\u00020\u00052\u0006\u0010E\u001a\u00020\tH\u0016J\u0010\u0010F\u001a\u00020\t2\u0006\u0010@\u001a\u00020\u0005H\u0016J\u0010\u0010G\u001a\u00020\t2\u0006\u0010@\u001a\u00020\u0005H\u0016J\u0010\u0010H\u001a\u00020\t2\u0006\u0010@\u001a\u00020\u0005H\u0016J\u0010\u0010I\u001a\u00020\u00052\u0006\u0010@\u001a\u00020\u0005H\u0016J\u0010\u0010J\u001a\u00020\t2\u0006\u0010@\u001a\u00020\u0005H\u0016J\u0010\u0010K\u001a\u00020\t2\u0006\u0010@\u001a\u00020\u0005H\u0016J\u001d\u0010L\u001a\u00020\u00052\u0006\u0010M\u001a\u00020NH\u0016\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\bO\u0010PJ\u0010\u0010Q\u001a\u0002052\u0006\u00106\u001a\u00020\u0005H\u0016J\u0018\u0010R\u001a\u00020S2\u0006\u0010T\u001a\u00020\u00052\u0006\u0010:\u001a\u00020\u0005H\u0016J \u0010U\u001a\u00020V2\u0006\u00106\u001a\u00020\u0005H\u0016\u00f8\u0001\u0000\u00f8\u0001\u0002\u00f8\u0001\u0001\u00a2\u0006\u0004\bW\u0010XJ\u0010\u0010Y\u001a\u00020\u00072\u0006\u0010@\u001a\u00020\u0005H\u0016J\u0012\u0010Z\u001a\u0004\u0018\u00010\u001f2\u0006\u00106\u001a\u00020\u0005H\u0002J9\u0010[\u001a\u00020\\2\u0006\u0010]\u001a\u00020^2\u0006\u0010_\u001a\u00020`2\b\u0010a\u001a\u0004\u0018\u00010b2\b\u0010c\u001a\u0004\u0018\u00010dH\u0016\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\be\u0010fR\u0014\u0010\u000b\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\rR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0013R\u0014\u0010\u0016\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0013R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001a\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u001a\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010!R\u0014\u0010\"\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010\u0013R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010\u001cR\u0014\u0010%\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b&\u0010\u0013R\u000e\u0010'\u001a\u00020(X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010)\u001a\u00020*X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010+\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010-0,8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b.\u0010/R\u0014\u00100\u001a\u00020\u00108BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b1\u00102R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b3\u0010\u0013\u0082\u0002\u000f\n\u0002\b\u0019\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006g"}, d2={"Landroidx/compose/ui/text/platform/SkiaParagraph;", "Landroidx/compose/ui/text/Paragraph;", "intrinsics", "Landroidx/compose/ui/text/ParagraphIntrinsics;", "maxLines", "", "ellipsis", "", "width", "", "(Landroidx/compose/ui/text/ParagraphIntrinsics;IZF)V", "didExceedMaxLines", "getDidExceedMaxLines", "()Z", "getEllipsis", "ellipsisChar", "", "firstBaseline", "getFirstBaseline", "()F", "height", "getHeight", "lastBaseline", "getLastBaseline", "layouter", "Landroidx/compose/ui/text/platform/ParagraphLayouter;", "lineCount", "getLineCount", "()I", "lineMetrics", "", "Lorg/jetbrains/skia/paragraph/LineMetrics;", "getLineMetrics", "()[Lorg/jetbrains/skia/paragraph/LineMetrics;", "maxIntrinsicWidth", "getMaxIntrinsicWidth", "getMaxLines", "minIntrinsicWidth", "getMinIntrinsicWidth", "para", "Lorg/jetbrains/skia/paragraph/Paragraph;", "paragraphIntrinsics", "Landroidx/compose/ui/text/platform/SkiaParagraphIntrinsics;", "placeholderRects", "", "Landroidx/compose/ui/geometry/Rect;", "getPlaceholderRects", "()Ljava/util/List;", "text", "getText", "()Ljava/lang/String;", "getWidth", "getBidiRunDirection", "Landroidx/compose/ui/text/style/ResolvedTextDirection;", "offset", "getBoundingBox", "getBoxBackwardByOffset", "Lorg/jetbrains/skia/paragraph/TextBox;", "end", "getBoxForwardByOffset", "getCursorRect", "getHorizontalPosition", "usePrimaryDirection", "getLineBottom", "lineIndex", "getLineEnd", "visibleEnd", "getLineForOffset", "getLineForVerticalPosition", "vertical", "getLineHeight", "getLineLeft", "getLineRight", "getLineStart", "getLineTop", "getLineWidth", "getOffsetForPosition", "position", "Landroidx/compose/ui/geometry/Offset;", "getOffsetForPosition-k-4lQ0M", "(J)I", "getParagraphDirection", "getPathForRange", "Landroidx/compose/ui/graphics/Path;", "start", "getWordBoundary", "Landroidx/compose/ui/text/TextRange;", "getWordBoundary--jx7JFs", "(I)J", "isLineEllipsized", "lineMetricsForOffset", "paint", "", "canvas", "Landroidx/compose/ui/graphics/Canvas;", "color", "Landroidx/compose/ui/graphics/Color;", "shadow", "Landroidx/compose/ui/graphics/Shadow;", "textDecoration", "Landroidx/compose/ui/text/style/TextDecoration;", "paint-RPmYEkk", "(Landroidx/compose/ui/graphics/Canvas;JLandroidx/compose/ui/graphics/Shadow;Landroidx/compose/ui/text/style/TextDecoration;)V", "ui-text"})
public final class SkiaParagraph
implements Paragraph {
    private final int maxLines;
    private final boolean ellipsis;
    private final float width;
    @NotNull
    private final String ellipsisChar;
    @NotNull
    private final SkiaParagraphIntrinsics paragraphIntrinsics;
    @NotNull
    private final ParagraphLayouter layouter;
    @NotNull
    private org.jetbrains.skia.paragraph.Paragraph para;

    public SkiaParagraph(@NotNull ParagraphIntrinsics intrinsics, int maxLines, boolean ellipsis, float width) {
        Intrinsics.checkNotNullParameter((Object)intrinsics, (String)"intrinsics");
        this.maxLines = maxLines;
        this.ellipsis = ellipsis;
        this.width = width;
        this.ellipsisChar = this.ellipsis ? "\u2026" : "";
        this.paragraphIntrinsics = (SkiaParagraphIntrinsics)intrinsics;
        this.layouter = this.paragraphIntrinsics.layouter();
        this.para = ParagraphLayouter.layoutParagraph-Bx497Mc$default(this.layouter, this.getWidth(), this.maxLines, this.ellipsisChar, 0L, null, null, 56, null);
        this.para.layout(this.getWidth());
    }

    public final int getMaxLines() {
        return this.maxLines;
    }

    public final boolean getEllipsis() {
        return this.ellipsis;
    }

    @Override
    public float getWidth() {
        return this.width;
    }

    private final String getText() {
        return this.paragraphIntrinsics.getText();
    }

    @Override
    public float getHeight() {
        return this.para.getHeight();
    }

    @Override
    public float getMinIntrinsicWidth() {
        return this.paragraphIntrinsics.getMinIntrinsicWidth();
    }

    @Override
    public float getMaxIntrinsicWidth() {
        return this.paragraphIntrinsics.getMaxIntrinsicWidth();
    }

    @Override
    public float getFirstBaseline() {
        float f;
        LineMetrics lineMetrics = (LineMetrics)ArraysKt.firstOrNull((Object[])this.getLineMetrics());
        if (lineMetrics == null) {
            f = 0.0f;
        } else {
            float f2;
            LineMetrics $this$_get_firstBaseline__u24lambda_u2d0 = lineMetrics;
            boolean bl = false;
            f = f2 = (float)$this$_get_firstBaseline__u24lambda_u2d0.getBaseline();
        }
        return f;
    }

    @Override
    public float getLastBaseline() {
        float f;
        LineMetrics lineMetrics = (LineMetrics)ArraysKt.lastOrNull((Object[])this.getLineMetrics());
        if (lineMetrics == null) {
            f = 0.0f;
        } else {
            float f2;
            LineMetrics $this$_get_lastBaseline__u24lambda_u2d1 = lineMetrics;
            boolean bl = false;
            f = f2 = (float)$this$_get_lastBaseline__u24lambda_u2d1.getBaseline();
        }
        return f;
    }

    @Override
    public boolean getDidExceedMaxLines() {
        return this.para.didExceedMaxLines();
    }

    @Override
    public int getLineCount() {
        return Intrinsics.areEqual((Object)this.getText(), (Object)"") ? 1 : this.para.getLineNumber();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<Rect> getPlaceholderRects() {
        void $this$mapTo$iv$iv;
        TextBox[] $this$map$iv = this.para.getRectsForPlaceholders();
        boolean $i$f$map = false;
        TextBox[] textBoxArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        for (void item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            void var10_10 = item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(Rects_skikoKt.toComposeRect((org.jetbrains.skia.Rect)it.getRect()));
        }
        return (List)destination$iv$iv;
    }

    @Override
    @NotNull
    public androidx.compose.ui.graphics.Path getPathForRange(int start, int end) {
        TextBox[] boxes = this.para.getRectsForRange(start, end, RectHeightMode.MAX, RectWidthMode.MAX);
        androidx.compose.ui.graphics.Path path = SkiaBackedPath_skikoKt.Path();
        for (TextBox b : boxes) {
            Path.addRect$default((Path)SkiaBackedPath_skikoKt.asSkiaPath((androidx.compose.ui.graphics.Path)path), (org.jetbrains.skia.Rect)b.getRect(), null, (int)0, (int)6, null);
        }
        return path;
    }

    @Override
    @NotNull
    public Rect getCursorRect(int offset) {
        float horizontal = this.getHorizontalPosition(offset, true);
        LineMetrics lineMetrics = this.lineMetricsForOffset(offset);
        Intrinsics.checkNotNull((Object)lineMetrics);
        LineMetrics line = lineMetrics;
        return new Rect(horizontal, (float)(line.getBaseline() - line.getAscent()), horizontal, (float)(line.getBaseline() + line.getDescent()));
    }

    @Override
    public float getLineLeft(int lineIndex) {
        float f;
        LineMetrics lineMetrics = (LineMetrics)ArraysKt.getOrNull((Object[])this.getLineMetrics(), (int)lineIndex);
        if (lineMetrics == null) {
            f = 0.0f;
        } else {
            float f2;
            double d = lineMetrics.getLeft();
            f = f2 = (float)d;
        }
        return f;
    }

    @Override
    public float getLineRight(int lineIndex) {
        float f;
        LineMetrics lineMetrics = (LineMetrics)ArraysKt.getOrNull((Object[])this.getLineMetrics(), (int)lineIndex);
        if (lineMetrics == null) {
            f = 0.0f;
        } else {
            float f2;
            double d = lineMetrics.getRight();
            f = f2 = (float)d;
        }
        return f;
    }

    @Override
    public float getLineTop(int lineIndex) {
        float f;
        LineMetrics lineMetrics = (LineMetrics)ArraysKt.getOrNull((Object[])this.getLineMetrics(), (int)lineIndex);
        if (lineMetrics == null) {
            f = 0.0f;
        } else {
            float f2;
            LineMetrics line = lineMetrics;
            boolean bl = false;
            f = f2 = (float)Math.floor((float)(line.getBaseline() - line.getAscent()));
        }
        return f;
    }

    @Override
    public float getLineBottom(int lineIndex) {
        float f;
        LineMetrics lineMetrics = (LineMetrics)ArraysKt.getOrNull((Object[])this.getLineMetrics(), (int)lineIndex);
        if (lineMetrics == null) {
            f = 0.0f;
        } else {
            float f2;
            LineMetrics line = lineMetrics;
            boolean bl = false;
            f = f2 = (float)Math.floor((float)(line.getBaseline() + line.getDescent()));
        }
        return f;
    }

    private final LineMetrics lineMetricsForOffset(int offset) {
        Object[] metrics = this.getLineMetrics();
        int n = metrics.length;
        for (int i = 0; i < n; ++i) {
            LineMetrics line = metrics[i];
            if (offset >= line.getEndIncludingNewline()) continue;
            return line;
        }
        if (metrics.length == 0) {
            return null;
        }
        return (LineMetrics)ArraysKt.last((Object[])metrics);
    }

    @Override
    public float getLineHeight(int lineIndex) {
        return (float)this.getLineMetrics()[lineIndex].getHeight();
    }

    @Override
    public float getLineWidth(int lineIndex) {
        return (float)this.getLineMetrics()[lineIndex].getWidth();
    }

    @Override
    public int getLineStart(int lineIndex) {
        return this.getLineMetrics()[lineIndex].getStartIndex();
    }

    @Override
    public int getLineEnd(int lineIndex, boolean visibleEnd) {
        int n;
        if (visibleEnd) {
            LineMetrics metrics = this.getLineMetrics()[lineIndex];
            n = lineIndex > 0 && metrics.getStartIndex() < this.getLineMetrics()[lineIndex - 1].getEndIndex() ? metrics.getEndIndex() : (metrics.getStartIndex() < this.getText().length() && this.getText().charAt(metrics.getStartIndex()) == '\n' ? metrics.getStartIndex() : metrics.getEndExcludingWhitespaces());
        } else {
            n = this.getLineMetrics()[lineIndex].getEndIndex();
        }
        return n;
    }

    @Override
    public boolean isLineEllipsized(int lineIndex) {
        return false;
    }

    @Override
    public int getLineForOffset(int offset) {
        int n;
        LineMetrics lineMetrics = this.lineMetricsForOffset(offset);
        if (lineMetrics == null) {
            n = 0;
        } else {
            int n2;
            LineMetrics $this$getLineForOffset_u24lambda_u2d5 = lineMetrics;
            boolean bl = false;
            n = n2 = $this$getLineForOffset_u24lambda_u2d5.getLineNumber();
        }
        return n;
    }

    @Override
    public int getLineForVerticalPosition(float vertical) {
        System.out.println((Object)Intrinsics.stringPlus((String)"Paragraph.getLineForVerticalPosition ", (Object)Float.valueOf(vertical)));
        return 0;
    }

    @Override
    public float getHorizontalPosition(int offset, boolean usePrimaryDirection) {
        float f;
        TextBox prevBox = SkiaParagraph.getBoxBackwardByOffset$default(this, offset, 0, 2, null);
        TextBox nextBox = this.getBoxForwardByOffset(offset);
        if (prevBox == null && nextBox == null) {
            f = 0.0f;
        } else if (prevBox == null) {
            TextBox textBox = nextBox;
            Intrinsics.checkNotNull((Object)textBox);
            f = SkiaParagraph_skikoKt.cursorHorizontalPosition(textBox, true);
        } else {
            f = nextBox == null ? SkiaParagraph_skikoKt.cursorHorizontalPosition$default(prevBox, false, 1, null) : (nextBox.getDirection() == prevBox.getDirection() ? SkiaParagraph_skikoKt.cursorHorizontalPosition(nextBox, true) : (usePrimaryDirection ? SkiaParagraph_skikoKt.cursorHorizontalPosition$default(prevBox, false, 1, null) : SkiaParagraph_skikoKt.cursorHorizontalPosition(nextBox, true)));
        }
        return f;
    }

    private final LineMetrics[] getLineMetrics() {
        LineMetrics[] lineMetricsArray;
        if (Intrinsics.areEqual((Object)this.getText(), (Object)"")) {
            double height = this.layouter.getDefaultHeight();
            LineMetrics[] lineMetricsArray2 = new LineMetrics[]{new LineMetrics(0, 0, 0, 0, true, height, 0.0, height, height, 0.0, 0.0, height, 0)};
            lineMetricsArray = lineMetricsArray2;
        } else {
            lineMetricsArray = this.para.getLineMetrics();
        }
        return lineMetricsArray;
    }

    private final TextBox getBoxForwardByOffset(int offset) {
        for (int to = offset + 1; to <= this.getText().length(); ++to) {
            TextBox box = (TextBox)ArraysKt.firstOrNull((Object[])this.para.getRectsForRange(offset, to, RectHeightMode.STRUT, RectWidthMode.TIGHT));
            if (box == null) continue;
            return box;
        }
        return null;
    }

    private final TextBox getBoxBackwardByOffset(int offset, int end) {
        for (int from = offset - 1; from >= 0; --from) {
            TextBox box = (TextBox)ArraysKt.firstOrNull((Object[])this.para.getRectsForRange(from, end, RectHeightMode.STRUT, RectWidthMode.TIGHT));
            if (box == null) {
                continue;
            }
            if (this.getText().charAt(from) == '\n') {
                float bottom = box.getRect().getBottom() + box.getRect().getBottom() - box.getRect().getTop();
                org.jetbrains.skia.Rect rect = new org.jetbrains.skia.Rect(0.0f, box.getRect().getBottom(), 0.0f, bottom);
                return new TextBox(rect, box.getDirection());
            }
            return box;
        }
        return null;
    }

    static /* synthetic */ TextBox getBoxBackwardByOffset$default(SkiaParagraph skiaParagraph, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n2 = n;
        }
        return skiaParagraph.getBoxBackwardByOffset(n, n2);
    }

    @Override
    @NotNull
    public ResolvedTextDirection getParagraphDirection(int offset) {
        return this.paragraphIntrinsics.getTextDirection();
    }

    @Override
    @NotNull
    public ResolvedTextDirection getBidiRunDirection(int offset) {
        ResolvedTextDirection resolvedTextDirection;
        TextBox textBox = this.getBoxForwardByOffset(offset);
        Object object = textBox == null ? null : textBox.getDirection();
        switch (object == null ? -1 : WhenMappings.$EnumSwitchMapping$0[object.ordinal()]) {
            case 1: {
                resolvedTextDirection = ResolvedTextDirection.Rtl;
                break;
            }
            case 2: {
                resolvedTextDirection = ResolvedTextDirection.Ltr;
                break;
            }
            case -1: {
                resolvedTextDirection = ResolvedTextDirection.Ltr;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return resolvedTextDirection;
    }

    @Override
    public int getOffsetForPosition-k-4lQ0M(long position) {
        return this.para.getGlyphPositionAtCoordinate(Offset.getX-impl((long)position), Offset.getY-impl((long)position)).getPosition();
    }

    @Override
    @NotNull
    public Rect getBoundingBox(int offset) {
        TextBox textBox = this.getBoxForwardByOffset(offset);
        if (textBox == null) {
            TextBox textBox2 = this.getBoxBackwardByOffset(offset, this.getText().length());
            textBox = textBox2;
            Intrinsics.checkNotNull((Object)textBox2);
        }
        TextBox box = textBox;
        return Rects_skikoKt.toComposeRect((org.jetbrains.skia.Rect)box.getRect());
    }

    @Override
    public long getWordBoundary--jx7JFs(int offset) {
        long l;
        if (Character.isLetterOrDigit(this.getText().charAt(offset))) {
            IRange it = this.para.getWordBoundary(offset);
            boolean bl = false;
            l = TextRangeKt.TextRange(it.getStart(), it.getEnd());
        } else {
            boolean it;
            Character c = StringsKt.getOrNull((CharSequence)this.getText(), (int)(offset - 1));
            if (c == null ? false : (it = Character.isLetterOrDigit(c.charValue()))) {
                IRange it2 = this.para.getWordBoundary(offset - 1);
                boolean bl = false;
                l = TextRangeKt.TextRange(it2.getStart(), it2.getEnd());
            } else {
                l = TextRangeKt.TextRange(offset, offset);
            }
        }
        return l;
    }

    @Override
    public void paint-RPmYEkk(@NotNull Canvas canvas, long color, @Nullable Shadow shadow, @Nullable TextDecoration textDecoration) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        this.para = this.layouter.layoutParagraph-Bx497Mc(this.getWidth(), this.maxLines, this.ellipsisChar, color, shadow, textDecoration);
        this.para.paint(SkiaBackedCanvas_skikoKt.getNativeCanvas((Canvas)canvas), 0.0f, 0.0f);
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Direction.values().length];
            nArray[Direction.RTL.ordinal()] = 1;
            nArray[Direction.LTR.ordinal()] = 2;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

