/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.text.platform;

import androidx.compose.ui.text.AnnotatedString;
import androidx.compose.ui.text.Placeholder;
import androidx.compose.ui.text.SpanStyle;
import androidx.compose.ui.text.TextStyle;
import androidx.compose.ui.text.font.FontFamily;
import androidx.compose.ui.text.font.FontStyle;
import androidx.compose.ui.text.font.FontWeight;
import androidx.compose.ui.text.platform.ComputedStyle;
import androidx.compose.ui.text.platform.FontLoader;
import androidx.compose.ui.text.platform.SkiaParagraph_skikoKt;
import androidx.compose.ui.text.style.ResolvedTextDirection;
import androidx.compose.ui.text.style.TextAlign;
import androidx.compose.ui.unit.Density;
import androidx.compose.ui.unit.TextUnit;
import androidx.compose.ui.unit.TextUnitKt;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference0;
import kotlin.jvm.internal.PropertyReference0Impl;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.skia.Font;
import org.jetbrains.skia.Typeface;
import org.jetbrains.skia.paragraph.BaselineMode;
import org.jetbrains.skia.paragraph.Paragraph;
import org.jetbrains.skia.paragraph.ParagraphStyle;
import org.jetbrains.skia.paragraph.PlaceholderStyle;
import org.jetbrains.skia.paragraph.StrutStyle;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001:\u0002MNBi\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\u0005\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u0012\u0012\u0010\u000b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\r0\f\u0012\u0012\u0010\u000f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\r0\f\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u0012\u0006\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\u0002\u0010\u0015J\u0006\u0010<\u001a\u00020=J\u0018\u0010>\u001a\u00020?2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010@\u001a\u00020\"H\u0002J6\u0010A\u001a\b\u0012\u0004\u0012\u0002010\f2\u0012\u0010B\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\r0\f2\u0012\u0010\u000f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\r0\fH\u0002J\u0010\u0010C\u001a\u00020D2\u0006\u0010@\u001a\u00020\"H\u0002J\u0016\u0010E\u001a\u00020\"2\f\u0010F\u001a\b\u0012\u0004\u0012\u00020\u000e0\fH\u0002J \u0010G\u001a\u0004\u0018\u00010H2\u0006\u0010I\u001a\u00020\n2\f\u00100\u001a\b\u0012\u0004\u0012\u0002010\fH\u0002J\u0018\u0010J\u001a\u00020K2\u0006\u0010@\u001a\u00020\u00072\u0006\u0010L\u001a\u00020\"H\u0002R\u001b\u0010\u0016\u001a\u00020\u00178@X\u0080\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001a\u0010\u001b\u001a\u0004\b\u0018\u0010\u0019R\u001b\u0010\u001c\u001a\u00020\u001d8@X\u0080\u0084\u0002\u00a2\u0006\f\n\u0004\b \u0010\u001b\u001a\u0004\b\u001e\u0010\u001fR\u000e\u0010!\u001a\u00020\"X\u0082.\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u001a\u0010\b\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010&\"\u0004\b'\u0010(R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010*R\u000e\u0010+\u001a\u00020\u000eX\u0082.\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b,\u0010-\"\u0004\b.\u0010/R\u0014\u00100\u001a\b\u0012\u0004\u0012\u0002010\fX\u0082.\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u000f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\r0\f\u00a2\u0006\b\n\u0000\u001a\u0004\b2\u00103R\u001d\u0010\u000b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\r0\f\u00a2\u0006\b\n\u0000\u001a\u0004\b4\u00103R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b5\u0010&R\u0011\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b6\u00107R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b8\u00109\"\u0004\b:\u0010;\u00a8\u0006O"}, d2={"Landroidx/compose/ui/text/platform/ParagraphBuilder;", "", "fontLoader", "Landroidx/compose/ui/text/platform/FontLoader;", "text", "", "textStyle", "Landroidx/compose/ui/text/TextStyle;", "ellipsis", "maxLines", "", "spanStyles", "", "Landroidx/compose/ui/text/AnnotatedString$Range;", "Landroidx/compose/ui/text/SpanStyle;", "placeholders", "Landroidx/compose/ui/text/Placeholder;", "density", "Landroidx/compose/ui/unit/Density;", "textDirection", "Landroidx/compose/ui/text/style/ResolvedTextDirection;", "(Landroidx/compose/ui/text/platform/FontLoader;Ljava/lang/String;Landroidx/compose/ui/text/TextStyle;Ljava/lang/String;ILjava/util/List;Ljava/util/List;Landroidx/compose/ui/unit/Density;Landroidx/compose/ui/text/style/ResolvedTextDirection;)V", "defaultFont", "Lorg/jetbrains/skia/Font;", "getDefaultFont$ui_text", "()Lorg/jetbrains/skia/Font;", "defaultFont$delegate", "Lkotlin/Lazy;", "defaultHeight", "", "getDefaultHeight$ui_text", "()F", "defaultHeight$delegate", "defaultStyle", "Landroidx/compose/ui/text/platform/ComputedStyle;", "getDensity", "()Landroidx/compose/ui/unit/Density;", "getEllipsis", "()Ljava/lang/String;", "setEllipsis", "(Ljava/lang/String;)V", "getFontLoader", "()Landroidx/compose/ui/text/platform/FontLoader;", "initialStyle", "getMaxLines", "()I", "setMaxLines", "(I)V", "ops", "Landroidx/compose/ui/text/platform/ParagraphBuilder$Op;", "getPlaceholders", "()Ljava/util/List;", "getSpanStyles", "getText", "getTextDirection", "()Landroidx/compose/ui/text/style/ResolvedTextDirection;", "getTextStyle", "()Landroidx/compose/ui/text/TextStyle;", "setTextStyle", "(Landroidx/compose/ui/text/TextStyle;)V", "build", "Lorg/jetbrains/skia/paragraph/Paragraph;", "ensureFontsAreRegistered", "", "style", "makeOps", "spans", "makeSkTextStyle", "Lorg/jetbrains/skia/paragraph/TextStyle;", "mergeStyles", "activeStyles", "previousStyleAddAtTheSamePosition", "Landroidx/compose/ui/text/platform/ParagraphBuilder$Op$StyleAdd;", "position", "textStyleToParagraphStyle", "Lorg/jetbrains/skia/paragraph/ParagraphStyle;", "computedStyle", "Cut", "Op", "ui-text"})
public final class ParagraphBuilder {
    @NotNull
    private final FontLoader fontLoader;
    @NotNull
    private final String text;
    @NotNull
    private TextStyle textStyle;
    @NotNull
    private String ellipsis;
    private int maxLines;
    @NotNull
    private final List<AnnotatedString.Range<SpanStyle>> spanStyles;
    @NotNull
    private final List<AnnotatedString.Range<Placeholder>> placeholders;
    @NotNull
    private final Density density;
    @NotNull
    private final ResolvedTextDirection textDirection;
    private SpanStyle initialStyle;
    private ComputedStyle defaultStyle;
    private List<? extends Op> ops;
    @NotNull
    private final Lazy defaultFont$delegate;
    @NotNull
    private final Lazy defaultHeight$delegate;

    public ParagraphBuilder(@NotNull FontLoader fontLoader, @NotNull String text, @NotNull TextStyle textStyle, @NotNull String ellipsis, int maxLines, @NotNull List<AnnotatedString.Range<SpanStyle>> spanStyles, @NotNull List<AnnotatedString.Range<Placeholder>> placeholders, @NotNull Density density, @NotNull ResolvedTextDirection textDirection) {
        Intrinsics.checkNotNullParameter((Object)fontLoader, (String)"fontLoader");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)textStyle, (String)"textStyle");
        Intrinsics.checkNotNullParameter((Object)ellipsis, (String)"ellipsis");
        Intrinsics.checkNotNullParameter(spanStyles, (String)"spanStyles");
        Intrinsics.checkNotNullParameter(placeholders, (String)"placeholders");
        Intrinsics.checkNotNullParameter((Object)density, (String)"density");
        Intrinsics.checkNotNullParameter((Object)((Object)textDirection), (String)"textDirection");
        this.fontLoader = fontLoader;
        this.text = text;
        this.textStyle = textStyle;
        this.ellipsis = ellipsis;
        this.maxLines = maxLines;
        this.spanStyles = spanStyles;
        this.placeholders = placeholders;
        this.density = density;
        this.textDirection = textDirection;
        this.defaultFont$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Font>(this){
            final /* synthetic */ ParagraphBuilder this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Font invoke() {
                Typeface typeface;
                FontFamily fontFamily = this.this$0.getTextStyle().getFontFamily();
                if (fontFamily == null) {
                    typeface = null;
                } else {
                    FontFamily fontFamily2 = fontFamily;
                    ParagraphBuilder paragraphBuilder = this.this$0;
                    FontFamily it = fontFamily2;
                    boolean bl = false;
                    FontLoader fontLoader = paragraphBuilder.getFontLoader();
                    FontWeight fontWeight = paragraphBuilder.getTextStyle().getFontWeight();
                    if (fontWeight == null) {
                        fontWeight = FontWeight.Companion.getNormal();
                    }
                    FontStyle fontStyle = paragraphBuilder.getTextStyle().getFontStyle-4Lr2A7w();
                    typeface = fontLoader.findTypeface-RetOiIg$ui_text(it, fontWeight, fontStyle == null ? FontStyle.Companion.getNormal-_-LCdwA() : fontStyle.unbox-impl());
                }
                Typeface typeface2 = typeface;
                Typeface typeface3 = typeface2 == null ? Typeface.Companion.makeDefault() : typeface2;
                ComputedStyle computedStyle = ParagraphBuilder.access$getDefaultStyle$p(this.this$0);
                if (computedStyle == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"defaultStyle");
                    computedStyle = null;
                }
                return new Font(typeface3, computedStyle.getFontSize());
            }
        }));
        this.defaultHeight$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Float>(this){
            final /* synthetic */ ParagraphBuilder this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Float invoke() {
                return Float.valueOf(this.this$0.getDefaultFont$ui_text().getMetrics().getHeight());
            }
        }));
    }

    public /* synthetic */ ParagraphBuilder(FontLoader fontLoader, String string, TextStyle textStyle, String string2, int n, List list, List list2, Density density, ResolvedTextDirection resolvedTextDirection, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 8) != 0) {
            string2 = "";
        }
        if ((n2 & 0x10) != 0) {
            n = Integer.MAX_VALUE;
        }
        this(fontLoader, string, textStyle, string2, n, list, list2, density, resolvedTextDirection);
    }

    @NotNull
    public final FontLoader getFontLoader() {
        return this.fontLoader;
    }

    @NotNull
    public final String getText() {
        return this.text;
    }

    @NotNull
    public final TextStyle getTextStyle() {
        return this.textStyle;
    }

    public final void setTextStyle(@NotNull TextStyle textStyle) {
        Intrinsics.checkNotNullParameter((Object)textStyle, (String)"<set-?>");
        this.textStyle = textStyle;
    }

    @NotNull
    public final String getEllipsis() {
        return this.ellipsis;
    }

    public final void setEllipsis(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.ellipsis = string;
    }

    public final int getMaxLines() {
        return this.maxLines;
    }

    public final void setMaxLines(int n) {
        this.maxLines = n;
    }

    @NotNull
    public final List<AnnotatedString.Range<SpanStyle>> getSpanStyles() {
        return this.spanStyles;
    }

    @NotNull
    public final List<AnnotatedString.Range<Placeholder>> getPlaceholders() {
        return this.placeholders;
    }

    @NotNull
    public final Density getDensity() {
        return this.density;
    }

    @NotNull
    public final ResolvedTextDirection getTextDirection() {
        return this.textDirection;
    }

    @NotNull
    public final Paragraph build() {
        this.initialStyle = SkiaParagraph_skikoKt.access$withDefaultFontSize(this.textStyle.toSpanStyle());
        SpanStyle spanStyle = this.initialStyle;
        if (spanStyle == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"initialStyle");
            spanStyle = null;
        }
        this.defaultStyle = new ComputedStyle(this.density, spanStyle);
        this.ops = this.makeOps(this.spanStyles, this.placeholders);
        int pos = 0;
        ComputedStyle computedStyle = this.defaultStyle;
        if (computedStyle == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"defaultStyle");
            computedStyle = null;
        }
        ParagraphStyle ps = this.textStyleToParagraphStyle(this.textStyle, computedStyle);
        if (this.maxLines != Integer.MAX_VALUE) {
            ps.setMaxLinesCount(this.maxLines);
            ps.setEllipsis(this.ellipsis);
        }
        org.jetbrains.skia.paragraph.ParagraphBuilder pb = new org.jetbrains.skia.paragraph.ParagraphBuilder(ps, this.fontLoader.getFonts$ui_text());
        boolean addText = true;
        List<? extends Op> list = this.ops;
        if (list == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"ops");
            list = null;
        }
        for (Op op : list) {
            Op op2;
            if (addText && pos < op.getPosition()) {
                pb.addText(((Object)this.text.subSequence(pos, op.getPosition())).toString());
            }
            if ((op2 = op) instanceof Op.StyleAdd) {
                this.ensureFontsAreRegistered(this.fontLoader, ((Op.StyleAdd)op).getStyle());
                pb.pushStyle(this.makeSkTextStyle(((Op.StyleAdd)op).getStyle()));
            } else if (op2 instanceof Op.PutPlaceholder) {
                PlaceholderStyle placeholderStyle = new PlaceholderStyle(((Op.PutPlaceholder)op).getWidth(), ((Op.PutPlaceholder)op).getHeight(), SkiaParagraph_skikoKt.toSkPlaceholderAlignment-do9X-Gg(((Op.PutPlaceholder)op).getCut().getPlaceholder().getPlaceholderVerticalAlign-J6kI3mc()), BaselineMode.ALPHABETIC, 0.0f);
                pb.addPlaceholder(placeholderStyle);
                addText = false;
            } else if (op2 instanceof Op.EndPlaceholder) {
                addText = true;
            }
            pos = op.getPosition();
        }
        if (addText && pos < this.text.length()) {
            pb.addText(((Object)this.text.subSequence(pos, this.text.length())).toString());
        }
        return pb.build();
    }

    private final void ensureFontsAreRegistered(FontLoader fontLoader, ComputedStyle style) {
        FontFamily fontFamily = style.getFontFamily();
        if (fontFamily != null) {
            FontFamily it = fontFamily;
            boolean bl = false;
            fontLoader.ensureRegistered$ui_text(it);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<Op> makeOps(List<AnnotatedString.Range<SpanStyle>> spans, List<AnnotatedString.Range<Placeholder>> placeholders) {
        List cuts = new ArrayList();
        for (AnnotatedString.Range<SpanStyle> range : spans) {
            cuts.add(new Cut.StyleAdd(range.getStart(), range.getItem()));
            cuts.add(new Cut.StyleRemove(range.getEnd(), range.getItem()));
        }
        for (AnnotatedString.Range<Object> range : placeholders) {
            cuts.add(new Cut.PutPlaceholder(range.getStart(), (Placeholder)range.getItem()));
            cuts.add(new Cut.EndPlaceholder(range.getEnd()));
        }
        Object[] objectArray = new Op[1];
        ComputedStyle computedStyle = this.defaultStyle;
        if (computedStyle == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"defaultStyle");
            computedStyle = null;
        }
        objectArray[0] = new Op.StyleAdd(0, computedStyle);
        List ops = CollectionsKt.mutableListOf((Object[])objectArray);
        List list = cuts;
        boolean $i$f$sortBy = false;
        if (list.size() > 1) {
            CollectionsKt.sortWith((List)list, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    Cut it = (Cut)a;
                    boolean bl = false;
                    Comparable comparable = Integer.valueOf(it.getPosition());
                    it = (Cut)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getPosition()));
                }
            });
        }
        SpanStyle[] spanStyleArray = new SpanStyle[1];
        SpanStyle spanStyle = this.initialStyle;
        if (spanStyle == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"initialStyle");
            spanStyle = null;
        }
        spanStyleArray[0] = spanStyle;
        List list2 = CollectionsKt.mutableListOf((Object[])spanStyleArray);
        for (Cut cut : cuts) {
            if (cut instanceof Cut.StyleAdd) {
                list2.add(((Cut.StyleAdd)cut).getStyle());
                Op.StyleAdd prev = this.previousStyleAddAtTheSamePosition(cut.getPosition(), ops);
                if (prev == null) {
                    void it;
                    ComputedStyle computedStyle2;
                    ComputedStyle computedStyle3 = computedStyle2 = this.mergeStyles(list2);
                    int n = cut.getPosition();
                    List list3 = ops;
                    boolean bl = false;
                    it.merge(this.getDensity(), ((Cut.StyleAdd)cut).getStyle());
                    Unit unit = Unit.INSTANCE;
                    ComputedStyle computedStyle4 = computedStyle2;
                    int n2 = n;
                    list3.add(new Op.StyleAdd(n2, computedStyle4));
                    continue;
                }
                prev.getStyle().merge(this.density, ((Cut.StyleAdd)cut).getStyle());
                continue;
            }
            if (cut instanceof Cut.StyleRemove) {
                list2.remove(((Cut.StyleRemove)cut).getStyle());
                ops.add(new Op.StyleAdd(cut.getPosition(), this.mergeStyles(list2)));
                continue;
            }
            if (cut instanceof Cut.PutPlaceholder) {
                ComputedStyle currentStyle = this.mergeStyles(list2);
                Op.PutPlaceholder op = new Op.PutPlaceholder((Cut.PutPlaceholder)cut, SkiaParagraph_skikoKt.access$fontSizeInHierarchy-kncR6DU(this.density, currentStyle.getFontSize(), ((Cut.PutPlaceholder)cut).getPlaceholder().getWidth-XSAIIZE()), SkiaParagraph_skikoKt.access$fontSizeInHierarchy-kncR6DU(this.density, currentStyle.getFontSize(), ((Cut.PutPlaceholder)cut).getPlaceholder().getHeight-XSAIIZE()));
                ops.add(op);
                continue;
            }
            if (!(cut instanceof Cut.EndPlaceholder)) continue;
            ops.add(new Op.EndPlaceholder((Cut.EndPlaceholder)cut));
        }
        return ops;
    }

    private final ComputedStyle mergeStyles(List<SpanStyle> activeStyles) {
        ComputedStyle style = new ComputedStyle(this.density, activeStyles.get(0));
        int n = 1;
        int n2 = activeStyles.size();
        while (n < n2) {
            int i = n++;
            style.merge(this.density, activeStyles.get(i));
        }
        return style;
    }

    private final Op.StyleAdd previousStyleAddAtTheSamePosition(int position, List<? extends Op> ops) {
        for (Op prevOp : CollectionsKt.asReversed(ops)) {
            if (prevOp.getPosition() < position) {
                return null;
            }
            if (!(prevOp instanceof Op.StyleAdd)) continue;
            return (Op.StyleAdd)prevOp;
        }
        return null;
    }

    private final ParagraphStyle textStyleToParagraphStyle(TextStyle style, ComputedStyle computedStyle) {
        ParagraphStyle pStyle = new ParagraphStyle();
        pStyle.setTextStyle(this.makeSkTextStyle(computedStyle));
        TextAlign textAlign = style.getTextAlign-buA522U();
        if (textAlign != null) {
            int it = textAlign.unbox-impl();
            boolean bl = false;
            pStyle.setAlignment(SkiaParagraph_skikoKt.toSkAlignment-aXe7zB0(it));
        }
        long $this$isSpecified$iv = style.getLineHeight-XSAIIZE();
        boolean bl = false;
        if (!TextUnitKt.isUnspecified--R2X_6o((long)$this$isSpecified$iv)) {
            float f;
            StrutStyle strutStyle = new StrutStyle();
            strutStyle.setEnabled(true);
            strutStyle.setHeightOverridden(true);
            Density $this$textStyleToParagraphStyle_u24lambda_u2d4 = this.density;
            boolean bl2 = false;
            float fontSize = $this$textStyleToParagraphStyle_u24lambda_u2d4.toPx--R2X_6o(SkiaParagraph_skikoKt.access$orDefaultFontSize--R2X_6o(style.getFontSize-XSAIIZE()));
            if (TextUnit.isSp-impl((long)style.getLineHeight-XSAIIZE())) {
                Density $this$textStyleToParagraphStyle_u24lambda_u2d5 = this.density;
                boolean bl3 = false;
                f = $this$textStyleToParagraphStyle_u24lambda_u2d5.toPx--R2X_6o(style.getLineHeight-XSAIIZE());
            } else if (TextUnit.isEm-impl((long)style.getLineHeight-XSAIIZE())) {
                f = fontSize * TextUnit.getValue-impl((long)style.getLineHeight-XSAIIZE());
            } else {
                throw new IllegalStateException("Unexpected size in textStyleToParagraphStyle".toString());
            }
            float lineHeight = f;
            strutStyle.setHeight(lineHeight / fontSize);
            pStyle.setStrutStyle(strutStyle);
        }
        pStyle.setDirection(SkiaParagraph_skikoKt.toSkDirection(this.textDirection));
        return pStyle;
    }

    private final org.jetbrains.skia.paragraph.TextStyle makeSkTextStyle(ComputedStyle style) {
        Object object;
        Map $this$getOrPut$iv = SkiaParagraph_skikoKt.access$getSkTextStylesCache$p();
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(style);
        if (value$iv == null) {
            boolean bl = false;
            org.jetbrains.skia.paragraph.TextStyle answer$iv = style.toSkTextStyle(this.getFontLoader());
            $this$getOrPut$iv.put(style, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        Object v = object;
        Intrinsics.checkNotNullExpressionValue(v, (String)"skTextStylesCache.getOrP\u2026yle(fontLoader)\n        }");
        return (org.jetbrains.skia.paragraph.TextStyle)v;
    }

    @NotNull
    public final Font getDefaultFont$ui_text() {
        Lazy lazy = this.defaultFont$delegate;
        return (Font)lazy.getValue();
    }

    public final float getDefaultHeight$ui_text() {
        Lazy lazy = this.defaultHeight$delegate;
        return ((Number)lazy.getValue()).floatValue();
    }

    public static final /* synthetic */ ComputedStyle access$getDefaultStyle$p(ParagraphBuilder $this) {
        return $this.defaultStyle;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b2\u0018\u00002\u00020\u0001:\u0003\u0007\b\tB\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002R\u0012\u0010\u0003\u001a\u00020\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u0082\u0001\u0003\n\u000b\f\u00a8\u0006\r"}, d2={"Landroidx/compose/ui/text/platform/ParagraphBuilder$Op;", "", "()V", "position", "", "getPosition", "()I", "EndPlaceholder", "PutPlaceholder", "StyleAdd", "Landroidx/compose/ui/text/platform/ParagraphBuilder$Op$StyleAdd;", "Landroidx/compose/ui/text/platform/ParagraphBuilder$Op$PutPlaceholder;", "Landroidx/compose/ui/text/platform/ParagraphBuilder$Op$EndPlaceholder;", "ui-text"})
    private static abstract class Op {
        private Op() {
        }

        public abstract int getPosition();

        public /* synthetic */ Op(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"Landroidx/compose/ui/text/platform/ParagraphBuilder$Op$StyleAdd;", "Landroidx/compose/ui/text/platform/ParagraphBuilder$Op;", "position", "", "style", "Landroidx/compose/ui/text/platform/ComputedStyle;", "(ILandroidx/compose/ui/text/platform/ComputedStyle;)V", "getPosition", "()I", "getStyle", "()Landroidx/compose/ui/text/platform/ComputedStyle;", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "toString", "", "ui-text"})
        public static final class StyleAdd
        extends Op {
            private final int position;
            @NotNull
            private final ComputedStyle style;

            public StyleAdd(int position, @NotNull ComputedStyle style) {
                Intrinsics.checkNotNullParameter((Object)style, (String)"style");
                super(null);
                this.position = position;
                this.style = style;
            }

            @Override
            public int getPosition() {
                return this.position;
            }

            @NotNull
            public final ComputedStyle getStyle() {
                return this.style;
            }

            public final int component1() {
                return this.getPosition();
            }

            @NotNull
            public final ComputedStyle component2() {
                return this.style;
            }

            @NotNull
            public final StyleAdd copy(int position, @NotNull ComputedStyle style) {
                Intrinsics.checkNotNullParameter((Object)style, (String)"style");
                return new StyleAdd(position, style);
            }

            public static /* synthetic */ StyleAdd copy$default(StyleAdd styleAdd, int n, ComputedStyle computedStyle, int n2, Object object) {
                if ((n2 & 1) != 0) {
                    n = styleAdd.getPosition();
                }
                if ((n2 & 2) != 0) {
                    computedStyle = styleAdd.style;
                }
                return styleAdd.copy(n, computedStyle);
            }

            @NotNull
            public String toString() {
                return "StyleAdd(position=" + this.getPosition() + ", style=" + this.style + ')';
            }

            public int hashCode() {
                int result = Integer.hashCode(this.getPosition());
                result = result * 31 + this.style.hashCode();
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof StyleAdd)) {
                    return false;
                }
                StyleAdd styleAdd = (StyleAdd)other;
                if (this.getPosition() != styleAdd.getPosition()) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.style, (Object)styleAdd.style);
            }
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\t\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\t\u0010\u0016\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0005H\u00c6\u0003J'\u0010\u0019\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u00d6\u0003J\t\u0010\u001e\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u001f\u001a\u00020 H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001a\u0010\u0006\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001b\u0010\u000e\u001a\u00020\u000f8VX\u0096\u0084\u0002\u00a2\u0006\f\u001a\u0004\b\u0012\u0010\u0013*\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u000b\"\u0004\b\u0015\u0010\r\u00a8\u0006!"}, d2={"Landroidx/compose/ui/text/platform/ParagraphBuilder$Op$PutPlaceholder;", "Landroidx/compose/ui/text/platform/ParagraphBuilder$Op;", "cut", "Landroidx/compose/ui/text/platform/ParagraphBuilder$Cut$PutPlaceholder;", "width", "", "height", "(Landroidx/compose/ui/text/platform/ParagraphBuilder$Cut$PutPlaceholder;FF)V", "getCut", "()Landroidx/compose/ui/text/platform/ParagraphBuilder$Cut$PutPlaceholder;", "getHeight", "()F", "setHeight", "(F)V", "position", "", "getPosition$delegate", "(Landroidx/compose/ui/text/platform/ParagraphBuilder$Op$PutPlaceholder;)Ljava/lang/Object;", "getPosition", "()I", "getWidth", "setWidth", "component1", "component2", "component3", "copy", "equals", "", "other", "", "hashCode", "toString", "", "ui-text"})
        public static final class PutPlaceholder
        extends Op {
            @NotNull
            private final Cut.PutPlaceholder cut;
            private float width;
            private float height;

            public PutPlaceholder(@NotNull Cut.PutPlaceholder cut, float width, float height) {
                Intrinsics.checkNotNullParameter((Object)cut, (String)"cut");
                super(null);
                this.cut = cut;
                this.width = width;
                this.height = height;
            }

            @NotNull
            public final Cut.PutPlaceholder getCut() {
                return this.cut;
            }

            public final float getWidth() {
                return this.width;
            }

            public final void setWidth(float f) {
                this.width = f;
            }

            public final float getHeight() {
                return this.height;
            }

            public final void setHeight(float f) {
                this.height = f;
            }

            @Override
            public int getPosition() {
                return this.cut.getPosition();
            }

            public static Object getPosition$delegate(PutPlaceholder putPlaceholder) {
                Intrinsics.checkNotNullParameter((Object)putPlaceholder, (String)"<this>");
                return Reflection.property0((PropertyReference0)((PropertyReference0)new PropertyReference0Impl((Object)putPlaceholder.cut, Cut.PutPlaceholder.class, "position", "getPosition()I", 0)));
            }

            @NotNull
            public final Cut.PutPlaceholder component1() {
                return this.cut;
            }

            public final float component2() {
                return this.width;
            }

            public final float component3() {
                return this.height;
            }

            @NotNull
            public final PutPlaceholder copy(@NotNull Cut.PutPlaceholder cut, float width, float height) {
                Intrinsics.checkNotNullParameter((Object)cut, (String)"cut");
                return new PutPlaceholder(cut, width, height);
            }

            public static /* synthetic */ PutPlaceholder copy$default(PutPlaceholder putPlaceholder, Cut.PutPlaceholder putPlaceholder2, float f, float f2, int n, Object object) {
                if ((n & 1) != 0) {
                    putPlaceholder2 = putPlaceholder.cut;
                }
                if ((n & 2) != 0) {
                    f = putPlaceholder.width;
                }
                if ((n & 4) != 0) {
                    f2 = putPlaceholder.height;
                }
                return putPlaceholder.copy(putPlaceholder2, f, f2);
            }

            @NotNull
            public String toString() {
                return "PutPlaceholder(cut=" + this.cut + ", width=" + this.width + ", height=" + this.height + ')';
            }

            public int hashCode() {
                int result = this.cut.hashCode();
                result = result * 31 + Float.hashCode(this.width);
                result = result * 31 + Float.hashCode(this.height);
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof PutPlaceholder)) {
                    return false;
                }
                PutPlaceholder putPlaceholder = (PutPlaceholder)other;
                if (!Intrinsics.areEqual((Object)this.cut, (Object)putPlaceholder.cut)) {
                    return false;
                }
                if (!Intrinsics.areEqual((Object)Float.valueOf(this.width), (Object)Float.valueOf(putPlaceholder.width))) {
                    return false;
                }
                return Intrinsics.areEqual((Object)Float.valueOf(this.height), (Object)Float.valueOf(putPlaceholder.height));
            }
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\bH\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u001b\u0010\u0007\u001a\u00020\b8VX\u0096\u0084\u0002\u00a2\u0006\f\u001a\u0004\b\u000b\u0010\f*\u0004\b\t\u0010\n\u00a8\u0006\u0016"}, d2={"Landroidx/compose/ui/text/platform/ParagraphBuilder$Op$EndPlaceholder;", "Landroidx/compose/ui/text/platform/ParagraphBuilder$Op;", "cut", "Landroidx/compose/ui/text/platform/ParagraphBuilder$Cut$EndPlaceholder;", "(Landroidx/compose/ui/text/platform/ParagraphBuilder$Cut$EndPlaceholder;)V", "getCut", "()Landroidx/compose/ui/text/platform/ParagraphBuilder$Cut$EndPlaceholder;", "position", "", "getPosition$delegate", "(Landroidx/compose/ui/text/platform/ParagraphBuilder$Op$EndPlaceholder;)Ljava/lang/Object;", "getPosition", "()I", "component1", "copy", "equals", "", "other", "", "hashCode", "toString", "", "ui-text"})
        public static final class EndPlaceholder
        extends Op {
            @NotNull
            private final Cut.EndPlaceholder cut;

            public EndPlaceholder(@NotNull Cut.EndPlaceholder cut) {
                Intrinsics.checkNotNullParameter((Object)cut, (String)"cut");
                super(null);
                this.cut = cut;
            }

            @NotNull
            public final Cut.EndPlaceholder getCut() {
                return this.cut;
            }

            @Override
            public int getPosition() {
                return this.cut.getPosition();
            }

            public static Object getPosition$delegate(EndPlaceholder endPlaceholder) {
                Intrinsics.checkNotNullParameter((Object)endPlaceholder, (String)"<this>");
                return Reflection.property0((PropertyReference0)((PropertyReference0)new PropertyReference0Impl((Object)endPlaceholder.cut, Cut.EndPlaceholder.class, "position", "getPosition()I", 0)));
            }

            @NotNull
            public final Cut.EndPlaceholder component1() {
                return this.cut;
            }

            @NotNull
            public final EndPlaceholder copy(@NotNull Cut.EndPlaceholder cut) {
                Intrinsics.checkNotNullParameter((Object)cut, (String)"cut");
                return new EndPlaceholder(cut);
            }

            public static /* synthetic */ EndPlaceholder copy$default(EndPlaceholder endPlaceholder, Cut.EndPlaceholder endPlaceholder2, int n, Object object) {
                if ((n & 1) != 0) {
                    endPlaceholder2 = endPlaceholder.cut;
                }
                return endPlaceholder.copy(endPlaceholder2);
            }

            @NotNull
            public String toString() {
                return "EndPlaceholder(cut=" + this.cut + ')';
            }

            public int hashCode() {
                return this.cut.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof EndPlaceholder)) {
                    return false;
                }
                EndPlaceholder endPlaceholder = (EndPlaceholder)other;
                return Intrinsics.areEqual((Object)this.cut, (Object)endPlaceholder.cut);
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b2\u0018\u00002\u00020\u0001:\u0004\u0007\b\t\nB\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002R\u0012\u0010\u0003\u001a\u00020\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u0082\u0001\u0004\u000b\f\r\u000e\u00a8\u0006\u000f"}, d2={"Landroidx/compose/ui/text/platform/ParagraphBuilder$Cut;", "", "()V", "position", "", "getPosition", "()I", "EndPlaceholder", "PutPlaceholder", "StyleAdd", "StyleRemove", "Landroidx/compose/ui/text/platform/ParagraphBuilder$Cut$StyleAdd;", "Landroidx/compose/ui/text/platform/ParagraphBuilder$Cut$StyleRemove;", "Landroidx/compose/ui/text/platform/ParagraphBuilder$Cut$PutPlaceholder;", "Landroidx/compose/ui/text/platform/ParagraphBuilder$Cut$EndPlaceholder;", "ui-text"})
    private static abstract class Cut {
        private Cut() {
        }

        public abstract int getPosition();

        public /* synthetic */ Cut(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"Landroidx/compose/ui/text/platform/ParagraphBuilder$Cut$StyleAdd;", "Landroidx/compose/ui/text/platform/ParagraphBuilder$Cut;", "position", "", "style", "Landroidx/compose/ui/text/SpanStyle;", "(ILandroidx/compose/ui/text/SpanStyle;)V", "getPosition", "()I", "getStyle", "()Landroidx/compose/ui/text/SpanStyle;", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "toString", "", "ui-text"})
        public static final class StyleAdd
        extends Cut {
            private final int position;
            @NotNull
            private final SpanStyle style;

            public StyleAdd(int position, @NotNull SpanStyle style) {
                Intrinsics.checkNotNullParameter((Object)style, (String)"style");
                super(null);
                this.position = position;
                this.style = style;
            }

            @Override
            public int getPosition() {
                return this.position;
            }

            @NotNull
            public final SpanStyle getStyle() {
                return this.style;
            }

            public final int component1() {
                return this.getPosition();
            }

            @NotNull
            public final SpanStyle component2() {
                return this.style;
            }

            @NotNull
            public final StyleAdd copy(int position, @NotNull SpanStyle style) {
                Intrinsics.checkNotNullParameter((Object)style, (String)"style");
                return new StyleAdd(position, style);
            }

            public static /* synthetic */ StyleAdd copy$default(StyleAdd styleAdd, int n, SpanStyle spanStyle, int n2, Object object) {
                if ((n2 & 1) != 0) {
                    n = styleAdd.getPosition();
                }
                if ((n2 & 2) != 0) {
                    spanStyle = styleAdd.style;
                }
                return styleAdd.copy(n, spanStyle);
            }

            @NotNull
            public String toString() {
                return "StyleAdd(position=" + this.getPosition() + ", style=" + this.style + ')';
            }

            public int hashCode() {
                int result = Integer.hashCode(this.getPosition());
                result = result * 31 + this.style.hashCode();
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof StyleAdd)) {
                    return false;
                }
                StyleAdd styleAdd = (StyleAdd)other;
                if (this.getPosition() != styleAdd.getPosition()) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.style, (Object)styleAdd.style);
            }
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"Landroidx/compose/ui/text/platform/ParagraphBuilder$Cut$StyleRemove;", "Landroidx/compose/ui/text/platform/ParagraphBuilder$Cut;", "position", "", "style", "Landroidx/compose/ui/text/SpanStyle;", "(ILandroidx/compose/ui/text/SpanStyle;)V", "getPosition", "()I", "getStyle", "()Landroidx/compose/ui/text/SpanStyle;", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "toString", "", "ui-text"})
        public static final class StyleRemove
        extends Cut {
            private final int position;
            @NotNull
            private final SpanStyle style;

            public StyleRemove(int position, @NotNull SpanStyle style) {
                Intrinsics.checkNotNullParameter((Object)style, (String)"style");
                super(null);
                this.position = position;
                this.style = style;
            }

            @Override
            public int getPosition() {
                return this.position;
            }

            @NotNull
            public final SpanStyle getStyle() {
                return this.style;
            }

            public final int component1() {
                return this.getPosition();
            }

            @NotNull
            public final SpanStyle component2() {
                return this.style;
            }

            @NotNull
            public final StyleRemove copy(int position, @NotNull SpanStyle style) {
                Intrinsics.checkNotNullParameter((Object)style, (String)"style");
                return new StyleRemove(position, style);
            }

            public static /* synthetic */ StyleRemove copy$default(StyleRemove styleRemove, int n, SpanStyle spanStyle, int n2, Object object) {
                if ((n2 & 1) != 0) {
                    n = styleRemove.getPosition();
                }
                if ((n2 & 2) != 0) {
                    spanStyle = styleRemove.style;
                }
                return styleRemove.copy(n, spanStyle);
            }

            @NotNull
            public String toString() {
                return "StyleRemove(position=" + this.getPosition() + ", style=" + this.style + ')';
            }

            public int hashCode() {
                int result = Integer.hashCode(this.getPosition());
                result = result * 31 + this.style.hashCode();
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof StyleRemove)) {
                    return false;
                }
                StyleRemove styleRemove = (StyleRemove)other;
                if (this.getPosition() != styleRemove.getPosition()) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.style, (Object)styleRemove.style);
            }
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"Landroidx/compose/ui/text/platform/ParagraphBuilder$Cut$PutPlaceholder;", "Landroidx/compose/ui/text/platform/ParagraphBuilder$Cut;", "position", "", "placeholder", "Landroidx/compose/ui/text/Placeholder;", "(ILandroidx/compose/ui/text/Placeholder;)V", "getPlaceholder", "()Landroidx/compose/ui/text/Placeholder;", "getPosition", "()I", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "toString", "", "ui-text"})
        public static final class PutPlaceholder
        extends Cut {
            private final int position;
            @NotNull
            private final Placeholder placeholder;

            public PutPlaceholder(int position, @NotNull Placeholder placeholder) {
                Intrinsics.checkNotNullParameter((Object)placeholder, (String)"placeholder");
                super(null);
                this.position = position;
                this.placeholder = placeholder;
            }

            @Override
            public int getPosition() {
                return this.position;
            }

            @NotNull
            public final Placeholder getPlaceholder() {
                return this.placeholder;
            }

            public final int component1() {
                return this.getPosition();
            }

            @NotNull
            public final Placeholder component2() {
                return this.placeholder;
            }

            @NotNull
            public final PutPlaceholder copy(int position, @NotNull Placeholder placeholder) {
                Intrinsics.checkNotNullParameter((Object)placeholder, (String)"placeholder");
                return new PutPlaceholder(position, placeholder);
            }

            public static /* synthetic */ PutPlaceholder copy$default(PutPlaceholder putPlaceholder, int n, Placeholder placeholder, int n2, Object object) {
                if ((n2 & 1) != 0) {
                    n = putPlaceholder.getPosition();
                }
                if ((n2 & 2) != 0) {
                    placeholder = putPlaceholder.placeholder;
                }
                return putPlaceholder.copy(n, placeholder);
            }

            @NotNull
            public String toString() {
                return "PutPlaceholder(position=" + this.getPosition() + ", placeholder=" + this.placeholder + ')';
            }

            public int hashCode() {
                int result = Integer.hashCode(this.getPosition());
                result = result * 31 + this.placeholder.hashCode();
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof PutPlaceholder)) {
                    return false;
                }
                PutPlaceholder putPlaceholder = (PutPlaceholder)other;
                if (this.getPosition() != putPlaceholder.getPosition()) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.placeholder, (Object)putPlaceholder.placeholder);
            }
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0010"}, d2={"Landroidx/compose/ui/text/platform/ParagraphBuilder$Cut$EndPlaceholder;", "Landroidx/compose/ui/text/platform/ParagraphBuilder$Cut;", "position", "", "(I)V", "getPosition", "()I", "component1", "copy", "equals", "", "other", "", "hashCode", "toString", "", "ui-text"})
        public static final class EndPlaceholder
        extends Cut {
            private final int position;

            public EndPlaceholder(int position) {
                super(null);
                this.position = position;
            }

            @Override
            public int getPosition() {
                return this.position;
            }

            public final int component1() {
                return this.getPosition();
            }

            @NotNull
            public final EndPlaceholder copy(int position) {
                return new EndPlaceholder(position);
            }

            public static /* synthetic */ EndPlaceholder copy$default(EndPlaceholder endPlaceholder, int n, int n2, Object object) {
                if ((n2 & 1) != 0) {
                    n = endPlaceholder.getPosition();
                }
                return endPlaceholder.copy(n);
            }

            @NotNull
            public String toString() {
                return "EndPlaceholder(position=" + this.getPosition() + ')';
            }

            public int hashCode() {
                return Integer.hashCode(this.getPosition());
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof EndPlaceholder)) {
                    return false;
                }
                EndPlaceholder endPlaceholder = (EndPlaceholder)other;
                return this.getPosition() == endPlaceholder.getPosition();
            }
        }
    }
}

