/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.text;

import androidx.compose.ui.text.Cache;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u00022\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00020\u0003:\u0004!\"#$B\u0017\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0005H\u0002J)\u0010\u001c\u001a\u00028\u00012\u0006\u0010\u001d\u001a\u00028\u00002\u0012\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u001fH\u0016\u00a2\u0006\u0002\u0010 R$\u0010\t\u001a\u00120\nR\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0000X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000RP\u0010\u0011\u001a>\u0012\u0004\u0012\u00028\u0000\u0012\u0014\u0012\u00120\u0013R\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00000\u0012j\u001e\u0012\u0004\u0012\u00028\u0000\u0012\u0014\u0012\u00120\u0013R\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0000`\u0014X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006%"}, d2={"Landroidx/compose/ui/text/ExpireAfterAccessCache;", "K", "V", "Landroidx/compose/ui/text/Cache;", "expireAfterNanos", "", "timeProvider", "Landroidx/compose/ui/text/ExpireAfterAccessCache$TimeProvider;", "(JLandroidx/compose/ui/text/ExpireAfterAccessCache$TimeProvider;)V", "accessQueue", "Landroidx/compose/ui/text/ExpireAfterAccessCache$LinkedQueue;", "getAccessQueue$ui_text", "()Landroidx/compose/ui/text/ExpireAfterAccessCache$LinkedQueue;", "getExpireAfterNanos", "()J", "lock", "Ljava/util/concurrent/locks/ReentrantLock;", "map", "Ljava/util/HashMap;", "Landroidx/compose/ui/text/ExpireAfterAccessCache$Entry;", "Lkotlin/collections/HashMap;", "getMap$ui_text", "()Ljava/util/HashMap;", "getTimeProvider", "()Landroidx/compose/ui/text/ExpireAfterAccessCache$TimeProvider;", "checkEvicted", "", "now", "get", "key", "loader", "Lkotlin/Function1;", "(Ljava/lang/Object;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "Entry", "LinkedQueue", "SystemTimeProvider", "TimeProvider", "ui-text"})
public final class ExpireAfterAccessCache<K, V>
implements Cache<K, V> {
    private final long expireAfterNanos;
    @NotNull
    private final TimeProvider timeProvider;
    @NotNull
    private final HashMap<K, Entry> map;
    @NotNull
    private final LinkedQueue accessQueue;
    @NotNull
    private final ReentrantLock lock;

    public ExpireAfterAccessCache(long expireAfterNanos, @NotNull TimeProvider timeProvider) {
        Intrinsics.checkNotNullParameter((Object)timeProvider, (String)"timeProvider");
        this.expireAfterNanos = expireAfterNanos;
        this.timeProvider = timeProvider;
        this.map = new HashMap();
        this.accessQueue = new LinkedQueue();
        this.lock = new ReentrantLock();
    }

    public /* synthetic */ ExpireAfterAccessCache(long l, TimeProvider timeProvider, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            timeProvider = new SystemTimeProvider();
        }
        this(l, timeProvider);
    }

    public final long getExpireAfterNanos() {
        return this.expireAfterNanos;
    }

    @NotNull
    public final TimeProvider getTimeProvider() {
        return this.timeProvider;
    }

    @NotNull
    public final HashMap<K, Entry> getMap$ui_text() {
        return this.map;
    }

    @NotNull
    public final LinkedQueue getAccessQueue$ui_text() {
        return this.accessQueue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V get(K key, @NotNull Function1<? super K, ? extends V> loader) {
        Intrinsics.checkNotNullParameter(loader, (String)"loader");
        Lock lock = this.lock;
        lock.lock();
        try {
            boolean bl = false;
            long now = this.getTimeProvider().getTime();
            Entry v = this.getMap$ui_text().get(key);
            if (v != null) {
                v.setAccessTime(now);
                this.getAccessQueue$ui_text().moveToHead(v);
                this.checkEvicted(now);
                Object v2 = v.getValue();
                return v2;
            }
            this.checkEvicted(now);
            Object newVal = loader.invoke(key);
            Entry entry = new Entry(key, newVal, now, null, null, 24, null);
            ((Map)this.getMap$ui_text()).put(key, entry);
            this.getAccessQueue$ui_text().putToHead(entry);
            Object object = newVal;
            return (V)object;
        }
        finally {
            lock.unlock();
        }
    }

    private final void checkEvicted(long now) {
        long expireTime = now - this.expireAfterNanos;
        for (Entry next = this.accessQueue.getTail(); next != null && next.getAccessTime() < expireTime; next = next.getNextInAccess()) {
            this.map.remove(next.getKey());
            this.accessQueue.removeFromTail();
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0000\b`\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H&\u00a8\u0006\u0004"}, d2={"Landroidx/compose/ui/text/ExpireAfterAccessCache$TimeProvider;", "", "getTime", "", "ui-text"})
    public static interface TimeProvider {
        public long getTime();
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016\u00a8\u0006\u0005"}, d2={"Landroidx/compose/ui/text/ExpireAfterAccessCache$SystemTimeProvider;", "Landroidx/compose/ui/text/ExpireAfterAccessCache$TimeProvider;", "()V", "getTime", "", "ui-text"})
    public static final class SystemTimeProvider
    implements TimeProvider {
        @Override
        public long getTime() {
            return System.nanoTime();
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0011\b\u0086\u0004\u0018\u00002\u00020\u0001BU\u0012\u0006\u0010\u0002\u001a\u00028\u0000\u0012\u0006\u0010\u0003\u001a\u00028\u0001\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u001a\b\u0002\u0010\u0006\u001a\u0014\u0018\u00010\u0000R\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0007\u0012\u001a\b\u0002\u0010\b\u001a\u0014\u0018\u00010\u0000R\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0007\u00a2\u0006\u0002\u0010\tR\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u0013\u0010\u0002\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010\u0010\u001a\u0004\b\u000e\u0010\u000fR,\u0010\u0006\u001a\u0014\u0018\u00010\u0000R\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R,\u0010\b\u001a\u0014\u0018\u00010\u0000R\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0012\"\u0004\b\u0016\u0010\u0014R\u0013\u0010\u0003\u001a\u00028\u0001\u00a2\u0006\n\n\u0002\u0010\u0010\u001a\u0004\b\u0017\u0010\u000f\u00a8\u0006\u0018"}, d2={"Landroidx/compose/ui/text/ExpireAfterAccessCache$Entry;", "", "key", "value", "accessTime", "", "nextInAccess", "Landroidx/compose/ui/text/ExpireAfterAccessCache;", "prevInAccess", "(Landroidx/compose/ui/text/ExpireAfterAccessCache;Ljava/lang/Object;Ljava/lang/Object;JLandroidx/compose/ui/text/ExpireAfterAccessCache$Entry;Landroidx/compose/ui/text/ExpireAfterAccessCache$Entry;)V", "getAccessTime", "()J", "setAccessTime", "(J)V", "getKey", "()Ljava/lang/Object;", "Ljava/lang/Object;", "getNextInAccess", "()Landroidx/compose/ui/text/ExpireAfterAccessCache$Entry;", "setNextInAccess", "(Landroidx/compose/ui/text/ExpireAfterAccessCache$Entry;)V", "getPrevInAccess", "setPrevInAccess", "getValue", "ui-text"})
    public final class Entry {
        private final K key;
        private final V value;
        private long accessTime;
        @Nullable
        private Entry nextInAccess;
        @Nullable
        private Entry prevInAccess;

        public Entry(K key, V value, @Nullable long accessTime, @Nullable Entry nextInAccess, Entry prevInAccess) {
            Intrinsics.checkNotNullParameter((Object)ExpireAfterAccessCache.this, (String)"this$0");
            this.key = key;
            this.value = value;
            this.accessTime = accessTime;
            this.nextInAccess = nextInAccess;
            this.prevInAccess = prevInAccess;
        }

        public /* synthetic */ Entry(Object object, Object object2, long l, Entry entry, Entry entry2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 8) != 0) {
                entry = null;
            }
            if ((n & 0x10) != 0) {
                entry2 = null;
            }
            this(object, object2, l, entry, entry2);
        }

        public final K getKey() {
            return this.key;
        }

        public final V getValue() {
            return this.value;
        }

        public final long getAccessTime() {
            return this.accessTime;
        }

        public final void setAccessTime(long l) {
            this.accessTime = l;
        }

        @Nullable
        public final Entry getNextInAccess() {
            return this.nextInAccess;
        }

        public final void setNextInAccess(@Nullable Entry entry) {
            this.nextInAccess = entry;
        }

        @Nullable
        public final Entry getPrevInAccess() {
            return this.prevInAccess;
        }

        public final void setPrevInAccess(@Nullable Entry entry) {
            this.prevInAccess = entry;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\r\u001a\u00020\u000e2\u0016\u0010\u000f\u001a\u00120\u0004R\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0005J\u001e\u0010\u0010\u001a\u00020\u000e2\u0016\u0010\u000f\u001a\u00120\u0004R\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0005J\u0006\u0010\u0011\u001a\u00020\u000eR,\u0010\u0003\u001a\u0014\u0018\u00010\u0004R\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR,\u0010\n\u001a\u0014\u0018\u00010\u0004R\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\u0007\"\u0004\b\f\u0010\t\u00a8\u0006\u0012"}, d2={"Landroidx/compose/ui/text/ExpireAfterAccessCache$LinkedQueue;", "", "(Landroidx/compose/ui/text/ExpireAfterAccessCache;)V", "head", "Landroidx/compose/ui/text/ExpireAfterAccessCache$Entry;", "Landroidx/compose/ui/text/ExpireAfterAccessCache;", "getHead", "()Landroidx/compose/ui/text/ExpireAfterAccessCache$Entry;", "setHead", "(Landroidx/compose/ui/text/ExpireAfterAccessCache$Entry;)V", "tail", "getTail", "setTail", "moveToHead", "", "entry", "putToHead", "removeFromTail", "ui-text"})
    public final class LinkedQueue {
        @Nullable
        private Entry head;
        @Nullable
        private Entry tail;

        public LinkedQueue() {
            Intrinsics.checkNotNullParameter((Object)ExpireAfterAccessCache.this, (String)"this$0");
        }

        @Nullable
        public final Entry getHead() {
            return this.head;
        }

        public final void setHead(@Nullable Entry entry) {
            this.head = entry;
        }

        @Nullable
        public final Entry getTail() {
            return this.tail;
        }

        public final void setTail(@Nullable Entry entry) {
            this.tail = entry;
        }

        public final void moveToHead(@NotNull Entry entry) {
            Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
            if (Intrinsics.areEqual((Object)this.head, (Object)entry)) {
                return;
            }
            if (Intrinsics.areEqual((Object)this.tail, (Object)entry)) {
                this.tail = entry.getNextInAccess();
            }
            Entry entry2 = entry.getNextInAccess();
            if (entry2 != null) {
                entry2.setPrevInAccess(entry.getPrevInAccess());
            }
            Entry entry3 = entry.getPrevInAccess();
            if (entry3 != null) {
                entry3.setNextInAccess(entry.getNextInAccess());
            }
            Entry entry4 = this.head;
            if (entry4 != null) {
                entry4.setNextInAccess(entry);
            }
            entry.setPrevInAccess(this.head);
            entry.setNextInAccess(null);
            this.head = entry;
        }

        public final void putToHead(@NotNull Entry entry) {
            Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
            if (this.tail == null) {
                this.tail = entry;
            }
            Entry entry2 = this.head;
            if (entry2 != null) {
                entry2.setNextInAccess(entry);
            }
            entry.setPrevInAccess(this.head);
            this.head = entry;
        }

        public final void removeFromTail() {
            if (Intrinsics.areEqual((Object)this.tail, (Object)this.head)) {
            }
            Entry entry = this.tail;
            Entry entry2 = entry == null ? null : entry.getNextInAccess();
            if (entry2 != null) {
                entry2.setPrevInAccess(null);
            }
            Entry entry3 = this.tail;
            this.tail = entry3 == null ? null : entry3.getNextInAccess();
        }
    }
}

