/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.graphics.vector;

import androidx.compose.ui.graphics.Path;
import androidx.compose.ui.graphics.SkiaBackedPath_skikoKt;
import androidx.compose.ui.graphics.vector.FastFloatParserKt;
import androidx.compose.ui.graphics.vector.PathNode;
import androidx.compose.ui.graphics.vector.PathNodeKt;
import androidx.compose.ui.graphics.vector.PathParserKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0014\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\t\u001a\u00020\u00002\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\nJ\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010\r\u001a\u00020\u00002\u0006\u0010\u000e\u001a\u00020\u000fJ8\u0010\u0010\u001a\u0012\u0012\u0004\u0012\u00020\u00070\u0006j\b\u0012\u0004\u0012\u00020\u0007`\b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0018\b\u0002\u0010\u0005\u001a\u0012\u0012\u0004\u0012\u00020\u00070\u0006j\b\u0012\u0004\u0012\u00020\u0007`\bJ\u0011\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0082\bJ\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00070\nJ\u0010\u0010\u0015\u001a\u00020\u00162\b\b\u0002\u0010\u0017\u001a\u00020\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\"\u0010\u0005\u001a\u0016\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u0006j\n\u0012\u0004\u0012\u00020\u0007\u0018\u0001`\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Landroidx/compose/ui/graphics/vector/PathParser;", "", "()V", "nodeData", "", "nodes", "Ljava/util/ArrayList;", "Landroidx/compose/ui/graphics/vector/PathNode;", "Lkotlin/collections/ArrayList;", "addPathNodes", "", "clear", "", "parsePathString", "pathData", "", "pathStringToNodes", "resizeNodeData", "dataCount", "", "toNodes", "toPath", "Landroidx/compose/ui/graphics/Path;", "target", "ui-graphics"})
@SourceDebugExtension(value={"SMAP\nPathParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PathParser.kt\nandroidx/compose/ui/graphics/vector/PathParser\n+ 2 FastFloatParser.kt\nandroidx/compose/ui/graphics/vector/FastFloatParserKt\n+ 3 InlineClassHelper.jvm.kt\nandroidx/compose/ui/util/InlineClassHelper_jvmKt\n*L\n1#1,589:1\n155#1,6:593\n43#2:590\n44#2:591\n22#3:592\n*S KotlinDebug\n*F\n+ 1 PathParser.kt\nandroidx/compose/ui/graphics/vector/PathParser\n*L\n138#1:593,6\n132#1:590\n133#1:591\n133#1:592\n*E\n"})
public final class PathParser {
    @Nullable
    private ArrayList<PathNode> nodes;
    @NotNull
    private float[] nodeData = new float[64];

    public final void clear() {
        block0: {
            ArrayList<PathNode> arrayList = this.nodes;
            if (arrayList == null) break block0;
            arrayList.clear();
        }
    }

    @NotNull
    public final PathParser parsePathString(@NotNull String pathData) {
        Intrinsics.checkNotNullParameter((Object)pathData, (String)"pathData");
        ArrayList<PathNode> dstNodes = this.nodes;
        if (dstNodes == null) {
            this.nodes = dstNodes = new ArrayList();
        } else {
            dstNodes.clear();
        }
        this.pathStringToNodes(pathData, dstNodes);
        return this;
    }

    @NotNull
    public final ArrayList<PathNode> pathStringToNodes(@NotNull String pathData, @NotNull ArrayList<PathNode> nodes) {
        int start;
        Intrinsics.checkNotNullParameter((Object)pathData, (String)"pathData");
        Intrinsics.checkNotNullParameter(nodes, (String)"nodes");
        int end = pathData.length();
        int dataCount = 0;
        for (start = 0; start < end && Intrinsics.compare((int)pathData.charAt(start), (int)32) <= 0; ++start) {
        }
        while (end > start && Intrinsics.compare((int)pathData.charAt(end - 1), (int)32) <= 0) {
            --end;
        }
        int index = start;
        while (index < end) {
            char c = '\u0000';
            char command = '\u0000';
            do {
                int lowerChar;
                if (((lowerChar = (c = pathData.charAt(index++)) | 0x20) - 97) * (lowerChar - 122) > 0 || lowerChar == 101) continue;
                command = c;
                break;
            } while (index < end);
            if (command == '\u0000') continue;
            if ((command | 0x20) != 122) {
                dataCount = 0;
                while (true) {
                    long result;
                    if (index < end && Intrinsics.compare((int)pathData.charAt(index), (int)32) <= 0) {
                        ++index;
                        continue;
                    }
                    long $this$index$iv = result = FastFloatParserKt.nextFloat(pathData, index, end);
                    boolean $i$f$getIndex = false;
                    index = (int)($this$index$iv >>> 32);
                    long $this$floatValue$iv = result;
                    boolean $i$f$getFloatValue = false;
                    int bits$iv$iv = (int)($this$floatValue$iv & 0xFFFFFFFFL);
                    boolean $i$f$floatFromBits = false;
                    float value = Float.intBitsToFloat(bits$iv$iv);
                    if (!Float.isNaN(value)) {
                        this.nodeData[dataCount++] = value;
                        PathParser this_$iv = this;
                        boolean $i$f$resizeNodeData = false;
                        if (dataCount >= this_$iv.nodeData.length) {
                            float[] src$iv = this_$iv.nodeData;
                            this_$iv.nodeData = new float[dataCount * 2];
                            ArraysKt.copyInto((float[])src$iv, (float[])this_$iv.nodeData, (int)0, (int)0, (int)src$iv.length);
                        }
                    }
                    while (index < end && pathData.charAt(index) == ',') {
                        ++index;
                    }
                    if (index >= end || Float.isNaN(value)) break;
                }
            }
            PathNodeKt.addPathNodes(command, nodes, this.nodeData, dataCount);
        }
        return nodes;
    }

    public static /* synthetic */ ArrayList pathStringToNodes$default(PathParser pathParser, String string, ArrayList arrayList, int n, Object object) {
        if ((n & 2) != 0) {
            arrayList = new ArrayList<PathNode>();
        }
        return pathParser.pathStringToNodes(string, arrayList);
    }

    private final void resizeNodeData(int dataCount) {
        boolean $i$f$resizeNodeData = false;
        if (dataCount >= this.nodeData.length) {
            float[] src = this.nodeData;
            this.nodeData = new float[dataCount * 2];
            ArraysKt.copyInto((float[])src, (float[])this.nodeData, (int)0, (int)0, (int)src.length);
        }
    }

    @NotNull
    public final PathParser addPathNodes(@NotNull List<? extends PathNode> nodes) {
        Intrinsics.checkNotNullParameter(nodes, (String)"nodes");
        ArrayList<PathNode> dstNodes = this.nodes;
        if (dstNodes == null) {
            this.nodes = dstNodes = new ArrayList();
        }
        dstNodes.addAll((Collection<PathNode>)nodes);
        return this;
    }

    @NotNull
    public final List<PathNode> toNodes() {
        ArrayList<PathNode> arrayList = this.nodes;
        return arrayList != null ? (List)arrayList : CollectionsKt.emptyList();
    }

    @NotNull
    public final Path toPath(@NotNull Path target) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        ArrayList<PathNode> arrayList = this.nodes;
        if (arrayList == null || (arrayList = PathParserKt.toPath((List<? extends PathNode>)arrayList, target)) == null) {
            arrayList = SkiaBackedPath_skikoKt.Path();
        }
        return arrayList;
    }

    public static /* synthetic */ Path toPath$default(PathParser pathParser, Path path, int n, Object object) {
        if ((n & 1) != 0) {
            path = SkiaBackedPath_skikoKt.Path();
        }
        return pathParser.toPath(path);
    }
}

