/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.graphics.colorspace;

import androidx.compose.ui.graphics.ColorKt;
import androidx.compose.ui.graphics.colorspace.Adaptation;
import androidx.compose.ui.graphics.colorspace.ColorModel;
import androidx.compose.ui.graphics.colorspace.ColorSpace;
import androidx.compose.ui.graphics.colorspace.ColorSpaceKt;
import androidx.compose.ui.graphics.colorspace.Illuminant;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0014\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\t\b\u0000\u0018\u0000 #2\u00020\u0001:\u0001#B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0005H\u0016J\u0010\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0005H\u0016J%\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u000eH\u0010\u00a2\u0006\u0002\b\u0016J\u0010\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0016J%\u0010\u0018\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u000eH\u0010\u00a2\u0006\u0002\b\u0019J=\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u000e2\u0006\u0010\u001d\u001a\u00020\u000e2\u0006\u0010\u001e\u001a\u00020\u000e2\u0006\u0010\u001f\u001a\u00020\u000e2\u0006\u0010 \u001a\u00020\u0001H\u0010\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b!\u0010\"R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\t\u0082\u0002\u000b\n\u0002\b!\n\u0005\b\u00a1\u001e0\u0001\u00a8\u0006$"}, d2={"Landroidx/compose/ui/graphics/colorspace/Oklab;", "Landroidx/compose/ui/graphics/colorspace/ColorSpace;", "name", "", "id", "", "(Ljava/lang/String;I)V", "isWideGamut", "", "()Z", "fromXyz", "", "v", "getMaxValue", "", "component", "getMinValue", "toXy", "", "v0", "v1", "v2", "toXy$ui_graphics", "toXyz", "toZ", "toZ$ui_graphics", "xyzaToColor", "Landroidx/compose/ui/graphics/Color;", "x", "y", "z", "a", "colorSpace", "xyzaToColor-JlNiLsg$ui_graphics", "(FFFFLandroidx/compose/ui/graphics/colorspace/ColorSpace;)J", "Companion", "ui-graphics"})
@SourceDebugExtension(value={"SMAP\nOklab.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Oklab.kt\nandroidx/compose/ui/graphics/colorspace/Oklab\n+ 2 InlineClassHelper.kt\nandroidx/compose/ui/util/InlineClassHelperKt\n*L\n1#1,172:1\n25#2,3:173\n*S KotlinDebug\n*F\n+ 1 Oklab.kt\nandroidx/compose/ui/graphics/colorspace/Oklab\n*L\n78#1:173,3\n*E\n"})
public final class Oklab
extends ColorSpace {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final float[] M1;
    @NotNull
    private static final float[] M2;
    @NotNull
    private static final float[] InverseM1;
    @NotNull
    private static final float[] InverseM2;

    public Oklab(@NotNull String name, int id) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        super(name, ColorModel.Companion.getLab-xdoWZVw(), id, null);
    }

    @Override
    public boolean isWideGamut() {
        return true;
    }

    @Override
    public float getMinValue(int component) {
        return component == 0 ? 0.0f : -0.5f;
    }

    @Override
    public float getMaxValue(int component) {
        return component == 0 ? 1.0f : 0.5f;
    }

    @Override
    @NotNull
    public float[] toXyz(@NotNull float[] v) {
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        v[0] = RangesKt.coerceIn((float)v[0], (float)0.0f, (float)1.0f);
        v[1] = RangesKt.coerceIn((float)v[1], (float)-0.5f, (float)0.5f);
        v[2] = RangesKt.coerceIn((float)v[2], (float)-0.5f, (float)0.5f);
        ColorSpaceKt.mul3x3Float3(InverseM2, v);
        v[0] = v[0] * v[0] * v[0];
        v[1] = v[1] * v[1] * v[1];
        v[2] = v[2] * v[2] * v[2];
        ColorSpaceKt.mul3x3Float3(InverseM1, v);
        return v;
    }

    @Override
    public long toXy$ui_graphics(float v0, float v1, float v2) {
        float v00 = RangesKt.coerceIn((float)v0, (float)0.0f, (float)1.0f);
        float v10 = RangesKt.coerceIn((float)v1, (float)-0.5f, (float)0.5f);
        float v20 = RangesKt.coerceIn((float)v2, (float)-0.5f, (float)0.5f);
        float v01 = ColorSpaceKt.mul3x3Float3_0(InverseM2, v00, v10, v20);
        float v11 = ColorSpaceKt.mul3x3Float3_1(InverseM2, v00, v10, v20);
        float v21 = ColorSpaceKt.mul3x3Float3_2(InverseM2, v00, v10, v20);
        float v02 = v01 * v01 * v01;
        float v12 = v11 * v11 * v11;
        float v22 = v21 * v21 * v21;
        float v03 = ColorSpaceKt.mul3x3Float3_0(InverseM1, v02, v12, v22);
        float v13 = ColorSpaceKt.mul3x3Float3_1(InverseM1, v02, v12, v22);
        boolean $i$f$packFloats = false;
        long v1$iv = Float.floatToIntBits(v03);
        long v2$iv = Float.floatToIntBits(v13);
        return v1$iv << 32 | v2$iv & 0xFFFFFFFFL;
    }

    @Override
    public float toZ$ui_graphics(float v0, float v1, float v2) {
        float v00 = RangesKt.coerceIn((float)v0, (float)0.0f, (float)1.0f);
        float v10 = RangesKt.coerceIn((float)v1, (float)-0.5f, (float)0.5f);
        float v20 = RangesKt.coerceIn((float)v2, (float)-0.5f, (float)0.5f);
        float v01 = ColorSpaceKt.mul3x3Float3_0(InverseM2, v00, v10, v20);
        float v11 = ColorSpaceKt.mul3x3Float3_1(InverseM2, v00, v10, v20);
        float v21 = ColorSpaceKt.mul3x3Float3_2(InverseM2, v00, v10, v20);
        float v02 = v01 * v01 * v01;
        float v12 = v11 * v11 * v11;
        float v22 = v21 * v21 * v21;
        float v23 = ColorSpaceKt.mul3x3Float3_2(InverseM1, v02, v12, v22);
        return v23;
    }

    @Override
    public long xyzaToColor-JlNiLsg$ui_graphics(float x, float y, float z, float a, @NotNull ColorSpace colorSpace) {
        Intrinsics.checkNotNullParameter((Object)colorSpace, (String)"colorSpace");
        float v0 = ColorSpaceKt.mul3x3Float3_0(M1, x, y, z);
        float v1 = ColorSpaceKt.mul3x3Float3_1(M1, x, y, z);
        float v2 = ColorSpaceKt.mul3x3Float3_2(M1, x, y, z);
        v0 = Math.signum(v0) * (float)Math.pow(Math.abs(v0), 0.33333334f);
        v1 = Math.signum(v1) * (float)Math.pow(Math.abs(v1), 0.33333334f);
        v2 = Math.signum(v2) * (float)Math.pow(Math.abs(v2), 0.33333334f);
        float v01 = ColorSpaceKt.mul3x3Float3_0(M2, v0, v1, v2);
        float v11 = ColorSpaceKt.mul3x3Float3_1(M2, v0, v1, v2);
        float v21 = ColorSpaceKt.mul3x3Float3_2(M2, v0, v1, v2);
        return ColorKt.Color(v01, v11, v21, a, colorSpace);
    }

    @Override
    @NotNull
    public float[] fromXyz(@NotNull float[] v) {
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        ColorSpaceKt.mul3x3Float3(M1, v);
        v[0] = Math.signum(v[0]) * (float)Math.pow(Math.abs(v[0]), 0.33333334f);
        v[1] = Math.signum(v[1]) * (float)Math.pow(Math.abs(v[1]), 0.33333334f);
        v[2] = Math.signum(v[2]) * (float)Math.pow(Math.abs(v[2]), 0.33333334f);
        ColorSpaceKt.mul3x3Float3(M2, v);
        return v;
    }

    static {
        float[] fArray = new float[]{0.818933f, 0.032984544f, 0.0482003f, 0.36186674f, 0.9293119f, 0.26436627f, -0.12885971f, 0.03614564f, 0.6338517f};
        M1 = ColorSpaceKt.mul3x3(fArray, ColorSpaceKt.chromaticAdaptation(Adaptation.Companion.getBradford().getTransform$ui_graphics(), Illuminant.INSTANCE.getD50().toXyz$ui_graphics(), Illuminant.INSTANCE.getD65().toXyz$ui_graphics()));
        fArray = new float[]{0.21045426f, 1.9779985f, 0.025904037f, 0.7936178f, -2.4285922f, 0.78277177f, -0.004072047f, 0.4505937f, -0.80867577f};
        M2 = fArray;
        InverseM1 = ColorSpaceKt.inverse3x3(M1);
        InverseM2 = ColorSpaceKt.inverse3x3(M2);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0014\n\u0002\b\u0004\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Landroidx/compose/ui/graphics/colorspace/Oklab$Companion;", "", "()V", "InverseM1", "", "InverseM2", "M1", "M2", "ui-graphics"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

