/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.spatial;

import androidx.collection.MutableObjectList;
import androidx.collection.ObjectList;
import androidx.compose.runtime.collection.MutableVector;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.ComposeUiFlags;
import androidx.compose.ui.geometry.MutableRect;
import androidx.compose.ui.geometry.Offset;
import androidx.compose.ui.graphics.Matrix;
import androidx.compose.ui.graphics.MatrixKt;
import androidx.compose.ui.node.LayoutNode;
import androidx.compose.ui.node.LayoutNodeLayoutDelegate;
import androidx.compose.ui.node.NodeCoordinator;
import androidx.compose.ui.node.OwnedLayer;
import androidx.compose.ui.spatial.RectList;
import androidx.compose.ui.spatial.RectManagerKt;
import androidx.compose.ui.unit.IntOffset;
import androidx.compose.ui.unit.IntOffsetKt;
import androidx.compose.ui.unit.IntSize;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.TypeIntrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\b\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0010\u001a\u00020\bJ8\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u0016H\u0002J*\u0010\u001a\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0014\u001a\u00020\nH\u0002\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\u0010\u0010\u001f\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0006\u0010 \u001a\u00020\bJ\u000e\u0010!\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u0013J(\u0010\"\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0014\u001a\u00020\n\u00f8\u0001\u0000\u00a2\u0006\u0004\b#\u0010\u001eJ\u0016\u0010$\u001a\u0004\u0018\u00010\u00012\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\b0\u0007J\u000e\u0010&\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u0013J\u0010\u0010'\u001a\u00020\b2\b\u0010(\u001a\u0004\u0018\u00010\u0001J\u0014\u0010)\u001a\u00020\b*\u00020*2\u0006\u0010+\u001a\u00020\u0004H\u0002J\u0019\u0010,\u001a\u00020\u001c*\u00020\u0013H\u0002\u00f8\u0001\u0001\u00f8\u0001\u0000\u00a2\u0006\u0004\b-\u0010.J\u0019\u0010/\u001a\u00020\u001c*\u00020*H\u0002\u00f8\u0001\u0001\u00f8\u0001\u0000\u00a2\u0006\u0004\b0\u00101R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u0082\u0002\u000b\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u00062"}, d2={"Landroidx/compose/ui/spatial/RectManager;", "", "()V", "cachedRect", "Landroidx/compose/ui/geometry/MutableRect;", "callbacks", "Landroidx/collection/MutableObjectList;", "Lkotlin/Function0;", "", "isDirty", "", "isFragmented", "rects", "Landroidx/compose/ui/spatial/RectList;", "getRects", "()Landroidx/compose/ui/spatial/RectList;", "dispatchCallbacks", "insertOrUpdate", "layoutNode", "Landroidx/compose/ui/node/LayoutNode;", "firstPlacement", "l", "", "t", "r", "b", "insertOrUpdateTransformedNode", "position", "Landroidx/compose/ui/unit/IntOffset;", "insertOrUpdateTransformedNode-70tqf50", "(Landroidx/compose/ui/node/LayoutNode;JZ)V", "insertOrUpdateTransformedNodeSubhierarchy", "invalidate", "onLayoutLayerPositionalPropertiesChanged", "onLayoutPositionChanged", "onLayoutPositionChanged-70tqf50", "registerOnChangedCallback", "callback", "remove", "unregisterOnChangedCallback", "token", "boundingRectInRoot", "Landroidx/compose/ui/node/NodeCoordinator;", "rect", "outerToInnerOffset", "outerToInnerOffset-Bjo55l4", "(Landroidx/compose/ui/node/LayoutNode;)J", "positionInRoot", "positionInRoot-Bjo55l4", "(Landroidx/compose/ui/node/NodeCoordinator;)J", "ui"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nRectManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RectManager.kt\nandroidx/compose/ui/spatial/RectManager\n+ 2 ObjectList.kt\nandroidx/collection/ObjectListKt\n+ 3 ObjectList.kt\nandroidx/collection/ObjectList\n+ 4 LayoutNode.kt\nandroidx/compose/ui/node/LayoutNode\n+ 5 MutableVector.kt\nandroidx/compose/runtime/collection/MutableVector\n+ 6 IntSize.kt\nandroidx/compose/ui/unit/IntSize\n+ 7 InlineClassHelper.kt\nandroidx/compose/ui/util/InlineClassHelperKt\n+ 8 IntSize.kt\nandroidx/compose/ui/unit/IntSizeKt\n+ 9 IntOffset.kt\nandroidx/compose/ui/unit/IntOffsetKt\n+ 10 Offset.kt\nandroidx/compose/ui/geometry/OffsetKt\n+ 11 RectManager.kt\nandroidx/compose/ui/spatial/RectManagerKt\n*L\n1#1,356:1\n1501#2:357\n286#3,6:358\n197#4:364\n197#4:382\n433#5,11:365\n433#5,11:383\n54#6:376\n59#6:378\n85#7:377\n90#7:379\n80#7:381\n53#7,3:396\n30#8:380\n159#9:394\n30#10:395\n349#11:399\n353#11:400\n*S KotlinDebug\n*F\n+ 1 RectManager.kt\nandroidx/compose/ui/spatial/RectManager\n*L\n38#1:357\n58#1:358,6\n80#1:364\n168#1:382\n80#1:365,11\n168#1:383,11\n114#1:376\n115#1:378\n114#1:377\n115#1:379\n153#1:381\n267#1:396,3\n153#1:380\n267#1:394\n267#1:395\n290#1:399\n291#1:400\n*E\n"})
public final class RectManager {
    @NotNull
    private final RectList rects = new RectList();
    @NotNull
    private final MutableObjectList<Function0<Unit>> callbacks;
    private boolean isDirty;
    private boolean isFragmented;
    @NotNull
    private final MutableRect cachedRect;
    public static final int $stable = 8;

    public RectManager() {
        boolean $i$f$mutableObjectListOf = false;
        this.callbacks = new MutableObjectList(0, 1, null);
        this.cachedRect = new MutableRect(0.0f, 0.0f, 0.0f, 0.0f);
    }

    @NotNull
    public final RectList getRects() {
        return this.rects;
    }

    public final void invalidate() {
        this.isDirty = true;
    }

    public final void dispatchCallbacks() {
        if (this.isDirty) {
            this.isDirty = false;
            if (this.isFragmented) {
                this.isFragmented = false;
                this.rects.defragment();
            }
            ObjectList this_$iv = (ObjectList)this.callbacks;
            boolean $i$f$forEach = false;
            Object[] content$iv = this_$iv.content;
            int n = this_$iv._size;
            for (int i$iv = 0; i$iv < n; ++i$iv) {
                Function0 it = (Function0)content$iv[i$iv];
                boolean bl = false;
                it.invoke();
            }
        }
    }

    @Nullable
    public final Object registerOnChangedCallback(@NotNull Function0<Unit> callback) {
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        this.callbacks.add(callback);
        return callback;
    }

    public final void unregisterOnChangedCallback(@Nullable Object token) {
        if ((TypeIntrinsics.isFunctionOfArity((Object)token, (int)0) ? (Function0)token : null) == null) {
            return;
        }
        this.callbacks.remove(token);
    }

    public final void onLayoutLayerPositionalPropertiesChanged(@NotNull LayoutNode layoutNode2) {
        Intrinsics.checkNotNullParameter((Object)layoutNode2, (String)"layoutNode");
        if (!ComposeUiFlags.isRectTrackingEnabled) {
            return;
        }
        long outerToInnerOffset = this.outerToInnerOffset-Bjo55l4(layoutNode2);
        if (RectManagerKt.access$isSet--gyyYBs(outerToInnerOffset)) {
            layoutNode2.setOuterToInnerOffset--gyyYBs$ui(outerToInnerOffset);
            layoutNode2.setOuterToInnerOffsetDirty$ui(false);
            LayoutNode this_$iv = layoutNode2;
            boolean $i$f$forEachChild = false;
            MutableVector<LayoutNode> this_$iv$iv = this_$iv.get_children$ui();
            boolean $i$f$forEach = false;
            int size$iv$iv = this_$iv$iv.getSize();
            if (size$iv$iv > 0) {
                int i$iv$iv = 0;
                Object[] content$iv$iv = this_$iv$iv.getContent();
                do {
                    LayoutNode it = (LayoutNode)content$iv$iv[i$iv$iv];
                    boolean bl = false;
                    this.onLayoutPositionChanged-70tqf50(it, it.getOuterCoordinator$ui().getPosition-nOcc-ac(), false);
                } while (++i$iv$iv < size$iv$iv);
            }
        } else {
            this.insertOrUpdateTransformedNodeSubhierarchy(layoutNode2);
        }
    }

    public final void onLayoutPositionChanged-70tqf50(@NotNull LayoutNode layoutNode2, long position, boolean firstPlacement) {
        Intrinsics.checkNotNullParameter((Object)layoutNode2, (String)"layoutNode");
        if (!ComposeUiFlags.isRectTrackingEnabled) {
            return;
        }
        LayoutNodeLayoutDelegate.MeasurePassDelegate delegate = layoutNode2.getMeasurePassDelegate$ui();
        int width = delegate.getMeasuredWidth();
        int height = delegate.getMeasuredHeight();
        LayoutNode parent2 = layoutNode2.getParent$ui();
        long offset = 0L;
        long lastOffset = layoutNode2.getOffsetFromRoot-nOcc-ac$ui();
        long lastSize = layoutNode2.getLastSize-YbymL2g$ui();
        boolean bl = false;
        long value$iv$iv = lastSize;
        boolean $i$f$unpackInt1 = false;
        int lastWidth = (int)(value$iv$iv >> 32);
        boolean bl2 = false;
        long value$iv$iv2 = lastSize;
        boolean $i$f$unpackInt2 = false;
        int lastHeight = (int)(value$iv$iv2 & 0xFFFFFFFFL);
        boolean hasNonTranslationTransformations = false;
        if (parent2 != null) {
            long l;
            boolean parentOffsetDirty = parent2.getOuterToInnerOffsetDirty$ui();
            long parentOffset = parent2.getOffsetFromRoot-nOcc-ac$ui();
            long prevOuterToInnerOffset = parent2.getOuterToInnerOffset-nOcc-ac$ui();
            if (RectManagerKt.access$isSet--gyyYBs(parentOffset)) {
                long l2;
                if (parentOffsetDirty) {
                    long it = this.outerToInnerOffset-Bjo55l4(parent2);
                    parent2.setOuterToInnerOffset--gyyYBs$ui(it);
                    parent2.setOuterToInnerOffsetDirty$ui(false);
                    l2 = it;
                } else {
                    l2 = prevOuterToInnerOffset;
                }
                long parentOuterInnerOffset = l2;
                hasNonTranslationTransformations = !RectManagerKt.access$isSet--gyyYBs(parentOuterInnerOffset);
                l = IntOffset.plus-qkQi6aY((long)IntOffset.plus-qkQi6aY((long)parentOffset, (long)parentOuterInnerOffset), (long)position);
            } else {
                l = this.positionInRoot-Bjo55l4(layoutNode2.getOuterCoordinator$ui());
            }
            offset = l;
        } else {
            offset = position;
        }
        if (hasNonTranslationTransformations || !RectManagerKt.access$isSet--gyyYBs(offset)) {
            this.insertOrUpdateTransformedNode-70tqf50(layoutNode2, position, firstPlacement);
            return;
        }
        layoutNode2.setOffsetFromRoot--gyyYBs$ui(offset);
        boolean $i$f$IntSize = false;
        boolean $i$f$packInts = false;
        layoutNode2.setLastSize-ozmzZPI$ui(IntSize.constructor-impl((long)((long)width << 32 | (long)height & 0xFFFFFFFFL)));
        int l = IntOffset.getX-impl((long)offset);
        int t = IntOffset.getY-impl((long)offset);
        int r = l + width;
        int b = t + height;
        if (!firstPlacement && IntOffset.equals-impl0((long)offset, (long)lastOffset) && lastWidth == width && lastHeight == height) {
            return;
        }
        this.insertOrUpdate(layoutNode2, firstPlacement, l, t, r, b);
    }

    private final void insertOrUpdateTransformedNodeSubhierarchy(LayoutNode layoutNode2) {
        LayoutNode this_$iv = layoutNode2;
        boolean $i$f$forEachChild = false;
        MutableVector<LayoutNode> this_$iv$iv = this_$iv.get_children$ui();
        boolean $i$f$forEach = false;
        int size$iv$iv = this_$iv$iv.getSize();
        if (size$iv$iv > 0) {
            int i$iv$iv = 0;
            Object[] content$iv$iv = this_$iv$iv.getContent();
            do {
                LayoutNode it = (LayoutNode)content$iv$iv[i$iv$iv];
                boolean bl = false;
                this.insertOrUpdateTransformedNode-70tqf50(it, it.getOuterCoordinator$ui().getPosition-nOcc-ac(), false);
                this.insertOrUpdateTransformedNodeSubhierarchy(it);
            } while (++i$iv$iv < size$iv$iv);
        }
    }

    private final void insertOrUpdateTransformedNode-70tqf50(LayoutNode layoutNode2, long position, boolean firstPlacement) {
        NodeCoordinator coord = layoutNode2.getOuterCoordinator$ui();
        LayoutNodeLayoutDelegate.MeasurePassDelegate delegate = layoutNode2.getMeasurePassDelegate$ui();
        int width = delegate.getMeasuredWidth();
        int height = delegate.getMeasuredHeight();
        MutableRect rect = this.cachedRect;
        rect.set((float)IntOffset.getX-impl((long)position), (float)IntOffset.getY-impl((long)position), (float)(IntOffset.getX-impl((long)position) + width), (float)(IntOffset.getY-impl((long)position) + height));
        this.boundingRectInRoot(coord, rect);
        int l = (int)rect.getLeft();
        int t = (int)rect.getTop();
        int r = (int)rect.getRight();
        int b = (int)rect.getBottom();
        int id = layoutNode2.getSemanticsId();
        if (firstPlacement || !this.rects.update(id, l, t, r, b)) {
            LayoutNode layoutNode3 = layoutNode2.getParent$ui();
            int parentId = layoutNode3 != null ? layoutNode3.getSemanticsId() : -1;
            RectList.insert$default(this.rects, id, l, t, r, b, parentId, false, false, 192, null);
        }
        this.invalidate();
    }

    private final void insertOrUpdate(LayoutNode layoutNode2, boolean firstPlacement, int l, int t, int r, int b) {
        int id = layoutNode2.getSemanticsId();
        if (firstPlacement || !this.rects.move(id, l, t, r, b)) {
            LayoutNode layoutNode3 = layoutNode2.getParent$ui();
            int parentId = layoutNode3 != null ? layoutNode3.getSemanticsId() : -1;
            RectList.insert$default(this.rects, id, l, t, r, b, parentId, false, false, 192, null);
        }
        this.invalidate();
    }

    private final long positionInRoot-Bjo55l4(NodeCoordinator $this$positionInRoot_u2dBjo55l4) {
        long position = Offset.Companion.getZero-F1C5BW0();
        for (NodeCoordinator coordinator = $this$positionInRoot_u2dBjo55l4; coordinator != null; coordinator = coordinator.getWrappedBy$ui()) {
            boolean hasNonTranslationComponents;
            float[] matrix;
            int analysis;
            OwnedLayer layer = coordinator.getLayer();
            position = IntOffsetKt.plus-Nv-tHpc((long)position, (long)coordinator.getPosition-nOcc-ac());
            if (layer == null || (analysis = RectManagerKt.access$analyzeComponents-58bKbWc(matrix = layer.getUnderlyingMatrix-sQKQjiQ())) == 3) continue;
            boolean bl = hasNonTranslationComponents = (analysis & 2) == 0;
            if (hasNonTranslationComponents) {
                return IntOffset.Companion.getMax-nOcc-ac();
            }
            position = Matrix.map-MK-Hz9U((float[])matrix, (long)position);
        }
        return IntOffsetKt.round-k-4lQ0M((long)position);
    }

    /*
     * WARNING - void declaration
     */
    private final void boundingRectInRoot(NodeCoordinator $this$boundingRectInRoot, MutableRect rect) {
        for (NodeCoordinator coordinator = $this$boundingRectInRoot; coordinator != null; coordinator = coordinator.getWrappedBy$ui()) {
            float[] matrix;
            void x$iv$iv;
            OwnedLayer layer = coordinator.getLayer();
            long $this$toOffset_u2d_u2dgyyYBs$iv = coordinator.getPosition-nOcc-ac();
            boolean bl = false;
            float f = IntOffset.getX-impl((long)$this$toOffset_u2d_u2dgyyYBs$iv);
            float y$iv$iv = IntOffset.getY-impl((long)$this$toOffset_u2d_u2dgyyYBs$iv);
            boolean $i$f$Offset = false;
            boolean $i$f$packFloats = false;
            long v1$iv$iv$iv = Float.floatToRawIntBits((float)x$iv$iv);
            long v2$iv$iv$iv = Float.floatToRawIntBits(y$iv$iv);
            rect.translate-k-4lQ0M(Offset.constructor-impl((long)(v1$iv$iv$iv << 32 | v2$iv$iv$iv & 0xFFFFFFFFL)));
            if (layer == null || MatrixKt.isIdentity-58bKbWc((float[])(matrix = layer.getUnderlyingMatrix-sQKQjiQ()))) continue;
            Matrix.map-impl((float[])matrix, (MutableRect)rect);
        }
    }

    private final long outerToInnerOffset-Bjo55l4(LayoutNode $this$outerToInnerOffset_u2dBjo55l4) {
        NodeCoordinator terminator = $this$outerToInnerOffset_u2dBjo55l4.getOuterCoordinator$ui();
        long position = Offset.Companion.getZero-F1C5BW0();
        for (NodeCoordinator coordinator = $this$outerToInnerOffset_u2dBjo55l4.getInnerCoordinator$ui(); coordinator != null && coordinator != terminator; coordinator = coordinator.getWrappedBy$ui()) {
            int analysis;
            OwnedLayer layer = coordinator.getLayer();
            position = IntOffsetKt.plus-Nv-tHpc((long)position, (long)coordinator.getPosition-nOcc-ac());
            if (layer == null) continue;
            float[] matrix = layer.getUnderlyingMatrix-sQKQjiQ();
            int $this$isIdentity$iv = analysis = RectManagerKt.access$analyzeComponents-58bKbWc(matrix);
            boolean $i$f$isIdentity = false;
            if ($this$isIdentity$iv == 3) continue;
            int $this$hasNonTranslationComponents$iv = analysis;
            boolean $i$f$getHasNonTranslationComponents = false;
            if (($this$hasNonTranslationComponents$iv & 2) == 0) {
                return IntOffset.Companion.getMax-nOcc-ac();
            }
            position = Matrix.map-MK-Hz9U((float[])matrix, (long)position);
        }
        return IntOffsetKt.round-k-4lQ0M((long)position);
    }

    public final void remove(@NotNull LayoutNode layoutNode2) {
        Intrinsics.checkNotNullParameter((Object)layoutNode2, (String)"layoutNode");
        this.rects.remove(layoutNode2.getSemanticsId());
        this.invalidate();
        this.isFragmented = true;
    }
}

