/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.node;

import androidx.collection.MutableObjectIntMap;
import androidx.collection.ObjectIntMap;
import androidx.collection.ObjectIntMapKt;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.internal.InlineClassHelperKt;
import androidx.compose.ui.node.DepthSortedSetKt;
import androidx.compose.ui.node.LayoutNode;
import androidx.compose.ui.node.SortedSet;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0007J\u000e\u0010\r\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u0007J\u0006\u0010\u000e\u001a\u00020\u0003J\t\u0010\u000f\u001a\u00020\u0003H\u0086\bJ\u0006\u0010\u0010\u001a\u00020\u0007J\"\u0010\u0011\u001a\u00020\u000b2\u0014\b\u0004\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u000b0\u0013H\u0086\b\u00f8\u0001\u0000J\u000e\u0010\u0014\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u0007J\u000e\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0002J\b\u0010\u0016\u001a\u00020\u0017H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006\u0018"}, d2={"Landroidx/compose/ui/node/DepthSortedSet;", "", "extraAssertions", "", "(Z)V", "mapOfOriginalDepth", "Landroidx/collection/MutableObjectIntMap;", "Landroidx/compose/ui/node/LayoutNode;", "set", "Landroidx/compose/ui/node/SortedSet;", "add", "", "node", "contains", "isEmpty", "isNotEmpty", "pop", "popEach", "block", "Lkotlin/Function1;", "remove", "safeMapOfOriginalDepth", "toString", "", "ui"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nDepthSortedSet.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DepthSortedSet.kt\nandroidx/compose/ui/node/DepthSortedSet\n+ 2 InlineClassHelper.kt\nandroidx/compose/ui/internal/InlineClassHelperKt\n+ 3 ObjectIntMap.kt\nandroidx/collection/ObjectIntMap\n*L\n1#1,203:1\n107#1:230\n56#2,5:204\n56#2,5:209\n56#2,5:214\n56#2,5:219\n56#2,5:225\n438#3:224\n*S KotlinDebug\n*F\n+ 1 DepthSortedSet.kt\nandroidx/compose/ui/node/DepthSortedSet\n*L\n99#1:230\n55#1:204,5\n63#1:209,5\n70#1:214,5\n77#1:219,5\n84#1:225,5\n81#1:224\n*E\n"})
public final class DepthSortedSet {
    private final boolean extraAssertions;
    @Nullable
    private MutableObjectIntMap<LayoutNode> mapOfOriginalDepth;
    @NotNull
    private final SortedSet<LayoutNode> set;
    public static final int $stable = 8;

    public DepthSortedSet(boolean extraAssertions) {
        this.extraAssertions = extraAssertions;
        this.set = new SortedSet(DepthSortedSetKt.access$getDepthComparator$p());
    }

    public final boolean contains(@NotNull LayoutNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        boolean contains = this.set.contains(node);
        if (this.extraAssertions) {
            boolean value$iv = contains == this.safeMapOfOriginalDepth().containsKey((Object)node);
            boolean $i$f$checkPrecondition = false;
            if (!value$iv) {
                boolean bl = false;
                InlineClassHelperKt.throwIllegalStateException("inconsistency in TreeSet");
            }
        }
        return contains;
    }

    public final void add(@NotNull LayoutNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        boolean value$iv = node.isAttached();
        boolean $i$f$checkPrecondition = false;
        if (!value$iv) {
            boolean bl = false;
            InlineClassHelperKt.throwIllegalStateException("DepthSortedSet.add called on an unattached node");
        }
        if (this.extraAssertions) {
            MutableObjectIntMap<LayoutNode> map = this.safeMapOfOriginalDepth();
            int usedDepth = map.getOrDefault((Object)node, Integer.MAX_VALUE);
            if (usedDepth == Integer.MAX_VALUE) {
                map.set((Object)node, node.getDepth$ui());
            } else {
                boolean value$iv2 = usedDepth == node.getDepth$ui();
                boolean $i$f$checkPrecondition2 = false;
                if (!value$iv2) {
                    boolean bl = false;
                    InlineClassHelperKt.throwIllegalStateException("invalid node depth");
                }
            }
        }
        this.set.add(node);
    }

    public final boolean remove(@NotNull LayoutNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        boolean value$iv = node.isAttached();
        boolean $i$f$checkPrecondition = false;
        if (!value$iv) {
            boolean bl = false;
            InlineClassHelperKt.throwIllegalStateException("DepthSortedSet.remove called on an unattached node");
        }
        boolean contains = this.set.remove(node);
        if (this.extraAssertions) {
            MutableObjectIntMap<LayoutNode> map = this.safeMapOfOriginalDepth();
            ObjectIntMap this_$iv = (ObjectIntMap)map;
            boolean $i$f$contains = false;
            if (this_$iv.containsKey((Object)node)) {
                int usedDepth = map.get((Object)node);
                map.remove((Object)node);
                boolean value$iv2 = usedDepth == (contains ? node.getDepth$ui() : Integer.MAX_VALUE);
                boolean $i$f$checkPrecondition2 = false;
                if (!value$iv2) {
                    boolean bl = false;
                    InlineClassHelperKt.throwIllegalStateException("invalid node depth");
                }
            }
        }
        return contains;
    }

    @NotNull
    public final LayoutNode pop() {
        LayoutNode node = (LayoutNode)this.set.first();
        Intrinsics.checkNotNull((Object)node);
        this.remove(node);
        return node;
    }

    public final void popEach(@NotNull Function1<? super LayoutNode, Unit> block) {
        Intrinsics.checkNotNullParameter(block, (String)"block");
        boolean $i$f$popEach = false;
        while (true) {
            DepthSortedSet this_$iv = this;
            boolean $i$f$isNotEmpty = false;
            if (!(!this_$iv.isEmpty())) break;
            LayoutNode node = this.pop();
            block.invoke((Object)node);
        }
    }

    public final boolean isEmpty() {
        return this.set.isEmpty();
    }

    public final boolean isNotEmpty() {
        boolean $i$f$isNotEmpty = false;
        return !this.isEmpty();
    }

    private final MutableObjectIntMap<LayoutNode> safeMapOfOriginalDepth() {
        if (this.mapOfOriginalDepth == null) {
            this.mapOfOriginalDepth = ObjectIntMapKt.mutableObjectIntMapOf();
        }
        MutableObjectIntMap<LayoutNode> mutableObjectIntMap = this.mapOfOriginalDepth;
        Intrinsics.checkNotNull(mutableObjectIntMap);
        return mutableObjectIntMap;
    }

    @NotNull
    public String toString() {
        String string = this.set.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }
}

