/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.input.pointer;

import androidx.collection.LongSparseArray;
import androidx.collection.MutableObjectList;
import androidx.compose.runtime.collection.MutableVector;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.Modifier;
import androidx.compose.ui.input.pointer.InternalPointerEvent;
import androidx.compose.ui.input.pointer.Node;
import androidx.compose.ui.input.pointer.PointerInputChange;
import androidx.compose.ui.layout.LayoutCoordinates;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0010\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J.\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u000bH\u0016J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0016\u001a\u00020\u0015H\u0016J\u0006\u0010\u0017\u001a\u00020\u0015J\b\u0010\u0018\u001a\u00020\u0015H\u0016J\u0010\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J.\u0010\u001a\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u000bH\u0016J\u001e\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u001d2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00050\tH\u0016J\u0010\u0010\u001f\u001a\u00020\u00152\u0006\u0010 \u001a\u00020!H\u0016R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00000\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Landroidx/compose/ui/input/pointer/NodeParent;", "", "()V", "children", "Landroidx/compose/runtime/collection/MutableVector;", "Landroidx/compose/ui/input/pointer/Node;", "getChildren", "()Landroidx/compose/runtime/collection/MutableVector;", "removeMatchingPointerInputModifierNodeList", "Landroidx/collection/MutableObjectList;", "buildCache", "", "changes", "Landroidx/collection/LongSparseArray;", "Landroidx/compose/ui/input/pointer/PointerInputChange;", "parentCoordinates", "Landroidx/compose/ui/layout/LayoutCoordinates;", "internalPointerEvent", "Landroidx/compose/ui/input/pointer/InternalPointerEvent;", "isInBounds", "cleanUpHits", "", "cleanUpHover", "clear", "dispatchCancel", "dispatchFinalEventPass", "dispatchMainEventPass", "removeInvalidPointerIdsAndChanges", "pointerIdValue", "", "hitNodes", "removePointerInputModifierNode", "pointerInputModifierNode", "Landroidx/compose/ui/Modifier$Node;", "ui"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nHitPathTracker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HitPathTracker.kt\nandroidx/compose/ui/input/pointer/NodeParent\n+ 2 MutableVector.kt\nandroidx/compose/runtime/collection/MutableVectorKt\n+ 3 MutableVector.kt\nandroidx/compose/runtime/collection/MutableVector\n*L\n1#1,642:1\n1147#2:643\n1129#2,2:644\n433#3,11:646\n433#3,11:657\n433#3,11:668\n433#3,11:679\n489#3:690\n433#3,11:691\n42#3:702\n489#3:703\n433#3,11:704\n*S KotlinDebug\n*F\n+ 1 HitPathTracker.kt\nandroidx/compose/ui/input/pointer/NodeParent\n*L\n191#1:643\n191#1:644,2\n203#1:646,11\n230#1:657,11\n250#1:668,11\n260#1:679,11\n277#1:690\n301#1:691,11\n305#1:702\n306#1:703\n314#1:704,11\n*E\n"})
public class NodeParent {
    @NotNull
    private final MutableVector<Node> children;
    @NotNull
    private final MutableObjectList<NodeParent> removeMatchingPointerInputModifierNodeList;
    public static final int $stable = 8;

    public NodeParent() {
        boolean $i$f$mutableVectorOf = false;
        int capacity$iv$iv = 16;
        boolean $i$f$MutableVector = false;
        this.children = new MutableVector((Object[])new Node[capacity$iv$iv], 0);
        this.removeMatchingPointerInputModifierNodeList = new MutableObjectList(10);
    }

    @NotNull
    public final MutableVector<Node> getChildren() {
        return this.children;
    }

    public boolean buildCache(@NotNull LongSparseArray<PointerInputChange> changes, @NotNull LayoutCoordinates parentCoordinates, @NotNull InternalPointerEvent internalPointerEvent, boolean isInBounds) {
        Intrinsics.checkNotNullParameter(changes, (String)"changes");
        Intrinsics.checkNotNullParameter((Object)parentCoordinates, (String)"parentCoordinates");
        Intrinsics.checkNotNullParameter((Object)internalPointerEvent, (String)"internalPointerEvent");
        boolean changed = false;
        MutableVector<Node> this_$iv = this.children;
        boolean $i$f$forEach = false;
        int size$iv = this_$iv.getSize();
        if (size$iv > 0) {
            int i$iv = 0;
            Object[] content$iv = this_$iv.getContent();
            do {
                Node it = (Node)content$iv[i$iv];
                boolean bl = false;
                changed = it.buildCache(changes, parentCoordinates, internalPointerEvent, isInBounds) || changed;
            } while (++i$iv < size$iv);
        }
        return changed;
    }

    public boolean dispatchMainEventPass(@NotNull LongSparseArray<PointerInputChange> changes, @NotNull LayoutCoordinates parentCoordinates, @NotNull InternalPointerEvent internalPointerEvent, boolean isInBounds) {
        Intrinsics.checkNotNullParameter(changes, (String)"changes");
        Intrinsics.checkNotNullParameter((Object)parentCoordinates, (String)"parentCoordinates");
        Intrinsics.checkNotNullParameter((Object)internalPointerEvent, (String)"internalPointerEvent");
        boolean dispatched = false;
        MutableVector<Node> this_$iv = this.children;
        boolean $i$f$forEach = false;
        int size$iv = this_$iv.getSize();
        if (size$iv > 0) {
            int i$iv = 0;
            Object[] content$iv = this_$iv.getContent();
            do {
                Node it = (Node)content$iv[i$iv];
                boolean bl = false;
                dispatched = it.dispatchMainEventPass(changes, parentCoordinates, internalPointerEvent, isInBounds) || dispatched;
            } while (++i$iv < size$iv);
        }
        return dispatched;
    }

    public boolean dispatchFinalEventPass(@NotNull InternalPointerEvent internalPointerEvent) {
        Intrinsics.checkNotNullParameter((Object)internalPointerEvent, (String)"internalPointerEvent");
        boolean dispatched = false;
        MutableVector<Node> this_$iv = this.children;
        boolean $i$f$forEach = false;
        int size$iv = this_$iv.getSize();
        if (size$iv > 0) {
            int i$iv = 0;
            Object[] content$iv = this_$iv.getContent();
            do {
                Node it = (Node)content$iv[i$iv];
                boolean bl = false;
                dispatched = it.dispatchFinalEventPass(internalPointerEvent) || dispatched;
            } while (++i$iv < size$iv);
        }
        this.cleanUpHits(internalPointerEvent);
        this.cleanUpHover();
        return dispatched;
    }

    public void dispatchCancel() {
        MutableVector<Node> this_$iv = this.children;
        boolean $i$f$forEach = false;
        int size$iv = this_$iv.getSize();
        if (size$iv > 0) {
            int i$iv = 0;
            Object[] content$iv = this_$iv.getContent();
            do {
                Node it = (Node)content$iv[i$iv];
                boolean bl = false;
                it.dispatchCancel();
            } while (++i$iv < size$iv);
        }
    }

    public void removePointerInputModifierNode(@NotNull Modifier.Node pointerInputModifierNode) {
        Intrinsics.checkNotNullParameter((Object)pointerInputModifierNode, (String)"pointerInputModifierNode");
        this.removeMatchingPointerInputModifierNodeList.clear();
        this.removeMatchingPointerInputModifierNodeList.add((Object)this);
        while (this.removeMatchingPointerInputModifierNodeList.isNotEmpty()) {
            NodeParent parent2 = (NodeParent)this.removeMatchingPointerInputModifierNodeList.removeAt(this.removeMatchingPointerInputModifierNodeList.getSize() - 1);
            int index = 0;
            while (index < parent2.children.getSize()) {
                MutableVector<Node> this_$iv = parent2.children;
                boolean $i$f$get = false;
                Node child = (Node)this_$iv.getContent()[index];
                if (Intrinsics.areEqual((Object)child.getModifierNode(), (Object)pointerInputModifierNode)) {
                    parent2.children.remove((Object)child);
                    child.dispatchCancel();
                    continue;
                }
                this.removeMatchingPointerInputModifierNodeList.add((Object)child);
                ++index;
            }
        }
    }

    public final void clear() {
        this.children.clear();
    }

    public void removeInvalidPointerIdsAndChanges(long pointerIdValue, @NotNull MutableObjectList<Node> hitNodes) {
        Intrinsics.checkNotNullParameter(hitNodes, (String)"hitNodes");
        MutableVector<Node> this_$iv = this.children;
        boolean $i$f$forEach = false;
        int size$iv = this_$iv.getSize();
        if (size$iv > 0) {
            int i$iv = 0;
            Object[] content$iv = this_$iv.getContent();
            do {
                Node it = (Node)content$iv[i$iv];
                boolean bl = false;
                it.removeInvalidPointerIdsAndChanges(pointerIdValue, hitNodes);
            } while (++i$iv < size$iv);
        }
    }

    public void cleanUpHits(@NotNull InternalPointerEvent internalPointerEvent) {
        Intrinsics.checkNotNullParameter((Object)internalPointerEvent, (String)"internalPointerEvent");
        MutableVector<Node> this_$iv = this.children;
        boolean $i$f$getLastIndex = false;
        for (int i = this_$iv.getSize() - 1; -1 < i; --i) {
            MutableVector<Node> this_$iv2 = this.children;
            boolean $i$f$get = false;
            Node child = (Node)this_$iv2.getContent()[i];
            if (!child.getPointerIds().isEmpty()) continue;
            this.children.removeAt(i);
        }
    }

    public void cleanUpHover() {
        MutableVector<Node> this_$iv = this.children;
        boolean $i$f$forEach = false;
        int size$iv = this_$iv.getSize();
        if (size$iv > 0) {
            int i$iv = 0;
            Object[] content$iv = this_$iv.getContent();
            do {
                Node it = (Node)content$iv[i$iv];
                boolean bl = false;
                it.cleanUpHover();
            } while (++i$iv < size$iv);
        }
    }
}

