/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.ui.platform.l10n

import androidx.compose.ui.platform.Strings
import androidx.compose.ui.platform.Translations

@Suppress("UnusedReceiverParameter", "DuplicatedCode")
internal fun Translations.en() = mapOf(
    Strings.SelectAll to "Select all",
    Strings.Cut to "Cut",
    Strings.Copy to "Copy",
    Strings.Paste to "Paste",
)

@Suppress("UnusedReceiverParameter", "DuplicatedCode")
internal fun Translations.enAU() = mapOf(
    Strings.SelectAll to "Select all",
    Strings.Cut to "Cut",
    Strings.Copy to "Copy",
    Strings.Paste to "Paste",
)

@Suppress("UnusedReceiverParameter", "DuplicatedCode")
internal fun Translations.enCA() = mapOf(
    Strings.SelectAll to "Select all",
    Strings.Cut to "Cut",
    Strings.Copy to "Copy",
    Strings.Paste to "Paste",
)

@Suppress("UnusedReceiverParameter", "DuplicatedCode")
internal fun Translations.enGB() = mapOf(
    Strings.SelectAll to "Select all",
    Strings.Cut to "Cut",
    Strings.Copy to "Copy",
    Strings.Paste to "Paste",
)

@Suppress("UnusedReceiverParameter", "DuplicatedCode")
internal fun Translations.enIN() = mapOf(
    Strings.SelectAll to "Select all",
    Strings.Cut to "Cut",
    Strings.Copy to "Copy",
    Strings.Paste to "Paste",
)
