/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.focus;

import androidx.compose.ui.ExperimentalComposeUiApi;
import androidx.compose.ui.Modifier;
import androidx.compose.ui.focus.FocusDirection;
import androidx.compose.ui.focus.FocusEventModifierNodeKt;
import androidx.compose.ui.focus.FocusProperties;
import androidx.compose.ui.focus.FocusStateImpl;
import androidx.compose.ui.focus.FocusTargetModifierNode;
import androidx.compose.ui.focus.FocusTransactionsKt;
import androidx.compose.ui.focus.FocusTraversalKt;
import androidx.compose.ui.focus.TwoDimensionalFocusSearchKt;
import androidx.compose.ui.node.DelegatableNode;
import androidx.compose.ui.node.DelegatableNodeKt;
import androidx.compose.ui.node.LayoutNode;
import androidx.compose.ui.node.NodeCoordinator;
import androidx.compose.ui.node.NodeKind;
import androidx.compose.ui.node.ObserverNodeKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u000b\u001a\f\u0010\u0000\u001a\u00020\u0001*\u00020\u0002H\u0001\u001a \u0010\u0003\u001a\u00020\u0001*\u00020\u00022\b\b\u0002\u0010\u0004\u001a\u00020\u00012\b\b\u0002\u0010\u0005\u001a\u00020\u0001H\u0003\u001a\u001e\u0010\u0006\u001a\u00020\u0001*\u00020\u00022\b\b\u0002\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u0001H\u0001\u001a\f\u0010\u0007\u001a\u00020\u0001*\u00020\u0002H\u0001\u001a\f\u0010\b\u001a\u00020\u0001*\u00020\u0002H\u0002\u001a\f\u0010\t\u001a\u00020\u0001*\u00020\u0002H\u0001\u001a\u0014\u0010\n\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u000b\u001a\u00020\u0002H\u0002\u001a\f\u0010\f\u001a\u00020\u0001*\u00020\u0002H\u0002\u00a8\u0006\r"}, d2={"captureFocus", "", "Landroidx/compose/ui/focus/FocusTargetModifierNode;", "clearChildFocus", "forced", "refreshFocusEvents", "clearFocus", "freeFocus", "grantFocus", "requestFocus", "requestFocusForChild", "childNode", "requestFocusForOwner", "ui"})
@SourceDebugExtension(value={"SMAP\nFocusTransactions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FocusTransactions.kt\nandroidx/compose/ui/focus/FocusTransactionsKt\n+ 2 NodeKind.kt\nandroidx/compose/ui/node/Nodes\n+ 3 DelegatableNode.kt\nandroidx/compose/ui/node/DelegatableNodeKt\n*L\n1#1,242:1\n89#2:243\n89#2:245\n89#2:247\n324#3:244\n324#3:246\n324#3:248\n*S KotlinDebug\n*F\n+ 1 FocusTransactions.kt\nandroidx/compose/ui/focus/FocusTransactionsKt\n*L\n55#1:243\n185#1:245\n209#1:247\n55#1:244\n185#1:246\n209#1:248\n*E\n"})
public final class FocusTransactionsKt {
    /*
     * WARNING - void declaration
     */
    @ExperimentalComposeUiApi
    public static final boolean requestFocus(@NotNull FocusTargetModifierNode $this$requestFocus) {
        Intrinsics.checkNotNullParameter((Object)$this$requestFocus, (String)"<this>");
        if (!$this$requestFocus.getNode().isAttached()) {
            String string = "Check failed.";
            throw new IllegalStateException(string.toString());
        }
        FocusProperties focusProperties = $this$requestFocus.fetchFocusProperties$ui();
        if (!focusProperties.getCanFocus()) {
            return TwoDimensionalFocusSearchKt.findChildCorrespondingToFocusEnter--OM-vw8($this$requestFocus, FocusDirection.Companion.getEnter-dhqQ-8s(), (Function1<? super FocusTargetModifierNode, Boolean>)((Function1)requestFocus.1.INSTANCE));
        }
        switch (WhenMappings.$EnumSwitchMapping$0[$this$requestFocus.getFocusStateImpl$ui().ordinal()]) {
            case 1: 
            case 2: {
                FocusEventModifierNodeKt.refreshFocusEventNodes($this$requestFocus);
                return true;
            }
            case 3: {
                boolean bl;
                boolean success = bl = FocusTransactionsKt.clearChildFocus$default($this$requestFocus, false, false, 3, null) && FocusTransactionsKt.grantFocus($this$requestFocus);
                boolean bl2 = false;
                if (success) {
                    FocusEventModifierNodeKt.refreshFocusEventNodes($this$requestFocus);
                }
                return bl;
            }
            case 4: {
                boolean bl;
                FocusTargetModifierNode focusTargetModifierNode;
                void $this$nearestAncestor_u2d64DMado$iv;
                DelegatableNode success = $this$requestFocus;
                boolean bl3 = false;
                int type$iv = NodeKind.constructor-impl(1024);
                boolean bl4 = false;
                Modifier.Node node = DelegatableNodeKt.nearestAncestor((DelegatableNode)$this$nearestAncestor_u2d64DMado$iv, type$iv);
                if (!(node instanceof FocusTargetModifierNode)) {
                    node = null;
                }
                if ((focusTargetModifierNode = (FocusTargetModifierNode)node) != null) {
                    bl = FocusTransactionsKt.requestFocusForChild(focusTargetModifierNode, $this$requestFocus);
                } else {
                    boolean bl5;
                    boolean success2 = bl5 = FocusTransactionsKt.requestFocusForOwner($this$requestFocus) && FocusTransactionsKt.grantFocus($this$requestFocus);
                    boolean bl6 = false;
                    if (success2) {
                        FocusEventModifierNodeKt.refreshFocusEventNodes($this$requestFocus);
                    }
                    bl = bl5;
                }
                return bl;
            }
        }
        throw new NoWhenBranchMatchedException();
    }

    @ExperimentalComposeUiApi
    public static final boolean captureFocus(@NotNull FocusTargetModifierNode $this$captureFocus) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)$this$captureFocus, (String)"<this>");
        switch (WhenMappings.$EnumSwitchMapping$0[$this$captureFocus.getFocusStateImpl$ui().ordinal()]) {
            case 1: {
                $this$captureFocus.setFocusStateImpl$ui(FocusStateImpl.Captured);
                FocusEventModifierNodeKt.refreshFocusEventNodes($this$captureFocus);
                bl = true;
                break;
            }
            case 2: {
                bl = true;
                break;
            }
            case 3: 
            case 4: {
                bl = false;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return bl;
    }

    @ExperimentalComposeUiApi
    public static final boolean freeFocus(@NotNull FocusTargetModifierNode $this$freeFocus) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)$this$freeFocus, (String)"<this>");
        switch (WhenMappings.$EnumSwitchMapping$0[$this$freeFocus.getFocusStateImpl$ui().ordinal()]) {
            case 2: {
                $this$freeFocus.setFocusStateImpl$ui(FocusStateImpl.Active);
                FocusEventModifierNodeKt.refreshFocusEventNodes($this$freeFocus);
                bl = true;
                break;
            }
            case 1: {
                bl = true;
                break;
            }
            case 3: 
            case 4: {
                bl = false;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return bl;
    }

    @ExperimentalComposeUiApi
    public static final boolean clearFocus(@NotNull FocusTargetModifierNode $this$clearFocus, boolean forced, boolean refreshFocusEvents) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)$this$clearFocus, (String)"<this>");
        switch (WhenMappings.$EnumSwitchMapping$0[$this$clearFocus.getFocusStateImpl$ui().ordinal()]) {
            case 1: {
                $this$clearFocus.setFocusStateImpl$ui(FocusStateImpl.Inactive);
                if (refreshFocusEvents) {
                    FocusEventModifierNodeKt.refreshFocusEventNodes($this$clearFocus);
                }
                bl = true;
                break;
            }
            case 3: {
                if (FocusTransactionsKt.clearChildFocus($this$clearFocus, forced, refreshFocusEvents)) {
                    $this$clearFocus.setFocusStateImpl$ui(FocusStateImpl.Inactive);
                    if (refreshFocusEvents) {
                        FocusEventModifierNodeKt.refreshFocusEventNodes($this$clearFocus);
                    }
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case 2: {
                if (forced) {
                    $this$clearFocus.setFocusStateImpl$ui(FocusStateImpl.Inactive);
                    if (refreshFocusEvents) {
                        FocusEventModifierNodeKt.refreshFocusEventNodes($this$clearFocus);
                    }
                }
                bl = forced;
                break;
            }
            case 4: {
                bl = true;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return bl;
    }

    public static /* synthetic */ boolean clearFocus$default(FocusTargetModifierNode focusTargetModifierNode, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        return FocusTransactionsKt.clearFocus(focusTargetModifierNode, bl, bl2);
    }

    private static final boolean grantFocus(FocusTargetModifierNode $this$grantFocus) {
        ObserverNodeKt.observeReads((Modifier.Node)$this$grantFocus, (Function0<Unit>)((Function0)new Function0<Unit>($this$grantFocus){
            final /* synthetic */ FocusTargetModifierNode $this_grantFocus;
            {
                this.$this_grantFocus = $receiver;
                super(0);
            }

            public final void invoke() {
                this.$this_grantFocus.fetchFocusProperties$ui();
            }
        }));
        switch (WhenMappings.$EnumSwitchMapping$0[$this$grantFocus.getFocusStateImpl$ui().ordinal()]) {
            case 3: 
            case 4: {
                $this$grantFocus.setFocusStateImpl$ui(FocusStateImpl.Active);
            }
        }
        return true;
    }

    @ExperimentalComposeUiApi
    private static final boolean clearChildFocus(FocusTargetModifierNode $this$clearChildFocus, boolean forced, boolean refreshFocusEvents) {
        FocusTargetModifierNode focusTargetModifierNode = FocusTraversalKt.getActiveChild($this$clearChildFocus);
        return focusTargetModifierNode != null ? FocusTransactionsKt.clearFocus(focusTargetModifierNode, forced, refreshFocusEvents) : true;
    }

    static /* synthetic */ boolean clearChildFocus$default(FocusTargetModifierNode focusTargetModifierNode, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        if ((n & 2) != 0) {
            bl2 = true;
        }
        return FocusTransactionsKt.clearChildFocus(focusTargetModifierNode, bl, bl2);
    }

    /*
     * WARNING - void declaration
     */
    private static final boolean requestFocusForChild(FocusTargetModifierNode $this$requestFocusForChild, FocusTargetModifierNode childNode) {
        boolean bl;
        void $this$nearestAncestor_u2d64DMado$iv;
        DelegatableNode delegatableNode = childNode;
        boolean bl2 = false;
        int type$iv = NodeKind.constructor-impl(1024);
        boolean bl3 = false;
        Modifier.Node node = DelegatableNodeKt.nearestAncestor((DelegatableNode)$this$nearestAncestor_u2d64DMado$iv, type$iv);
        if (!(node instanceof FocusTargetModifierNode)) {
            node = null;
        }
        if (!Intrinsics.areEqual((Object)((FocusTargetModifierNode)node), (Object)$this$requestFocusForChild)) {
            throw new IllegalStateException("Non child node cannot request focus.".toString());
        }
        switch (WhenMappings.$EnumSwitchMapping$0[$this$requestFocusForChild.getFocusStateImpl$ui().ordinal()]) {
            case 1: {
                boolean success = bl3 = FocusTransactionsKt.grantFocus(childNode);
                boolean bl4 = false;
                if (success) {
                    $this$requestFocusForChild.setFocusStateImpl$ui(FocusStateImpl.ActiveParent);
                    FocusEventModifierNodeKt.refreshFocusEventNodes(childNode);
                    FocusEventModifierNodeKt.refreshFocusEventNodes($this$requestFocusForChild);
                }
                bl = bl3;
                break;
            }
            case 3: {
                if (FocusTraversalKt.getActiveChild($this$requestFocusForChild) == null) {
                    String success = "Required value was null.";
                    throw new IllegalStateException(success.toString());
                }
                boolean success = bl3 = FocusTransactionsKt.clearChildFocus$default($this$requestFocusForChild, false, false, 3, null) && FocusTransactionsKt.grantFocus(childNode);
                boolean bl5 = false;
                if (success) {
                    FocusEventModifierNodeKt.refreshFocusEventNodes(childNode);
                }
                bl = bl3;
                break;
            }
            case 4: {
                void type$iv2;
                void $this$nearestAncestor_u2d64DMado$iv2;
                DelegatableNode success = $this$requestFocusForChild;
                int n = 0;
                n = NodeKind.constructor-impl(1024);
                $i$f$nearestAncestor-64DMado = false;
                Modifier.Node node2 = DelegatableNodeKt.nearestAncestor((DelegatableNode)$this$nearestAncestor_u2d64DMado$iv2, (int)type$iv2);
                if (!(node2 instanceof FocusTargetModifierNode)) {
                    node2 = null;
                }
                FocusTargetModifierNode focusParent = (FocusTargetModifierNode)node2;
                if (focusParent == null && FocusTransactionsKt.requestFocusForOwner($this$requestFocusForChild)) {
                    $this$requestFocusForChild.setFocusStateImpl$ui(FocusStateImpl.Active);
                    FocusEventModifierNodeKt.refreshFocusEventNodes($this$requestFocusForChild);
                    bl = FocusTransactionsKt.requestFocusForChild($this$requestFocusForChild, childNode);
                    break;
                }
                if (focusParent != null && FocusTransactionsKt.requestFocusForChild(focusParent, $this$requestFocusForChild)) {
                    boolean bl6;
                    boolean it = bl6 = FocusTransactionsKt.requestFocusForChild($this$requestFocusForChild, childNode);
                    boolean bl7 = false;
                    if (!($this$requestFocusForChild.getFocusState() == FocusStateImpl.ActiveParent)) {
                        String string = "Check failed.";
                        throw new IllegalStateException(string.toString());
                    }
                    bl = bl6;
                    break;
                }
                bl = false;
                break;
            }
            case 2: {
                bl = false;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return bl;
    }

    private static final boolean requestFocusForOwner(FocusTargetModifierNode $this$requestFocusForOwner) {
        Object object = $this$requestFocusForOwner.getCoordinator$ui();
        if (object == null || (object = ((NodeCoordinator)object).getLayoutNode()) == null || (object = ((LayoutNode)object).getOwner$ui()) == null) {
            throw new IllegalStateException("Owner not initialized.".toString());
        }
        return object.requestFocus();
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[FocusStateImpl.values().length];
            try {
                nArray[FocusStateImpl.Active.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FocusStateImpl.Captured.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FocusStateImpl.ActiveParent.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FocusStateImpl.Inactive.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

