/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.window;

import androidx.compose.ui.window.Geometry_desktopKt;
import androidx.compose.ui.window.WindowLocationTracker;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00005\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002*\u0001\u0006\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u000eJ\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0010\u001a\u00020\u000eJ\u000e\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0010\u001a\u00020\u000eR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007R\u0013\u0010\b\u001a\u0004\u0018\u00010\t8F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Landroidx/compose/ui/window/WindowLocationTracker;", "", "()V", "cascadeOffset", "Ljava/awt/Point;", "focusListener", "androidx/compose/ui/window/WindowLocationTracker$focusListener$1", "Landroidx/compose/ui/window/WindowLocationTracker$focusListener$1;", "lastActiveGraphicsConfiguration", "Ljava/awt/GraphicsConfiguration;", "getLastActiveGraphicsConfiguration", "()Ljava/awt/GraphicsConfiguration;", "lastFocusedWindows", "", "Ljava/awt/Window;", "getCascadeLocationFor", "window", "onWindowCreated", "", "onWindowDisposed", "ui"})
public final class WindowLocationTracker {
    @NotNull
    public static final WindowLocationTracker INSTANCE = new WindowLocationTracker();
    @NotNull
    private static final Point cascadeOffset = new Point(48, 48);
    @NotNull
    private static Set<Window> lastFocusedWindows = new LinkedHashSet();
    @NotNull
    private static final focusListener.1 focusListener = new WindowFocusListener(){

        public void windowGainedFocus(@NotNull WindowEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            WindowLocationTracker.access$getLastFocusedWindows$p().remove(e.getWindow());
            Set set = WindowLocationTracker.access$getLastFocusedWindows$p();
            Window window = e.getWindow();
            Intrinsics.checkNotNullExpressionValue((Object)window, (String)"e.window");
            set.add(window);
        }

        public void windowLostFocus(@NotNull WindowEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        }
    };

    private WindowLocationTracker() {
    }

    public final void onWindowCreated(@NotNull Window window) {
        Intrinsics.checkNotNullParameter((Object)window, (String)"window");
        window.addWindowFocusListener(focusListener);
    }

    public final void onWindowDisposed(@NotNull Window window) {
        Intrinsics.checkNotNullParameter((Object)window, (String)"window");
        window.removeWindowFocusListener(focusListener);
        lastFocusedWindows.remove(window);
    }

    @Nullable
    public final GraphicsConfiguration getLastActiveGraphicsConfiguration() {
        Window window = (Window)CollectionsKt.lastOrNull((Iterable)lastFocusedWindows);
        return window != null ? window.getGraphicsConfiguration() : null;
    }

    @NotNull
    public final Point getCascadeLocationFor(@NotNull Window window) {
        Point point;
        Object graphicsConfiguration;
        Intrinsics.checkNotNullParameter((Object)window, (String)"window");
        Window lastWindow = (Window)CollectionsKt.lastOrNull((Iterable)lastFocusedWindows);
        Object object = lastWindow;
        if (object == null || (object = ((Component)object).getGraphicsConfiguration()) == null) {
            GraphicsDevice graphicsDevice = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
            object = graphicsDevice != null ? graphicsDevice.getDefaultConfiguration() : null;
        }
        if ((graphicsConfiguration = object) != null) {
            Rectangle screenBounds = ((GraphicsConfiguration)graphicsConfiguration).getBounds();
            Insets screenInsets = Toolkit.getDefaultToolkit().getScreenInsets((GraphicsConfiguration)graphicsConfiguration);
            Intrinsics.checkNotNullExpressionValue((Object)screenBounds, (String)"screenBounds");
            Point screenLeftTop = Geometry_desktopKt.plus(Geometry_desktopKt.getLeftTop(screenBounds), new Point(screenInsets.left, screenInsets.top));
            Point screenRightBottom = Geometry_desktopKt.minus(Geometry_desktopKt.getRightBottom(screenBounds), new Point(screenInsets.right, screenInsets.bottom));
            Window window2 = lastWindow;
            Point point2 = window2 != null ? window2.getLocation() : null;
            if (point2 == null) {
                point2 = screenLeftTop;
            }
            Point lastLocation = point2;
            Point location = Geometry_desktopKt.plus(lastLocation, cascadeOffset);
            Dimension dimension = window.getSize();
            Intrinsics.checkNotNullExpressionValue((Object)dimension, (String)"window.size");
            Point rightBottom = Geometry_desktopKt.plus(location, Geometry_desktopKt.getRightBottom(dimension));
            if (rightBottom.x > screenRightBottom.x || rightBottom.y > screenRightBottom.y) {
                location = Geometry_desktopKt.plus(screenLeftTop, cascadeOffset);
            }
            point = location;
        } else {
            point = cascadeOffset;
        }
        return point;
    }

    public static final /* synthetic */ Set access$getLastFocusedWindows$p() {
        return lastFocusedWindows;
    }
}

