/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.semantics;

import androidx.compose.ui.Modifier;
import androidx.compose.ui.geometry.Rect;
import androidx.compose.ui.layout.LayoutCoordinatesKt;
import androidx.compose.ui.node.EntityList;
import androidx.compose.ui.node.LayoutNodeEntity;
import androidx.compose.ui.node.LayoutNodeWrapper;
import androidx.compose.ui.node.Owner;
import androidx.compose.ui.semantics.SemanticsActions;
import androidx.compose.ui.semantics.SemanticsConfiguration;
import androidx.compose.ui.semantics.SemanticsConfigurationKt;
import androidx.compose.ui.semantics.SemanticsModifier;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u00020\u0001B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\u000b\u001a\u00020\fJ'\u0010\r\u001a\u0004\u0018\u00010\u00002\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\b0\u000fH\u0080\b\u00f8\u0001\u0000\u00a2\u0006\u0002\b\u0010J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0012H\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\u0006\u0010\u0016\u001a\u00020\u0017R\u0014\u0010\u0007\u001a\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006\u0018"}, d2={"Landroidx/compose/ui/semantics/SemanticsEntity;", "Landroidx/compose/ui/node/LayoutNodeEntity;", "Landroidx/compose/ui/semantics/SemanticsModifier;", "wrapped", "Landroidx/compose/ui/node/LayoutNodeWrapper;", "modifier", "(Landroidx/compose/ui/node/LayoutNodeWrapper;Landroidx/compose/ui/semantics/SemanticsModifier;)V", "useMinimumTouchTarget", "", "getUseMinimumTouchTarget", "()Z", "collapsedSemanticsConfiguration", "Landroidx/compose/ui/semantics/SemanticsConfiguration;", "nearestSemantics", "predicate", "Lkotlin/Function1;", "nearestSemantics$ui", "onAttach", "", "onDetach", "toString", "", "touchBoundsInRoot", "Landroidx/compose/ui/geometry/Rect;", "ui"})
public final class SemanticsEntity
extends LayoutNodeEntity<SemanticsEntity, SemanticsModifier> {
    public SemanticsEntity(@NotNull LayoutNodeWrapper wrapped, @NotNull SemanticsModifier modifier2) {
        Intrinsics.checkNotNullParameter((Object)wrapped, (String)"wrapped");
        Intrinsics.checkNotNullParameter((Object)modifier2, (String)"modifier");
        super(wrapped, (Modifier)modifier2);
    }

    private final boolean getUseMinimumTouchTarget() {
        return SemanticsConfigurationKt.getOrNull(((SemanticsModifier)this.getModifier()).getSemanticsConfiguration(), SemanticsActions.INSTANCE.getOnClick()) != null;
    }

    @NotNull
    public final SemanticsConfiguration collapsedSemanticsConfiguration() {
        SemanticsEntity nextSemantics;
        block14: {
            Object object;
            SemanticsEntity next = (SemanticsEntity)this.getNext();
            if (next == null) {
                LayoutNodeWrapper layoutNodeWrapper = this.getLayoutNodeWrapper().getWrapped$ui();
                if (layoutNodeWrapper != null) {
                    LayoutNodeWrapper wrapper$iv;
                    LayoutNodeWrapper $this$nearestSemantics$iv = layoutNodeWrapper;
                    boolean $i$f$nearestSemantics = false;
                    for (wrapper$iv = $this$nearestSemantics$iv; wrapper$iv != null && !EntityList.has-0OSVbXo(wrapper$iv.getEntities-CHwCgZE(), EntityList.Companion.getSemanticsEntityType-EEbPh1w()); wrapper$iv = wrapper$iv.getWrapped$ui()) {
                    }
                    Object object2 = wrapper$iv;
                    if (object2 != null && (object2 = (SemanticsEntity)EntityList.head-0OSVbXo(((LayoutNodeWrapper)object2).getEntities-CHwCgZE(), EntityList.Companion.getSemanticsEntityType-EEbPh1w())) != null) {
                        Object this_$iv$iv = object2;
                        boolean $i$f$nearestSemantics$ui = false;
                        LayoutNodeWrapper layoutNodeWrapper$iv$iv = ((LayoutNodeEntity)this_$iv$iv).getLayoutNodeWrapper();
                        Object next$iv$iv = this_$iv$iv;
                        while (layoutNodeWrapper$iv$iv != null) {
                            while (next$iv$iv != null) {
                                Object it = next$iv$iv;
                                boolean bl = false;
                                if (true) {
                                    object = next$iv$iv;
                                    break block14;
                                }
                                next$iv$iv = (SemanticsEntity)((LayoutNodeEntity)next$iv$iv).getNext();
                            }
                            LayoutNodeWrapper layoutNodeWrapper2 = layoutNodeWrapper$iv$iv = layoutNodeWrapper$iv$iv.getWrapped$ui();
                            next$iv$iv = layoutNodeWrapper2 != null ? (SemanticsEntity)EntityList.head-0OSVbXo(layoutNodeWrapper2.getEntities-CHwCgZE(), EntityList.Companion.getSemanticsEntityType-EEbPh1w()) : null;
                        }
                        object = null;
                    } else {
                        object = null;
                    }
                } else {
                    object = null;
                }
            } else {
                SemanticsEntity this_$iv = next;
                boolean $i$f$nearestSemantics$ui = false;
                LayoutNodeWrapper layoutNodeWrapper$iv = this_$iv.getLayoutNodeWrapper();
                SemanticsEntity next$iv = this_$iv;
                while (layoutNodeWrapper$iv != null) {
                    while (next$iv != null) {
                        SemanticsEntity it = next$iv;
                        boolean bl = false;
                        if (true) {
                            object = next$iv;
                            break block14;
                        }
                        next$iv = (SemanticsEntity)next$iv.getNext();
                    }
                    LayoutNodeWrapper layoutNodeWrapper = layoutNodeWrapper$iv = layoutNodeWrapper$iv.getWrapped$ui();
                    next$iv = layoutNodeWrapper != null ? (SemanticsEntity)EntityList.head-0OSVbXo(layoutNodeWrapper.getEntities-CHwCgZE(), EntityList.Companion.getSemanticsEntityType-EEbPh1w()) : null;
                }
                object = nextSemantics = null;
            }
        }
        if (nextSemantics == null || ((SemanticsModifier)this.getModifier()).getSemanticsConfiguration().isClearingSemantics()) {
            return ((SemanticsModifier)this.getModifier()).getSemanticsConfiguration();
        }
        SemanticsConfiguration config2 = ((SemanticsModifier)this.getModifier()).getSemanticsConfiguration().copy();
        config2.collapsePeer$ui(nextSemantics.collapsedSemanticsConfiguration());
        return config2;
    }

    @Override
    public void onDetach() {
        block0: {
            super.onDetach();
            Owner owner = this.getLayoutNode().getOwner$ui();
            if (owner == null) break block0;
            owner.onSemanticsChange();
        }
    }

    @Override
    public void onAttach() {
        block0: {
            super.onAttach();
            Owner owner = this.getLayoutNode().getOwner$ui();
            if (owner == null) break block0;
            owner.onSemanticsChange();
        }
    }

    @NotNull
    public String toString() {
        return super.toString() + " id: " + ((SemanticsModifier)this.getModifier()).getId() + " config: " + ((SemanticsModifier)this.getModifier()).getSemanticsConfiguration();
    }

    @NotNull
    public final Rect touchBoundsInRoot() {
        if (!this.isAttached()) {
            return Rect.Companion.getZero();
        }
        if (!this.getUseMinimumTouchTarget()) {
            return LayoutCoordinatesKt.boundsInRoot(this.getLayoutNodeWrapper());
        }
        return this.getLayoutNodeWrapper().touchBoundsInRoot();
    }

    @Nullable
    public final SemanticsEntity nearestSemantics$ui(@NotNull Function1<? super SemanticsEntity, Boolean> predicate) {
        Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
        boolean $i$f$nearestSemantics$ui = false;
        LayoutNodeWrapper layoutNodeWrapper = this.getLayoutNodeWrapper();
        SemanticsEntity next = this;
        while (layoutNodeWrapper != null) {
            while (next != null) {
                if (((Boolean)predicate.invoke((Object)next)).booleanValue()) {
                    return next;
                }
                next = (SemanticsEntity)next.getNext();
            }
            LayoutNodeWrapper layoutNodeWrapper2 = layoutNodeWrapper = layoutNodeWrapper.getWrapped$ui();
            next = layoutNodeWrapper2 != null ? (SemanticsEntity)EntityList.head-0OSVbXo(layoutNodeWrapper2.getEntities-CHwCgZE(), EntityList.Companion.getSemanticsEntityType-EEbPh1w()) : null;
        }
        return null;
    }
}

