/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.node;

import androidx.compose.runtime.collection.MutableVector;
import androidx.compose.ui.node.DepthSortedSet;
import androidx.compose.ui.node.LayoutNode;
import androidx.compose.ui.node.LayoutTreeConsistencyChecker;
import androidx.compose.ui.node.OnPositionedDispatcher;
import androidx.compose.ui.node.Owner;
import androidx.compose.ui.unit.Constraints;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0010\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u001f\u001a\u00020 H\u0002J\u0010\u0010!\u001a\u00020 2\b\b\u0002\u0010\"\u001a\u00020\bJ%\u0010#\u001a\u00020\b2\u0006\u0010$\u001a\u00020\u00032\b\u0010%\u001a\u0004\u0018\u00010\u001bH\u0002\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0002\b&J\u000e\u0010'\u001a\u00020 2\u0006\u0010$\u001a\u00020\u0003J\u0018\u0010(\u001a\u00020\b2\u0010\b\u0002\u0010)\u001a\n\u0012\u0004\u0012\u00020 \u0018\u00010*J#\u0010(\u001a\u00020 2\u0006\u0010$\u001a\u00020\u00032\u0006\u0010%\u001a\u00020\u001b\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b+\u0010,J\u000e\u0010-\u001a\u00020 2\u0006\u0010.\u001a\u00020\u0003J\u0017\u0010/\u001a\u00020 2\f\u00100\u001a\b\u0012\u0004\u0012\u00020 0*H\u0082\bJ\u000e\u00101\u001a\u00020 2\u0006\u00102\u001a\u00020\u0013J\u0010\u00103\u001a\u00020\b2\u0006\u0010$\u001a\u00020\u0003H\u0002J\u0018\u00104\u001a\u00020\b2\u0006\u0010$\u001a\u00020\u00032\b\b\u0002\u00105\u001a\u00020\bJ\u0018\u00106\u001a\u00020\b2\u0006\u0010$\u001a\u00020\u00032\b\b\u0002\u00105\u001a\u00020\bJ\u001b\u00107\u001a\u00020 2\u0006\u0010%\u001a\u00020\u001b\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b8\u00109R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR \u0010\u000e\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\r8F@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00030\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u001a\u001a\u0004\u0018\u00010\u001bX\u0082\u000e\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u001c\u001a\u00020\b*\u00020\u00038BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001e\u0082\u0002\u000f\n\u0002\b\u0019\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006:"}, d2={"Landroidx/compose/ui/node/MeasureAndLayoutDelegate;", "", "root", "Landroidx/compose/ui/node/LayoutNode;", "(Landroidx/compose/ui/node/LayoutNode;)V", "consistencyChecker", "Landroidx/compose/ui/node/LayoutTreeConsistencyChecker;", "duringMeasureLayout", "", "hasPendingMeasureOrLayout", "getHasPendingMeasureOrLayout", "()Z", "<set-?>", "", "measureIteration", "getMeasureIteration", "()J", "onLayoutCompletedListeners", "Landroidx/compose/runtime/collection/MutableVector;", "Landroidx/compose/ui/node/Owner$OnLayoutCompletedListener;", "onPositionedDispatcher", "Landroidx/compose/ui/node/OnPositionedDispatcher;", "postponedMeasureRequests", "", "relayoutNodes", "Landroidx/compose/ui/node/DepthSortedSet;", "rootConstraints", "Landroidx/compose/ui/unit/Constraints;", "canAffectParent", "getCanAffectParent", "(Landroidx/compose/ui/node/LayoutNode;)Z", "callOnLayoutCompletedListeners", "", "dispatchOnPositionedCallbacks", "forceDispatch", "doRemeasure", "layoutNode", "constraints", "doRemeasure-sdFAvZA", "forceMeasureTheSubtree", "measureAndLayout", "onLayout", "Lkotlin/Function0;", "measureAndLayout-0kLqBqw", "(Landroidx/compose/ui/node/LayoutNode;J)V", "onNodeDetached", "node", "performMeasureAndLayout", "block", "registerOnLayoutCompletedListener", "listener", "remeasureAndRelayoutIfNeeded", "requestRelayout", "forced", "requestRemeasure", "updateRootConstraints", "updateRootConstraints-BRTryo0", "(J)V", "ui"})
public final class MeasureAndLayoutDelegate {
    @NotNull
    private final LayoutNode root;
    @NotNull
    private final DepthSortedSet relayoutNodes;
    private boolean duringMeasureLayout;
    @NotNull
    private final OnPositionedDispatcher onPositionedDispatcher;
    @NotNull
    private final MutableVector<Owner.OnLayoutCompletedListener> onLayoutCompletedListeners;
    private long measureIteration;
    @NotNull
    private final List<LayoutNode> postponedMeasureRequests;
    @Nullable
    private Constraints rootConstraints;
    @Nullable
    private final LayoutTreeConsistencyChecker consistencyChecker;

    public MeasureAndLayoutDelegate(@NotNull LayoutNode root2) {
        Intrinsics.checkNotNullParameter((Object)root2, (String)"root");
        this.root = root2;
        this.relayoutNodes = new DepthSortedSet(Owner.Companion.getEnableExtraAssertions());
        this.onPositionedDispatcher = new OnPositionedDispatcher();
        boolean $i$f$mutableVectorOf = false;
        int capacity$iv$iv = 16;
        boolean $i$f$MutableVector = false;
        this.onLayoutCompletedListeners = new MutableVector((Object[])new Owner.OnLayoutCompletedListener[capacity$iv$iv], 0);
        this.measureIteration = 1L;
        this.postponedMeasureRequests = new ArrayList();
        this.consistencyChecker = Owner.Companion.getEnableExtraAssertions() ? new LayoutTreeConsistencyChecker(this.root, this.relayoutNodes, this.postponedMeasureRequests) : (LayoutTreeConsistencyChecker)null;
    }

    public final boolean getHasPendingMeasureOrLayout() {
        DepthSortedSet this_$iv = this.relayoutNodes;
        boolean $i$f$isNotEmpty = false;
        return !this_$iv.isEmpty();
    }

    public final long getMeasureIteration() {
        if (!this.duringMeasureLayout) {
            boolean bl = false;
            String string = "measureIteration should be only used during the measure/layout pass";
            throw new IllegalArgumentException(string.toString());
        }
        return this.measureIteration;
    }

    public final void updateRootConstraints-BRTryo0(long constraints) {
        Constraints constraints2 = this.rootConstraints;
        if (!(constraints2 == null ? false : Constraints.equals-impl0((long)constraints2.unbox-impl(), (long)constraints))) {
            if (!(!this.duringMeasureLayout)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            this.rootConstraints = Constraints.box-impl((long)constraints);
            this.root.markMeasurePending$ui();
            this.relayoutNodes.add(this.root);
        }
    }

    public final boolean requestRemeasure(@NotNull LayoutNode layoutNode, boolean forced) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)layoutNode, (String)"layoutNode");
        switch (WhenMappings.$EnumSwitchMapping$0[layoutNode.getLayoutState$ui().ordinal()]) {
            case 1: {
                bl = false;
                break;
            }
            case 2: {
                this.postponedMeasureRequests.add(layoutNode);
                LayoutTreeConsistencyChecker layoutTreeConsistencyChecker = this.consistencyChecker;
                if (layoutTreeConsistencyChecker != null) {
                    layoutTreeConsistencyChecker.assertConsistent();
                }
                bl = false;
                break;
            }
            case 3: {
                if (layoutNode.getMeasurePending$ui() && !forced) {
                    bl = false;
                    break;
                }
                layoutNode.markMeasurePending$ui();
                if (layoutNode.isPlaced() || this.getCanAffectParent(layoutNode)) {
                    LayoutNode layoutNode2 = layoutNode.getParent$ui();
                    if (!(layoutNode2 != null ? layoutNode2.getMeasurePending$ui() : false)) {
                        this.relayoutNodes.add(layoutNode);
                    }
                }
                if (!this.duringMeasureLayout) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return bl;
    }

    public static /* synthetic */ boolean requestRemeasure$default(MeasureAndLayoutDelegate measureAndLayoutDelegate, LayoutNode layoutNode, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return measureAndLayoutDelegate.requestRemeasure(layoutNode, bl);
    }

    public final boolean requestRelayout(@NotNull LayoutNode layoutNode, boolean forced) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)layoutNode, (String)"layoutNode");
        switch (WhenMappings.$EnumSwitchMapping$0[layoutNode.getLayoutState$ui().ordinal()]) {
            case 1: 
            case 2: {
                LayoutTreeConsistencyChecker layoutTreeConsistencyChecker = this.consistencyChecker;
                if (layoutTreeConsistencyChecker != null) {
                    layoutTreeConsistencyChecker.assertConsistent();
                }
                bl = false;
                break;
            }
            case 3: {
                if ((layoutNode.getMeasurePending$ui() || layoutNode.getLayoutPending$ui()) && !forced) {
                    LayoutTreeConsistencyChecker layoutTreeConsistencyChecker = this.consistencyChecker;
                    if (layoutTreeConsistencyChecker != null) {
                        layoutTreeConsistencyChecker.assertConsistent();
                    }
                    bl = false;
                    break;
                }
                layoutNode.markLayoutPending$ui();
                if (layoutNode.isPlaced()) {
                    LayoutNode parent2;
                    LayoutNode layoutNode2 = parent2 = layoutNode.getParent$ui();
                    if (!(layoutNode2 != null ? layoutNode2.getLayoutPending$ui() : false)) {
                        LayoutNode layoutNode3 = parent2;
                        if (!(layoutNode3 != null ? layoutNode3.getMeasurePending$ui() : false)) {
                            this.relayoutNodes.add(layoutNode);
                        }
                    }
                }
                if (!this.duringMeasureLayout) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return bl;
    }

    public static /* synthetic */ boolean requestRelayout$default(MeasureAndLayoutDelegate measureAndLayoutDelegate, LayoutNode layoutNode, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return measureAndLayoutDelegate.requestRelayout(layoutNode, bl);
    }

    private final boolean doRemeasure-sdFAvZA(LayoutNode layoutNode, Constraints constraints) {
        boolean sizeChanged = constraints != null ? layoutNode.remeasure-_Sx5XlM$ui(constraints) : LayoutNode.remeasure-_Sx5XlM$ui$default(layoutNode, null, 1, null);
        LayoutNode parent2 = layoutNode.getParent$ui();
        if (sizeChanged && parent2 != null) {
            if (layoutNode.getMeasuredByParent$ui() == LayoutNode.UsageByParent.InMeasureBlock) {
                MeasureAndLayoutDelegate.requestRemeasure$default(this, parent2, false, 2, null);
            } else if (layoutNode.getMeasuredByParent$ui() == LayoutNode.UsageByParent.InLayoutBlock) {
                MeasureAndLayoutDelegate.requestRelayout$default(this, parent2, false, 2, null);
            }
        }
        return sizeChanged;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean measureAndLayout(@Nullable Function0<Unit> onLayout) {
        boolean rootNodeResized = false;
        MeasureAndLayoutDelegate this_$iv = this;
        boolean $i$f$performMeasureAndLayout = false;
        if (!this_$iv.root.isAttached()) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (!this_$iv.root.isPlaced()) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (!(!this_$iv.duringMeasureLayout)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (this_$iv.rootConstraints != null) {
            this_$iv.duringMeasureLayout = true;
            try {
                boolean bl = false;
                DepthSortedSet this_$iv2 = this.relayoutNodes;
                boolean $i$f$isNotEmpty = false;
                if (!this_$iv2.isEmpty()) {
                    this_$iv2 = this.relayoutNodes;
                    boolean $i$f$popEach = false;
                    while (true) {
                        LayoutNode node$iv;
                        DepthSortedSet this_$iv$iv = this_$iv2;
                        boolean $i$f$isNotEmpty2 = false;
                        if (!(!this_$iv$iv.isEmpty())) break;
                        LayoutNode layoutNode = node$iv = this_$iv2.pop();
                        boolean bl2 = false;
                        boolean sizeChanged = this.remeasureAndRelayoutIfNeeded(layoutNode);
                        if (layoutNode != this.root || !sizeChanged) continue;
                        rootNodeResized = true;
                    }
                    Function0<Unit> function0 = onLayout;
                    if (function0 != null) {
                        function0.invoke();
                    }
                }
            }
            finally {
                this_$iv.duringMeasureLayout = false;
            }
            LayoutTreeConsistencyChecker layoutTreeConsistencyChecker = this_$iv.consistencyChecker;
            if (layoutTreeConsistencyChecker != null) {
                layoutTreeConsistencyChecker.assertConsistent();
            }
        }
        this.callOnLayoutCompletedListeners();
        return rootNodeResized;
    }

    public static /* synthetic */ boolean measureAndLayout$default(MeasureAndLayoutDelegate measureAndLayoutDelegate, Function0 function0, int n, Object object) {
        if ((n & 1) != 0) {
            function0 = null;
        }
        return measureAndLayoutDelegate.measureAndLayout((Function0<Unit>)function0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void measureAndLayout-0kLqBqw(@NotNull LayoutNode layoutNode, long constraints) {
        Intrinsics.checkNotNullParameter((Object)layoutNode, (String)"layoutNode");
        if (!(!Intrinsics.areEqual((Object)layoutNode, (Object)this.root))) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        MeasureAndLayoutDelegate this_$iv = this;
        boolean $i$f$performMeasureAndLayout = false;
        if (!this_$iv.root.isAttached()) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (!this_$iv.root.isPlaced()) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (!(!this_$iv.duringMeasureLayout)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (this_$iv.rootConstraints != null) {
            this_$iv.duringMeasureLayout = true;
            try {
                boolean bl = false;
                this.relayoutNodes.remove(layoutNode);
                this.doRemeasure-sdFAvZA(layoutNode, Constraints.box-impl((long)constraints));
                if (layoutNode.getLayoutPending$ui() && layoutNode.isPlaced()) {
                    layoutNode.replace$ui();
                    this.onPositionedDispatcher.onNodePositioned(layoutNode);
                }
            }
            finally {
                this_$iv.duringMeasureLayout = false;
            }
            LayoutTreeConsistencyChecker layoutTreeConsistencyChecker = this_$iv.consistencyChecker;
            if (layoutTreeConsistencyChecker != null) {
                layoutTreeConsistencyChecker.assertConsistent();
            }
        }
        this.callOnLayoutCompletedListeners();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void performMeasureAndLayout(Function0<Unit> block) {
        block8: {
            boolean $i$f$performMeasureAndLayout = false;
            if (!this.root.isAttached()) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            if (!this.root.isPlaced()) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            if (!(!this.duringMeasureLayout)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            if (this.rootConstraints == null) break block8;
            this.duringMeasureLayout = true;
            try {
                block.invoke();
            }
            finally {
                InlineMarker.finallyStart((int)1);
                this.duringMeasureLayout = false;
                InlineMarker.finallyEnd((int)1);
            }
            LayoutTreeConsistencyChecker layoutTreeConsistencyChecker = this.consistencyChecker;
            if (layoutTreeConsistencyChecker != null) {
                layoutTreeConsistencyChecker.assertConsistent();
            }
        }
    }

    public final void registerOnLayoutCompletedListener(@NotNull Owner.OnLayoutCompletedListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        MutableVector<Owner.OnLayoutCompletedListener> this_$iv = this.onLayoutCompletedListeners;
        boolean $i$f$plusAssign = false;
        this_$iv.add((Object)listener);
    }

    private final void callOnLayoutCompletedListeners() {
        MutableVector<Owner.OnLayoutCompletedListener> this_$iv = this.onLayoutCompletedListeners;
        boolean $i$f$forEach = false;
        int size$iv = this_$iv.getSize();
        if (size$iv > 0) {
            int i$iv = 0;
            Object[] content$iv = this_$iv.getContent();
            do {
                Owner.OnLayoutCompletedListener it = (Owner.OnLayoutCompletedListener)content$iv[i$iv];
                boolean bl = false;
                it.onLayoutComplete();
            } while (++i$iv < size$iv);
        }
        this.onLayoutCompletedListeners.clear();
    }

    private final boolean remeasureAndRelayoutIfNeeded(LayoutNode layoutNode) {
        boolean sizeChanged = false;
        if (layoutNode.isPlaced() || this.getCanAffectParent(layoutNode) || layoutNode.getAlignmentLines$ui().getRequired$ui()) {
            if (layoutNode.getMeasurePending$ui()) {
                Constraints constraints;
                if (layoutNode == this.root) {
                    Constraints constraints2 = this.rootConstraints;
                    constraints = constraints2;
                    Intrinsics.checkNotNull((Object)constraints2);
                } else {
                    constraints = null;
                }
                Constraints constraints3 = constraints;
                sizeChanged = this.doRemeasure-sdFAvZA(layoutNode, constraints3);
            }
            if (layoutNode.getLayoutPending$ui() && layoutNode.isPlaced()) {
                if (layoutNode == this.root) {
                    layoutNode.place$ui(0, 0);
                } else {
                    layoutNode.replace$ui();
                }
                this.onPositionedDispatcher.onNodePositioned(layoutNode);
                LayoutTreeConsistencyChecker layoutTreeConsistencyChecker = this.consistencyChecker;
                if (layoutTreeConsistencyChecker != null) {
                    layoutTreeConsistencyChecker.assertConsistent();
                }
            }
            if (!((Collection)this.postponedMeasureRequests).isEmpty()) {
                List<LayoutNode> $this$fastForEach$iv = this.postponedMeasureRequests;
                boolean $i$f$fastForEach = false;
                int n = $this$fastForEach$iv.size();
                for (int index$iv = 0; index$iv < n; ++index$iv) {
                    LayoutNode item$iv;
                    LayoutNode it = item$iv = $this$fastForEach$iv.get(index$iv);
                    boolean bl = false;
                    if (!it.isAttached()) continue;
                    MeasureAndLayoutDelegate.requestRemeasure$default(this, it, false, 2, null);
                }
                this.postponedMeasureRequests.clear();
            }
        }
        return sizeChanged;
    }

    public final void forceMeasureTheSubtree(@NotNull LayoutNode layoutNode) {
        Intrinsics.checkNotNullParameter((Object)layoutNode, (String)"layoutNode");
        if (this.relayoutNodes.isEmpty()) {
            return;
        }
        if (!this.duringMeasureLayout) {
            String string = "Check failed.";
            throw new IllegalStateException(string.toString());
        }
        if (!(!layoutNode.getMeasurePending$ui())) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        MutableVector<LayoutNode> this_$iv = layoutNode.get_children$ui();
        boolean $i$f$forEach = false;
        int size$iv = this_$iv.getSize();
        if (size$iv > 0) {
            int i$iv = 0;
            Object[] content$iv = this_$iv.getContent();
            do {
                LayoutNode child = (LayoutNode)content$iv[i$iv];
                boolean bl = false;
                if (child.getMeasurePending$ui() && this.relayoutNodes.remove(child)) {
                    this.remeasureAndRelayoutIfNeeded(child);
                }
                if (child.getMeasurePending$ui()) continue;
                this.forceMeasureTheSubtree(child);
            } while (++i$iv < size$iv);
        }
        if (layoutNode.getMeasurePending$ui() && this.relayoutNodes.remove(layoutNode)) {
            this.remeasureAndRelayoutIfNeeded(layoutNode);
        }
    }

    public final void dispatchOnPositionedCallbacks(boolean forceDispatch) {
        if (forceDispatch) {
            this.onPositionedDispatcher.onRootNodePositioned(this.root);
        }
        this.onPositionedDispatcher.dispatch();
    }

    public static /* synthetic */ void dispatchOnPositionedCallbacks$default(MeasureAndLayoutDelegate measureAndLayoutDelegate, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        measureAndLayoutDelegate.dispatchOnPositionedCallbacks(bl);
    }

    public final void onNodeDetached(@NotNull LayoutNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        this.relayoutNodes.remove(node);
    }

    private final boolean getCanAffectParent(LayoutNode $this$canAffectParent) {
        return $this$canAffectParent.getMeasurePending$ui() && ($this$canAffectParent.getMeasuredByParent$ui() == LayoutNode.UsageByParent.InMeasureBlock || $this$canAffectParent.getAlignmentLines$ui().getRequired$ui());
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[LayoutNode.LayoutState.values().length];
            nArray[LayoutNode.LayoutState.Measuring.ordinal()] = 1;
            nArray[LayoutNode.LayoutState.LayingOut.ordinal()] = 2;
            nArray[LayoutNode.LayoutState.Idle.ordinal()] = 3;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

