/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.node;

import androidx.compose.runtime.collection.MutableVector;
import androidx.compose.ui.geometry.Offset;
import androidx.compose.ui.geometry.OffsetKt;
import androidx.compose.ui.layout.AlignmentLine;
import androidx.compose.ui.layout.AlignmentLineKt;
import androidx.compose.ui.layout.HorizontalAlignmentLine;
import androidx.compose.ui.node.LayoutNode;
import androidx.compose.ui.node.LayoutNodeWrapper;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0019\n\u0002\u0010$\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010#\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0$J\u0006\u0010%\u001a\u00020&J\r\u0010'\u001a\u00020&H\u0000\u00a2\u0006\u0002\b(J\r\u0010)\u001a\u00020&H\u0000\u00a2\u0006\u0002\b*R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u00020\nX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u00020\nX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\f\"\u0004\b\u0011\u0010\u000eR\u0014\u0010\u0012\u001a\u00020\n8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\fR\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\u00020\n8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\fR\u001a\u0010\u0017\u001a\u00020\nX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\f\"\u0004\b\u0019\u0010\u000eR\u001a\u0010\u001a\u001a\u00020\nX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\f\"\u0004\b\u001c\u0010\u000eR\u001a\u0010\u001d\u001a\u00020\nX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\f\"\u0004\b\u001f\u0010\u000eR\u001a\u0010 \u001a\u00020\nX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\f\"\u0004\b\"\u0010\u000e\u00a8\u0006+"}, d2={"Landroidx/compose/ui/node/LayoutNodeAlignmentLines;", "", "layoutNode", "Landroidx/compose/ui/node/LayoutNode;", "(Landroidx/compose/ui/node/LayoutNode;)V", "alignmentLines", "", "Landroidx/compose/ui/layout/AlignmentLine;", "", "dirty", "", "getDirty$ui", "()Z", "setDirty$ui", "(Z)V", "previousUsedDuringParentLayout", "getPreviousUsedDuringParentLayout$ui", "setPreviousUsedDuringParentLayout$ui", "queried", "getQueried$ui", "queryOwner", "required", "getRequired$ui", "usedByModifierLayout", "getUsedByModifierLayout$ui", "setUsedByModifierLayout$ui", "usedByModifierMeasurement", "getUsedByModifierMeasurement$ui", "setUsedByModifierMeasurement$ui", "usedDuringParentLayout", "getUsedDuringParentLayout$ui", "setUsedDuringParentLayout$ui", "usedDuringParentMeasurement", "getUsedDuringParentMeasurement$ui", "setUsedDuringParentMeasurement$ui", "getLastCalculation", "", "recalculate", "", "recalculateQueryOwner", "recalculateQueryOwner$ui", "reset", "reset$ui", "ui"})
public final class LayoutNodeAlignmentLines {
    @NotNull
    private final LayoutNode layoutNode;
    private boolean dirty;
    private boolean usedDuringParentMeasurement;
    private boolean usedDuringParentLayout;
    private boolean previousUsedDuringParentLayout;
    private boolean usedByModifierMeasurement;
    private boolean usedByModifierLayout;
    @Nullable
    private LayoutNode queryOwner;
    @NotNull
    private final Map<AlignmentLine, Integer> alignmentLines;

    public LayoutNodeAlignmentLines(@NotNull LayoutNode layoutNode) {
        Intrinsics.checkNotNullParameter((Object)layoutNode, (String)"layoutNode");
        this.layoutNode = layoutNode;
        this.dirty = true;
        this.alignmentLines = new HashMap();
    }

    public final boolean getDirty$ui() {
        return this.dirty;
    }

    public final void setDirty$ui(boolean bl) {
        this.dirty = bl;
    }

    public final boolean getUsedDuringParentMeasurement$ui() {
        return this.usedDuringParentMeasurement;
    }

    public final void setUsedDuringParentMeasurement$ui(boolean bl) {
        this.usedDuringParentMeasurement = bl;
    }

    public final boolean getUsedDuringParentLayout$ui() {
        return this.usedDuringParentLayout;
    }

    public final void setUsedDuringParentLayout$ui(boolean bl) {
        this.usedDuringParentLayout = bl;
    }

    public final boolean getPreviousUsedDuringParentLayout$ui() {
        return this.previousUsedDuringParentLayout;
    }

    public final void setPreviousUsedDuringParentLayout$ui(boolean bl) {
        this.previousUsedDuringParentLayout = bl;
    }

    public final boolean getUsedByModifierMeasurement$ui() {
        return this.usedByModifierMeasurement;
    }

    public final void setUsedByModifierMeasurement$ui(boolean bl) {
        this.usedByModifierMeasurement = bl;
    }

    public final boolean getUsedByModifierLayout$ui() {
        return this.usedByModifierLayout;
    }

    public final void setUsedByModifierLayout$ui(boolean bl) {
        this.usedByModifierLayout = bl;
    }

    public final boolean getQueried$ui() {
        return this.usedDuringParentMeasurement || this.previousUsedDuringParentLayout || this.usedByModifierMeasurement || this.usedByModifierLayout;
    }

    public final boolean getRequired$ui() {
        this.recalculateQueryOwner$ui();
        return this.queryOwner != null;
    }

    public final void recalculateQueryOwner$ui() {
        LayoutNode layoutNode;
        if (this.getQueried$ui()) {
            layoutNode = this.layoutNode;
        } else {
            LayoutNode layoutNode2 = this.layoutNode.getParent$ui();
            if (layoutNode2 == null) {
                return;
            }
            LayoutNode parent2 = layoutNode2;
            LayoutNode parentQueryOwner = parent2.getAlignmentLines$ui().queryOwner;
            if (parentQueryOwner != null && parentQueryOwner.getAlignmentLines$ui().getQueried$ui()) {
                layoutNode = parentQueryOwner;
            } else {
                Object object;
                LayoutNode owner = this.queryOwner;
                if (owner == null || owner.getAlignmentLines$ui().getQueried$ui()) {
                    return;
                }
                Object object2 = owner.getParent$ui();
                if (object2 != null && (object2 = ((LayoutNode)object2).getAlignmentLines$ui()) != null) {
                    ((LayoutNodeAlignmentLines)object2).recalculateQueryOwner$ui();
                }
                layoutNode = (object = owner.getParent$ui()) != null && (object = ((LayoutNode)object).getAlignmentLines$ui()) != null ? ((LayoutNodeAlignmentLines)object).queryOwner : null;
            }
        }
        this.queryOwner = layoutNode;
    }

    @NotNull
    public final Map<AlignmentLine, Integer> getLastCalculation() {
        return this.alignmentLines;
    }

    public final void recalculate() {
        this.alignmentLines.clear();
        MutableVector<LayoutNode> this_$iv = this.layoutNode.get_children$ui();
        boolean $i$f$forEach = false;
        int size$iv = this_$iv.getSize();
        if (size$iv > 0) {
            int i$iv = 0;
            Object[] content$iv = this_$iv.getContent();
            do {
                LayoutNode child = (LayoutNode)content$iv[i$iv];
                boolean bl = false;
                if (!child.isPlaced()) continue;
                if (child.getAlignmentLines$ui().dirty) {
                    child.layoutChildren$ui();
                }
                Map<AlignmentLine, Integer> $this$forEach$iv = child.getAlignmentLines$ui().alignmentLines;
                boolean $i$f$forEach2 = false;
                Iterator<Map.Entry<AlignmentLine, Integer>> iterator2 = $this$forEach$iv.entrySet().iterator();
                while (iterator2.hasNext()) {
                    Map.Entry<AlignmentLine, Integer> element$iv;
                    Map.Entry<AlignmentLine, Integer> entry = element$iv = iterator2.next();
                    boolean bl2 = false;
                    AlignmentLine childLine = entry.getKey();
                    int linePosition = ((Number)entry.getValue()).intValue();
                    LayoutNodeAlignmentLines.recalculate$addAlignmentLine(this, childLine, linePosition, child.getInnerLayoutNodeWrapper$ui());
                }
                LayoutNodeWrapper wrapper = null;
                LayoutNodeWrapper layoutNodeWrapper = child.getInnerLayoutNodeWrapper$ui().getWrappedBy$ui();
                Intrinsics.checkNotNull((Object)layoutNodeWrapper);
                wrapper = layoutNodeWrapper;
                while (!Intrinsics.areEqual((Object)wrapper, (Object)this.layoutNode.getInnerLayoutNodeWrapper$ui())) {
                    Iterable $this$forEach$iv2 = wrapper.getMeasureResult().getAlignmentLines().keySet();
                    boolean $i$f$forEach3 = false;
                    for (Object element$iv : $this$forEach$iv2) {
                        AlignmentLine childLine = (AlignmentLine)element$iv;
                        boolean bl3 = false;
                        LayoutNodeAlignmentLines.recalculate$addAlignmentLine(this, childLine, wrapper.get(childLine), wrapper);
                    }
                    Intrinsics.checkNotNull((Object)wrapper.getWrappedBy$ui());
                }
            } while (++i$iv < size$iv);
        }
        this.alignmentLines.putAll(this.layoutNode.getInnerLayoutNodeWrapper$ui().getMeasureResult().getAlignmentLines());
        this.dirty = false;
    }

    public final void reset$ui() {
        this.dirty = true;
        this.usedDuringParentMeasurement = false;
        this.previousUsedDuringParentLayout = false;
        this.usedDuringParentLayout = false;
        this.usedByModifierMeasurement = false;
        this.usedByModifierLayout = false;
        this.queryOwner = null;
    }

    private static final void recalculate$addAlignmentLine(LayoutNodeAlignmentLines this$0, AlignmentLine alignmentLine, int initialPosition, LayoutNodeWrapper initialWrapper) {
        long position = OffsetKt.Offset((float)initialPosition, (float)initialPosition);
        LayoutNodeWrapper wrapper = initialWrapper;
        while (true) {
            position = wrapper.toParentPosition-MK-Hz9U(position);
            Intrinsics.checkNotNull((Object)wrapper.getWrappedBy$ui());
            if (Intrinsics.areEqual((Object)wrapper, (Object)this$0.layoutNode.getInnerLayoutNodeWrapper$ui())) break;
            if (!wrapper.getMeasureResult().getAlignmentLines().containsKey(alignmentLine)) continue;
            int newPosition = wrapper.get(alignmentLine);
            position = OffsetKt.Offset((float)newPosition, (float)newPosition);
        }
        int positionInContainer = alignmentLine instanceof HorizontalAlignmentLine ? MathKt.roundToInt((float)Offset.getY-impl((long)position)) : MathKt.roundToInt((float)Offset.getX-impl((long)position));
        this$0.alignmentLines.put(alignmentLine, this$0.alignmentLines.containsKey(alignmentLine) ? AlignmentLineKt.merge(alignmentLine, ((Number)MapsKt.getValue(this$0.alignmentLines, (Object)alignmentLine)).intValue(), positionInContainer) : positionInContainer);
    }
}

