/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.input.pointer.util;

import androidx.compose.ui.input.pointer.HistoricalChange;
import androidx.compose.ui.input.pointer.PointerInputChange;
import androidx.compose.ui.input.pointer.util.Matrix;
import androidx.compose.ui.input.pointer.util.PolynomialFit;
import androidx.compose.ui.input.pointer.util.Vector;
import androidx.compose.ui.input.pointer.util.VelocityTracker;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000.\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u0007\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\u0003H\u0002\u001a,\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00030\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00030\f2\u0006\u0010\u000e\u001a\u00020\u0001H\u0000\u001a\u0012\u0010\u000f\u001a\u00020\u0010*\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0003X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0006\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"AssumePointerMoveStoppedMilliseconds", "", "DefaultWeight", "", "HistorySize", "HorizonMilliseconds", "MinSampleSize", "kineticEnergyToVelocity", "work", "polyFitLeastSquares", "Landroidx/compose/ui/input/pointer/util/PolynomialFit;", "x", "", "y", "degree", "addPointerInputChange", "", "Landroidx/compose/ui/input/pointer/util/VelocityTracker;", "event", "Landroidx/compose/ui/input/pointer/PointerInputChange;", "ui"})
public final class VelocityTrackerKt {
    private static final int AssumePointerMoveStoppedMilliseconds = 40;
    private static final int HistorySize = 20;
    private static final int HorizonMilliseconds = 100;
    private static final int MinSampleSize = 3;
    private static final float DefaultWeight = 1.0f;

    private static final float kineticEnergyToVelocity(float work) {
        return Math.signum(work) * (float)Math.sqrt((float)2 * Math.abs(work));
    }

    public static final void addPointerInputChange(@NotNull VelocityTracker $this$addPointerInputChange, @NotNull PointerInputChange event) {
        Intrinsics.checkNotNullParameter((Object)$this$addPointerInputChange, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        List<HistoricalChange> $this$fastForEach$iv = event.getHistorical();
        boolean $i$f$fastForEach = false;
        int n = $this$fastForEach$iv.size();
        for (int index$iv = 0; index$iv < n; ++index$iv) {
            HistoricalChange item$iv;
            HistoricalChange it = item$iv = $this$fastForEach$iv.get(index$iv);
            boolean bl = false;
            $this$addPointerInputChange.addPosition-Uv8p0NA(it.getUptimeMillis(), it.getPosition-F1C5BW0());
        }
        $this$addPointerInputChange.addPosition-Uv8p0NA(event.getUptimeMillis(), event.getPosition-F1C5BW0());
    }

    @NotNull
    public static final PolynomialFit polyFitLeastSquares(@NotNull List<Float> x, @NotNull List<Float> y, int degree) {
        int i;
        Intrinsics.checkNotNullParameter(x, (String)"x");
        Intrinsics.checkNotNullParameter(y, (String)"y");
        if (degree < 1) {
            throw new IllegalArgumentException("The degree must be at positive integer");
        }
        if (x.size() != y.size()) {
            throw new IllegalArgumentException("x and y must be the same length");
        }
        if (x.isEmpty()) {
            throw new IllegalArgumentException("At least one point must be provided");
        }
        int truncatedDegree = degree >= x.size() ? x.size() - 1 : degree;
        int n = degree + 1;
        ArrayList<Float> arrayList = new ArrayList<Float>(n);
        int n2 = 0;
        while (n2 < n) {
            int n3;
            int n4 = n3 = n2++;
            ArrayList<Float> arrayList2 = arrayList;
            boolean bl = false;
            arrayList2.add(Float.valueOf(0.0f));
        }
        List coefficients = arrayList;
        int m = x.size();
        int n5 = truncatedDegree + 1;
        Matrix a = new Matrix(n5, m);
        for (int h = 0; h < m; ++h) {
            a.set(0, h, 1.0f);
            for (int i2 = 1; i2 < n5; ++i2) {
                a.set(i2, h, a.get(i2 - 1, h) * ((Number)x.get(h)).floatValue());
            }
        }
        Matrix q = new Matrix(n5, m);
        Matrix r = new Matrix(n5, n5);
        for (int j = 0; j < n5; ++j) {
            int h;
            for (int h2 = 0; h2 < m; ++h2) {
                q.set(j, h2, a.get(j, h2));
            }
            for (int i3 = 0; i3 < j; ++i3) {
                float dot = q.getRow(j).times(q.getRow(i3));
                for (h = 0; h < m; ++h) {
                    q.set(j, h, q.get(j, h) - dot * q.get(i3, h));
                }
            }
            float norm = q.getRow(j).norm();
            if ((double)norm < 1.0E-6) {
                throw new IllegalArgumentException("Vectors are linearly dependent or zero so no solution. TODO(shepshapard), actually determine what this means");
            }
            float inverseNorm = 1.0f / norm;
            for (h = 0; h < m; ++h) {
                q.set(j, h, q.get(j, h) * inverseNorm);
            }
            for (i = 0; i < n5; ++i) {
                r.set(j, i, i < j ? 0.0f : q.getRow(j).times(a.getRow(i)));
            }
        }
        Vector wy = new Vector(m);
        for (int h = 0; h < m; ++h) {
            wy.set(h, ((Number)y.get(h)).floatValue() * 1.0f);
        }
        for (int i4 = n5 - 1; -1 < i4; --i4) {
            coefficients.set(i4, Float.valueOf(q.getRow(i4).times(wy)));
            int j = n5 - 1;
            i = i4 + 1;
            if (i <= j) {
                while (true) {
                    int n6 = i4;
                    coefficients.set(n6, Float.valueOf(((Number)coefficients.get(n6)).floatValue() - r.get(i4, j) * ((Number)coefficients.get(j)).floatValue()));
                    if (j == i) break;
                    --j;
                }
            }
            j = i4;
            coefficients.set(j, Float.valueOf(((Number)coefficients.get(j)).floatValue() / r.get(i4, i4)));
        }
        float yMean = 0.0f;
        for (int h = 0; h < m; ++h) {
            yMean += ((Number)y.get(h)).floatValue();
        }
        yMean /= (float)m;
        float sumSquaredError = 0.0f;
        float sumSquaredTotal = 0.0f;
        for (int h = 0; h < m; ++h) {
            float term = 1.0f;
            float err = ((Number)y.get(h)).floatValue() - ((Number)coefficients.get(0)).floatValue();
            for (int i5 = 1; i5 < n5; ++i5) {
                err -= (term *= ((Number)x.get(h)).floatValue()) * ((Number)coefficients.get(i5)).floatValue();
            }
            sumSquaredError += 1.0f * err * err;
            float v = ((Number)y.get(h)).floatValue() - yMean;
            sumSquaredTotal += 1.0f * v * v;
        }
        float confidence = sumSquaredTotal <= 1.0E-6f ? 1.0f : 1.0f - sumSquaredError / sumSquaredTotal;
        return new PolynomialFit(coefficients, confidence);
    }

    public static final /* synthetic */ float access$kineticEnergyToVelocity(float work) {
        return VelocityTrackerKt.kineticEnergyToVelocity(work);
    }
}

