/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.graphics.vector;

import androidx.compose.ui.graphics.Matrix;
import androidx.compose.ui.graphics.Path;
import androidx.compose.ui.graphics.SkiaBackedPath_skikoKt;
import androidx.compose.ui.graphics.drawscope.DrawContext;
import androidx.compose.ui.graphics.drawscope.DrawScope;
import androidx.compose.ui.graphics.drawscope.DrawTransform;
import androidx.compose.ui.graphics.vector.PathNode;
import androidx.compose.ui.graphics.vector.PathParser;
import androidx.compose.ui.graphics.vector.VNode;
import androidx.compose.ui.graphics.vector.VectorKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0002\b&\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010C\u001a\u00020\u00132\u0006\u0010D\u001a\u00020#2\u0006\u0010E\u001a\u00020\u0001J\u001e\u0010F\u001a\u00020\u00132\u0006\u0010G\u001a\u00020#2\u0006\u0010H\u001a\u00020#2\u0006\u0010I\u001a\u00020#J\u0016\u0010J\u001a\u00020\u00132\u0006\u0010D\u001a\u00020#2\u0006\u0010I\u001a\u00020#J\b\u0010K\u001a\u00020\u001cH\u0016J\b\u0010L\u001a\u00020\u0013H\u0002J\b\u0010M\u001a\u00020\u0013H\u0002J\f\u0010N\u001a\u00020\u0013*\u00020OH\u0016R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R0\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\b2\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001b\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\n\u0002\u0010\u0011R4\u0010\u0014\u001a\n\u0012\u0004\u0012\u00020\u0013\u0018\u00010\u00122\u000e\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\u0013\u0018\u00010\u0012@PX\u0090\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u0007\u001a\u00020\u001c@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R\u0011\u0010\"\u001a\u00020#8F\u00a2\u0006\u0006\u001a\u0004\b$\u0010%R\u0010\u0010&\u001a\u0004\u0018\u00010'X\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010)\u001a\u00020(2\u0006\u0010\u0007\u001a\u00020(@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b*\u0010+\"\u0004\b,\u0010-R$\u0010.\u001a\u00020(2\u0006\u0010\u0007\u001a\u00020(@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b/\u0010+\"\u0004\b0\u0010-R$\u00101\u001a\u00020(2\u0006\u0010\u0007\u001a\u00020(@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b2\u0010+\"\u0004\b3\u0010-R$\u00104\u001a\u00020(2\u0006\u0010\u0007\u001a\u00020(@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b5\u0010+\"\u0004\b6\u0010-R$\u00107\u001a\u00020(2\u0006\u0010\u0007\u001a\u00020(@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b8\u0010+\"\u0004\b9\u0010-R$\u0010:\u001a\u00020(2\u0006\u0010\u0007\u001a\u00020(@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b;\u0010+\"\u0004\b<\u0010-R$\u0010=\u001a\u00020(2\u0006\u0010\u0007\u001a\u00020(@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b>\u0010+\"\u0004\b?\u0010-R\u0014\u0010@\u001a\u00020\u001a8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bA\u0010B\u0082\u0002\u000f\n\u0002\b\u0019\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006P"}, d2={"Landroidx/compose/ui/graphics/vector/GroupComponent;", "Landroidx/compose/ui/graphics/vector/VNode;", "()V", "children", "", "clipPath", "Landroidx/compose/ui/graphics/Path;", "value", "", "Landroidx/compose/ui/graphics/vector/PathNode;", "clipPathData", "getClipPathData", "()Ljava/util/List;", "setClipPathData", "(Ljava/util/List;)V", "groupMatrix", "Landroidx/compose/ui/graphics/Matrix;", "[F", "Lkotlin/Function0;", "", "invalidateListener", "getInvalidateListener$ui", "()Lkotlin/jvm/functions/Function0;", "setInvalidateListener$ui", "(Lkotlin/jvm/functions/Function0;)V", "isClipPathDirty", "", "isMatrixDirty", "", "name", "getName", "()Ljava/lang/String;", "setName", "(Ljava/lang/String;)V", "numChildren", "", "getNumChildren", "()I", "parser", "Landroidx/compose/ui/graphics/vector/PathParser;", "", "pivotX", "getPivotX", "()F", "setPivotX", "(F)V", "pivotY", "getPivotY", "setPivotY", "rotation", "getRotation", "setRotation", "scaleX", "getScaleX", "setScaleX", "scaleY", "getScaleY", "setScaleY", "translationX", "getTranslationX", "setTranslationX", "translationY", "getTranslationY", "setTranslationY", "willClipPath", "getWillClipPath", "()Z", "insertAt", "index", "instance", "move", "from", "to", "count", "remove", "toString", "updateClipPath", "updateMatrix", "draw", "Landroidx/compose/ui/graphics/drawscope/DrawScope;", "ui"})
public final class GroupComponent
extends VNode {
    @Nullable
    private float[] groupMatrix;
    @NotNull
    private final List<VNode> children = new ArrayList();
    @NotNull
    private List<? extends PathNode> clipPathData = VectorKt.getEmptyPath();
    private boolean isClipPathDirty = true;
    @Nullable
    private Path clipPath;
    @Nullable
    private PathParser parser;
    @Nullable
    private Function0<Unit> invalidateListener;
    @NotNull
    private String name = "";
    private float rotation;
    private float pivotX;
    private float pivotY;
    private float scaleX = 1.0f;
    private float scaleY = 1.0f;
    private float translationX;
    private float translationY;
    private boolean isMatrixDirty = true;

    public GroupComponent() {
        super(null);
    }

    @NotNull
    public final List<PathNode> getClipPathData() {
        return this.clipPathData;
    }

    public final void setClipPathData(@NotNull List<? extends PathNode> value) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        this.clipPathData = value;
        this.isClipPathDirty = true;
        this.invalidate();
    }

    private final boolean getWillClipPath() {
        return !((Collection)this.clipPathData).isEmpty();
    }

    @Override
    @Nullable
    public Function0<Unit> getInvalidateListener$ui() {
        return this.invalidateListener;
    }

    @Override
    public void setInvalidateListener$ui(@Nullable Function0<Unit> value) {
        this.invalidateListener = value;
        List<VNode> $this$fastForEach$iv = this.children;
        boolean $i$f$fastForEach = false;
        int n = $this$fastForEach$iv.size();
        for (int index$iv = 0; index$iv < n; ++index$iv) {
            VNode item$iv;
            VNode child = item$iv = $this$fastForEach$iv.get(index$iv);
            boolean bl = false;
            child.setInvalidateListener$ui(value);
        }
    }

    private final void updateClipPath() {
        if (this.getWillClipPath()) {
            PathParser targetParser = this.parser;
            if (targetParser == null) {
                this.parser = targetParser = new PathParser();
            } else {
                targetParser.clear();
            }
            Path targetClip = this.clipPath;
            if (targetClip == null) {
                this.clipPath = targetClip = SkiaBackedPath_skikoKt.Path();
            } else {
                targetClip.reset();
            }
            targetParser.addPathNodes(this.clipPathData).toPath(targetClip);
        }
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    public final void setName(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.name = value;
        this.invalidate();
    }

    public final float getRotation() {
        return this.rotation;
    }

    public final void setRotation(float value) {
        this.rotation = value;
        this.isMatrixDirty = true;
        this.invalidate();
    }

    public final float getPivotX() {
        return this.pivotX;
    }

    public final void setPivotX(float value) {
        this.pivotX = value;
        this.isMatrixDirty = true;
        this.invalidate();
    }

    public final float getPivotY() {
        return this.pivotY;
    }

    public final void setPivotY(float value) {
        this.pivotY = value;
        this.isMatrixDirty = true;
        this.invalidate();
    }

    public final float getScaleX() {
        return this.scaleX;
    }

    public final void setScaleX(float value) {
        this.scaleX = value;
        this.isMatrixDirty = true;
        this.invalidate();
    }

    public final float getScaleY() {
        return this.scaleY;
    }

    public final void setScaleY(float value) {
        this.scaleY = value;
        this.isMatrixDirty = true;
        this.invalidate();
    }

    public final float getTranslationX() {
        return this.translationX;
    }

    public final void setTranslationX(float value) {
        this.translationX = value;
        this.isMatrixDirty = true;
        this.invalidate();
    }

    public final float getTranslationY() {
        return this.translationY;
    }

    public final void setTranslationY(float value) {
        this.translationY = value;
        this.isMatrixDirty = true;
        this.invalidate();
    }

    private final void updateMatrix() {
        float[] matrix = null;
        float[] target = this.groupMatrix;
        if (target == null) {
            this.groupMatrix = matrix = Matrix.constructor-impl$default(null, (int)1, null);
        } else {
            matrix = target;
            Matrix.reset-impl((float[])matrix);
        }
        Matrix.translate-impl$default((float[])matrix, (float)(this.translationX + this.pivotX), (float)(this.translationY + this.pivotY), (float)0.0f, (int)4, null);
        Matrix.rotateZ-impl((float[])matrix, (float)this.rotation);
        Matrix.scale-impl((float[])matrix, (float)this.scaleX, (float)this.scaleY, (float)1.0f);
        Matrix.translate-impl$default((float[])matrix, (float)(-this.pivotX), (float)(-this.pivotY), (float)0.0f, (int)4, null);
    }

    public final void insertAt(int index, @NotNull VNode instance) {
        Intrinsics.checkNotNullParameter((Object)instance, (String)"instance");
        if (index < this.getNumChildren()) {
            this.children.set(index, instance);
        } else {
            this.children.add(instance);
        }
        instance.setInvalidateListener$ui(this.getInvalidateListener$ui());
        this.invalidate();
    }

    public final void move(int from, int to, int count) {
        if (from > to) {
            int current = 0;
            current = to;
            int n = 0;
            while (n < count) {
                int it = n++;
                boolean bl = false;
                VNode node = this.children.get(from);
                this.children.remove(from);
                this.children.add(current, node);
                ++current;
            }
        } else {
            int n = 0;
            while (n < count) {
                int it = n++;
                boolean bl = false;
                VNode node = this.children.get(from);
                this.children.remove(from);
                this.children.add(to - 1, node);
            }
        }
        this.invalidate();
    }

    public final void remove(int index, int count) {
        for (int i = 0; i < count; ++i) {
            int it = i;
            boolean bl = false;
            if (index >= this.children.size()) continue;
            this.children.get(index).setInvalidateListener$ui(null);
            this.children.remove(index);
        }
        this.invalidate();
    }

    @Override
    public void draw(@NotNull DrawScope $this$draw) {
        Intrinsics.checkNotNullParameter((Object)$this$draw, (String)"<this>");
        if (this.isMatrixDirty) {
            this.updateMatrix();
            this.isMatrixDirty = false;
        }
        if (this.isClipPathDirty) {
            this.updateClipPath();
            this.isClipPathDirty = false;
        }
        DrawScope $this$withTransform$iv = $this$draw;
        boolean $i$f$withTransform = false;
        DrawContext $this$withTransform_u24lambda_u2d6$iv = $this$withTransform$iv.getDrawContext();
        boolean bl = false;
        long previousSize$iv = $this$withTransform_u24lambda_u2d6$iv.getSize-NH-jbRc();
        $this$withTransform_u24lambda_u2d6$iv.getCanvas().save();
        DrawTransform $this$draw_u24lambda_u2d5 = $this$withTransform_u24lambda_u2d6$iv.getTransform();
        boolean bl2 = false;
        if (this.groupMatrix != null) {
            float[] it = (this.groupMatrix != null ? Matrix.box-impl((float[])this.groupMatrix) : null).unbox-impl();
            boolean bl3 = false;
            $this$draw_u24lambda_u2d5.transform-58bKbWc(it);
        }
        Path targetClip = this.clipPath;
        if (this.getWillClipPath() && targetClip != null) {
            DrawTransform.clipPath-mtrdD-E$default((DrawTransform)$this$draw_u24lambda_u2d5, (Path)targetClip, (int)0, (int)2, null);
        }
        DrawScope $this$draw_u24lambda_u2d8 = $this$withTransform$iv;
        boolean bl4 = false;
        List<VNode> $this$fastForEach$iv = this.children;
        boolean $i$f$fastForEach = false;
        int n = $this$fastForEach$iv.size();
        for (int index$iv = 0; index$iv < n; ++index$iv) {
            VNode item$iv;
            VNode node = item$iv = $this$fastForEach$iv.get(index$iv);
            boolean bl5 = false;
            VNode $this$draw_u24lambda_u2d8_u24lambda_u2d7_u24lambda_u2d6 = node;
            boolean bl6 = false;
            $this$draw_u24lambda_u2d8_u24lambda_u2d7_u24lambda_u2d6.draw($this$draw);
        }
        $this$withTransform_u24lambda_u2d6$iv.getCanvas().restore();
        $this$withTransform_u24lambda_u2d6$iv.setSize-uvyYCjk(previousSize$iv);
    }

    public final int getNumChildren() {
        return this.children.size();
    }

    @NotNull
    public String toString() {
        StringBuilder sb = new StringBuilder().append("VGroup: ").append(this.name);
        List<VNode> $this$fastForEach$iv = this.children;
        boolean $i$f$fastForEach = false;
        int n = $this$fastForEach$iv.size();
        for (int index$iv = 0; index$iv < n; ++index$iv) {
            VNode item$iv;
            VNode node = item$iv = $this$fastForEach$iv.get(index$iv);
            boolean bl = false;
            sb.append("\t").append(node.toString()).append("\n");
        }
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sb.toString()");
        return string;
    }
}

