/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.focus;

import androidx.compose.ui.Modifier;
import androidx.compose.ui.focus.FocusDirection;
import androidx.compose.ui.focus.FocusManager;
import androidx.compose.ui.focus.FocusManagerKt;
import androidx.compose.ui.focus.FocusModifier;
import androidx.compose.ui.focus.FocusModifierKt;
import androidx.compose.ui.focus.FocusOrderModifierKt;
import androidx.compose.ui.focus.FocusRequester;
import androidx.compose.ui.focus.FocusStateImpl;
import androidx.compose.ui.focus.FocusTransactionsKt;
import androidx.compose.ui.focus.FocusTraversalKt;
import androidx.compose.ui.unit.LayoutDirection;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\b\u0000\u0018\u00002\u00020\u0001B\u001b\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0001\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0006\u0010\u0014\u001a\u00020\u0011J\u000f\u0010\u0015\u001a\u0004\u0018\u00010\u0003H\u0000\u00a2\u0006\u0002\b\u0016J\u001d\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u0019H\u0016\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u001d\u0010\u001c\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u0019H\u0002\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b\u001d\u0010\u001bJ\u0006\u0010\u001e\u001a\u00020\u0011J\u0006\u0010\u001f\u001a\u00020\u0011J\u001d\u0010 \u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u0019H\u0002\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b!\u0010\u001bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u000b\n\u0002\b\u0019\n\u0005\b\u00a1\u001e0\u0001\u00a8\u0006\""}, d2={"Landroidx/compose/ui/focus/FocusManagerImpl;", "Landroidx/compose/ui/focus/FocusManager;", "focusModifier", "Landroidx/compose/ui/focus/FocusModifier;", "parent", "(Landroidx/compose/ui/focus/FocusModifier;Landroidx/compose/ui/focus/FocusManager;)V", "layoutDirection", "Landroidx/compose/ui/unit/LayoutDirection;", "getLayoutDirection", "()Landroidx/compose/ui/unit/LayoutDirection;", "setLayoutDirection", "(Landroidx/compose/ui/unit/LayoutDirection;)V", "modifier", "Landroidx/compose/ui/Modifier;", "getModifier", "()Landroidx/compose/ui/Modifier;", "clearFocus", "", "force", "", "fetchUpdatedFocusProperties", "getActiveFocusModifier", "getActiveFocusModifier$ui", "moveFocus", "focusDirection", "Landroidx/compose/ui/focus/FocusDirection;", "moveFocus-3ESFkO8", "(I)Z", "moveParentFocus", "moveParentFocus-3ESFkO8", "releaseFocus", "takeFocus", "wrapAroundFocus", "wrapAroundFocus-3ESFkO8", "ui"})
public final class FocusManagerImpl
implements FocusManager {
    @NotNull
    private final FocusModifier focusModifier;
    @Nullable
    private final FocusManager parent;
    @NotNull
    private final Modifier modifier;
    public LayoutDirection layoutDirection;

    public FocusManagerImpl(@NotNull FocusModifier focusModifier2, @Nullable FocusManager parent2) {
        Intrinsics.checkNotNullParameter((Object)focusModifier2, (String)"focusModifier");
        this.focusModifier = focusModifier2;
        this.parent = parent2;
        this.modifier = FocusModifierKt.focusTarget(Modifier.Companion, this.focusModifier);
    }

    public /* synthetic */ FocusManagerImpl(FocusModifier focusModifier2, FocusManager focusManager2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            focusModifier2 = new FocusModifier(FocusStateImpl.Inactive, null, 2, null);
        }
        if ((n & 2) != 0) {
            focusManager2 = null;
        }
        this(focusModifier2, focusManager2);
    }

    @NotNull
    public final Modifier getModifier() {
        return this.modifier;
    }

    @NotNull
    public final LayoutDirection getLayoutDirection() {
        LayoutDirection layoutDirection = this.layoutDirection;
        if (layoutDirection != null) {
            return layoutDirection;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"layoutDirection");
        return null;
    }

    public final void setLayoutDirection(@NotNull LayoutDirection layoutDirection) {
        Intrinsics.checkNotNullParameter((Object)layoutDirection, (String)"<set-?>");
        this.layoutDirection = layoutDirection;
    }

    public final void takeFocus() {
        if (this.focusModifier.getFocusState() == FocusStateImpl.Inactive) {
            this.focusModifier.setFocusState(FocusStateImpl.Active);
        }
    }

    public final void releaseFocus() {
        FocusTransactionsKt.clearFocus(this.focusModifier, true);
    }

    @Override
    public void clearFocus(boolean force) {
        block6: {
            FocusStateImpl focusStateImpl;
            FocusStateImpl rootInitialState = this.focusModifier.getFocusState();
            if (!FocusTransactionsKt.clearFocus(this.focusModifier, force)) break block6;
            switch (WhenMappings.$EnumSwitchMapping$0[rootInitialState.ordinal()]) {
                case 1: 
                case 2: 
                case 3: {
                    focusStateImpl = FocusStateImpl.Active;
                    break;
                }
                case 4: 
                case 5: {
                    focusStateImpl = FocusStateImpl.Deactivated;
                    break;
                }
                case 6: {
                    focusStateImpl = FocusStateImpl.Inactive;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            this.focusModifier.setFocusState(focusStateImpl);
            FocusManager focusManager2 = this.parent;
            if (focusManager2 != null) {
                focusManager2.clearFocus(force);
            }
        }
    }

    @Override
    public boolean moveFocus-3ESFkO8(int focusDirection) {
        FocusModifier focusModifier2 = FocusTraversalKt.findActiveFocusNode(this.focusModifier);
        if (focusModifier2 == null) {
            return false;
        }
        FocusModifier source = focusModifier2;
        FocusRequester nextFocusRequester = FocusOrderModifierKt.customFocusSearch--OM-vw8(source, focusDirection, this.getLayoutDirection());
        if (!Intrinsics.areEqual((Object)nextFocusRequester, (Object)FocusRequester.Companion.getDefault())) {
            nextFocusRequester.requestFocus();
            return true;
        }
        boolean foundNextItem2 = FocusTraversalKt.focusSearch-sMXa3k8(this.focusModifier, focusDirection, this.getLayoutDirection(), (Function1<? super FocusModifier, Boolean>)((Function1)new Function1<FocusModifier, Boolean>(source){
            final /* synthetic */ FocusModifier $source;
            {
                this.$source = $source;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull FocusModifier destination) {
                Intrinsics.checkNotNullParameter((Object)destination, (String)"destination");
                if (Intrinsics.areEqual((Object)destination, (Object)this.$source)) {
                    return false;
                }
                if (destination.getParent() == null) {
                    boolean bl = false;
                    String string = "Move focus landed at the root.";
                    throw new IllegalStateException(string.toString());
                }
                FocusTransactionsKt.requestFocus(destination);
                return true;
            }
        }));
        return foundNextItem2 || this.moveParentFocus-3ESFkO8(focusDirection) || this.wrapAroundFocus-3ESFkO8(focusDirection);
    }

    public final void fetchUpdatedFocusProperties() {
        FocusManagerKt.access$updateProperties(this.focusModifier);
    }

    @Nullable
    public final FocusModifier getActiveFocusModifier$ui() {
        return FocusManagerKt.access$findActiveItem(this.focusModifier);
    }

    private final boolean moveParentFocus-3ESFkO8(int focusDirection) {
        FocusManager focusManager2 = this.parent;
        return focusManager2 != null ? focusManager2.moveFocus-3ESFkO8(focusDirection) : false;
    }

    private final boolean wrapAroundFocus-3ESFkO8(int focusDirection) {
        if (!this.focusModifier.getFocusState().getHasFocus() || this.focusModifier.getFocusState().isFocused()) {
            return false;
        }
        int n = focusDirection;
        if (FocusDirection.equals-impl0(n, FocusDirection.Companion.getNext-dhqQ-8s()) ? true : FocusDirection.equals-impl0(n, FocusDirection.Companion.getPrevious-dhqQ-8s())) {
            this.clearFocus(false);
            if (!this.focusModifier.getFocusState().isFocused()) {
                return false;
            }
            return this.moveFocus-3ESFkO8(focusDirection);
        }
        return false;
    }

    public FocusManagerImpl() {
        this(null, null, 3, null);
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[FocusStateImpl.values().length];
            nArray[FocusStateImpl.Active.ordinal()] = 1;
            nArray[FocusStateImpl.ActiveParent.ordinal()] = 2;
            nArray[FocusStateImpl.Captured.ordinal()] = 3;
            nArray[FocusStateImpl.Deactivated.ordinal()] = 4;
            nArray[FocusStateImpl.DeactivatedParent.ordinal()] = 5;
            nArray[FocusStateImpl.Inactive.ordinal()] = 6;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

