/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.draw;

import androidx.compose.ui.Alignment;
import androidx.compose.ui.draw.DrawModifier;
import androidx.compose.ui.geometry.Size;
import androidx.compose.ui.geometry.SizeKt;
import androidx.compose.ui.graphics.ColorFilter;
import androidx.compose.ui.graphics.drawscope.ContentDrawScope;
import androidx.compose.ui.graphics.drawscope.DrawScope;
import androidx.compose.ui.graphics.painter.Painter;
import androidx.compose.ui.layout.ContentScale;
import androidx.compose.ui.layout.IntrinsicMeasurable;
import androidx.compose.ui.layout.IntrinsicMeasureScope;
import androidx.compose.ui.layout.LayoutModifier;
import androidx.compose.ui.layout.Measurable;
import androidx.compose.ui.layout.MeasureResult;
import androidx.compose.ui.layout.MeasureScope;
import androidx.compose.ui.layout.Placeable;
import androidx.compose.ui.layout.ScaleFactorKt;
import androidx.compose.ui.platform.InspectorInfo;
import androidx.compose.ui.platform.InspectorValueInfo;
import androidx.compose.ui.unit.Constraints;
import androidx.compose.ui.unit.ConstraintsKt;
import androidx.compose.ui.unit.IntOffset;
import androidx.compose.ui.unit.IntSizeKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0092\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003BX\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u0012\b\b\u0002\u0010\f\u001a\u00020\r\u0012\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u000f\u0012\u0017\u0010\u0010\u001a\u0013\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00130\u0011\u00a2\u0006\u0002\b\u0014\u00a2\u0006\u0002\u0010\u0015J\u001d\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020%H\u0002\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b'\u0010(J\u0013\u0010)\u001a\u00020\u00072\b\u0010*\u001a\u0004\u0018\u00010+H\u0096\u0002J\b\u0010,\u001a\u00020-H\u0016J\u001d\u0010.\u001a\u00020/2\u0006\u00100\u001a\u00020/H\u0002\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b1\u0010(J\b\u00102\u001a\u000203H\u0016J\f\u00104\u001a\u00020\u0013*\u000205H\u0016J\u0019\u00106\u001a\u00020\u0007*\u00020%H\u0002\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b7\u00108J\u0019\u00109\u001a\u00020\u0007*\u00020%H\u0002\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b:\u00108J\u001c\u0010;\u001a\u00020-*\u00020<2\u0006\u0010=\u001a\u00020>2\u0006\u0010?\u001a\u00020-H\u0016J\u001c\u0010@\u001a\u00020-*\u00020<2\u0006\u0010=\u001a\u00020>2\u0006\u0010A\u001a\u00020-H\u0016J)\u0010B\u001a\u00020C*\u00020D2\u0006\u0010=\u001a\u00020E2\u0006\u00100\u001a\u00020/H\u0016\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\bF\u0010GJ\u001c\u0010H\u001a\u00020-*\u00020<2\u0006\u0010=\u001a\u00020>2\u0006\u0010?\u001a\u00020-H\u0016J\u001c\u0010I\u001a\u00020-*\u00020<2\u0006\u0010=\u001a\u00020>2\u0006\u0010A\u001a\u00020-H\u0016R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0013\u0010\u000e\u001a\u0004\u0018\u00010\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u0014\u0010\"\u001a\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010!\u0082\u0002\u000b\n\u0002\b\u0019\n\u0005\b\u00a1\u001e0\u0001\u00a8\u0006J"}, d2={"Landroidx/compose/ui/draw/PainterModifier;", "Landroidx/compose/ui/layout/LayoutModifier;", "Landroidx/compose/ui/draw/DrawModifier;", "Landroidx/compose/ui/platform/InspectorValueInfo;", "painter", "Landroidx/compose/ui/graphics/painter/Painter;", "sizeToIntrinsics", "", "alignment", "Landroidx/compose/ui/Alignment;", "contentScale", "Landroidx/compose/ui/layout/ContentScale;", "alpha", "", "colorFilter", "Landroidx/compose/ui/graphics/ColorFilter;", "inspectorInfo", "Lkotlin/Function1;", "Landroidx/compose/ui/platform/InspectorInfo;", "", "Lkotlin/ExtensionFunctionType;", "(Landroidx/compose/ui/graphics/painter/Painter;ZLandroidx/compose/ui/Alignment;Landroidx/compose/ui/layout/ContentScale;FLandroidx/compose/ui/graphics/ColorFilter;Lkotlin/jvm/functions/Function1;)V", "getAlignment", "()Landroidx/compose/ui/Alignment;", "getAlpha", "()F", "getColorFilter", "()Landroidx/compose/ui/graphics/ColorFilter;", "getContentScale", "()Landroidx/compose/ui/layout/ContentScale;", "getPainter", "()Landroidx/compose/ui/graphics/painter/Painter;", "getSizeToIntrinsics", "()Z", "useIntrinsicSize", "getUseIntrinsicSize", "calculateScaledSize", "Landroidx/compose/ui/geometry/Size;", "dstSize", "calculateScaledSize-E7KxVPU", "(J)J", "equals", "other", "", "hashCode", "", "modifyConstraints", "Landroidx/compose/ui/unit/Constraints;", "constraints", "modifyConstraints-ZezNO4M", "toString", "", "draw", "Landroidx/compose/ui/graphics/drawscope/ContentDrawScope;", "hasSpecifiedAndFiniteHeight", "hasSpecifiedAndFiniteHeight-uvyYCjk", "(J)Z", "hasSpecifiedAndFiniteWidth", "hasSpecifiedAndFiniteWidth-uvyYCjk", "maxIntrinsicHeight", "Landroidx/compose/ui/layout/IntrinsicMeasureScope;", "measurable", "Landroidx/compose/ui/layout/IntrinsicMeasurable;", "width", "maxIntrinsicWidth", "height", "measure", "Landroidx/compose/ui/layout/MeasureResult;", "Landroidx/compose/ui/layout/MeasureScope;", "Landroidx/compose/ui/layout/Measurable;", "measure-3p2s80s", "(Landroidx/compose/ui/layout/MeasureScope;Landroidx/compose/ui/layout/Measurable;J)Landroidx/compose/ui/layout/MeasureResult;", "minIntrinsicHeight", "minIntrinsicWidth", "ui"})
final class PainterModifier
extends InspectorValueInfo
implements LayoutModifier,
DrawModifier {
    @NotNull
    private final Painter painter;
    private final boolean sizeToIntrinsics;
    @NotNull
    private final Alignment alignment;
    @NotNull
    private final ContentScale contentScale;
    private final float alpha;
    @Nullable
    private final ColorFilter colorFilter;

    public PainterModifier(@NotNull Painter painter, boolean sizeToIntrinsics, @NotNull Alignment alignment, @NotNull ContentScale contentScale, float alpha, @Nullable ColorFilter colorFilter, @NotNull Function1<? super InspectorInfo, Unit> inspectorInfo) {
        Intrinsics.checkNotNullParameter((Object)painter, (String)"painter");
        Intrinsics.checkNotNullParameter((Object)alignment, (String)"alignment");
        Intrinsics.checkNotNullParameter((Object)contentScale, (String)"contentScale");
        Intrinsics.checkNotNullParameter(inspectorInfo, (String)"inspectorInfo");
        super(inspectorInfo);
        this.painter = painter;
        this.sizeToIntrinsics = sizeToIntrinsics;
        this.alignment = alignment;
        this.contentScale = contentScale;
        this.alpha = alpha;
        this.colorFilter = colorFilter;
    }

    public /* synthetic */ PainterModifier(Painter painter, boolean bl, Alignment alignment, ContentScale contentScale, float f, ColorFilter colorFilter, Function1 function1, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            alignment = Alignment.Companion.getCenter();
        }
        if ((n & 8) != 0) {
            contentScale = ContentScale.Companion.getInside();
        }
        if ((n & 0x10) != 0) {
            f = 1.0f;
        }
        if ((n & 0x20) != 0) {
            colorFilter = null;
        }
        this(painter, bl, alignment, contentScale, f, colorFilter, (Function1<? super InspectorInfo, Unit>)function1);
    }

    @NotNull
    public final Painter getPainter() {
        return this.painter;
    }

    public final boolean getSizeToIntrinsics() {
        return this.sizeToIntrinsics;
    }

    @NotNull
    public final Alignment getAlignment() {
        return this.alignment;
    }

    @NotNull
    public final ContentScale getContentScale() {
        return this.contentScale;
    }

    public final float getAlpha() {
        return this.alpha;
    }

    @Nullable
    public final ColorFilter getColorFilter() {
        return this.colorFilter;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean getUseIntrinsicSize() {
        if (!this.sizeToIntrinsics) return false;
        long $this$isSpecified$iv = this.painter.getIntrinsicSize-NH-jbRc();
        boolean bl = false;
        if ($this$isSpecified$iv == Size.Companion.getUnspecified-NH-jbRc()) return false;
        return true;
    }

    @Override
    @NotNull
    public MeasureResult measure-3p2s80s(@NotNull MeasureScope $this$measure_u2d3p2s80s, @NotNull Measurable measurable, long constraints) {
        Intrinsics.checkNotNullParameter((Object)$this$measure_u2d3p2s80s, (String)"$this$measure");
        Intrinsics.checkNotNullParameter((Object)measurable, (String)"measurable");
        Placeable placeable = measurable.measure-BRTryo0(this.modifyConstraints-ZezNO4M(constraints));
        return MeasureScope.layout$default($this$measure_u2d3p2s80s, placeable.getWidth(), placeable.getHeight(), null, (Function1)new Function1<Placeable.PlacementScope, Unit>(placeable){
            final /* synthetic */ Placeable $placeable;
            {
                this.$placeable = $placeable;
                super(1);
            }

            public final void invoke(@NotNull Placeable.PlacementScope $this$layout) {
                Intrinsics.checkNotNullParameter((Object)$this$layout, (String)"$this$layout");
                Placeable.PlacementScope.placeRelative$default($this$layout, this.$placeable, 0, 0, 0.0f, 4, null);
            }
        }, 4, null);
    }

    @Override
    public int minIntrinsicWidth(@NotNull IntrinsicMeasureScope $this$minIntrinsicWidth, @NotNull IntrinsicMeasurable measurable, int height) {
        int n;
        Intrinsics.checkNotNullParameter((Object)$this$minIntrinsicWidth, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)measurable, (String)"measurable");
        if (this.getUseIntrinsicSize()) {
            long constraints = this.modifyConstraints-ZezNO4M(ConstraintsKt.Constraints$default((int)0, (int)0, (int)0, (int)height, (int)7, null));
            int layoutWidth = measurable.minIntrinsicWidth(height);
            n = Math.max(Constraints.getMinWidth-impl((long)constraints), layoutWidth);
        } else {
            n = measurable.minIntrinsicWidth(height);
        }
        return n;
    }

    @Override
    public int maxIntrinsicWidth(@NotNull IntrinsicMeasureScope $this$maxIntrinsicWidth, @NotNull IntrinsicMeasurable measurable, int height) {
        int n;
        Intrinsics.checkNotNullParameter((Object)$this$maxIntrinsicWidth, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)measurable, (String)"measurable");
        if (this.getUseIntrinsicSize()) {
            long constraints = this.modifyConstraints-ZezNO4M(ConstraintsKt.Constraints$default((int)0, (int)0, (int)0, (int)height, (int)7, null));
            int layoutWidth = measurable.maxIntrinsicWidth(height);
            n = Math.max(Constraints.getMinWidth-impl((long)constraints), layoutWidth);
        } else {
            n = measurable.maxIntrinsicWidth(height);
        }
        return n;
    }

    @Override
    public int minIntrinsicHeight(@NotNull IntrinsicMeasureScope $this$minIntrinsicHeight, @NotNull IntrinsicMeasurable measurable, int width) {
        int n;
        Intrinsics.checkNotNullParameter((Object)$this$minIntrinsicHeight, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)measurable, (String)"measurable");
        if (this.getUseIntrinsicSize()) {
            long constraints = this.modifyConstraints-ZezNO4M(ConstraintsKt.Constraints$default((int)0, (int)width, (int)0, (int)0, (int)13, null));
            int layoutHeight = measurable.minIntrinsicHeight(width);
            n = Math.max(Constraints.getMinHeight-impl((long)constraints), layoutHeight);
        } else {
            n = measurable.minIntrinsicHeight(width);
        }
        return n;
    }

    @Override
    public int maxIntrinsicHeight(@NotNull IntrinsicMeasureScope $this$maxIntrinsicHeight, @NotNull IntrinsicMeasurable measurable, int width) {
        int n;
        Intrinsics.checkNotNullParameter((Object)$this$maxIntrinsicHeight, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)measurable, (String)"measurable");
        if (this.getUseIntrinsicSize()) {
            long constraints = this.modifyConstraints-ZezNO4M(ConstraintsKt.Constraints$default((int)0, (int)width, (int)0, (int)0, (int)13, null));
            int layoutHeight = measurable.maxIntrinsicHeight(width);
            n = Math.max(Constraints.getMinHeight-impl((long)constraints), layoutHeight);
        } else {
            n = measurable.maxIntrinsicHeight(width);
        }
        return n;
    }

    private final long calculateScaledSize-E7KxVPU(long dstSize) {
        long l;
        if (!this.getUseIntrinsicSize()) {
            l = dstSize;
        } else {
            float srcWidth = !this.hasSpecifiedAndFiniteWidth-uvyYCjk(this.painter.getIntrinsicSize-NH-jbRc()) ? Size.getWidth-impl((long)dstSize) : Size.getWidth-impl((long)this.painter.getIntrinsicSize-NH-jbRc());
            float srcHeight = !this.hasSpecifiedAndFiniteHeight-uvyYCjk(this.painter.getIntrinsicSize-NH-jbRc()) ? Size.getHeight-impl((long)dstSize) : Size.getHeight-impl((long)this.painter.getIntrinsicSize-NH-jbRc());
            long srcSize = SizeKt.Size((float)srcWidth, (float)srcHeight);
            l = !(Size.getWidth-impl((long)dstSize) == 0.0f) && !(Size.getHeight-impl((long)dstSize) == 0.0f) ? ScaleFactorKt.times-UQTWf7w(srcSize, this.contentScale.computeScaleFactor-H7hwNQA(srcSize, dstSize)) : Size.Companion.getZero-NH-jbRc();
        }
        return l;
    }

    private final long modifyConstraints-ZezNO4M(long constraints) {
        boolean hasFixedDimens;
        boolean hasBoundedDimens = Constraints.getHasBoundedWidth-impl((long)constraints) && Constraints.getHasBoundedHeight-impl((long)constraints);
        boolean bl = hasFixedDimens = Constraints.getHasFixedWidth-impl((long)constraints) && Constraints.getHasFixedHeight-impl((long)constraints);
        if (!this.getUseIntrinsicSize() && hasBoundedDimens || hasFixedDimens) {
            return Constraints.copy-Zbe2FdA$default((long)constraints, (int)Constraints.getMaxWidth-impl((long)constraints), (int)0, (int)Constraints.getMaxHeight-impl((long)constraints), (int)0, (int)10, null);
        }
        long intrinsicSize = this.painter.getIntrinsicSize-NH-jbRc();
        int intrinsicWidth = this.hasSpecifiedAndFiniteWidth-uvyYCjk(intrinsicSize) ? MathKt.roundToInt((float)Size.getWidth-impl((long)intrinsicSize)) : Constraints.getMinWidth-impl((long)constraints);
        int intrinsicHeight = this.hasSpecifiedAndFiniteHeight-uvyYCjk(intrinsicSize) ? MathKt.roundToInt((float)Size.getHeight-impl((long)intrinsicSize)) : Constraints.getMinHeight-impl((long)constraints);
        int constrainedWidth = ConstraintsKt.constrainWidth-K40F9xA((long)constraints, (int)intrinsicWidth);
        int constrainedHeight = ConstraintsKt.constrainHeight-K40F9xA((long)constraints, (int)intrinsicHeight);
        long scaledSize = this.calculateScaledSize-E7KxVPU(SizeKt.Size((float)constrainedWidth, (float)constrainedHeight));
        int minWidth = ConstraintsKt.constrainWidth-K40F9xA((long)constraints, (int)MathKt.roundToInt((float)Size.getWidth-impl((long)scaledSize)));
        int minHeight = ConstraintsKt.constrainHeight-K40F9xA((long)constraints, (int)MathKt.roundToInt((float)Size.getHeight-impl((long)scaledSize)));
        return Constraints.copy-Zbe2FdA$default((long)constraints, (int)minWidth, (int)0, (int)minHeight, (int)0, (int)10, null);
    }

    @Override
    public void draw(@NotNull ContentDrawScope $this$draw) {
        Intrinsics.checkNotNullParameter((Object)$this$draw, (String)"<this>");
        long intrinsicSize = this.painter.getIntrinsicSize-NH-jbRc();
        float srcWidth = this.hasSpecifiedAndFiniteWidth-uvyYCjk(intrinsicSize) ? Size.getWidth-impl((long)intrinsicSize) : Size.getWidth-impl((long)$this$draw.getSize-NH-jbRc());
        float srcHeight = this.hasSpecifiedAndFiniteHeight-uvyYCjk(intrinsicSize) ? Size.getHeight-impl((long)intrinsicSize) : Size.getHeight-impl((long)$this$draw.getSize-NH-jbRc());
        long srcSize = SizeKt.Size((float)srcWidth, (float)srcHeight);
        long scaledSize = !(Size.getWidth-impl((long)$this$draw.getSize-NH-jbRc()) == 0.0f) && !(Size.getHeight-impl((long)$this$draw.getSize-NH-jbRc()) == 0.0f) ? ScaleFactorKt.times-UQTWf7w(srcSize, this.contentScale.computeScaleFactor-H7hwNQA(srcSize, $this$draw.getSize-NH-jbRc())) : Size.Companion.getZero-NH-jbRc();
        long alignedPosition = this.alignment.align-KFBX0sM(IntSizeKt.IntSize((int)MathKt.roundToInt((float)Size.getWidth-impl((long)scaledSize)), (int)MathKt.roundToInt((float)Size.getHeight-impl((long)scaledSize))), IntSizeKt.IntSize((int)MathKt.roundToInt((float)Size.getWidth-impl((long)$this$draw.getSize-NH-jbRc())), (int)MathKt.roundToInt((float)Size.getHeight-impl((long)$this$draw.getSize-NH-jbRc()))), $this$draw.getLayoutDirection());
        float dx = IntOffset.getX-impl((long)alignedPosition);
        float dy = IntOffset.getY-impl((long)alignedPosition);
        DrawScope $this$translate$iv = (DrawScope)$this$draw;
        boolean $i$f$translate = false;
        $this$translate$iv.getDrawContext().getTransform().translate(dx, dy);
        DrawScope $this$draw_u24lambda_u2d1 = $this$translate$iv;
        boolean bl = false;
        Painter $this$draw_u24lambda_u2d1_u24lambda_u2d0 = this.painter;
        boolean bl2 = false;
        $this$draw_u24lambda_u2d1_u24lambda_u2d0.draw-x_KDEd0($this$draw_u24lambda_u2d1, scaledSize, this.alpha, this.colorFilter);
        $this$translate$iv.getDrawContext().getTransform().translate(-dx, -dy);
        $this$draw.drawContent();
    }

    private final boolean hasSpecifiedAndFiniteWidth-uvyYCjk(long $this$hasSpecifiedAndFiniteWidth_u2duvyYCjk) {
        float f;
        return !Size.equals-impl0((long)$this$hasSpecifiedAndFiniteWidth_u2duvyYCjk, (long)Size.Companion.getUnspecified-NH-jbRc()) && !Float.isInfinite(f = Size.getWidth-impl((long)$this$hasSpecifiedAndFiniteWidth_u2duvyYCjk)) && !Float.isNaN(f);
    }

    private final boolean hasSpecifiedAndFiniteHeight-uvyYCjk(long $this$hasSpecifiedAndFiniteHeight_u2duvyYCjk) {
        float f;
        return !Size.equals-impl0((long)$this$hasSpecifiedAndFiniteHeight_u2duvyYCjk, (long)Size.Companion.getUnspecified-NH-jbRc()) && !Float.isInfinite(f = Size.getHeight-impl((long)$this$hasSpecifiedAndFiniteHeight_u2duvyYCjk)) && !Float.isNaN(f);
    }

    public int hashCode() {
        int result2 = this.painter.hashCode();
        result2 = 31 * result2 + Boolean.hashCode(this.sizeToIntrinsics);
        result2 = 31 * result2 + this.alignment.hashCode();
        result2 = 31 * result2 + this.contentScale.hashCode();
        result2 = 31 * result2 + Float.hashCode(this.alpha);
        ColorFilter colorFilter = this.colorFilter;
        result2 = 31 * result2 + (colorFilter != null ? colorFilter.hashCode() : 0);
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        PainterModifier painterModifier = other instanceof PainterModifier ? (PainterModifier)other : null;
        if (painterModifier == null) {
            return false;
        }
        PainterModifier otherModifier = painterModifier;
        return Intrinsics.areEqual((Object)this.painter, (Object)otherModifier.painter) && this.sizeToIntrinsics == otherModifier.sizeToIntrinsics && Intrinsics.areEqual((Object)this.alignment, (Object)otherModifier.alignment) && Intrinsics.areEqual((Object)this.contentScale, (Object)otherModifier.contentScale) && this.alpha == otherModifier.alpha && Intrinsics.areEqual((Object)this.colorFilter, (Object)otherModifier.colorFilter);
    }

    @NotNull
    public String toString() {
        return "PainterModifier(painter=" + this.painter + ", sizeToIntrinsics=" + this.sizeToIntrinsics + ", alignment=" + this.alignment + ", alpha=" + this.alpha + ", colorFilter=" + this.colorFilter + ')';
    }
}

