/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.compose.desktop.ui.tooling.preview.rpc;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.compose.desktop.ui.tooling.preview.rpc.Command;
import org.jetbrains.compose.desktop.ui.tooling.preview.rpc.PreviewLogger;
import org.jetbrains.compose.desktop.ui.tooling.preview.rpc.RemoteConnection;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0000\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\tJ\b\u0010\u0013\u001a\u00020\bH\u0016J\u0017\u0010\u0014\u001a\u00020\b2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0082\bJ\u001a\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u001c\u0010\u001a\u001a\u00020\b2\u0012\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\b0\u001cH\u0016J\u001c\u0010\u001e\u001a\u00020\b2\u0012\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\b0\u001cH\u0016J\u0010\u0010\u001f\u001a\u00020\b2\u0006\u0010 \u001a\u00020\u001dH\u0016J\u0010\u0010!\u001a\u00020\b2\u0006\u0010\"\u001a\u00020\u0017H\u0016J \u0010#\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\"\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lorg/jetbrains/compose/desktop/ui/tooling/preview/rpc/RemoteConnectionImpl;", "Lorg/jetbrains/compose/desktop/ui/tooling/preview/rpc/RemoteConnection;", "socket", "Ljava/net/Socket;", "log", "Lorg/jetbrains/compose/desktop/ui/tooling/preview/rpc/PreviewLogger;", "onClose", "Lkotlin/Function0;", "", "(Ljava/net/Socket;Lorg/jetbrains/compose/desktop/ui/tooling/preview/rpc/PreviewLogger;Lkotlin/jvm/functions/Function0;)V", "input", "Ljava/io/DataInputStream;", "isAlive", "", "()Z", "isConnectionAlive", "Ljava/util/concurrent/atomic/AtomicBoolean;", "output", "Ljava/io/DataOutputStream;", "close", "ifAlive", "fn", "readData", "", "maxDataSize", "", "receiveCommand", "onResult", "Lkotlin/Function1;", "Lorg/jetbrains/compose/desktop/ui/tooling/preview/rpc/Command;", "receiveData", "sendCommand", "command", "sendData", "data", "writeData", "preview-rpc"})
@SourceDebugExtension(value={"SMAP\nRemoteConnection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RemoteConnection.kt\norg/jetbrains/compose/desktop/ui/tooling/preview/rpc/RemoteConnectionImpl\n+ 2 PreviewLogger.kt\norg/jetbrains/compose/desktop/ui/tooling/preview/rpc/PreviewLogger\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,160:1\n60#1,2:169\n63#1:175\n60#1,2:176\n63#1:182\n60#1,2:183\n63#1:193\n60#1,2:194\n63#1:200\n12#2,4:161\n12#2,4:165\n12#2,4:171\n12#2,4:178\n12#2,4:185\n12#2,4:189\n12#2,4:196\n1#3:201\n*S KotlinDebug\n*F\n+ 1 RemoteConnection.kt\norg/jetbrains/compose/desktop/ui/tooling/preview/rpc/RemoteConnectionImpl\n*L\n74#1:169,2\n74#1:175\n81#1:176,2\n81#1:182\n86#1:183,2\n86#1:193\n101#1:194,2\n101#1:200\n67#1:161,4\n70#1:165,4\n78#1:171,4\n83#1:178,4\n91#1:185,4\n93#1:189,4\n104#1:196,4\n*E\n"})
public final class RemoteConnectionImpl
extends RemoteConnection {
    @NotNull
    private final Socket socket;
    @NotNull
    private final PreviewLogger log;
    @NotNull
    private final Function0<Unit> onClose;
    @NotNull
    private final DataInputStream input;
    @NotNull
    private final DataOutputStream output;
    @NotNull
    private AtomicBoolean isConnectionAlive;

    public RemoteConnectionImpl(@NotNull Socket socket, @NotNull PreviewLogger log, @NotNull Function0<Unit> onClose2) {
        Intrinsics.checkNotNullParameter((Object)socket, (String)"socket");
        Intrinsics.checkNotNullParameter((Object)log, (String)"log");
        Intrinsics.checkNotNullParameter(onClose2, (String)"onClose");
        this.socket = socket;
        this.log = log;
        this.onClose = onClose2;
        this.socket.setSoTimeout(1000);
        this.input = new DataInputStream(this.socket.getInputStream());
        this.output = new DataOutputStream(this.socket.getOutputStream());
        this.isConnectionAlive = new AtomicBoolean(true);
    }

    @Override
    public boolean isAlive() {
        return !this.socket.isClosed() && this.isConnectionAlive.get();
    }

    private final void ifAlive(Function0<Unit> fn) {
        boolean $i$f$ifAlive = false;
        if (this.isAlive()) {
            fn.invoke();
        }
    }

    @Override
    public void close() {
        if (this.isConnectionAlive.compareAndSet(true, false)) {
            PreviewLogger previewLogger;
            PreviewLogger this_$iv = this.log;
            boolean $i$f$invoke = false;
            if (this_$iv.isEnabled()) {
                previewLogger = this_$iv;
                boolean bl = false;
                previewLogger.log("CLOSING");
            }
            this.socket.close();
            this.onClose.invoke();
            this_$iv = this.log;
            $i$f$invoke = false;
            if (this_$iv.isEnabled()) {
                previewLogger = this_$iv;
                boolean bl = false;
                previewLogger.log("CLOSED");
            }
        }
    }

    @Override
    public void sendCommand(@NotNull Command command) {
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        RemoteConnectionImpl this_$iv = this;
        boolean $i$f$ifAlive = false;
        if (this_$iv.isAlive()) {
            boolean bl = false;
            String commandStr = command.asString();
            byte[] byArray = commandStr.getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
            byte[] data = byArray;
            this.writeData(this.output, data, 8192);
            PreviewLogger this_$iv2 = this.log;
            boolean $i$f$invoke = false;
            if (this_$iv2.isEnabled()) {
                PreviewLogger previewLogger = this_$iv2;
                boolean bl2 = false;
                previewLogger.log("SENT COMMAND '" + commandStr + '\'');
            }
        }
    }

    @Override
    public void sendData(@NotNull byte[] data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        RemoteConnectionImpl this_$iv = this;
        boolean $i$f$ifAlive = false;
        if (this_$iv.isAlive()) {
            boolean bl = false;
            this.writeData(this.output, data, 0x6400000);
            PreviewLogger this_$iv2 = this.log;
            boolean $i$f$invoke = false;
            if (this_$iv2.isEnabled()) {
                PreviewLogger previewLogger = this_$iv2;
                boolean bl2 = false;
                previewLogger.log("SENT DATA [" + data.length + ']');
            }
        }
    }

    @Override
    public void receiveCommand(@NotNull Function1<? super Command, Unit> onResult) {
        Intrinsics.checkNotNullParameter(onResult, (String)"onResult");
        RemoteConnectionImpl this_$iv = this;
        boolean $i$f$ifAlive = false;
        if (this_$iv.isAlive()) {
            String line;
            boolean bl = false;
            byte[] byArray = this.readData(this.input, 8192);
            String string = line = byArray != null ? new String(byArray, Charsets.UTF_8) : null;
            if (line != null) {
                Command cmd = Command.Companion.fromString(line);
                if (cmd == null) {
                    PreviewLogger this_$iv2 = this.log;
                    boolean $i$f$invoke = false;
                    if (this_$iv2.isEnabled()) {
                        PreviewLogger previewLogger = this_$iv2;
                        boolean bl2 = false;
                        previewLogger.log("GOT UNKNOWN COMMAND '" + line + '\'');
                    }
                } else {
                    PreviewLogger this_$iv3 = this.log;
                    boolean $i$f$invoke = false;
                    if (this_$iv3.isEnabled()) {
                        PreviewLogger previewLogger = this_$iv3;
                        boolean bl3 = false;
                        previewLogger.log("GOT COMMAND '" + line + '\'');
                    }
                    onResult.invoke((Object)cmd);
                }
            } else {
                this.close();
            }
        }
    }

    @Override
    public void receiveData(@NotNull Function1<? super byte[], Unit> onResult) {
        Intrinsics.checkNotNullParameter(onResult, (String)"onResult");
        RemoteConnectionImpl this_$iv = this;
        boolean $i$f$ifAlive = false;
        if (this_$iv.isAlive()) {
            boolean bl = false;
            byte[] data = this.readData(this.input, 0x6400000);
            if (data != null) {
                PreviewLogger this_$iv2 = this.log;
                boolean $i$f$invoke = false;
                if (this_$iv2.isEnabled()) {
                    PreviewLogger previewLogger = this_$iv2;
                    boolean bl2 = false;
                    previewLogger.log("GOT [" + data.length + ']');
                }
                onResult.invoke((Object)data);
            } else {
                this.close();
            }
        }
    }

    private final boolean writeData(DataOutputStream output, byte[] data, int maxDataSize) {
        boolean bl;
        if (!this.isAlive()) {
            return false;
        }
        try {
            int len;
            boolean bl2;
            int size = data.length;
            boolean bl3 = bl2 = size < maxDataSize;
            if (_Assertions.ENABLED && !bl2) {
                boolean $i$a$-assert-RemoteConnectionImpl$writeData$22 = false;
                String $i$a$-assert-RemoteConnectionImpl$writeData$22 = "Data is too big: " + size + " >= " + maxDataSize;
                throw new AssertionError((Object)$i$a$-assert-RemoteConnectionImpl$writeData$22);
            }
            output.writeInt(size);
            int bufSize = Math.min(8192, size);
            for (int index = 0; index < size; index += len) {
                len = Math.min(bufSize, size - index);
                output.write(data, index, len);
            }
            output.flush();
            bl = true;
        }
        catch (IOException e) {
            bl = false;
        }
        return bl;
    }

    private final byte[] readData(DataInputStream input, int maxDataSize) {
        while (this.isAlive()) {
            try {
                int size = input.readInt();
                if (size != -1) {
                    int bytesRead;
                    boolean bl;
                    boolean bl2 = bl = size < maxDataSize;
                    if (_Assertions.ENABLED && !bl) {
                        boolean $i$a$-assert-RemoteConnectionImpl$readData$22 = false;
                        String $i$a$-assert-RemoteConnectionImpl$readData$22 = "Data is too big: " + size + " >= " + maxDataSize;
                        throw new AssertionError((Object)$i$a$-assert-RemoteConnectionImpl$readData$22);
                    }
                    byte[] bytes = new byte[size];
                    int bufSize = Math.min(size, 8192);
                    for (int index = 0; index < size; index += bytesRead) {
                        int len = Math.min(bufSize, size - index);
                        bytesRead = input.read(bytes, index, len);
                    }
                    return bytes;
                }
            }
            catch (IOException e) {
                if (e instanceof SocketTimeoutException) continue;
            }
            break;
        }
        return null;
    }
}

