/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material3.l10n

import androidx.compose.material3.internal.Strings
import androidx.compose.material3.internal.Translations

@Suppress("UnusedReceiverParameter", "DuplicatedCode")
internal fun Translations.am() = mapOf(
    Strings.NavigationMenu to "የዳሰሳ ምናሌ",
    Strings.ExposedDropdownMenu to "ተቆልቋይ ምናሌ",
    Strings.CloseDrawer to "የዳሰሳ ምናሌን ዝጋ",
    Strings.CloseSheet to "ሉህን ዝጋ",
    Strings.DefaultErrorMessage to "ልክ ያልሆነ ግቤት",
    Strings.SliderRangeStart to "የክልል መጀመሪያ",
    Strings.SliderRangeEnd to "የክልል መጨረሻ",
    Strings.Dialog to "መገናኛ",
    Strings.MenuExpanded to "ተዘርግቷል",
    Strings.MenuCollapsed to "ተሰብስቧል",
    Strings.ToggleDropdownMenu to "ተቆልቋይ ምናሌ ይቀያይሩ",
    Strings.SnackbarDismiss to "አሰናብት",
    Strings.SearchBarSearch to "ፈልግ",
    Strings.SuggestionsAvailable to "የአስተያየት ጥቆማዎች ከታች",
    Strings.DatePickerTitle to "ቀን ይምረጡ",
    Strings.DatePickerHeadline to "የተመረጠው ቀን",
    Strings.DatePickerSwitchToYearSelection to "ወደ ዓመት መምረጥ ይቀይሩ",
    Strings.DatePickerSwitchToDaySelection to "ዓመት ለመምረጥ ያንሸራትቱ ወይም ወደ ቀንን መምረጥ መልሶ ለመቀየር መታ ያድርጉ",
    Strings.DatePickerSwitchToNextMonth to "ወደ የሚቀጥለው ወር ይቀይሩ",
    Strings.DatePickerSwitchToPreviousMonth to "ወደ ቀዳሚው ወር ይቀይሩ",
    Strings.DatePickerNavigateToYearDescription to "ወደ ዓመት %1\$s ያስሱ",
    Strings.DatePickerHeadlineDescription to "የአሁን ምርጫ፦ %1\$s",
    Strings.DatePickerNoSelectionDescription to "ምንም",
    Strings.DatePickerTodayDescription to "ዛሬ",
    Strings.DatePickerYearPickerPaneTitle to "ዓመት መራጭ ይታያል",
    Strings.DateInputTitle to "ቀን ይምረጡ",
    Strings.DateInputHeadline to "የገባው ቀን",
    Strings.DateInputLabel to "ቀን",
    Strings.DateInputHeadlineDescription to "የገባው ቀን፦ %1\$s",
    Strings.DateInputNoInputDescription to "ምንም",
    Strings.DateInputInvalidNotAllowed to "ቀን አልተፈቀደም፦ %1\$s",
    Strings.DateInputInvalidForPattern to "ቀኑ ከተጠበቀው ስርዓተ ጥለት ጋር አይዛመድም፦ %1\$s",
    Strings.DateInputInvalidYearRange to "ቀን ከተጠበቀው የዓመት ክልል ውጭ ነው %1\$s - %2\$s",
    Strings.DatePickerSwitchToCalendarMode to "ወደ የቀን መቁጠሪያ ግቤት ሁነታ ይቀይሩ",
    Strings.DatePickerSwitchToInputMode to "ወደ የጽሁፍ ግቤት ሁነታ ይቀይሩ",
    Strings.DatePickerScrollToShowLaterYears to "ከዚህ በኋላ ያሉ ዓመታትን ለማሳየት ያሸብልሉ",
    Strings.DatePickerScrollToShowEarlierYears to "ቀደም ያሉ ዓመታትን ለማሳየት ያሸብልሉ",
    Strings.DateRangePickerTitle to "ቀናትን ይምረጡ",
    Strings.DateRangePickerStartHeadline to "መጀመሪያ ቀን",
    Strings.DateRangePickerEndHeadline to "የማብቂያ ቀን",
    Strings.DateRangePickerScrollToShowNextMonth to "ቀጣዩን ወር ለማሳየት ያሸብልሉ",
    Strings.DateRangePickerScrollToShowPreviousMonth to "ቀዳሚውን ወር ለማሳየት ያሸብልሉ",
    Strings.DateRangePickerDayInRange to "በክልል ውስጥ",
    Strings.DateRangeInputTitle to "ቀናትን ያስገቡ",
    Strings.DateRangeInputInvalidRangeInput to "ልክ ያልሆነ የቀን ክልል ግቤት",
    Strings.BottomSheetPaneTitle to "የግርጌ ሉህ",
    Strings.BottomSheetDragHandleDescription to "መያዣ ይጎትቱ",
    Strings.BottomSheetPartialExpandDescription to "የግርጌ ሉህን ይሰብስቡ",
    Strings.BottomSheetDismissDescription to "የግርጌ ሉህን ያሰናብቱ",
    Strings.BottomSheetExpandDescription to "የግርጌ ሉህ ይዘርጉ",
    Strings.TooltipPaneDescription to "የመሣሪያ ጥቆማ",
    Strings.TooltipLongPressLabel to "መሣሪያ ጥቆማን አሳይ",
    Strings.TimePickerPM to "ፒኤም",
    Strings.TimePickerAM to "ኤኤም",
    Strings.TimePickerPeriodToggle to "ኤኤም ወይም ፒኤምን ይምረጡ",
    Strings.TimePickerHourSelection to "ሰዓት ምረጥ",
    Strings.TimePickerMinuteSelection to "ደቂቃዎችን ምረጥ",
    Strings.TimePickerHourSuffix to "%1\$d ሰዓት",
    Strings.TimePicker24HourSuffix to "%1\$d ሰዓታት",
    Strings.TimePickerMinuteSuffix to "%1\$d ደቂቃዎች",
    Strings.TimePickerMinute to "ደቂቃ",
    Strings.TimePickerHour to "ሰዓት",
    Strings.TimePickerMinuteTextField to "ለደቂቃዎች",
    Strings.TimePickerHourTextField to "ለሰዓት",
)
