/*
 * Copyright 2021 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material3

import androidx.compose.runtime.Composable
import androidx.compose.ui.Modifier
import androidx.compose.ui.graphics.Color
import androidx.compose.ui.graphics.Shape
import androidx.compose.ui.unit.Dp
import androidx.compose.ui.window.DialogProperties
import kotlin.js.JsName
import kotlin.jvm.JvmName

// Keep expect/actual for maintain binary compatibility.
// `@file:JvmName` doesn't work here because Android and Desktop were published with different names
// Please note that binary compatibility for Desktop is tracked only in JetBrains fork

@Composable
actual fun AlertDialog(
    onDismissRequest: () -> Unit,
    confirmButton: @Composable () -> Unit,
    modifier: Modifier,
    dismissButton: @Composable (() -> Unit)?,
    icon: @Composable (() -> Unit)?,
    title: @Composable (() -> Unit)?,
    text: @Composable (() -> Unit)?,
    shape: Shape,
    containerColor: Color,
    iconContentColor: Color,
    titleContentColor: Color,
    textContentColor: Color,
    tonalElevation: Dp,
    properties: DialogProperties
): Unit = AlertDialogImpl(
    onDismissRequest = onDismissRequest,
    confirmButton = confirmButton,
    modifier = modifier,
    dismissButton = dismissButton,
    icon = icon,
    title = title,
    text = text,
    shape = shape,
    containerColor = containerColor,
    iconContentColor = iconContentColor,
    titleContentColor = titleContentColor,
    textContentColor = textContentColor,
    tonalElevation = tonalElevation,
    properties = properties
)

@Deprecated("Kept for binary compatibility", level = DeprecationLevel.HIDDEN)
@JvmName("BasicAlertDialog")
@JsName("BasicAlertDialog")
@ExperimentalMaterial3Api
@Composable
fun BasicAlertDialogDeprecated(
    onDismissRequest: () -> Unit,
    modifier: Modifier,
    properties: DialogProperties,
    content: @Composable () -> Unit
) = BasicAlertDialog(onDismissRequest, modifier, properties, content)

@Suppress("DEPRECATION")
@JvmName("AlertDialog")
@JsName("AlertDialog")
@Deprecated("Kept for binary compatibility", level = DeprecationLevel.HIDDEN)
@ExperimentalMaterial3Api
@Composable
fun AlertDialogDeprecated(
    onDismissRequest: () -> Unit,
    modifier: Modifier = Modifier,
    properties: DialogProperties = DialogProperties(),
    content: @Composable () -> Unit
) = AlertDialog(onDismissRequest, modifier, properties, content)
