/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material3.l10n

import androidx.compose.material3.internal.Strings
import androidx.compose.material3.internal.Translations

@Suppress("UnusedReceiverParameter", "DuplicatedCode")
internal fun Translations.or() = mapOf(
    Strings.NavigationMenu to "ନାଭିଗେସନ୍ ମେନୁ",
    Strings.ExposedDropdownMenu to "ଡ୍ରପଡାଉନ ମେନୁ",
    Strings.CloseDrawer to "ନାଭିଗେସନ୍ ମେନୁ ବନ୍ଦ କରନ୍ତୁ",
    Strings.CloseSheet to "ସିଟ୍ ବନ୍ଦ କରନ୍ତୁ",
    Strings.DefaultErrorMessage to "ଅବୈଧ ଇନପୁଟ୍",
    Strings.SliderRangeStart to "ରେଞ୍ଜ ଆରମ୍ଭ",
    Strings.SliderRangeEnd to "ରେଞ୍ଜ ଶେଷ",
    Strings.Dialog to "ଡାଏଲଗ",
    Strings.MenuExpanded to "ବିସ୍ତାର କରାଯାଇଛି",
    Strings.MenuCollapsed to "ସଙ୍କୁଚିତ କରାଯାଇଛି",
    Strings.ToggleDropdownMenu to "ଡ୍ରପଡାଉନ ମେନୁକୁ ଟୋଗଲ କରନ୍ତୁ",
    Strings.SnackbarDismiss to "ଖାରଜ କରନ୍ତୁ",
    Strings.SearchBarSearch to "ସର୍ଚ୍ଚ କରନ୍ତୁ",
    Strings.SuggestionsAvailable to "ପରାମର୍ଶ ତଳେ ଦିଆଯାଇଛି",
    Strings.DatePickerTitle to "ତାରିଖ ଚୟନ କରନ୍ତୁ",
    Strings.DatePickerHeadline to "ଚୟନିତ ତାରିଖ",
    Strings.DatePickerSwitchToYearSelection to "ଏକ ବର୍ଷ ଚୟନ କରିବାକୁ ସୁଇଚ କରନ୍ତୁ",
    Strings.DatePickerSwitchToDaySelection to "ଏକ ବର୍ଷ ଚୟନ କରିବା ପାଇଁ ସ୍ୱାଇପ କରନ୍ତୁ କିମ୍ବା ଏକ ଦିନ ଚୟନ କରିବା ପାଇଁ ପୁଣି ସୁଇଚ କରିବାକୁ ଟାପ କରନ୍ତୁ",
    Strings.DatePickerSwitchToNextMonth to "ପରବର୍ତ୍ତୀ ମାସକୁ ପରିବର୍ତ୍ତନ କରନ୍ତୁ",
    Strings.DatePickerSwitchToPreviousMonth to "ପୂର୍ବବର୍ତ୍ତୀ ମାସକୁ ପରିବର୍ତ୍ତନ କରନ୍ତୁ",
    Strings.DatePickerNavigateToYearDescription to "%1\$s ବର୍ଷକୁ ନାଭିଗେଟ କରନ୍ତୁ",
    Strings.DatePickerHeadlineDescription to "ବର୍ତ୍ତମାନର ଚୟନ: %1\$s",
    Strings.DatePickerNoSelectionDescription to "କିଛି ନାହିଁ",
    Strings.DatePickerTodayDescription to "ଆଜି",
    Strings.DatePickerYearPickerPaneTitle to "ବର୍ଷ ପିକର ଦେଖାଯାଉଛି",
    Strings.DateInputTitle to "ତାରିଖ ଚୟନ କରନ୍ତୁ",
    Strings.DateInputHeadline to "ଲେଖାଯାଇଥିବା ତାରିଖ",
    Strings.DateInputLabel to "ତାରିଖ",
    Strings.DateInputHeadlineDescription to "ଲେଖାଯାଇଥିବା ତାରିଖ: %1\$s",
    Strings.DateInputNoInputDescription to "କିଛି ନାହିଁ",
    Strings.DateInputInvalidNotAllowed to "ତାରିଖକୁ ଅନୁମତି ଦିଆଯାଇନାହିଁ: %1\$s",
    Strings.DateInputInvalidForPattern to "ଆଶା କରାଯାଉଥିବା ପାଟର୍ନ ସହ ତାରିଖ ମେଳ ହେଉନାହିଁ: %1\$s",
    Strings.DateInputInvalidYearRange to "ତାରିଖଟି ଆଶା କରାଯାଉଥିବା ବର୍ଷ ରେଞ୍ଜ %1\$s - %2\$sରୁ ବାହାରେ ଅଛି",
    Strings.DatePickerSwitchToCalendarMode to "କେଲେଣ୍ଡର ଇନପୁଟ ମୋଡକୁ ସୁଇଚ କରନ୍ତୁ",
    Strings.DatePickerSwitchToInputMode to "ଟେକ୍ସଟ ଇନପୁଟ ମୋଡକୁ ସୁଇଚ କରନ୍ତୁ",
    Strings.DatePickerScrollToShowLaterYears to "ପର ବର୍ଷଗୁଡ଼ିକ ଦେଖାଇବା ପାଇଁ ସ୍କ୍ରୋଲ କରନ୍ତୁ",
    Strings.DatePickerScrollToShowEarlierYears to "ପୂର୍ବ ବର୍ଷଗୁଡ଼ିକ ଦେଖାଇବା ପାଇଁ ସ୍କ୍ରୋଲ କରନ୍ତୁ",
    Strings.DateRangePickerTitle to "ତାରିଖଗୁଡ଼ିକ ଚୟନ କରନ୍ତୁ",
    Strings.DateRangePickerStartHeadline to "ଆରମ୍ଭ ତାରିଖ",
    Strings.DateRangePickerEndHeadline to "ଶେଷ ତାରିଖ",
    Strings.DateRangePickerScrollToShowNextMonth to "ପରବର୍ତ୍ତୀ ମାସ ଦେଖାଇବା ପାଇଁ ସ୍କ୍ରୋଲ କରନ୍ତୁ",
    Strings.DateRangePickerScrollToShowPreviousMonth to "ପୂର୍ବବର୍ତ୍ତୀ ମାସ ଦେଖାଇବା ପାଇଁ ସ୍କ୍ରୋଲ କରନ୍ତୁ",
    Strings.DateRangePickerDayInRange to "ରେଞ୍ଜରେ ଅଛି",
    Strings.DateRangeInputTitle to "ତାରିଖଗୁଡ଼ିକ ଲେଖନ୍ତୁ",
    Strings.DateRangeInputInvalidRangeInput to "ଅବୈଧ ତାରିଖ ରେଞ୍ଜ ଇନପୁଟ",
    Strings.BottomSheetPaneTitle to "ବଟମ ସିଟ",
    Strings.BottomSheetDragHandleDescription to "ଡ୍ରାଗ ହେଣ୍ଡେଲ",
    Strings.BottomSheetPartialExpandDescription to "ବଟମ ସିଟକୁ ସଙ୍କୁଚିତ କରନ୍ତୁ",
    Strings.BottomSheetDismissDescription to "ବଟମ ସିଟକୁ ଖାରଜ କରନ୍ତୁ",
    Strings.BottomSheetExpandDescription to "ବଟମ ସିଟକୁ ବିସ୍ତାର କରନ୍ତୁ",
    Strings.TooltipPaneDescription to "ଟୁଲଟିପ",
    Strings.TooltipLongPressLabel to "ଟୁଲଟିପ ଦେଖାନ୍ତୁ",
    Strings.TimePickerPM to "PM",
    Strings.TimePickerAM to "AM",
    Strings.TimePickerPeriodToggle to "AM କିମ୍ବା PM ଚୟନ କରନ୍ତୁ",
    Strings.TimePickerHourSelection to "ଘଣ୍ଟା ଚୟନ କରନ୍ତୁ",
    Strings.TimePickerMinuteSelection to "ମିନିଟ ଚୟନ କରନ୍ତୁ",
    Strings.TimePickerHourSuffix to "%1\$dଟା",
    Strings.TimePicker24HourSuffix to "%1\$d ଘଣ୍ଟା",
    Strings.TimePickerMinuteSuffix to "%1\$d ମିନିଟ",
    Strings.TimePickerMinute to "ମିନିଟ",
    Strings.TimePickerHour to "ଘଣ୍ଟା",
    Strings.TimePickerMinuteTextField to "ମିନିଟ ପାଇଁ",
    Strings.TimePickerHourTextField to "ଘଣ୍ଟା ପାଇଁ",
)
