/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material3.l10n

import androidx.compose.material3.internal.Strings
import androidx.compose.material3.internal.Translations

@Suppress("UnusedReceiverParameter", "DuplicatedCode")
internal fun Translations.sv() = mapOf(
    Strings.NavigationMenu to "Navigeringsmeny",
    Strings.ExposedDropdownMenu to "Rullgardinsmeny",
    Strings.CloseDrawer to "Stäng navigeringsmenyn",
    Strings.CloseSheet to "Stäng kalkylarket",
    Strings.DefaultErrorMessage to "Ogiltiga indata",
    Strings.SliderRangeStart to "Intervallets början",
    Strings.SliderRangeEnd to "Intervallets slut",
    Strings.Dialog to "Dialogruta",
    Strings.MenuExpanded to "Utökad",
    Strings.MenuCollapsed to "Komprimerad",
    Strings.ToggleDropdownMenu to "Utöka/komprimera rullgardinsmeny",
    Strings.SnackbarDismiss to "Stäng",
    Strings.SearchBarSearch to "Sök",
    Strings.SuggestionsAvailable to "Se förslag nedan",
    Strings.DatePickerTitle to "Välj datum",
    Strings.DatePickerHeadline to "Valt datum",
    Strings.DatePickerSwitchToYearSelection to "Byt till att välja år",
    Strings.DatePickerSwitchToDaySelection to "Svep för att välja ett år eller tryck för att återgå till att välja en dag",
    Strings.DatePickerSwitchToNextMonth to "Ändra till nästa månad",
    Strings.DatePickerSwitchToPreviousMonth to "Ändra till föregående månad",
    Strings.DatePickerNavigateToYearDescription to "Navigera till %1\$s",
    Strings.DatePickerHeadlineDescription to "Aktuellt val: %1\$s",
    Strings.DatePickerNoSelectionDescription to "Inga",
    Strings.DatePickerTodayDescription to "I dag",
    Strings.DatePickerYearPickerPaneTitle to "Årväljaren är synlig",
    Strings.DateInputTitle to "Välj datum",
    Strings.DateInputHeadline to "Angivet datum",
    Strings.DateInputLabel to "Datum",
    Strings.DateInputHeadlineDescription to "Angivet datum: %1\$s",
    Strings.DateInputNoInputDescription to "Inga",
    Strings.DateInputInvalidNotAllowed to "Datumet är inte tillåtet: %1\$s",
    Strings.DateInputInvalidForPattern to "Datumet matchar inte det förväntade formatet: %1\$s",
    Strings.DateInputInvalidYearRange to "Datumet faller utanför det förväntade årsintervallet %1\$s–%2\$s",
    Strings.DatePickerSwitchToCalendarMode to "Byt till kalender som inmatningsläge",
    Strings.DatePickerSwitchToInputMode to "Byt till text som inmatningsläge",
    Strings.DatePickerScrollToShowLaterYears to "Scrolla för att visa senare år",
    Strings.DatePickerScrollToShowEarlierYears to "Scrolla för att visa föregående år",
    Strings.DateRangePickerTitle to "Välj datum",
    Strings.DateRangePickerStartHeadline to "Startdatum",
    Strings.DateRangePickerEndHeadline to "Slutdatum",
    Strings.DateRangePickerScrollToShowNextMonth to "Scrolla för att visa nästa månad",
    Strings.DateRangePickerScrollToShowPreviousMonth to "Scrolla för att visa föregående månad",
    Strings.DateRangePickerDayInRange to "Inom intervall",
    Strings.DateRangeInputTitle to "Ange datum",
    Strings.DateRangeInputInvalidRangeInput to "Ett ogiltigt datumintervall har angetts",
    Strings.BottomSheetPaneTitle to "Ark på nedre delen av skärmen",
    Strings.BottomSheetDragHandleDescription to "Handtag",
    Strings.BottomSheetPartialExpandDescription to "Komprimera arket på nedre delen av skärmen",
    Strings.BottomSheetDismissDescription to "Stäng arket på nedre delen av skärmen",
    Strings.BottomSheetExpandDescription to "Utöka arket på nedre delen av skärmen",
    Strings.TooltipPaneDescription to "Beskrivning",
    Strings.TooltipLongPressLabel to "Visa beskrivning",
    Strings.TimePickerPM to "EM",
    Strings.TimePickerAM to "FM",
    Strings.TimePickerPeriodToggle to "Välj mellan FM och EM",
    Strings.TimePickerHourSelection to "Ange timme",
    Strings.TimePickerMinuteSelection to "Välj minuter",
    Strings.TimePickerHourSuffix to "Kl. %1\$d",
    Strings.TimePicker24HourSuffix to "%1\$d tim",
    Strings.TimePickerMinuteSuffix to "%1\$d minuter",
    Strings.TimePickerMinute to "Minut",
    Strings.TimePickerHour to "Timme",
    Strings.TimePickerMinuteTextField to "för minuter",
    Strings.TimePickerHourTextField to "för timme",
)
