/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material3.l10n

import androidx.compose.material3.internal.Strings
import androidx.compose.material3.internal.Translations

@Suppress("UnusedReceiverParameter", "DuplicatedCode")
internal fun Translations.ml() = mapOf(
    Strings.NavigationMenu to "നാവിഗേഷൻ മെനു",
    Strings.ExposedDropdownMenu to "ഡ്രോപ്പ്‌ഡൗൺ മെനു",
    Strings.CloseDrawer to "നാവിഗേഷൻ മെനു അടയ്‌ക്കുക",
    Strings.CloseSheet to "ഷീറ്റ് അടയ്ക്കുക",
    Strings.DefaultErrorMessage to "ഇൻപുട്ട് അസാധുവാണ്",
    Strings.SliderRangeStart to "ശ്രേണിയുടെ ആരംഭം",
    Strings.SliderRangeEnd to "ശ്രേണിയുടെ അവസാനം",
    Strings.Dialog to "ഡയലോഗ്",
    Strings.MenuExpanded to "വിപുലീകരിച്ചത്",
    Strings.MenuCollapsed to "ചുരുക്കിയത്",
    Strings.ToggleDropdownMenu to "ഡ്രോപ്പ്ഡൗൺ മെനു ടോഗിൾ ചെയ്യുക",
    Strings.SnackbarDismiss to "ഡിസ്‌മിസ് ചെയ്യുക",
    Strings.SearchBarSearch to "തിരയുക",
    Strings.SuggestionsAvailable to "നിദ്ദേശങ്ങൾ ചുവടെയുണ്ട്",
    Strings.DatePickerTitle to "തീയതി തിരഞ്ഞെടുക്കുക",
    Strings.DatePickerHeadline to "തിരഞ്ഞെടുത്ത തീയതി",
    Strings.DatePickerSwitchToYearSelection to "വർഷം തിരഞ്ഞെടുക്കുന്നതിലേക്ക് മാറുക",
    Strings.DatePickerSwitchToDaySelection to "വർഷം തിരഞ്ഞെടുക്കാൻ സ്വൈപ്പ് ചെയ്യുക അല്ലെങ്കിൽ ദിവസം തിരഞ്ഞെടുക്കുന്നതിലേക്ക് തിരികെ പോകാൻ ടാപ്പ് ചെയ്യുക",
    Strings.DatePickerSwitchToNextMonth to "അടുത്ത മാസത്തിലേക്ക് മാറ്റുക",
    Strings.DatePickerSwitchToPreviousMonth to "മുമ്പത്തെ മാസത്തിലേക്ക് മാറ്റുക",
    Strings.DatePickerNavigateToYearDescription to "%1\$s എന്ന വർഷത്തിലേക്ക് പോകുക",
    Strings.DatePickerHeadlineDescription to "നിലവിലെ തിരഞ്ഞെടുപ്പ്: %1\$s",
    Strings.DatePickerNoSelectionDescription to "ഒന്നുമില്ല",
    Strings.DatePickerTodayDescription to "ഇന്ന്",
    Strings.DatePickerYearPickerPaneTitle to "വർഷ പിക്കർ ദൃശ്യമാണ്",
    Strings.DateInputTitle to "തീയതി തിരഞ്ഞെടുക്കുക",
    Strings.DateInputHeadline to "നൽകിയ തീയതി",
    Strings.DateInputLabel to "തീയതി",
    Strings.DateInputHeadlineDescription to "നൽകിയ തീയതി: %1\$s",
    Strings.DateInputNoInputDescription to "ഒന്നുമില്ല",
    Strings.DateInputInvalidNotAllowed to "തീയതി അനുവദനീയമല്ല: %1\$s",
    Strings.DateInputInvalidForPattern to "പ്രതീക്ഷിച്ച പാറ്റേണുമായി തീയതി പൊരുത്തപ്പെടുന്നില്ല: %1\$s",
    Strings.DateInputInvalidYearRange to "പ്രതീക്ഷിക്കുന്ന കാലയളവിലെ വർഷമല്ല നൽകിയ തീയതിയുടേത് %1\$s - %2\$s",
    Strings.DatePickerSwitchToCalendarMode to "കലണ്ടർ ഇൻപുട്ട് മോഡിലേക്ക് മാറുക",
    Strings.DatePickerSwitchToInputMode to "ടെക്‌സ്‌റ്റ് ഇൻപുട്ട് മോഡിലേക്ക് മാറുക",
    Strings.DatePickerScrollToShowLaterYears to "പിന്നീടുള്ള വർഷങ്ങൾ കാണിക്കാൻ സ്ക്രോൾ ചെയ്യുക",
    Strings.DatePickerScrollToShowEarlierYears to "മുൻ വർഷങ്ങൾ കാണിക്കാൻ സ്ക്രോൾ ചെയ്യുക",
    Strings.DateRangePickerTitle to "തീയതികൾ തിരഞ്ഞെടുക്കുക",
    Strings.DateRangePickerStartHeadline to "ആരംഭിക്കുന്ന തീയതി",
    Strings.DateRangePickerEndHeadline to "അവസാനിക്കുന്ന തീയതി",
    Strings.DateRangePickerScrollToShowNextMonth to "അടുത്ത മാസം കാണിക്കാൻ സ്ക്രോൾ ചെയ്യുക",
    Strings.DateRangePickerScrollToShowPreviousMonth to "മുമ്പത്തെ മാസം കാണിക്കാൻ സ്ക്രോൾ ചെയ്യുക",
    Strings.DateRangePickerDayInRange to "പരിധിയിൽ",
    Strings.DateRangeInputTitle to "തീയതികൾ നൽകുക",
    Strings.DateRangeInputInvalidRangeInput to "തീയതി ശ്രേണി ഇൻപുട്ട് അസാധുവാണ്",
    Strings.BottomSheetPaneTitle to "ബോട്ടം ഷീറ്റ്",
    Strings.BottomSheetDragHandleDescription to "വലിച്ചിടുന്നതിനുള്ള ഹാൻഡിൽ",
    Strings.BottomSheetPartialExpandDescription to "ബോട്ടം ഷീറ്റ് ചുരുക്കുക",
    Strings.BottomSheetDismissDescription to "ബോട്ടം ഷീറ്റ് ഡിസ്മിസ് ചെയ്യുക",
    Strings.BottomSheetExpandDescription to "ബോട്ടം ഷീറ്റ് വികസിപ്പിക്കുക",
    Strings.TooltipPaneDescription to "ടൂൾടിപ്പ്",
    Strings.TooltipLongPressLabel to "ടൂൾടിപ്പ് കാണിക്കുക",
    Strings.TimePickerPM to "PM",
    Strings.TimePickerAM to "AM",
    Strings.TimePickerPeriodToggle to "AM അല്ലെങ്കിൽ PM തിരഞ്ഞെടുക്കുക",
    Strings.TimePickerHourSelection to "മണിക്കൂർ തിരഞ്ഞെടുക്കുക",
    Strings.TimePickerMinuteSelection to "മിനിറ്റ് തിരഞ്ഞെടുക്കുക",
    Strings.TimePickerHourSuffix to "%1\$d മണി",
    Strings.TimePicker24HourSuffix to "%1\$d മ.",
    Strings.TimePickerMinuteSuffix to "%1\$d മിനിറ്റ്",
    Strings.TimePickerMinute to "മിനിറ്റ്",
    Strings.TimePickerHour to "മണിക്കൂർ",
    Strings.TimePickerMinuteTextField to "മിനിറ്റ് നേരത്തേക്ക്",
    Strings.TimePickerHourTextField to "മണിക്കൂർ നേരത്തേക്ക്",
)
