/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material3.l10n

import androidx.compose.material3.internal.Strings
import androidx.compose.material3.internal.Translations

@Suppress("UnusedReceiverParameter", "DuplicatedCode")
internal fun Translations.pt() = mapOf(
    Strings.NavigationMenu to "Menu de navegação",
    Strings.ExposedDropdownMenu to "Menu suspenso",
    Strings.CloseDrawer to "Fechar menu de navegação",
    Strings.CloseSheet to "Fechar planilha",
    Strings.DefaultErrorMessage to "Entrada inválida",
    Strings.SliderRangeStart to "Início do intervalo",
    Strings.SliderRangeEnd to "Fim do intervalo",
    Strings.Dialog to "Caixa de diálogo",
    Strings.MenuExpanded to "Aberto",
    Strings.MenuCollapsed to "Fechado",
    Strings.ToggleDropdownMenu to "Ativar/desativar o menu suspenso",
    Strings.SnackbarDismiss to "Dispensar",
    Strings.SearchBarSearch to "Pesquisar",
    Strings.SuggestionsAvailable to "Sugestões abaixo",
    Strings.DatePickerTitle to "Selecionar data",
    Strings.DatePickerHeadline to "Data selecionada",
    Strings.DatePickerSwitchToYearSelection to "Usar a seleção de ano",
    Strings.DatePickerSwitchToDaySelection to "Deslize para selecionar um ano ou toque para voltar à seleção de dia",
    Strings.DatePickerSwitchToNextMonth to "Mudar para o próximo mês",
    Strings.DatePickerSwitchToPreviousMonth to "Mudar para o mês anterior",
    Strings.DatePickerNavigateToYearDescription to "Navegar para o ano de %1\$s",
    Strings.DatePickerHeadlineDescription to "Seleção atual: %1\$s",
    Strings.DatePickerNoSelectionDescription to "Nenhum",
    Strings.DatePickerTodayDescription to "Hoje",
    Strings.DatePickerYearPickerPaneTitle to "Seletor de ano visível",
    Strings.DateInputTitle to "Selecionar data",
    Strings.DateInputHeadline to "Data informada",
    Strings.DateInputLabel to "Data",
    Strings.DateInputHeadlineDescription to "Data informada: %1\$s",
    Strings.DateInputNoInputDescription to "Nenhum",
    Strings.DateInputInvalidNotAllowed to "Data não permitida: %1\$s",
    Strings.DateInputInvalidForPattern to "A data não está no padrão esperado: %1\$s",
    Strings.DateInputInvalidYearRange to "A data está fora do intervalo de anos esperado: %1\$s a %2\$s",
    Strings.DatePickerSwitchToCalendarMode to "Usar o modo de entrada na agenda",
    Strings.DatePickerSwitchToInputMode to "Usar o modo de entrada de texto",
    Strings.DatePickerScrollToShowLaterYears to "Role a tela para mostrar anos seguintes",
    Strings.DatePickerScrollToShowEarlierYears to "Role a tela para mostrar anos anteriores",
    Strings.DateRangePickerTitle to "Selecionar datas",
    Strings.DateRangePickerStartHeadline to "Data de início",
    Strings.DateRangePickerEndHeadline to "Data de término",
    Strings.DateRangePickerScrollToShowNextMonth to "Role a tela para mostrar o mês seguinte",
    Strings.DateRangePickerScrollToShowPreviousMonth to "Role a tela para mostrar o mês anterior",
    Strings.DateRangePickerDayInRange to "Dentro do período",
    Strings.DateRangeInputTitle to "Informar datas",
    Strings.DateRangeInputInvalidRangeInput to "Período inválido",
    Strings.BottomSheetPaneTitle to "Página inferior",
    Strings.BottomSheetDragHandleDescription to "Alça de arrastar",
    Strings.BottomSheetPartialExpandDescription to "Fechar página inferior",
    Strings.BottomSheetDismissDescription to "Dispensar página inferior",
    Strings.BottomSheetExpandDescription to "Abrir página inferior",
    Strings.TooltipPaneDescription to "Dica",
    Strings.TooltipLongPressLabel to "Mostrar dica",
    Strings.TimePickerPM to "PM",
    Strings.TimePickerAM to "AM",
    Strings.TimePickerPeriodToggle to "Selecione AM ou PM",
    Strings.TimePickerHourSelection to "Selecione a hora",
    Strings.TimePickerMinuteSelection to "Selecione os minutos",
    Strings.TimePickerHourSuffix to "%1\$dh",
    Strings.TimePicker24HourSuffix to "%1\$d horas",
    Strings.TimePickerMinuteSuffix to "%1\$d minutos",
    Strings.TimePickerMinute to "Minuto",
    Strings.TimePickerHour to "Hora",
    Strings.TimePickerMinuteTextField to "por minutos",
    Strings.TimePickerHourTextField to "por hora",
)

@Suppress("UnusedReceiverParameter", "DuplicatedCode")
internal fun Translations.ptBR() = mapOf(
    Strings.NavigationMenu to "Menu de navegação",
    Strings.ExposedDropdownMenu to "Menu suspenso",
    Strings.CloseDrawer to "Fechar menu de navegação",
    Strings.CloseSheet to "Fechar planilha",
    Strings.DefaultErrorMessage to "Entrada inválida",
    Strings.SliderRangeStart to "Início do intervalo",
    Strings.SliderRangeEnd to "Fim do intervalo",
    Strings.Dialog to "Caixa de diálogo",
    Strings.MenuExpanded to "Aberto",
    Strings.MenuCollapsed to "Fechado",
    Strings.ToggleDropdownMenu to "Ativar/desativar o menu suspenso",
    Strings.SnackbarDismiss to "Dispensar",
    Strings.SearchBarSearch to "Pesquisar",
    Strings.SuggestionsAvailable to "Sugestões abaixo",
    Strings.DatePickerTitle to "Selecionar data",
    Strings.DatePickerHeadline to "Data selecionada",
    Strings.DatePickerSwitchToYearSelection to "Usar a seleção de ano",
    Strings.DatePickerSwitchToDaySelection to "Deslize para selecionar um ano ou toque para voltar à seleção de dia",
    Strings.DatePickerSwitchToNextMonth to "Mudar para o próximo mês",
    Strings.DatePickerSwitchToPreviousMonth to "Mudar para o mês anterior",
    Strings.DatePickerNavigateToYearDescription to "Navegar para o ano de %1\$s",
    Strings.DatePickerHeadlineDescription to "Seleção atual: %1\$s",
    Strings.DatePickerNoSelectionDescription to "Nenhum",
    Strings.DatePickerTodayDescription to "Hoje",
    Strings.DatePickerYearPickerPaneTitle to "Seletor de ano visível",
    Strings.DateInputTitle to "Selecionar data",
    Strings.DateInputHeadline to "Data informada",
    Strings.DateInputLabel to "Data",
    Strings.DateInputHeadlineDescription to "Data informada: %1\$s",
    Strings.DateInputNoInputDescription to "Nenhum",
    Strings.DateInputInvalidNotAllowed to "Data não permitida: %1\$s",
    Strings.DateInputInvalidForPattern to "A data não está no padrão esperado: %1\$s",
    Strings.DateInputInvalidYearRange to "A data está fora do intervalo de anos esperado: %1\$s a %2\$s",
    Strings.DatePickerSwitchToCalendarMode to "Usar o modo de entrada na agenda",
    Strings.DatePickerSwitchToInputMode to "Usar o modo de entrada de texto",
    Strings.DatePickerScrollToShowLaterYears to "Role a tela para mostrar anos seguintes",
    Strings.DatePickerScrollToShowEarlierYears to "Role a tela para mostrar anos anteriores",
    Strings.DateRangePickerTitle to "Selecionar datas",
    Strings.DateRangePickerStartHeadline to "Data de início",
    Strings.DateRangePickerEndHeadline to "Data de término",
    Strings.DateRangePickerScrollToShowNextMonth to "Role a tela para mostrar o mês seguinte",
    Strings.DateRangePickerScrollToShowPreviousMonth to "Role a tela para mostrar o mês anterior",
    Strings.DateRangePickerDayInRange to "Dentro do período",
    Strings.DateRangeInputTitle to "Informar datas",
    Strings.DateRangeInputInvalidRangeInput to "Período inválido",
    Strings.BottomSheetPaneTitle to "Página inferior",
    Strings.BottomSheetDragHandleDescription to "Alça de arrastar",
    Strings.BottomSheetPartialExpandDescription to "Fechar página inferior",
    Strings.BottomSheetDismissDescription to "Dispensar página inferior",
    Strings.BottomSheetExpandDescription to "Abrir página inferior",
    Strings.TooltipPaneDescription to "Dica",
    Strings.TooltipLongPressLabel to "Mostrar dica",
    Strings.TimePickerPM to "PM",
    Strings.TimePickerAM to "AM",
    Strings.TimePickerPeriodToggle to "Selecione AM ou PM",
    Strings.TimePickerHourSelection to "Selecione a hora",
    Strings.TimePickerMinuteSelection to "Selecione os minutos",
    Strings.TimePickerHourSuffix to "%1\$dh",
    Strings.TimePicker24HourSuffix to "%1\$d horas",
    Strings.TimePickerMinuteSuffix to "%1\$d minutos",
    Strings.TimePickerMinute to "Minuto",
    Strings.TimePickerHour to "Hora",
    Strings.TimePickerMinuteTextField to "por minutos",
    Strings.TimePickerHourTextField to "por hora",
)

@Suppress("UnusedReceiverParameter", "DuplicatedCode")
internal fun Translations.ptPT() = mapOf(
    Strings.NavigationMenu to "Menu de navegação",
    Strings.ExposedDropdownMenu to "Menu pendente",
    Strings.CloseDrawer to "Fechar menu de navegação",
    Strings.CloseSheet to "Fechar folha",
    Strings.DefaultErrorMessage to "Entrada inválida",
    Strings.SliderRangeStart to "Início do intervalo",
    Strings.SliderRangeEnd to "Fim do intervalo",
    Strings.Dialog to "Caixa de diálogo",
    Strings.MenuExpanded to "Expandido",
    Strings.MenuCollapsed to "Reduzido",
    Strings.ToggleDropdownMenu to "Ativar/desativar menu pendente",
    Strings.SnackbarDismiss to "Ignorar",
    Strings.SearchBarSearch to "Pesquisar",
    Strings.SuggestionsAvailable to "Sugestões abaixo",
    Strings.DatePickerTitle to "Selecione uma data",
    Strings.DatePickerHeadline to "Data selecionada",
    Strings.DatePickerSwitchToYearSelection to "Mudar para a seleção do ano",
    Strings.DatePickerSwitchToDaySelection to "Deslize rapidamente para selecionar um ano ou toque para mudar novamente para a seleção do dia",
    Strings.DatePickerSwitchToNextMonth to "Mudar para o mês seguinte",
    Strings.DatePickerSwitchToPreviousMonth to "Mudar para o mês anterior",
    Strings.DatePickerNavigateToYearDescription to "Navegar para o ano %1\$s",
    Strings.DatePickerHeadlineDescription to "Seleção atual: %1\$s",
    Strings.DatePickerNoSelectionDescription to "Nenhuma",
    Strings.DatePickerTodayDescription to "Hoje",
    Strings.DatePickerYearPickerPaneTitle to "Selecionador de ano visível",
    Strings.DateInputTitle to "Selecione uma data",
    Strings.DateInputHeadline to "Data introduzida",
    Strings.DateInputLabel to "Data",
    Strings.DateInputHeadlineDescription to "Data introduzida: %1\$s",
    Strings.DateInputNoInputDescription to "Nenhuma",
    Strings.DateInputInvalidNotAllowed to "Data não permitida: %1\$s",
    Strings.DateInputInvalidForPattern to "A data não corresponde ao padrão esperado: %1\$s",
    Strings.DateInputInvalidYearRange to "Data fora do intervalo de anos esperado: %1\$s – %2\$s",
    Strings.DatePickerSwitchToCalendarMode to "Mudar para o método de introdução de calendário",
    Strings.DatePickerSwitchToInputMode to "Mudar para o método de introdução de texto",
    Strings.DatePickerScrollToShowLaterYears to "Desloque a página para mostrar anos posteriores",
    Strings.DatePickerScrollToShowEarlierYears to "Desloque a página para mostrar anos anteriores",
    Strings.DateRangePickerTitle to "Selecione as datas",
    Strings.DateRangePickerStartHeadline to "Data de início",
    Strings.DateRangePickerEndHeadline to "Data de fim",
    Strings.DateRangePickerScrollToShowNextMonth to "Desloque a página para mostrar o mês seguinte",
    Strings.DateRangePickerScrollToShowPreviousMonth to "Desloque a página para mostrar o mês anterior",
    Strings.DateRangePickerDayInRange to "Dentro do intervalo",
    Strings.DateRangeInputTitle to "Introduza as datas",
    Strings.DateRangeInputInvalidRangeInput to "Entrada do intervalo de datas inválida",
    Strings.BottomSheetPaneTitle to "Secção inferior",
    Strings.BottomSheetDragHandleDescription to "Indicador para arrastar",
    Strings.BottomSheetPartialExpandDescription to "Reduza a secção inferior",
    Strings.BottomSheetDismissDescription to "Ignore a secção inferior",
    Strings.BottomSheetExpandDescription to "Expanda a secção inferior",
    Strings.TooltipPaneDescription to "Sugestão",
    Strings.TooltipLongPressLabel to "Mostrar sugestão",
    Strings.TimePickerPM to "PM",
    Strings.TimePickerAM to "AM",
    Strings.TimePickerPeriodToggle to "Selecione AM ou PM",
    Strings.TimePickerHourSelection to "Selecionar hora",
    Strings.TimePickerMinuteSelection to "Selecionar minutos",
    Strings.TimePickerHourSuffix to "%1\$d h",
    Strings.TimePicker24HourSuffix to "%1\$d horas",
    Strings.TimePickerMinuteSuffix to "%1\$d minutos",
    Strings.TimePickerMinute to "Minuto",
    Strings.TimePickerHour to "Hora",
    Strings.TimePickerMinuteTextField to "para minutos",
    Strings.TimePickerHourTextField to "para hora",
)
