/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material3.l10n

import androidx.compose.material3.internal.Strings
import androidx.compose.material3.internal.Translations

@Suppress("UnusedReceiverParameter", "DuplicatedCode")
internal fun Translations.hy() = mapOf(
    Strings.NavigationMenu to "Նավիգացիայի ընտրացանկ",
    Strings.ExposedDropdownMenu to "Իջնող ցանկ",
    Strings.CloseDrawer to "Փակել նավիգացիայի ընտրացանկը",
    Strings.CloseSheet to "Փակել թերթը",
    Strings.DefaultErrorMessage to "Սխալ ներածում",
    Strings.SliderRangeStart to "Ընդգրկույթի սկիզբ",
    Strings.SliderRangeEnd to "Ընդգրկույթի վերջ",
    Strings.Dialog to "Երկխոսության պատուհան",
    Strings.MenuExpanded to "Ծավալված է",
    Strings.MenuCollapsed to "Ծալված է",
    Strings.ToggleDropdownMenu to "Բացել/փակել իջնող ցանկը",
    Strings.SnackbarDismiss to "Փակել",
    Strings.SearchBarSearch to "Որոնում",
    Strings.SuggestionsAvailable to "Առաջարկները հասանելի են ստորև",
    Strings.DatePickerTitle to "Ընտրեք ամսաթիվը",
    Strings.DatePickerHeadline to "Ընտրված ամսաթիվ",
    Strings.DatePickerSwitchToYearSelection to "Անցնել տարվա ընտրությանը",
    Strings.DatePickerSwitchToDaySelection to "Սահեցրեք՝ տարեթիվ ընտրելու համար, կամ հպեք՝ օրվա ընտրությանը վերադառնալու համար",
    Strings.DatePickerSwitchToNextMonth to "Անցնել հաջորդ ամսվան",
    Strings.DatePickerSwitchToPreviousMonth to "Անցնել նախորդ ամսվան",
    Strings.DatePickerNavigateToYearDescription to "Անցնել %1\$s թվական",
    Strings.DatePickerHeadlineDescription to "Ընթացիկ ընտրությունը՝ %1\$s",
    Strings.DatePickerNoSelectionDescription to "Չկա",
    Strings.DatePickerTodayDescription to "Այսօր",
    Strings.DatePickerYearPickerPaneTitle to "Տարեթվի ցուցադրվող ընտրիչ",
    Strings.DateInputTitle to "Ընտրեք ամսաթիվը",
    Strings.DateInputHeadline to "Մուտքագրված ամսաթիվ",
    Strings.DateInputLabel to "Ամսաթիվ",
    Strings.DateInputHeadlineDescription to "Մուտքագրված ամսաթիվ՝ %1\$s",
    Strings.DateInputNoInputDescription to "Չկա",
    Strings.DateInputInvalidNotAllowed to "Ամսաթիվը թույլատրված չէ՝ %1\$s",
    Strings.DateInputInvalidForPattern to "Ամսաթիվը չի համընկնում թույլատրելի ձևաչափի հետ՝ %1\$s",
    Strings.DateInputInvalidYearRange to "Ամսաթիվը տարեթվերի թույլատրելի միջակայքից (%1\$s – %2\$s) դուրս է",
    Strings.DatePickerSwitchToCalendarMode to "Անցնել օրացույցի մուտքագրման ռեժիմ",
    Strings.DatePickerSwitchToInputMode to "Անցնել տեքստի մուտքագրման ռեժիմին",
    Strings.DatePickerScrollToShowLaterYears to "Ոլորեք՝ վերջին տարիները ցուցադրելու համար",
    Strings.DatePickerScrollToShowEarlierYears to "Ոլորեք՝ նախորդ տարիները ցուցադրելու համար",
    Strings.DateRangePickerTitle to "Ընտրեք ամսաթվեր",
    Strings.DateRangePickerStartHeadline to "Սկզբի ամսաթիվ",
    Strings.DateRangePickerEndHeadline to "Ավարտի ամսաթիվ",
    Strings.DateRangePickerScrollToShowNextMonth to "Ոլորեք՝ հաջորդ ամիսը ցուցադրելու համար",
    Strings.DateRangePickerScrollToShowPreviousMonth to "Ոլորեք՝ նախորդ ամիսը ցուցադրելու համար",
    Strings.DateRangePickerDayInRange to "Միջակայքում",
    Strings.DateRangeInputTitle to "Մուտքագրեք ամսաթվերը",
    Strings.DateRangeInputInvalidRangeInput to "Մուտքագրված ամսաթվերի միջակայքն անվավեր է",
    Strings.BottomSheetPaneTitle to "Ներքևի էկրան",
    Strings.BottomSheetDragHandleDescription to "Տեղափոխման նշիչ",
    Strings.BottomSheetPartialExpandDescription to "Ծալել ներքևի էկրանը",
    Strings.BottomSheetDismissDescription to "Փակել ներքևի էկրանը",
    Strings.BottomSheetExpandDescription to "Ծավալել ներքևի էկրանը",
    Strings.TooltipPaneDescription to "Հուշակ",
    Strings.TooltipLongPressLabel to "Ցուցադրել հուշում",
    Strings.TimePickerPM to "PM",
    Strings.TimePickerAM to "AM",
    Strings.TimePickerPeriodToggle to "Ընտրել AM կամ PM",
    Strings.TimePickerHourSelection to "Ընտրեք ժամը",
    Strings.TimePickerMinuteSelection to "Ընտրեք րոպեն",
    Strings.TimePickerHourSuffix to "%1\$d",
    Strings.TimePicker24HourSuffix to "%1\$d ժամ",
    Strings.TimePickerMinuteSuffix to "%1\$d րոպե",
    Strings.TimePickerMinute to "Րոպեներ",
    Strings.TimePickerHour to "Ժամ",
    Strings.TimePickerMinuteTextField to "րոպեներ",
    Strings.TimePickerHourTextField to "ժամեր",
)
