/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material3.l10n

import androidx.compose.material3.internal.Strings
import androidx.compose.material3.internal.Translations

@Suppress("UnusedReceiverParameter", "DuplicatedCode")
internal fun Translations.en() = mapOf(
    Strings.NavigationMenu to "Navigation menu",
    Strings.ExposedDropdownMenu to "Dropdown menu",
    Strings.CloseDrawer to "Close navigation menu",
    Strings.CloseSheet to "Close sheet",
    Strings.DefaultErrorMessage to "Invalid input",
    Strings.SliderRangeStart to "Range start",
    Strings.SliderRangeEnd to "Range end",
    Strings.Dialog to "Dialog",
    Strings.MenuExpanded to "Expanded",
    Strings.MenuCollapsed to "Collapsed",
    Strings.ToggleDropdownMenu to "Toggle dropdown menu",
    Strings.SnackbarDismiss to "Dismiss",
    Strings.SearchBarSearch to "Search",
    Strings.SuggestionsAvailable to "Suggestions below",
    Strings.DatePickerTitle to "Select date",
    Strings.DatePickerHeadline to "Selected date",
    Strings.DatePickerSwitchToYearSelection to "Switch to selecting a year",
    Strings.DatePickerSwitchToDaySelection to "Swipe to select a year, or tap to switch back to selecting a day",
    Strings.DatePickerSwitchToNextMonth to "Change to next month",
    Strings.DatePickerSwitchToPreviousMonth to "Change to previous month",
    Strings.DatePickerNavigateToYearDescription to "Navigate to year %1\$s",
    Strings.DatePickerHeadlineDescription to "Current selection: %1\$s",
    Strings.DatePickerNoSelectionDescription to "None",
    Strings.DatePickerTodayDescription to "Today",
    Strings.DatePickerYearPickerPaneTitle to "Year picker visible",
    Strings.DateInputTitle to "Select date",
    Strings.DateInputHeadline to "Entered date",
    Strings.DateInputLabel to "Date",
    Strings.DateInputHeadlineDescription to "Entered date: %1\$s",
    Strings.DateInputNoInputDescription to "None",
    Strings.DateInputInvalidNotAllowed to "Date not allowed: %1\$s",
    Strings.DateInputInvalidForPattern to "Date does not match expected pattern: %1\$s",
    Strings.DateInputInvalidYearRange to "Date out of expected year range %1\$s - %2\$s",
    Strings.DatePickerSwitchToCalendarMode to "Switch to calendar input mode",
    Strings.DatePickerSwitchToInputMode to "Switch to text input mode",
    Strings.DatePickerScrollToShowLaterYears to "Scroll to show later years",
    Strings.DatePickerScrollToShowEarlierYears to "Scroll to show earlier years",
    Strings.DateRangePickerTitle to "Select dates",
    Strings.DateRangePickerStartHeadline to "Start date",
    Strings.DateRangePickerEndHeadline to "End date",
    Strings.DateRangePickerScrollToShowNextMonth to "Scroll to show the next month",
    Strings.DateRangePickerScrollToShowPreviousMonth to "Scroll to show the previous month",
    Strings.DateRangePickerDayInRange to "In range",
    Strings.DateRangeInputTitle to "Enter dates",
    Strings.DateRangeInputInvalidRangeInput to "Invalid date range input",
    Strings.BottomSheetPaneTitle to "Bottom Sheet",
    Strings.BottomSheetDragHandleDescription to "Drag handle",
    Strings.BottomSheetPartialExpandDescription to "Collapse bottom sheet",
    Strings.BottomSheetDismissDescription to "Dismiss bottom sheet",
    Strings.BottomSheetExpandDescription to "Expand bottom sheet",
    Strings.TooltipPaneDescription to "Tooltip",
    Strings.TooltipLongPressLabel to "Show tooltip",
    Strings.TimePickerPM to "PM",
    Strings.TimePickerAM to "AM",
    Strings.TimePickerPeriodToggle to "Select AM or PM",
    Strings.TimePickerHourSelection to "Select hour",
    Strings.TimePickerMinuteSelection to "Select minutes",
    Strings.TimePickerHourSuffix to "%1\$d o\'clock",
    Strings.TimePicker24HourSuffix to "%1\$d hours",
    Strings.TimePickerMinuteSuffix to "%1\$d minutes",
    Strings.TimePickerMinute to "Minute",
    Strings.TimePickerHour to "Hour",
    Strings.TimePickerMinuteTextField to "for minutes",
    Strings.TimePickerHourTextField to "for hour",
)

@Suppress("UnusedReceiverParameter", "DuplicatedCode")
internal fun Translations.enAU() = mapOf(
    Strings.NavigationMenu to "Navigation menu",
    Strings.ExposedDropdownMenu to "Drop-down menu",
    Strings.CloseDrawer to "Close navigation menu",
    Strings.CloseSheet to "Close sheet",
    Strings.DefaultErrorMessage to "Invalid input",
    Strings.SliderRangeStart to "Range start",
    Strings.SliderRangeEnd to "Range end",
    Strings.Dialog to "Dialogue",
    Strings.MenuExpanded to "Expanded",
    Strings.MenuCollapsed to "Collapsed",
    Strings.ToggleDropdownMenu to "Toggle drop-down menu",
    Strings.SnackbarDismiss to "Dismiss",
    Strings.SearchBarSearch to "Search",
    Strings.SuggestionsAvailable to "Suggestions below",
    Strings.DatePickerTitle to "Select date",
    Strings.DatePickerHeadline to "Selected date",
    Strings.DatePickerSwitchToYearSelection to "Switch to selecting a year",
    Strings.DatePickerSwitchToDaySelection to "Swipe to select a year or tap to switch back to selecting a day",
    Strings.DatePickerSwitchToNextMonth to "Change to next month",
    Strings.DatePickerSwitchToPreviousMonth to "Change to previous month",
    Strings.DatePickerNavigateToYearDescription to "Navigate to year %1\$s",
    Strings.DatePickerHeadlineDescription to "Current selection: %1\$s",
    Strings.DatePickerNoSelectionDescription to "None",
    Strings.DatePickerTodayDescription to "Today",
    Strings.DatePickerYearPickerPaneTitle to "Year picker visible",
    Strings.DateInputTitle to "Select date",
    Strings.DateInputHeadline to "Entered date",
    Strings.DateInputLabel to "Date",
    Strings.DateInputHeadlineDescription to "Entered date: %1\$s",
    Strings.DateInputNoInputDescription to "None",
    Strings.DateInputInvalidNotAllowed to "Date not allowed: %1\$s",
    Strings.DateInputInvalidForPattern to "Date does not match expected pattern: %1\$s",
    Strings.DateInputInvalidYearRange to "Date out of expected year range %1\$s - %2\$s",
    Strings.DatePickerSwitchToCalendarMode to "Switch to calendar input mode",
    Strings.DatePickerSwitchToInputMode to "Switch to text input mode",
    Strings.DatePickerScrollToShowLaterYears to "Scroll to show later years",
    Strings.DatePickerScrollToShowEarlierYears to "Scroll to show earlier years",
    Strings.DateRangePickerTitle to "Select dates",
    Strings.DateRangePickerStartHeadline to "Start date",
    Strings.DateRangePickerEndHeadline to "End date",
    Strings.DateRangePickerScrollToShowNextMonth to "Scroll to show the next month",
    Strings.DateRangePickerScrollToShowPreviousMonth to "Scroll to show the previous month",
    Strings.DateRangePickerDayInRange to "In range",
    Strings.DateRangeInputTitle to "Enter dates",
    Strings.DateRangeInputInvalidRangeInput to "Invalid date range input",
    Strings.BottomSheetPaneTitle to "Bottom sheet",
    Strings.BottomSheetDragHandleDescription to "Drag handle",
    Strings.BottomSheetPartialExpandDescription to "Collapse bottom sheet",
    Strings.BottomSheetDismissDescription to "Dismiss bottom sheet",
    Strings.BottomSheetExpandDescription to "Expand bottom sheet",
    Strings.TooltipPaneDescription to "Tooltip",
    Strings.TooltipLongPressLabel to "Show tooltip",
    Strings.TimePickerPM to "p.m.",
    Strings.TimePickerAM to "a.m.",
    Strings.TimePickerPeriodToggle to "Select a.m. or p.m.",
    Strings.TimePickerHourSelection to "Select hour",
    Strings.TimePickerMinuteSelection to "Select minutes",
    Strings.TimePickerHourSuffix to "%1\$d o\'clock",
    Strings.TimePicker24HourSuffix to "%1\$d hours",
    Strings.TimePickerMinuteSuffix to "%1\$d minutes",
    Strings.TimePickerMinute to "Minute",
    Strings.TimePickerHour to "Hour",
    Strings.TimePickerMinuteTextField to "for minutes",
    Strings.TimePickerHourTextField to "for hour",
)

@Suppress("UnusedReceiverParameter", "DuplicatedCode")
internal fun Translations.enCA() = mapOf(
    Strings.NavigationMenu to "Navigation menu",
    Strings.ExposedDropdownMenu to "Dropdown menu",
    Strings.CloseDrawer to "Close navigation menu",
    Strings.CloseSheet to "Close sheet",
    Strings.DefaultErrorMessage to "Invalid input",
    Strings.SliderRangeStart to "Range start",
    Strings.SliderRangeEnd to "Range end",
    Strings.Dialog to "Dialog",
    Strings.MenuExpanded to "Expanded",
    Strings.MenuCollapsed to "Collapsed",
    Strings.ToggleDropdownMenu to "Toggle dropdown menu",
    Strings.SnackbarDismiss to "Dismiss",
    Strings.SearchBarSearch to "Search",
    Strings.SuggestionsAvailable to "Suggestions below",
    Strings.DatePickerTitle to "Select date",
    Strings.DatePickerHeadline to "Selected date",
    Strings.DatePickerSwitchToYearSelection to "Switch to selecting a year",
    Strings.DatePickerSwitchToDaySelection to "Swipe to select a year, or tap to switch back to selecting a day",
    Strings.DatePickerSwitchToNextMonth to "Change to next month",
    Strings.DatePickerSwitchToPreviousMonth to "Change to previous month",
    Strings.DatePickerNavigateToYearDescription to "Navigate to year %1\$s",
    Strings.DatePickerHeadlineDescription to "Current selection: %1\$s",
    Strings.DatePickerNoSelectionDescription to "None",
    Strings.DatePickerTodayDescription to "Today",
    Strings.DatePickerYearPickerPaneTitle to "Year picker visible",
    Strings.DateInputTitle to "Select date",
    Strings.DateInputHeadline to "Entered date",
    Strings.DateInputLabel to "Date",
    Strings.DateInputHeadlineDescription to "Entered date: %1\$s",
    Strings.DateInputNoInputDescription to "None",
    Strings.DateInputInvalidNotAllowed to "Date not allowed: %1\$s",
    Strings.DateInputInvalidForPattern to "Date does not match expected pattern: %1\$s",
    Strings.DateInputInvalidYearRange to "Date out of expected year range %1\$s - %2\$s",
    Strings.DatePickerSwitchToCalendarMode to "Switch to calendar input mode",
    Strings.DatePickerSwitchToInputMode to "Switch to text input mode",
    Strings.DatePickerScrollToShowLaterYears to "Scroll to show later years",
    Strings.DatePickerScrollToShowEarlierYears to "Scroll to show earlier years",
    Strings.DateRangePickerTitle to "Select dates",
    Strings.DateRangePickerStartHeadline to "Start date",
    Strings.DateRangePickerEndHeadline to "End date",
    Strings.DateRangePickerScrollToShowNextMonth to "Scroll to show the next month",
    Strings.DateRangePickerScrollToShowPreviousMonth to "Scroll to show the previous month",
    Strings.DateRangePickerDayInRange to "In range",
    Strings.DateRangeInputTitle to "Enter dates",
    Strings.DateRangeInputInvalidRangeInput to "Invalid date range input",
    Strings.BottomSheetPaneTitle to "Bottom Sheet",
    Strings.BottomSheetDragHandleDescription to "Drag handle",
    Strings.BottomSheetPartialExpandDescription to "Collapse bottom sheet",
    Strings.BottomSheetDismissDescription to "Dismiss bottom sheet",
    Strings.BottomSheetExpandDescription to "Expand bottom sheet",
    Strings.TooltipPaneDescription to "Tooltip",
    Strings.TooltipLongPressLabel to "Show tooltip",
    Strings.TimePickerPM to "PM",
    Strings.TimePickerAM to "AM",
    Strings.TimePickerPeriodToggle to "Select AM or PM",
    Strings.TimePickerHourSelection to "Select hour",
    Strings.TimePickerMinuteSelection to "Select minutes",
    Strings.TimePickerHourSuffix to "%1\$d o\'clock",
    Strings.TimePicker24HourSuffix to "%1\$d hours",
    Strings.TimePickerMinuteSuffix to "%1\$d minutes",
    Strings.TimePickerMinute to "Minute",
    Strings.TimePickerHour to "Hour",
    Strings.TimePickerMinuteTextField to "for minutes",
    Strings.TimePickerHourTextField to "for hour",
)

@Suppress("UnusedReceiverParameter", "DuplicatedCode")
internal fun Translations.enGB() = mapOf(
    Strings.NavigationMenu to "Navigation menu",
    Strings.ExposedDropdownMenu to "Drop-down menu",
    Strings.CloseDrawer to "Close navigation menu",
    Strings.CloseSheet to "Close sheet",
    Strings.DefaultErrorMessage to "Invalid input",
    Strings.SliderRangeStart to "Range start",
    Strings.SliderRangeEnd to "Range end",
    Strings.Dialog to "Dialogue",
    Strings.MenuExpanded to "Expanded",
    Strings.MenuCollapsed to "Collapsed",
    Strings.ToggleDropdownMenu to "Toggle drop-down menu",
    Strings.SnackbarDismiss to "Dismiss",
    Strings.SearchBarSearch to "Search",
    Strings.SuggestionsAvailable to "Suggestions below",
    Strings.DatePickerTitle to "Select date",
    Strings.DatePickerHeadline to "Selected date",
    Strings.DatePickerSwitchToYearSelection to "Switch to selecting a year",
    Strings.DatePickerSwitchToDaySelection to "Swipe to select a year or tap to switch back to selecting a day",
    Strings.DatePickerSwitchToNextMonth to "Change to next month",
    Strings.DatePickerSwitchToPreviousMonth to "Change to previous month",
    Strings.DatePickerNavigateToYearDescription to "Navigate to year %1\$s",
    Strings.DatePickerHeadlineDescription to "Current selection: %1\$s",
    Strings.DatePickerNoSelectionDescription to "None",
    Strings.DatePickerTodayDescription to "Today",
    Strings.DatePickerYearPickerPaneTitle to "Year picker visible",
    Strings.DateInputTitle to "Select date",
    Strings.DateInputHeadline to "Entered date",
    Strings.DateInputLabel to "Date",
    Strings.DateInputHeadlineDescription to "Entered date: %1\$s",
    Strings.DateInputNoInputDescription to "None",
    Strings.DateInputInvalidNotAllowed to "Date not allowed: %1\$s",
    Strings.DateInputInvalidForPattern to "Date does not match expected pattern: %1\$s",
    Strings.DateInputInvalidYearRange to "Date out of expected year range %1\$s - %2\$s",
    Strings.DatePickerSwitchToCalendarMode to "Switch to calendar input mode",
    Strings.DatePickerSwitchToInputMode to "Switch to text input mode",
    Strings.DatePickerScrollToShowLaterYears to "Scroll to show later years",
    Strings.DatePickerScrollToShowEarlierYears to "Scroll to show earlier years",
    Strings.DateRangePickerTitle to "Select dates",
    Strings.DateRangePickerStartHeadline to "Start date",
    Strings.DateRangePickerEndHeadline to "End date",
    Strings.DateRangePickerScrollToShowNextMonth to "Scroll to show the next month",
    Strings.DateRangePickerScrollToShowPreviousMonth to "Scroll to show the previous month",
    Strings.DateRangePickerDayInRange to "In range",
    Strings.DateRangeInputTitle to "Enter dates",
    Strings.DateRangeInputInvalidRangeInput to "Invalid date range input",
    Strings.BottomSheetPaneTitle to "Bottom sheet",
    Strings.BottomSheetDragHandleDescription to "Drag handle",
    Strings.BottomSheetPartialExpandDescription to "Collapse bottom sheet",
    Strings.BottomSheetDismissDescription to "Dismiss bottom sheet",
    Strings.BottomSheetExpandDescription to "Expand bottom sheet",
    Strings.TooltipPaneDescription to "Tooltip",
    Strings.TooltipLongPressLabel to "Show tooltip",
    Strings.TimePickerPM to "p.m.",
    Strings.TimePickerAM to "a.m.",
    Strings.TimePickerPeriodToggle to "Select a.m. or p.m.",
    Strings.TimePickerHourSelection to "Select hour",
    Strings.TimePickerMinuteSelection to "Select minutes",
    Strings.TimePickerHourSuffix to "%1\$d o\'clock",
    Strings.TimePicker24HourSuffix to "%1\$d hours",
    Strings.TimePickerMinuteSuffix to "%1\$d minutes",
    Strings.TimePickerMinute to "Minute",
    Strings.TimePickerHour to "Hour",
    Strings.TimePickerMinuteTextField to "for minutes",
    Strings.TimePickerHourTextField to "for hour",
)

@Suppress("UnusedReceiverParameter", "DuplicatedCode")
internal fun Translations.enIN() = mapOf(
    Strings.NavigationMenu to "Navigation menu",
    Strings.ExposedDropdownMenu to "Drop-down menu",
    Strings.CloseDrawer to "Close navigation menu",
    Strings.CloseSheet to "Close sheet",
    Strings.DefaultErrorMessage to "Invalid input",
    Strings.SliderRangeStart to "Range start",
    Strings.SliderRangeEnd to "Range end",
    Strings.Dialog to "Dialogue",
    Strings.MenuExpanded to "Expanded",
    Strings.MenuCollapsed to "Collapsed",
    Strings.ToggleDropdownMenu to "Toggle drop-down menu",
    Strings.SnackbarDismiss to "Dismiss",
    Strings.SearchBarSearch to "Search",
    Strings.SuggestionsAvailable to "Suggestions below",
    Strings.DatePickerTitle to "Select date",
    Strings.DatePickerHeadline to "Selected date",
    Strings.DatePickerSwitchToYearSelection to "Switch to selecting a year",
    Strings.DatePickerSwitchToDaySelection to "Swipe to select a year or tap to switch back to selecting a day",
    Strings.DatePickerSwitchToNextMonth to "Change to next month",
    Strings.DatePickerSwitchToPreviousMonth to "Change to previous month",
    Strings.DatePickerNavigateToYearDescription to "Navigate to year %1\$s",
    Strings.DatePickerHeadlineDescription to "Current selection: %1\$s",
    Strings.DatePickerNoSelectionDescription to "None",
    Strings.DatePickerTodayDescription to "Today",
    Strings.DatePickerYearPickerPaneTitle to "Year picker visible",
    Strings.DateInputTitle to "Select date",
    Strings.DateInputHeadline to "Entered date",
    Strings.DateInputLabel to "Date",
    Strings.DateInputHeadlineDescription to "Entered date: %1\$s",
    Strings.DateInputNoInputDescription to "None",
    Strings.DateInputInvalidNotAllowed to "Date not allowed: %1\$s",
    Strings.DateInputInvalidForPattern to "Date does not match expected pattern: %1\$s",
    Strings.DateInputInvalidYearRange to "Date out of expected year range %1\$s - %2\$s",
    Strings.DatePickerSwitchToCalendarMode to "Switch to calendar input mode",
    Strings.DatePickerSwitchToInputMode to "Switch to text input mode",
    Strings.DatePickerScrollToShowLaterYears to "Scroll to show later years",
    Strings.DatePickerScrollToShowEarlierYears to "Scroll to show earlier years",
    Strings.DateRangePickerTitle to "Select dates",
    Strings.DateRangePickerStartHeadline to "Start date",
    Strings.DateRangePickerEndHeadline to "End date",
    Strings.DateRangePickerScrollToShowNextMonth to "Scroll to show the next month",
    Strings.DateRangePickerScrollToShowPreviousMonth to "Scroll to show the previous month",
    Strings.DateRangePickerDayInRange to "In range",
    Strings.DateRangeInputTitle to "Enter dates",
    Strings.DateRangeInputInvalidRangeInput to "Invalid date range input",
    Strings.BottomSheetPaneTitle to "Bottom sheet",
    Strings.BottomSheetDragHandleDescription to "Drag handle",
    Strings.BottomSheetPartialExpandDescription to "Collapse bottom sheet",
    Strings.BottomSheetDismissDescription to "Dismiss bottom sheet",
    Strings.BottomSheetExpandDescription to "Expand bottom sheet",
    Strings.TooltipPaneDescription to "Tooltip",
    Strings.TooltipLongPressLabel to "Show tooltip",
    Strings.TimePickerPM to "p.m.",
    Strings.TimePickerAM to "a.m.",
    Strings.TimePickerPeriodToggle to "Select a.m. or p.m.",
    Strings.TimePickerHourSelection to "Select hour",
    Strings.TimePickerMinuteSelection to "Select minutes",
    Strings.TimePickerHourSuffix to "%1\$d o\'clock",
    Strings.TimePicker24HourSuffix to "%1\$d hours",
    Strings.TimePickerMinuteSuffix to "%1\$d minutes",
    Strings.TimePickerMinute to "Minute",
    Strings.TimePickerHour to "Hour",
    Strings.TimePickerMinuteTextField to "for minutes",
    Strings.TimePickerHourTextField to "for hour",
)
