/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.material3.carousel;

import androidx.collection.FloatList;
import androidx.collection.FloatListKt;
import androidx.collection.MutableFloatList;
import androidx.compose.material3.carousel.Keyline;
import androidx.compose.material3.carousel.KeylineKt;
import androidx.compose.material3.carousel.KeylineList;
import androidx.compose.material3.carousel.KeylineListScope;
import androidx.compose.material3.carousel.StrategyKt;
import androidx.compose.runtime.internal.StabilityInferred;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0000\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014BK\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\rJ'\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\b2\b\b\u0002\u0010\u0011\u001a\u00020\u0012H\u0000\u00a2\u0006\u0002\b\u0013R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Landroidx/compose/material3/carousel/Strategy;", "", "defaultKeylines", "Landroidx/compose/material3/carousel/KeylineList;", "startKeylineSteps", "", "endKeylineSteps", "startShiftDistance", "", "endShiftDistance", "startShiftPoints", "Landroidx/collection/FloatList;", "endShiftPoints", "(Landroidx/compose/material3/carousel/KeylineList;Ljava/util/List;Ljava/util/List;FFLandroidx/collection/FloatList;Landroidx/collection/FloatList;)V", "getKeylineListForScrollOffset", "scrollOffset", "maxScrollOffset", "roundToNearestStep", "", "getKeylineListForScrollOffset$material3", "Companion", "material3"})
@StabilityInferred(parameters=0)
public final class Strategy {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final KeylineList defaultKeylines;
    @NotNull
    private final List<KeylineList> startKeylineSteps;
    @NotNull
    private final List<KeylineList> endKeylineSteps;
    private final float startShiftDistance;
    private final float endShiftDistance;
    @NotNull
    private final FloatList startShiftPoints;
    @NotNull
    private final FloatList endShiftPoints;
    public static final int $stable = 8;

    private Strategy(KeylineList defaultKeylines, List<KeylineList> startKeylineSteps, List<KeylineList> endKeylineSteps, float startShiftDistance, float endShiftDistance, FloatList startShiftPoints, FloatList endShiftPoints) {
        this.defaultKeylines = defaultKeylines;
        this.startKeylineSteps = startKeylineSteps;
        this.endKeylineSteps = endKeylineSteps;
        this.startShiftDistance = startShiftDistance;
        this.endShiftDistance = endShiftDistance;
        this.startShiftPoints = startShiftPoints;
        this.endShiftPoints = endShiftPoints;
    }

    @NotNull
    public final KeylineList getKeylineListForScrollOffset$material3(float scrollOffset, float maxScrollOffset, boolean roundToNearestStep) {
        float startShiftOffset = this.startShiftDistance;
        float endShiftOffset = maxScrollOffset - this.endShiftDistance;
        boolean bl = startShiftOffset <= scrollOffset ? scrollOffset <= endShiftOffset : false;
        if (bl) {
            return this.defaultKeylines;
        }
        float interpolation = StrategyKt.access$lerp(1.0f, 0.0f, 0.0f, startShiftOffset, scrollOffset);
        FloatList shiftPoints = this.startShiftPoints;
        List<KeylineList> steps = this.startKeylineSteps;
        if (scrollOffset > endShiftOffset) {
            interpolation = StrategyKt.access$lerp(0.0f, 1.0f, endShiftOffset, maxScrollOffset, scrollOffset);
            shiftPoints = this.endShiftPoints;
            steps = this.endKeylineSteps;
        }
        Companion.ShiftPointRange shiftPointRange = Strategy.Companion.getShiftPointRange(steps.size(), shiftPoints, interpolation);
        if (roundToNearestStep) {
            int roundedStepIndex = MathKt.roundToInt((float)shiftPointRange.getSteppedInterpolation()) == 0 ? shiftPointRange.getFromStepIndex() : shiftPointRange.getToStepIndex();
            return steps.get(roundedStepIndex);
        }
        return StrategyKt.lerp(steps.get(shiftPointRange.getFromStepIndex()), steps.get(shiftPointRange.getToStepIndex()), shiftPointRange.getSteppedInterpolation());
    }

    public static /* synthetic */ KeylineList getKeylineListForScrollOffset$material3$default(Strategy strategy, float f, float f2, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        return strategy.getKeylineListForScrollOffset$material3(f, f2, bl);
    }

    public /* synthetic */ Strategy(KeylineList defaultKeylines, List startKeylineSteps, List endKeylineSteps, float startShiftDistance, float endShiftDistance, FloatList startShiftPoints, FloatList endShiftPoints, DefaultConstructorMarker $constructor_marker) {
        this(defaultKeylines, startKeylineSteps, endKeylineSteps, startShiftDistance, endShiftDistance, startShiftPoints, endShiftPoints);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001!B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001d\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0000\u00a2\u0006\u0002\b\tJ\u001e\u0010\n\u001a\b\u0012\u0004\u0012\u00020\b0\u000b2\u0006\u0010\f\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J \u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0006H\u0002J\u001e\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\b0\u000b2\u0006\u0010\f\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J&\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u00062\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\b0\u000b2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J(\u0010\u001a\u001a\u00020\b2\u0006\u0010\u001b\u001a\u00020\b2\u0006\u0010\u001c\u001a\u00020\u00102\u0006\u0010\u001d\u001a\u00020\u00102\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J(\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001f*\b\u0012\u0004\u0012\u00020 0\u001f2\u0006\u0010\u001c\u001a\u00020\u00102\u0006\u0010\u001d\u001a\u00020\u0010H\u0002\u00a8\u0006\""}, d2={"Landroidx/compose/material3/carousel/Strategy$Companion;", "", "()V", "create", "Landroidx/compose/material3/carousel/Strategy;", "carouselMainAxisSize", "", "keylineList", "Landroidx/compose/material3/carousel/KeylineList;", "create$material3", "getEndKeylineSteps", "", "defaultKeylines", "getShiftPointRange", "Landroidx/compose/material3/carousel/Strategy$Companion$ShiftPointRange;", "stepsCount", "", "shiftPoint", "Landroidx/collection/FloatList;", "interpolation", "getStartKeylineSteps", "getStepInterpolationPoints", "totalShiftDistance", "steps", "isShiftingLeft", "", "moveKeylineAndCreateShiftedKeylineList", "from", "srcIndex", "dstIndex", "move", "", "Landroidx/compose/material3/carousel/Keyline;", "ShiftPointRange", "material3"})
    @SourceDebugExtension(value={"SMAP\nStrategy.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Strategy.kt\nandroidx/compose/material3/carousel/Strategy$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,509:1\n1549#2:510\n1620#2,3:511\n1855#2,2:514\n*S KotlinDebug\n*F\n+ 1 Strategy.kt\nandroidx/compose/material3/carousel/Strategy$Companion\n*L\n405#1:510\n405#1:511,3\n432#1:514,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Strategy create$material3(float carouselMainAxisSize, @NotNull KeylineList keylineList) {
            Intrinsics.checkNotNullParameter((Object)keylineList, (String)"keylineList");
            List<KeylineList> startKeylineSteps = this.getStartKeylineSteps(keylineList, carouselMainAxisSize);
            List<KeylineList> endKeylineSteps = this.getEndKeylineSteps(keylineList, carouselMainAxisSize);
            float startShiftDistance = ((Keyline)CollectionsKt.first((List)((List)CollectionsKt.last(startKeylineSteps)))).getUnadjustedOffset() - ((Keyline)CollectionsKt.first((List)keylineList)).getUnadjustedOffset();
            float endShiftDistance = ((Keyline)CollectionsKt.last((List)keylineList)).getUnadjustedOffset() - ((Keyline)CollectionsKt.last((List)((List)CollectionsKt.last(endKeylineSteps)))).getUnadjustedOffset();
            return new Strategy(keylineList, startKeylineSteps, endKeylineSteps, startShiftDistance, endShiftDistance, this.getStepInterpolationPoints(startShiftDistance, startKeylineSteps, true), this.getStepInterpolationPoints(endShiftDistance, endKeylineSteps, false), null);
        }

        private final List<KeylineList> getStartKeylineSteps(KeylineList defaultKeylines, float carouselMainAxisSize) {
            List steps = new ArrayList();
            steps.add(defaultKeylines);
            if (defaultKeylines.isFirstFocalItemAtStartOfContainer()) {
                return steps;
            }
            int startIndex = defaultKeylines.getFirstNonAnchorIndex();
            int endIndex = defaultKeylines.getFirstFocalIndex();
            int numberOfSteps = endIndex - startIndex;
            if (numberOfSteps <= 0 && defaultKeylines.getFirstFocal().getCutoff() > 0.0f) {
                steps.add(this.moveKeylineAndCreateShiftedKeylineList(defaultKeylines, 0, 0, carouselMainAxisSize));
                return steps;
            }
            for (int i = 0; i < numberOfSteps; ++i) {
                KeylineList prevStep = (KeylineList)CollectionsKt.last((List)steps);
                int originalItemIndex = startIndex + i;
                int dstIndex = CollectionsKt.getLastIndex((List)defaultKeylines);
                if (originalItemIndex > 0) {
                    float originalNeighborBeforeSize = defaultKeylines.get(originalItemIndex - 1).getSize();
                    dstIndex = prevStep.firstIndexAfterFocalRangeWithSize(originalNeighborBeforeSize) - 1;
                }
                steps.add(this.moveKeylineAndCreateShiftedKeylineList(prevStep, defaultKeylines.getFirstNonAnchorIndex(), dstIndex, carouselMainAxisSize));
            }
            return steps;
        }

        private final List<KeylineList> getEndKeylineSteps(KeylineList defaultKeylines, float carouselMainAxisSize) {
            List steps = new ArrayList();
            steps.add(defaultKeylines);
            if (defaultKeylines.isLastFocalItemAtEndOfContainer(carouselMainAxisSize)) {
                return steps;
            }
            int startIndex = defaultKeylines.getLastFocalIndex();
            int endIndex = defaultKeylines.getLastNonAnchorIndex();
            int numberOfSteps = endIndex - startIndex;
            if (numberOfSteps <= 0 && defaultKeylines.getLastFocal().getCutoff() > 0.0f) {
                steps.add(this.moveKeylineAndCreateShiftedKeylineList(defaultKeylines, 0, 0, carouselMainAxisSize));
                return steps;
            }
            for (int i = 0; i < numberOfSteps; ++i) {
                KeylineList prevStep = (KeylineList)CollectionsKt.last((List)steps);
                int originalItemIndex = endIndex - i;
                int dstIndex = 0;
                if (originalItemIndex < CollectionsKt.getLastIndex((List)defaultKeylines)) {
                    float originalNeighborAfterSize = defaultKeylines.get(originalItemIndex + 1).getSize();
                    dstIndex = prevStep.lastIndexBeforeFocalRangeWithSize(originalNeighborAfterSize) + 1;
                }
                KeylineList keylines = this.moveKeylineAndCreateShiftedKeylineList(prevStep, defaultKeylines.getLastNonAnchorIndex(), dstIndex, carouselMainAxisSize);
                steps.add(keylines);
            }
            return steps;
        }

        private final KeylineList moveKeylineAndCreateShiftedKeylineList(KeylineList from, int srcIndex, int dstIndex, float carouselMainAxisSize) {
            int pivotDir = srcIndex > dstIndex ? 1 : -1;
            float pivotDelta = from.get(srcIndex).getSize() * (float)pivotDir;
            int newPivotIndex = from.getPivotIndex() + pivotDir;
            float newPivotOffset = from.getPivot().getOffset() + pivotDelta;
            return KeylineKt.keylineListOf(carouselMainAxisSize, newPivotIndex, newPivotOffset, (Function1<? super KeylineListScope, Unit>)((Function1)new Function1<KeylineListScope, Unit>(from, srcIndex, dstIndex){
                final /* synthetic */ KeylineList $from;
                final /* synthetic */ int $srcIndex;
                final /* synthetic */ int $dstIndex;
                {
                    this.$from = $from;
                    this.$srcIndex = $srcIndex;
                    this.$dstIndex = $dstIndex;
                    super(1);
                }

                public final void invoke(@NotNull KeylineListScope $this$keylineListOf) {
                    Intrinsics.checkNotNullParameter((Object)$this$keylineListOf, (String)"$this$keylineListOf");
                    List $this$fastForEach$iv = androidx.compose.material3.carousel.Strategy$Companion.access$move(Strategy.Companion, CollectionsKt.toMutableList((Collection)this.$from), this.$srcIndex, this.$dstIndex);
                    boolean $i$f$fastForEach = false;
                    int n = $this$fastForEach$iv.size();
                    for (int index$iv = 0; index$iv < n; ++index$iv) {
                        E item$iv = $this$fastForEach$iv.get(index$iv);
                        Keyline k = (Keyline)item$iv;
                        boolean bl = false;
                        $this$keylineListOf.add(k.getSize(), k.isAnchor());
                    }
                }
            }));
        }

        /*
         * WARNING - void declaration
         */
        private final FloatList getStepInterpolationPoints(float totalShiftDistance, List<KeylineList> steps, boolean isShiftingLeft) {
            void $this$mapTo$iv$iv;
            MutableFloatList points = FloatListKt.mutableFloatListOf((float)0.0f);
            if (totalShiftDistance == 0.0f) {
                return (FloatList)points;
            }
            Iterable $this$map$iv = (Iterable)RangesKt.until((int)1, (int)steps.size());
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            Iterator iterator = $this$mapTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                void i;
                int item$iv$iv;
                int n = item$iv$iv = ((IntIterator)iterator).nextInt();
                Collection collection = destination$iv$iv;
                boolean bl = false;
                KeylineList prevKeylines = steps.get((int)(i - true));
                KeylineList currKeylines = steps.get((int)i);
                float distanceShifted = isShiftingLeft ? ((Keyline)CollectionsKt.first((List)currKeylines)).getUnadjustedOffset() - ((Keyline)CollectionsKt.first((List)prevKeylines)).getUnadjustedOffset() : ((Keyline)CollectionsKt.last((List)prevKeylines)).getUnadjustedOffset() - ((Keyline)CollectionsKt.last((List)currKeylines)).getUnadjustedOffset();
                float stepPercentage = distanceShifted / totalShiftDistance;
                float point = i == CollectionsKt.getLastIndex(steps) ? 1.0f : points.get((int)(i - true)) + stepPercentage;
                collection.add(points.add(point));
            }
            List cfr_ignored_0 = (List)destination$iv$iv;
            return (FloatList)points;
        }

        private final ShiftPointRange getShiftPointRange(int stepsCount, FloatList shiftPoint, float interpolation) {
            float lowerBounds = 0.0f;
            lowerBounds = shiftPoint.get(0);
            Iterable $this$forEach$iv = (Iterable)RangesKt.until((int)1, (int)stepsCount);
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv.iterator();
            while (iterator.hasNext()) {
                int element$iv;
                int i = element$iv = ((IntIterator)iterator).nextInt();
                boolean bl = false;
                float upperBounds = shiftPoint.get(i);
                if (interpolation <= upperBounds) {
                    return new ShiftPointRange(i - 1, i, StrategyKt.access$lerp(0.0f, 1.0f, lowerBounds, upperBounds, interpolation));
                }
                lowerBounds = upperBounds;
            }
            return new ShiftPointRange(0, 0, 0.0f);
        }

        private final List<Keyline> move(List<Keyline> $this$move, int srcIndex, int dstIndex) {
            Keyline keyline = $this$move.get(srcIndex);
            $this$move.remove(srcIndex);
            $this$move.add(dstIndex, keyline);
            return $this$move;
        }

        public static final /* synthetic */ List access$move(Companion $this, List $receiver, int srcIndex, int dstIndex) {
            return $this.move($receiver, srcIndex, dstIndex);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0006H\u00c6\u0003J'\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\t\u00a8\u0006\u0017"}, d2={"Landroidx/compose/material3/carousel/Strategy$Companion$ShiftPointRange;", "", "fromStepIndex", "", "toStepIndex", "steppedInterpolation", "", "(IIF)V", "getFromStepIndex", "()I", "getSteppedInterpolation", "()F", "getToStepIndex", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "toString", "", "material3"})
        private static final class ShiftPointRange {
            private final int fromStepIndex;
            private final int toStepIndex;
            private final float steppedInterpolation;

            public ShiftPointRange(int fromStepIndex, int toStepIndex, float steppedInterpolation) {
                this.fromStepIndex = fromStepIndex;
                this.toStepIndex = toStepIndex;
                this.steppedInterpolation = steppedInterpolation;
            }

            public final int getFromStepIndex() {
                return this.fromStepIndex;
            }

            public final int getToStepIndex() {
                return this.toStepIndex;
            }

            public final float getSteppedInterpolation() {
                return this.steppedInterpolation;
            }

            public final int component1() {
                return this.fromStepIndex;
            }

            public final int component2() {
                return this.toStepIndex;
            }

            public final float component3() {
                return this.steppedInterpolation;
            }

            @NotNull
            public final ShiftPointRange copy(int fromStepIndex, int toStepIndex, float steppedInterpolation) {
                return new ShiftPointRange(fromStepIndex, toStepIndex, steppedInterpolation);
            }

            public static /* synthetic */ ShiftPointRange copy$default(ShiftPointRange shiftPointRange, int n, int n2, float f, int n3, Object object) {
                if ((n3 & 1) != 0) {
                    n = shiftPointRange.fromStepIndex;
                }
                if ((n3 & 2) != 0) {
                    n2 = shiftPointRange.toStepIndex;
                }
                if ((n3 & 4) != 0) {
                    f = shiftPointRange.steppedInterpolation;
                }
                return shiftPointRange.copy(n, n2, f);
            }

            @NotNull
            public String toString() {
                return "ShiftPointRange(fromStepIndex=" + this.fromStepIndex + ", toStepIndex=" + this.toStepIndex + ", steppedInterpolation=" + this.steppedInterpolation + ')';
            }

            public int hashCode() {
                int result2 = Integer.hashCode(this.fromStepIndex);
                result2 = result2 * 31 + Integer.hashCode(this.toStepIndex);
                result2 = result2 * 31 + Float.hashCode(this.steppedInterpolation);
                return result2;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof ShiftPointRange)) {
                    return false;
                }
                ShiftPointRange shiftPointRange = (ShiftPointRange)other;
                if (this.fromStepIndex != shiftPointRange.fromStepIndex) {
                    return false;
                }
                if (this.toStepIndex != shiftPointRange.toStepIndex) {
                    return false;
                }
                return Float.compare(this.steppedInterpolation, shiftPointRange.steppedInterpolation) == 0;
            }
        }
    }
}

